/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.cache;

import java.nio.ByteBuffer;
import java.util.Random;
import org.apache.hadoop.hive.common.io.DataCache;
import org.apache.hadoop.hive.common.io.DiskRange;
import org.apache.hadoop.hive.common.io.DiskRangeList;
import org.apache.hadoop.hive.common.io.encoded.MemoryBufferOrBuffers;
import org.apache.hadoop.hive.llap.cache.BuddyAllocator;
import org.apache.hadoop.hive.llap.cache.EvictionAwareAllocator;
import org.apache.hadoop.hive.llap.cache.EvictionListener;
import org.apache.hadoop.hive.llap.cache.LlapAllocatorBuffer;
import org.apache.hadoop.hive.llap.cache.LlapCacheableBuffer;
import org.apache.hadoop.hive.llap.cache.LlapOomDebugDump;
import org.apache.hadoop.hive.llap.cache.LowLevelCache;
import org.apache.hadoop.hive.llap.cache.LowLevelCachePolicy;
import org.apache.hadoop.hive.llap.cache.MemoryManager;
import org.apache.hadoop.hive.llap.io.metadata.MetadataCache;
import org.apache.hadoop.hive.llap.metrics.LlapDaemonCacheMetrics;
import org.apache.hadoop.hive.ql.io.orc.encoded.IncompleteCb;
import org.junit.Assert;
import org.junit.Test;

public class TestOrcMetadataCache {
    private static final int INCOMPLETE = 0;
    private static final int DRL = 1;

    @Test
    public void testBuffers() throws Exception {
        DummyMemoryManager mm = new DummyMemoryManager();
        DummyCachePolicy cp = new DummyCachePolicy();
        int MAX_ALLOC = 64;
        LlapDaemonCacheMetrics metrics = LlapDaemonCacheMetrics.create((String)"", (String)"");
        BuddyAllocator alloc = new BuddyAllocator(false, false, 8, 64, 1, 4096L, 0L, null, (MemoryManager)mm, metrics, null);
        MetadataCache cache = new MetadataCache((EvictionAwareAllocator)alloc, (MemoryManager)mm, (LowLevelCachePolicy)cp, true, metrics);
        Object fileKey1 = new Object();
        Random rdm = new Random();
        ByteBuffer smallBuffer = ByteBuffer.allocate(63);
        rdm.nextBytes(smallBuffer.array());
        MetadataCache.LlapBufferOrBuffers result = cache.putFileMetadata(fileKey1, smallBuffer);
        cache.decRefBuffer((MemoryBufferOrBuffers)result);
        ByteBuffer cacheBuf = result.getSingleBuffer().getByteBufferDup();
        Assert.assertEquals((Object)smallBuffer, (Object)cacheBuf);
        result = cache.putFileMetadata(fileKey1, smallBuffer);
        cache.decRefBuffer((MemoryBufferOrBuffers)result);
        cacheBuf = result.getSingleBuffer().getByteBufferDup();
        Assert.assertEquals((Object)smallBuffer, (Object)cacheBuf);
        result = cache.getFileMetadata(fileKey1);
        cacheBuf = result.getSingleBuffer().getByteBufferDup();
        Assert.assertEquals((Object)smallBuffer, (Object)cacheBuf);
        cache.decRefBuffer((MemoryBufferOrBuffers)result);
        cache.notifyEvicted((MetadataCache.LlapMetadataBuffer)result.getSingleBuffer());
        result = cache.getFileMetadata(fileKey1);
        Assert.assertNull((Object)result);
        ByteBuffer largeBuffer = ByteBuffer.allocate(160);
        rdm.nextBytes(largeBuffer.array());
        result = cache.putFileMetadata(fileKey1, largeBuffer);
        cache.decRefBuffer((MemoryBufferOrBuffers)result);
        Assert.assertNull((Object)result.getSingleBuffer());
        Assert.assertEquals((Object)largeBuffer, (Object)this.extractResultBbs(result));
        result = cache.getFileMetadata(fileKey1);
        Assert.assertNull((Object)result.getSingleBuffer());
        Assert.assertEquals((Object)largeBuffer, (Object)this.extractResultBbs(result));
        LlapAllocatorBuffer b0 = result.getMultipleLlapBuffers()[0];
        LlapAllocatorBuffer b1 = result.getMultipleLlapBuffers()[1];
        cache.decRefBuffer((MemoryBufferOrBuffers)result);
        cache.notifyEvicted((MetadataCache.LlapMetadataBuffer)b1);
        result = cache.getFileMetadata(fileKey1);
        Assert.assertNull((Object)result);
        Assert.assertFalse((b0.incRef() > 0 ? 1 : 0) != 0);
    }

    public ByteBuffer extractResultBbs(MetadataCache.LlapBufferOrBuffers result) {
        int totalLen = 0;
        for (LlapAllocatorBuffer buf : result.getMultipleLlapBuffers()) {
            totalLen += buf.getByteBufferRaw().remaining();
        }
        ByteBuffer combinedBb = ByteBuffer.allocate(totalLen);
        for (LlapAllocatorBuffer buf : result.getMultipleLlapBuffers()) {
            combinedBb.put(buf.getByteBufferDup());
        }
        combinedBb.flip();
        return combinedBb;
    }

    @Test
    public void testIncompleteCbs() throws Exception {
        DummyMemoryManager mm = new DummyMemoryManager();
        DummyCachePolicy cp = new DummyCachePolicy();
        int MAX_ALLOC = 64;
        LlapDaemonCacheMetrics metrics = LlapDaemonCacheMetrics.create((String)"", (String)"");
        BuddyAllocator alloc = new BuddyAllocator(false, false, 8, 64, 1, 4096L, 0L, null, (MemoryManager)mm, metrics, null);
        MetadataCache cache = new MetadataCache((EvictionAwareAllocator)alloc, (MemoryManager)mm, (LowLevelCachePolicy)cp, true, metrics);
        DataCache.BooleanRef gotAllData = new DataCache.BooleanRef();
        Object fileKey1 = new Object();
        cache.putIncompleteCbs(fileKey1, new DiskRange[]{new DiskRangeList(0L, 3L)}, 0L);
        cp.verifyEquals(1);
        DiskRangeList result = cache.getIncompleteCbs(fileKey1, new DiskRangeList(0L, 3L), 0L, gotAllData);
        Assert.assertTrue((boolean)gotAllData.value);
        this.verifyResult(result, 0L, 0L, 3L);
        cache.putIncompleteCbs(fileKey1, new DiskRange[]{new DiskRangeList(5L, 6L)}, 0L);
        cp.verifyEquals(3);
        DiskRangeList ranges = new DiskRangeList(0L, 3L);
        ranges.insertAfter(new DiskRangeList(4L, 6L));
        result = cache.getIncompleteCbs(fileKey1, ranges, 0L, gotAllData);
        Assert.assertFalse((boolean)gotAllData.value);
        this.verifyResult(result, 0L, 0L, 3L, 1L, 4L, 6L);
        ranges = new DiskRangeList(0L, 3L);
        ranges.insertAfter(new DiskRangeList(3L, 5L)).insertAfter(new DiskRangeList(5L, 6L));
        result = cache.getIncompleteCbs(fileKey1, ranges, 0L, gotAllData);
        Assert.assertFalse((boolean)gotAllData.value);
        this.verifyResult(result, 0L, 0L, 3L, 1L, 3L, 5L, 0L, 5L, 6L);
        result = cache.getIncompleteCbs(fileKey1, new DiskRangeList(5L, 6L), 0L, gotAllData);
        Assert.assertTrue((boolean)gotAllData.value);
        this.verifyResult(result, 0L, 5L, 6L);
        result = cache.getIncompleteCbs(fileKey1, new DiskRangeList(4L, 5L), 0L, gotAllData);
        Assert.assertFalse((boolean)gotAllData.value);
        this.verifyResult(result, 1L, 4L, 5L);
    }

    public void verifyResult(DiskRangeList result, long ... vals) {
        for (int i = 0; i < vals.length; i += 3) {
            switch ((int)vals[i]) {
                case 0: {
                    Assert.assertTrue((boolean)(result instanceof IncompleteCb));
                    break;
                }
                case 1: {
                    Assert.assertFalse((boolean)(result instanceof IncompleteCb));
                    break;
                }
                default: {
                    Assert.fail();
                }
            }
            Assert.assertEquals((long)vals[i + 1], (long)result.getOffset());
            Assert.assertEquals((long)vals[i + 2], (long)result.getEnd());
            result = result.next;
        }
        Assert.assertNull((Object)result);
    }

    private static class DummyMemoryManager
    implements MemoryManager {
        private DummyMemoryManager() {
        }

        public void reserveMemory(long memoryToReserve) {
        }

        public void releaseMemory(long memUsage) {
        }

        public String debugDumpForOom() {
            return "";
        }

        public void updateMaxSize(long maxSize) {
        }

        public void debugDumpShort(StringBuilder sb) {
        }
    }

    private static class DummyCachePolicy
    implements LowLevelCachePolicy {
        int lockCount = 0;
        int unlockCount = 0;

        private DummyCachePolicy() {
        }

        public void cache(LlapCacheableBuffer buffer, LowLevelCache.Priority pri) {
            ++this.lockCount;
        }

        public void notifyLock(LlapCacheableBuffer buffer) {
            ++this.lockCount;
        }

        public void notifyUnlock(LlapCacheableBuffer buffer) {
            ++this.unlockCount;
        }

        public long evictSomeBlocks(long memoryToReserve) {
            return memoryToReserve;
        }

        public void setEvictionListener(EvictionListener listener) {
        }

        public String debugDumpForOom() {
            return "";
        }

        public void setParentDebugDumper(LlapOomDebugDump dumper) {
        }

        public long purge() {
            return 0L;
        }

        public void verifyEquals(int i) {
            Assert.assertEquals((long)i, (long)this.lockCount);
            Assert.assertEquals((long)i, (long)this.unlockCount);
        }

        public void debugDumpShort(StringBuilder sb) {
        }
    }
}

