/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.daemon.impl;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.llap.daemon.SchedulerFragmentCompletingListener;
import org.apache.hadoop.hive.llap.daemon.impl.Scheduler;
import org.apache.hadoop.hive.llap.daemon.impl.TaskExecutorService;
import org.apache.hadoop.hive.llap.daemon.impl.TaskExecutorTestHelpers;
import org.apache.hadoop.hive.llap.daemon.impl.comparator.ShortestJobFirstComparator;
import org.apache.hadoop.hive.llap.testhelpers.ControlledClock;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.SystemClock;
import org.apache.tez.runtime.task.TaskRunner2Result;
import org.junit.Assert;
import org.junit.Test;

public class TestTaskExecutorService {
    @Test(timeout=5000L)
    public void testPreemptionQueueComparator() throws InterruptedException {
        TaskExecutorService.TaskWrapper r1 = TaskExecutorTestHelpers.createTaskWrapper(TaskExecutorTestHelpers.createSubmitWorkRequestProto(1, 2, 100L, 200L), false, 100000);
        TaskExecutorService.TaskWrapper r2 = TaskExecutorTestHelpers.createTaskWrapper(TaskExecutorTestHelpers.createSubmitWorkRequestProto(2, 4, 200L, 300L), false, 100000);
        TaskExecutorService.TaskWrapper r3 = TaskExecutorTestHelpers.createTaskWrapper(TaskExecutorTestHelpers.createSubmitWorkRequestProto(3, 6, 300L, 400L), false, 1000000);
        TaskExecutorService.TaskWrapper r4 = TaskExecutorTestHelpers.createTaskWrapper(TaskExecutorTestHelpers.createSubmitWorkRequestProto(4, 8, 400L, 500L), false, 1000000);
        PriorityBlockingQueue<TaskExecutorService.TaskWrapper> queue = new PriorityBlockingQueue<TaskExecutorService.TaskWrapper>(4, (Comparator<TaskExecutorService.TaskWrapper>)new TaskExecutorService.PreemptionQueueComparator());
        queue.offer(r1);
        Assert.assertEquals((Object)r1, queue.peek());
        queue.offer(r2);
        Assert.assertEquals((Object)r1, queue.peek());
        queue.offer(r3);
        Assert.assertEquals((Object)r1, queue.peek());
        queue.offer(r4);
        Assert.assertEquals((Object)r1, queue.take());
        Assert.assertEquals((Object)r2, queue.take());
        Assert.assertEquals((Object)r3, queue.take());
        Assert.assertEquals((Object)r4, queue.take());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testFinishablePreeptsNonFinishable() throws InterruptedException {
        TaskExecutorTestHelpers.MockRequest r1 = TaskExecutorTestHelpers.createMockRequest(1, 1, 100L, 200L, false, 5000L);
        TaskExecutorTestHelpers.MockRequest r2 = TaskExecutorTestHelpers.createMockRequest(2, 1, 100L, 200L, true, 1000L);
        TaskExecutorServiceForTest taskExecutorService = new TaskExecutorServiceForTest(1, 2, ShortestJobFirstComparator.class.getName(), true);
        taskExecutorService.init(new Configuration());
        taskExecutorService.start();
        try {
            taskExecutorService.schedule(r1);
            this.awaitStartAndSchedulerRun(r1, taskExecutorService);
            taskExecutorService.schedule(r2);
            this.awaitStartAndSchedulerRun(r2, taskExecutorService);
            r1.awaitEnd();
            Assert.assertTrue((boolean)r1.wasPreempted());
            Assert.assertTrue((boolean)r1.hasFinished());
            r2.complete();
            r2.awaitEnd();
            TaskExecutorServiceForTest.InternalCompletionListenerForTest icl1 = taskExecutorService.getInternalCompletionListenerForTest(r1.getRequestId());
            TaskExecutorServiceForTest.InternalCompletionListenerForTest icl2 = taskExecutorService.getInternalCompletionListenerForTest(r2.getRequestId());
            icl1.awaitCompletion();
            icl2.awaitCompletion();
            Assert.assertEquals((long)0L, (long)taskExecutorService.knownTasks.size());
        }
        finally {
            taskExecutorService.shutDown(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testPreemptionStateOnTaskMoveToFinishableState() throws InterruptedException {
        TaskExecutorTestHelpers.MockRequest r1 = TaskExecutorTestHelpers.createMockRequest(1, 1, 100L, 200L, false, 20000L);
        TaskExecutorServiceForTest taskExecutorService = new TaskExecutorServiceForTest(1, 2, ShortestJobFirstComparator.class.getName(), true);
        taskExecutorService.init(new Configuration());
        taskExecutorService.start();
        try {
            Scheduler.SubmissionState submissionState = taskExecutorService.schedule(r1);
            Assert.assertEquals((Object)Scheduler.SubmissionState.ACCEPTED, (Object)submissionState);
            this.awaitStartAndSchedulerRun(r1, taskExecutorService);
            TaskExecutorService.TaskWrapper taskWrapper = (TaskExecutorService.TaskWrapper)taskExecutorService.preemptionQueue.peek();
            Assert.assertNotNull((Object)taskWrapper);
            Assert.assertTrue((boolean)taskWrapper.isInPreemptionQueue());
            taskWrapper.finishableStateUpdated(true);
            TaskExecutorService.TaskWrapper taskWrapper2 = (TaskExecutorService.TaskWrapper)taskExecutorService.preemptionQueue.peek();
            Assert.assertNull((Object)taskWrapper2);
            Assert.assertFalse((boolean)taskWrapper.isInPreemptionQueue());
            r1.complete();
            r1.awaitEnd();
        }
        finally {
            taskExecutorService.shutDown(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testPreemptionStateOnTaskMoveToNonFinishableState() throws InterruptedException {
        TaskExecutorTestHelpers.MockRequest r1 = TaskExecutorTestHelpers.createMockRequest(1, 1, 100L, 200L, true, 20000L);
        TaskExecutorServiceForTest taskExecutorService = new TaskExecutorServiceForTest(1, 2, ShortestJobFirstComparator.class.getName(), true);
        taskExecutorService.init(new Configuration());
        taskExecutorService.start();
        try {
            Scheduler.SubmissionState submissionState = taskExecutorService.schedule(r1);
            Assert.assertEquals((Object)Scheduler.SubmissionState.ACCEPTED, (Object)submissionState);
            this.awaitStartAndSchedulerRun(r1, taskExecutorService);
            TaskExecutorService.TaskWrapper taskWrapper = (TaskExecutorService.TaskWrapper)taskExecutorService.preemptionQueue.peek();
            Assert.assertNull((Object)taskWrapper);
            Assert.assertEquals((long)1L, (long)taskExecutorService.knownTasks.size());
            taskWrapper = (TaskExecutorService.TaskWrapper)taskExecutorService.knownTasks.entrySet().iterator().next().getValue();
            Assert.assertFalse((boolean)taskWrapper.isInPreemptionQueue());
            taskWrapper.finishableStateUpdated(false);
            TaskExecutorService.TaskWrapper taskWrapper2 = (TaskExecutorService.TaskWrapper)taskExecutorService.preemptionQueue.peek();
            Assert.assertNotNull((Object)taskWrapper2);
            Assert.assertTrue((boolean)taskWrapper2.isInPreemptionQueue());
            Assert.assertEquals((Object)taskWrapper, (Object)taskWrapper2);
            r1.complete();
            r1.awaitEnd();
        }
        finally {
            taskExecutorService.shutDown(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testWaitQueueAcceptAfterAMTaskReport() throws InterruptedException {
        TaskExecutorServiceForTest taskExecutorService = new TaskExecutorServiceForTest(1, 2, ShortestJobFirstComparator.class.getName(), true);
        TaskExecutorTestHelpers.MockRequest r1 = TaskExecutorTestHelpers.createMockRequest(1, 1, 100L, 200L, true, 20000L);
        TaskExecutorTestHelpers.MockRequest r2 = TaskExecutorTestHelpers.createMockRequest(2, 1, 1, 200L, 2000L, true, 20000L);
        TaskExecutorTestHelpers.MockRequest r3 = TaskExecutorTestHelpers.createMockRequest(3, 1, 2, 300L, 420L, true, 20000L);
        TaskExecutorTestHelpers.MockRequest r4 = TaskExecutorTestHelpers.createMockRequest(4, 1, 3, 400L, 510L, false, 20000L);
        taskExecutorService.init(new Configuration());
        taskExecutorService.start();
        try {
            Scheduler.SubmissionState submissionState = taskExecutorService.schedule(r1);
            Assert.assertEquals((Object)Scheduler.SubmissionState.ACCEPTED, (Object)submissionState);
            r1.awaitStart();
            submissionState = taskExecutorService.schedule(r2);
            Assert.assertEquals((Object)Scheduler.SubmissionState.ACCEPTED, (Object)submissionState);
            submissionState = taskExecutorService.schedule(r3);
            Assert.assertEquals((Object)Scheduler.SubmissionState.ACCEPTED, (Object)submissionState);
            submissionState = taskExecutorService.schedule(r4);
            Assert.assertEquals((Object)Scheduler.SubmissionState.REJECTED, (Object)submissionState);
            taskExecutorService.fragmentCompleting(r1.getRequestId(), SchedulerFragmentCompletingListener.State.SUCCESS);
            submissionState = taskExecutorService.schedule(r4);
            Assert.assertEquals((Object)Scheduler.SubmissionState.ACCEPTED, (Object)submissionState);
            Assert.assertEquals((long)3L, (long)taskExecutorService.waitQueue.size());
            Assert.assertEquals((long)1L, (long)taskExecutorService.completingFragmentMap.size());
            r1.complete();
            r1.awaitEnd();
            this.awaitStartAndSchedulerRun(r2, taskExecutorService);
            Assert.assertEquals((long)0L, (long)taskExecutorService.completingFragmentMap.size());
        }
        finally {
            taskExecutorService.shutDown(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testWaitQueuePreemption() throws InterruptedException {
        TaskExecutorTestHelpers.MockRequest r1 = TaskExecutorTestHelpers.createMockRequest(1, 1, 100L, 200L, true, 20000L);
        TaskExecutorTestHelpers.MockRequest r2 = TaskExecutorTestHelpers.createMockRequest(2, 1, 1, 200L, 330L, false, 20000L);
        TaskExecutorTestHelpers.MockRequest r3 = TaskExecutorTestHelpers.createMockRequest(3, 2, 2, 300L, 420L, false, 20000L);
        TaskExecutorTestHelpers.MockRequest r4 = TaskExecutorTestHelpers.createMockRequest(4, 1, 3, 400L, 510L, false, 20000L);
        TaskExecutorTestHelpers.MockRequest r5 = TaskExecutorTestHelpers.createMockRequest(5, 1, 500L, 610L, true, 20000L);
        TaskExecutorServiceForTest taskExecutorService = new TaskExecutorServiceForTest(1, 2, ShortestJobFirstComparator.class.getName(), true);
        taskExecutorService.init(new Configuration());
        taskExecutorService.start();
        try {
            taskExecutorService.schedule(r1);
            this.awaitStartAndSchedulerRun(r1, taskExecutorService);
            Scheduler.SubmissionState submissionState = taskExecutorService.schedule(r2);
            Assert.assertEquals((Object)Scheduler.SubmissionState.ACCEPTED, (Object)submissionState);
            submissionState = taskExecutorService.schedule(r3);
            Assert.assertEquals((Object)Scheduler.SubmissionState.ACCEPTED, (Object)submissionState);
            submissionState = taskExecutorService.schedule(r4);
            Assert.assertEquals((Object)Scheduler.SubmissionState.REJECTED, (Object)submissionState);
            submissionState = taskExecutorService.schedule(r5);
            Assert.assertEquals((Object)Scheduler.SubmissionState.EVICTED_OTHER, (Object)submissionState);
            Assert.assertEquals((Object)true, (Object)r3.wasPreempted());
            TaskExecutorServiceForTest.InternalCompletionListenerForTest icl1 = taskExecutorService.getInternalCompletionListenerForTest(r1.getRequestId());
            Assert.assertEquals((long)3L, (long)taskExecutorService.knownTasks.size());
            Assert.assertTrue((boolean)taskExecutorService.knownTasks.containsKey(r1.getRequestId()));
            Assert.assertTrue((boolean)taskExecutorService.knownTasks.containsKey(r2.getRequestId()));
            Assert.assertTrue((boolean)taskExecutorService.knownTasks.containsKey(r5.getRequestId()));
            r1.complete();
            r1.awaitEnd();
            icl1.awaitCompletion();
            Assert.assertEquals((long)2L, (long)taskExecutorService.knownTasks.size());
            Assert.assertTrue((boolean)taskExecutorService.knownTasks.containsKey(r2.getRequestId()));
            Assert.assertTrue((boolean)taskExecutorService.knownTasks.containsKey(r5.getRequestId()));
            this.awaitStartAndSchedulerRun(r5, taskExecutorService);
            TaskExecutorServiceForTest.InternalCompletionListenerForTest icl5 = taskExecutorService.getInternalCompletionListenerForTest(r5.getRequestId());
            r5.complete();
            r5.awaitEnd();
            icl5.awaitCompletion();
            Assert.assertEquals((long)1L, (long)taskExecutorService.knownTasks.size());
            Assert.assertTrue((boolean)taskExecutorService.knownTasks.containsKey(r2.getRequestId()));
            this.awaitStartAndSchedulerRun(r2, taskExecutorService);
            TaskExecutorServiceForTest.InternalCompletionListenerForTest icl2 = taskExecutorService.getInternalCompletionListenerForTest(r2.getRequestId());
            r2.complete();
            r2.awaitEnd();
            icl2.awaitCompletion();
            Assert.assertEquals((long)0L, (long)taskExecutorService.knownTasks.size());
        }
        finally {
            taskExecutorService.shutDown(false);
        }
    }

    @Test(timeout=10000L)
    public void testDontKillMultiple() throws InterruptedException {
        TaskExecutorTestHelpers.MockRequest victim1 = TaskExecutorTestHelpers.createMockRequest(1, 1, 100L, 100L, false, 20000L);
        TaskExecutorTestHelpers.MockRequest victim2 = TaskExecutorTestHelpers.createMockRequest(2, 1, 100L, 100L, false, 20000L);
        this.runPreemptionGraceTest(victim1, victim2, 200);
        Assert.assertNotEquals((Object)victim1.wasPreempted(), (Object)victim2.wasPreempted());
    }

    @Test(timeout=10000L)
    public void testDoKillMultiple() throws InterruptedException {
        TaskExecutorTestHelpers.MockRequest victim1 = TaskExecutorTestHelpers.createMockRequest(1, 1, 100L, 100L, false, 20000L);
        TaskExecutorTestHelpers.MockRequest victim2 = TaskExecutorTestHelpers.createMockRequest(2, 1, 100L, 100L, false, 20000L);
        this.runPreemptionGraceTest(victim1, victim2, 1000);
        Assert.assertTrue((boolean)victim1.wasPreempted());
        Assert.assertTrue((boolean)victim2.wasPreempted());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runPreemptionGraceTest(TaskExecutorTestHelpers.MockRequest victim1, TaskExecutorTestHelpers.MockRequest victim2, int time) throws InterruptedException {
        TaskExecutorTestHelpers.MockRequest preemptor = TaskExecutorTestHelpers.createMockRequest(3, 1, 100L, 100L, true, 20000L);
        victim1.setSleepAfterKill();
        victim2.setSleepAfterKill();
        ControlledClock clock = new ControlledClock((Clock)new SystemClock());
        clock.setTime(0L);
        TaskExecutorServiceForTest taskExecutorService = new TaskExecutorServiceForTest(2, 3, ShortestJobFirstComparator.class.getName(), true, (Clock)clock);
        taskExecutorService.init(new Configuration());
        taskExecutorService.start();
        try {
            taskExecutorService.schedule(victim1);
            this.awaitStartAndSchedulerRun(victim1, taskExecutorService);
            taskExecutorService.schedule(victim2);
            this.awaitStartAndSchedulerRun(victim2, taskExecutorService);
            taskExecutorService.schedule(preemptor);
            taskExecutorService.waitForScheduleRuns(5);
            clock.setTime((long)time);
            taskExecutorService.waitForScheduleRuns(5);
            victim1.unblockKill();
            victim2.unblockKill();
            preemptor.complete();
            preemptor.awaitEnd();
            TaskExecutorServiceForTest.InternalCompletionListenerForTest icl3 = taskExecutorService.getInternalCompletionListenerForTest(preemptor.getRequestId());
            icl3.awaitCompletion();
        }
        finally {
            taskExecutorService.shutDown(false);
        }
    }

    private void awaitStartAndSchedulerRun(TaskExecutorTestHelpers.MockRequest mockRequest, TaskExecutorServiceForTest taskExecutorServiceForTest) throws InterruptedException {
        mockRequest.awaitStart();
        taskExecutorServiceForTest.awaitTryScheduleIfInProgress();
    }

    private static class TaskExecutorServiceForTest
    extends TaskExecutorService {
        private final Lock iclCreationLock = new ReentrantLock();
        private final Map<String, Condition> iclCreationConditions = new HashMap<String, Condition>();
        private final Lock tryScheduleLock = new ReentrantLock();
        private final Condition tryScheduleCondition = this.tryScheduleLock.newCondition();
        private boolean isInTrySchedule = false;
        private int scheduleAttempts = 0;
        private ConcurrentMap<String, InternalCompletionListenerForTest> completionListeners = new ConcurrentHashMap<String, InternalCompletionListenerForTest>();

        public TaskExecutorServiceForTest(int numExecutors, int waitQueueSize, String waitQueueComparatorClassName, boolean enablePreemption) {
            this(numExecutors, waitQueueSize, waitQueueComparatorClassName, enablePreemption, null);
        }

        public TaskExecutorServiceForTest(int numExecutors, int waitQueueSize, String waitQueueComparatorClassName, boolean enablePreemption, Clock clock) {
            super(numExecutors, waitQueueSize, waitQueueComparatorClassName, enablePreemption, Thread.currentThread().getContextClassLoader(), null, clock);
        }

        void tryScheduleUnderLock(TaskExecutorService.TaskWrapper taskWrapper) throws RejectedExecutionException {
            this.tryScheduleLock.lock();
            try {
                this.isInTrySchedule = true;
                super.tryScheduleUnderLock(taskWrapper);
            }
            finally {
                this.isInTrySchedule = false;
                ++this.scheduleAttempts;
                this.tryScheduleCondition.signal();
                this.tryScheduleLock.unlock();
            }
        }

        public void waitForScheduleRuns(int n) throws InterruptedException {
            this.tryScheduleLock.lock();
            try {
                int targetRuns = this.scheduleAttempts + n;
                while (this.scheduleAttempts < targetRuns) {
                    this.tryScheduleCondition.await(100L, TimeUnit.MILLISECONDS);
                }
            }
            finally {
                this.tryScheduleLock.unlock();
            }
        }

        private void awaitTryScheduleIfInProgress() throws InterruptedException {
            this.tryScheduleLock.lock();
            try {
                while (this.isInTrySchedule) {
                    this.tryScheduleCondition.await();
                }
            }
            finally {
                this.tryScheduleLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        TaskExecutorService.InternalCompletionListener createInternalCompletionListener(TaskExecutorService.TaskWrapper taskWrapper) {
            this.iclCreationLock.lock();
            try {
                InternalCompletionListenerForTest icl = new InternalCompletionListenerForTest(taskWrapper);
                this.completionListeners.put(taskWrapper.getRequestId(), icl);
                Condition condition = this.iclCreationConditions.get(taskWrapper.getRequestId());
                if (condition == null) {
                    condition = this.iclCreationLock.newCondition();
                    this.iclCreationConditions.put(taskWrapper.getRequestId(), condition);
                }
                condition.signalAll();
                InternalCompletionListenerForTest internalCompletionListenerForTest = icl;
                return internalCompletionListenerForTest;
            }
            finally {
                this.iclCreationLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        InternalCompletionListenerForTest getInternalCompletionListenerForTest(String requestId) throws InterruptedException {
            this.iclCreationLock.lock();
            try {
                Condition condition = this.iclCreationConditions.get(requestId);
                if (condition == null) {
                    condition = this.iclCreationLock.newCondition();
                    this.iclCreationConditions.put(requestId, condition);
                }
                while (this.completionListeners.get(requestId) == null) {
                    condition.await();
                }
                InternalCompletionListenerForTest internalCompletionListenerForTest = (InternalCompletionListenerForTest)((Object)this.completionListeners.get(requestId));
                return internalCompletionListenerForTest;
            }
            finally {
                this.iclCreationLock.unlock();
            }
        }

        private class InternalCompletionListenerForTest
        extends TaskExecutorService.InternalCompletionListener {
            private final Lock lock;
            private final Condition completionCondition;
            private final AtomicBoolean isComplete;

            public InternalCompletionListenerForTest(TaskExecutorService.TaskWrapper taskWrapper) {
                super((TaskExecutorService)TaskExecutorServiceForTest.this, taskWrapper);
                this.lock = new ReentrantLock();
                this.completionCondition = this.lock.newCondition();
                this.isComplete = new AtomicBoolean(false);
            }

            public void onSuccess(TaskRunner2Result result) {
                super.onSuccess(result);
                this.markComplete();
            }

            public void onFailure(Throwable t) {
                super.onFailure(t);
                this.markComplete();
            }

            private void markComplete() {
                this.lock.lock();
                try {
                    this.isComplete.set(true);
                    this.completionCondition.signal();
                }
                finally {
                    this.lock.unlock();
                }
            }

            private void awaitCompletion() throws InterruptedException {
                this.lock.lock();
                try {
                    while (!this.isComplete.get()) {
                        this.completionCondition.await();
                    }
                }
                finally {
                    this.lock.unlock();
                }
            }
        }
    }
}

