/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.daemon.services.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.daemon.services.impl.LlapWebServices;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestLlapWebServices {
    private static LlapWebServices llapWS = null;
    private static int llapWSPort;

    @BeforeClass
    public static void beforeTests() throws Exception {
        llapWSPort = MetaStoreUtils.findFreePortExcepting((int)Integer.valueOf(HiveConf.ConfVars.LLAP_DAEMON_WEB_PORT.getDefaultValue()));
        llapWS = new LlapWebServices(llapWSPort, null, null);
        llapWS.init((Configuration)new HiveConf());
        llapWS.start();
        Thread.sleep(5000L);
    }

    @Test
    public void testContextRootUrlRewrite() throws Exception {
        String contextRootURL = "http://localhost:" + llapWSPort + "/";
        String contextRootContent = this.getURLResponseAsString(contextRootURL);
        String indexHtmlUrl = "http://localhost:" + llapWSPort + "/index.html";
        String indexHtmlContent = this.getURLResponseAsString(indexHtmlUrl);
        Assert.assertEquals((Object)contextRootContent, (Object)indexHtmlContent);
    }

    private String getURLResponseAsString(String baseURL) throws IOException {
        URL url = new URL(baseURL);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        Assert.assertEquals((long)200L, (long)conn.getResponseCode());
        StringWriter writer = new StringWriter();
        IOUtils.copy((InputStream)conn.getInputStream(), (Writer)writer, (String)"UTF-8");
        return writer.toString();
    }

    @AfterClass
    public static void afterTests() throws Exception {
        llapWS.stop();
    }
}

