/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.daemon.services.impl;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.registry.ServiceInstance;
import org.apache.hadoop.hive.llap.registry.impl.LlapRegistryService;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.service.CompositeService;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hive.common.util.HiveVersionInfo;
import org.apache.hive.http.HttpServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LlapWebServices
extends AbstractService {
    private static final Logger LOG = LoggerFactory.getLogger(LlapWebServices.class);
    static final String ACCESS_CONTROL_ALLOW_METHODS = "Access-Control-Allow-Methods";
    static final String ACCESS_CONTROL_ALLOW_ORIGIN = "Access-Control-Allow-Origin";
    static final String REGISTRY_ATTRIBUTE = "llap.registry";
    static final String PARENT_ATTRIBUTE = "llap.parent";
    private int port;
    private HttpServer http;
    private boolean useSSL = false;
    private boolean useSPNEGO = false;
    private final CompositeService parent;
    private final LlapRegistryService registry;

    public LlapWebServices(int port, CompositeService parent, LlapRegistryService registry) {
        super("LlapWebServices");
        this.port = port;
        this.registry = registry;
        this.parent = parent;
    }

    public void serviceInit(Configuration conf) {
        this.useSSL = HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_DAEMON_WEB_SSL);
        this.useSPNEGO = HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_WEB_AUTO_AUTH);
        String bindAddress = "0.0.0.0";
        HttpServer.Builder builder = new HttpServer.Builder("llap").setPort(this.port).setHost(bindAddress);
        builder.setConf(new HiveConf(conf, HiveConf.class));
        if (UserGroupInformation.isSecurityEnabled()) {
            LOG.info("LLAP UI useSSL=" + this.useSSL + ", auto-auth/SPNEGO=" + this.useSPNEGO + ", port=" + this.port);
            builder.setUseSSL(this.useSSL);
            if (this.useSPNEGO) {
                builder.setUseSPNEGO(true);
                builder.setSPNEGOPrincipal(HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_WEBUI_SPNEGO_PRINCIPAL, (String)HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_KERBEROS_PRINCIPAL)));
                builder.setSPNEGOKeytab(HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_WEBUI_SPNEGO_KEYTAB_FILE, (String)HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_KERBEROS_KEYTAB_FILE)));
            }
        }
        builder.setContextAttribute(REGISTRY_ATTRIBUTE, (Object)this.registry);
        builder.setContextAttribute(PARENT_ATTRIBUTE, (Object)this.parent);
        try {
            this.http = builder.build();
            this.http.addServlet("status", "/status", LlapStatusServlet.class);
            this.http.addServlet("peers", "/peers", LlapPeerRegistryServlet.class);
        }
        catch (IOException e) {
            LOG.warn("LLAP web service failed to come up", (Throwable)e);
        }
    }

    @InterfaceAudience.Private
    public int getPort() {
        return this.http.getPort();
    }

    public void serviceStart() throws Exception {
        if (this.http != null) {
            this.http.start();
        }
    }

    public void serviceStop() throws Exception {
        if (this.http != null) {
            this.http.stop();
        }
    }

    public static class LlapPeerRegistryServlet
    extends HttpServlet {
        private static final long serialVersionUID = 1L;
        protected transient JsonFactory jsonFactory;

        public void init() throws ServletException {
            this.jsonFactory = new JsonFactory();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doGet(HttpServletRequest request, HttpServletResponse response) {
            JsonGenerator jg = null;
            PrintWriter writer = null;
            ServletContext context = this.getServletContext();
            LlapRegistryService registry = (LlapRegistryService)context.getAttribute(LlapWebServices.REGISTRY_ATTRIBUTE);
            try {
                if (!HttpServer.isInstrumentationAccessAllowed((ServletContext)context, (HttpServletRequest)request, (HttpServletResponse)response)) {
                    return;
                }
                try {
                    writer = response.getWriter();
                    response.setContentType("application/json; charset=utf8");
                    response.setHeader(LlapWebServices.ACCESS_CONTROL_ALLOW_METHODS, "GET");
                    response.setHeader(LlapWebServices.ACCESS_CONTROL_ALLOW_ORIGIN, "*");
                    jg = this.jsonFactory.createJsonGenerator((Writer)writer);
                    jg.disable(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
                    jg.useDefaultPrettyPrinter();
                    jg.writeStartObject();
                    if (registry.isDynamic()) {
                        jg.writeBooleanField("dynamic", true);
                    }
                    jg.writeStringField("identity", registry.getWorkerIdentity());
                    jg.writeArrayFieldStart("peers");
                    for (ServiceInstance s : registry.getInstances().getAllInstancesOrdered(false)) {
                        jg.writeStartObject();
                        jg.writeStringField("identity", s.getWorkerIdentity());
                        jg.writeStringField("host", s.getHost());
                        jg.writeNumberField("management-port", s.getManagementPort());
                        jg.writeNumberField("rpc-port", s.getRpcPort());
                        jg.writeNumberField("shuffle-port", s.getShufflePort());
                        Resource r = s.getResource();
                        if (r != null) {
                            jg.writeObjectFieldStart("resource");
                            jg.writeNumberField("vcores", r.getVirtualCores());
                            jg.writeNumberField("memory", r.getMemory());
                            jg.writeEndObject();
                        }
                        jg.writeStringField("host", s.getHost());
                        jg.writeEndObject();
                    }
                    jg.writeEndArray();
                    jg.writeEndObject();
                }
                finally {
                    if (jg != null) {
                        jg.close();
                    }
                    if (writer != null) {
                        writer.close();
                    }
                }
            }
            catch (IOException e) {
                LOG.error("Caught an exception while processing /status request", (Throwable)e);
                response.setStatus(500);
            }
        }
    }

    public static class LlapStatusServlet
    extends HttpServlet {
        private static final long serialVersionUID = 1L;
        private static final String STATUS_ATTRIBUTE = "status";
        private static final String UPTIME_ATTRIBUTE = "uptime";
        private static final String BUILD_ATTRIBUTE = "build";
        private static final String UNKNOWN_STATE = "UNKNOWN";
        protected transient JsonFactory jsonFactory;
        protected RuntimeMXBean runtimeBean;

        public void init() throws ServletException {
            this.jsonFactory = new JsonFactory();
            this.runtimeBean = ManagementFactory.getRuntimeMXBean();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doGet(HttpServletRequest request, HttpServletResponse response) {
            JsonGenerator jg = null;
            PrintWriter writer = null;
            ServletContext context = this.getServletContext();
            Object parent = context.getAttribute(LlapWebServices.PARENT_ATTRIBUTE);
            long uptime = this.runtimeBean.getUptime();
            try {
                try {
                    writer = response.getWriter();
                    response.setContentType("application/json; charset=utf8");
                    response.setHeader(LlapWebServices.ACCESS_CONTROL_ALLOW_METHODS, "GET");
                    response.setHeader(LlapWebServices.ACCESS_CONTROL_ALLOW_ORIGIN, "*");
                    jg = this.jsonFactory.createJsonGenerator((Writer)writer);
                    jg.disable(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
                    jg.useDefaultPrettyPrinter();
                    jg.writeStartObject();
                    if (parent != null && parent instanceof CompositeService) {
                        jg.writeStringField(STATUS_ATTRIBUTE, ((CompositeService)parent).getServiceState().toString());
                    } else {
                        jg.writeStringField(STATUS_ATTRIBUTE, UNKNOWN_STATE);
                    }
                    jg.writeNumberField(UPTIME_ATTRIBUTE, uptime);
                    jg.writeStringField(BUILD_ATTRIBUTE, HiveVersionInfo.getBuildVersion());
                    jg.writeEndObject();
                }
                finally {
                    if (jg != null) {
                        jg.close();
                    }
                    if (writer != null) {
                        writer.close();
                    }
                }
            }
            catch (IOException e) {
                LOG.error("Caught an exception while processing /status request", (Throwable)e);
                response.setStatus(500);
            }
        }
    }
}

