/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.ipc.ArrowStreamReader;
import org.apache.hadoop.hive.llap.LlapBaseRecordReader;
import org.apache.hadoop.hive.llap.Schema;
import org.apache.hadoop.hive.ql.io.arrow.ArrowWrapperWritable;
import org.apache.hadoop.hive.ql.io.arrow.RootAllocatorFactory;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.JobConf;

public class LlapArrowBatchRecordReader
extends LlapBaseRecordReader<ArrowWrapperWritable> {
    private BufferAllocator allocator;
    private ArrowStreamReader arrowStreamReader;

    public LlapArrowBatchRecordReader(InputStream in, Schema schema, Class<ArrowWrapperWritable> clazz, JobConf job, Closeable client, Socket socket, long arrowAllocatorLimit) throws IOException {
        super(in, schema, clazz, job, client, (Closeable)socket);
        this.allocator = RootAllocatorFactory.INSTANCE.getOrCreateRootAllocator(arrowAllocatorLimit);
        this.arrowStreamReader = new ArrowStreamReader(socket.getInputStream(), this.allocator);
    }

    public boolean next(NullWritable key, ArrowWrapperWritable value) throws IOException {
        try {
            this.setReaderThread(Thread.currentThread());
            boolean hasInput = this.arrowStreamReader.loadNextBatch();
            if (hasInput) {
                VectorSchemaRoot vectorSchemaRoot = this.arrowStreamReader.getVectorSchemaRoot();
                Preconditions.checkState((vectorSchemaRoot.getFieldVectors().size() > 0 ? 1 : 0) != 0);
                if (((FieldVector)vectorSchemaRoot.getFieldVectors().get(0)).getValueCount() == 0) {
                    return false;
                }
                value.setVectorSchemaRoot(this.arrowStreamReader.getVectorSchemaRoot());
                return true;
            }
            this.processReaderEvent();
            return false;
        }
        catch (IOException io) {
            this.failOnInterruption(io);
            return false;
        }
    }

    public void close() throws IOException {
        this.arrowStreamReader.close();
    }
}

