/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.storage.jdbc;

import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.MapWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hive.storage.jdbc.JdbcInputSplit;
import org.apache.hive.storage.jdbc.dao.DatabaseAccessor;
import org.apache.hive.storage.jdbc.dao.DatabaseAccessorFactory;
import org.apache.hive.storage.jdbc.dao.JdbcRecordIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcRecordReader
implements RecordReader<LongWritable, MapWritable> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JdbcRecordReader.class);
    private DatabaseAccessor dbAccessor = null;
    private JdbcRecordIterator iterator = null;
    private JdbcInputSplit split = null;
    private JobConf conf = null;
    private int pos = 0;

    public JdbcRecordReader(JobConf conf, JdbcInputSplit split) {
        LOGGER.debug("Initializing JdbcRecordReader");
        this.split = split;
        this.conf = conf;
    }

    public boolean next(LongWritable key, MapWritable value) throws IOException {
        try {
            LOGGER.debug("JdbcRecordReader.next called");
            if (this.dbAccessor == null) {
                this.dbAccessor = DatabaseAccessorFactory.getAccessor((Configuration)this.conf);
                this.iterator = this.dbAccessor.getRecordIterator((Configuration)this.conf, this.split.getLimit(), this.split.getOffset());
            }
            if (this.iterator.hasNext()) {
                LOGGER.debug("JdbcRecordReader has more records to read.");
                key.set((long)this.pos);
                ++this.pos;
                Object record = this.iterator.next();
                if (record != null && !record.isEmpty()) {
                    for (Map.Entry entry : record.entrySet()) {
                        value.put((Writable)new Text((String)entry.getKey()), (Writable)new Text((String)entry.getValue()));
                    }
                    return true;
                }
                LOGGER.debug("JdbcRecordReader got null record.");
                return false;
            }
            LOGGER.debug("JdbcRecordReader has no more records to read.");
            return false;
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while reading the next record from DB.", (Throwable)e);
            return false;
        }
    }

    public LongWritable createKey() {
        return new LongWritable();
    }

    public MapWritable createValue() {
        return new MapWritable();
    }

    public long getPos() throws IOException {
        return this.pos;
    }

    public void close() throws IOException {
        if (this.iterator != null) {
            this.iterator.close();
        }
    }

    public float getProgress() throws IOException {
        if (this.split == null) {
            return 0.0f;
        }
        return this.split.getLength() > 0L ? (float)this.pos / (float)this.split.getLength() : 1.0f;
    }

    public void setDbAccessor(DatabaseAccessor dbAccessor) {
        this.dbAccessor = dbAccessor;
    }

    public void setIterator(JdbcRecordIterator iterator) {
        this.iterator = iterator;
    }
}

