/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan.mapping;

import java.util.List;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.DriverFactory;
import org.apache.hadoop.hive.ql.IDriver;
import org.apache.hadoop.hive.ql.exec.FilterOperator;
import org.apache.hadoop.hive.ql.parse.ParseException;
import org.apache.hadoop.hive.ql.plan.mapper.PlanMapper;
import org.apache.hadoop.hive.ql.plan.mapping.TestCounterMapping;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hive.testutils.HiveTestEnvSetup;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;

@Ignore
public class TestStatEstimations {
    @ClassRule
    public static HiveTestEnvSetup env_setup = new HiveTestEnvSetup();
    @Rule
    public TestRule methodRule = env_setup.getMethodRule();

    @BeforeClass
    public static void beforeClass() throws Exception {
        String[] cmds;
        IDriver driver = TestStatEstimations.createDriver();
        TestStatEstimations.dropTables(driver);
        for (String cmd : cmds = new String[]{"create table t2(a integer, b string) STORED AS ORC", "insert into t2 values(1, 'AAA'),(2, 'AAA'),(3, 'AAA'),(4, 'AAA'),(5, 'AAA'),(6, 'BBB'),(7, 'BBB'),(8, 'BBB'),(9, 'BBB'),(10, 'BBB')", "analyze table t2 compute statistics for columns"}) {
            int ret = driver.run(cmd).getResponseCode();
            Assert.assertEquals((String)"Checking command success", (long)0L, (long)ret);
        }
    }

    @AfterClass
    public static void afterClass() throws Exception {
        IDriver driver = TestStatEstimations.createDriver();
        TestStatEstimations.dropTables(driver);
    }

    public static void dropTables(IDriver driver) throws Exception {
        String[] tables;
        for (String t : tables = new String[]{"t2"}) {
            int ret = driver.run("drop table if exists " + t).getResponseCode();
            Assert.assertEquals((String)"Checking command success", (long)0L, (long)ret);
        }
    }

    private PlanMapper getMapperForQuery(IDriver driver, String query) {
        int ret = driver.run(query).getResponseCode();
        Assert.assertEquals((String)"Checking command success", (long)0L, (long)ret);
        PlanMapper pm0 = driver.getContext().getPlanMapper();
        return pm0;
    }

    @Test
    public void testFilterIntIn() throws ParseException {
        IDriver driver = TestStatEstimations.createDriver();
        String query = "explain select a from t2 where a IN (-1,0,1,2,10,20,30,40) order by a";
        PlanMapper pm = this.getMapperForQuery(driver, query);
        List fos = pm.getAll(FilterOperator.class);
        fos.sort(TestCounterMapping.OPERATOR_ID_COMPARATOR.reversed());
        Assert.assertEquals((long)1L, (long)fos.size());
        FilterOperator fop = (FilterOperator)fos.get(0);
        Assert.assertEquals((long)3L, (long)fop.getStatistics().getNumRows());
    }

    private static IDriver createDriver() {
        HiveConf conf = TestStatEstimations.env_setup.getTestCtx().hiveConf;
        conf.setBoolVar(HiveConf.ConfVars.HIVE_VECTORIZATION_ENABLED, false);
        conf.setVar(HiveConf.ConfVars.HIVE_AUTHORIZATION_MANAGER, "org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.SQLStdHiveAuthorizerFactory");
        SessionState.start((HiveConf)conf);
        IDriver driver = DriverFactory.newDriver((HiveConf)conf);
        return driver;
    }
}

