/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io;

import java.util.concurrent.ThreadLocalRandom;
import org.apache.hadoop.hive.ql.io.RecordIdentifier;
import org.apache.hadoop.hive.ql.io.orc.OrcRawRecordMerger;
import org.junit.Assert;
import org.junit.Test;

public class TestRecordIdentifier {
    @Test
    public void TestOrdering() throws Exception {
        RecordIdentifier left = new RecordIdentifier(100L, 200, 1200L);
        RecordIdentifier right = new RecordIdentifier();
        right.setValues(100L, 200, 1000L);
        Assert.assertTrue((right.compareTo(left) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((left.compareTo(right) > 0 ? 1 : 0) != 0);
        left.set(right);
        Assert.assertTrue((right.compareTo(left) == 0 ? 1 : 0) != 0);
        right.setRowId(2000L);
        Assert.assertTrue((right.compareTo(left) > 0 ? 1 : 0) != 0);
        left.setValues(1L, 2, 3L);
        right.setValues(100L, 2, 3L);
        Assert.assertTrue((left.compareTo(right) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((right.compareTo(left) > 0 ? 1 : 0) != 0);
        left.setValues(1L, 2, 3L);
        right.setValues(1L, 100, 3L);
        Assert.assertTrue((left.compareTo(right) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((right.compareTo(left) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testHashEquals() throws Exception {
        long origTxn = ThreadLocalRandom.current().nextLong(1L, 10000000000L);
        int bucketId = ThreadLocalRandom.current().nextInt(1, 512);
        long rowId = ThreadLocalRandom.current().nextLong(1L, 10000000000L);
        long currTxn = origTxn + ThreadLocalRandom.current().nextLong(0L, 10000000000L);
        RecordIdentifier left = new RecordIdentifier(origTxn, bucketId, rowId);
        RecordIdentifier right = new RecordIdentifier(origTxn, bucketId, rowId);
        OrcRawRecordMerger.ReaderKey rkLeft = new OrcRawRecordMerger.ReaderKey(origTxn, bucketId, rowId, currTxn);
        OrcRawRecordMerger.ReaderKey rkRight = new OrcRawRecordMerger.ReaderKey(origTxn, bucketId, rowId, currTxn);
        Assert.assertEquals((String)"RecordIdentifier.equals", (Object)left, (Object)right);
        Assert.assertEquals((String)"RecordIdentifier.hashCode", (long)left.hashCode(), (long)right.hashCode());
        Assert.assertEquals((String)"ReaderKey", (Object)rkLeft, (Object)rkLeft);
        Assert.assertEquals((String)"ReaderKey.hashCode", (long)rkLeft.hashCode(), (long)rkRight.hashCode());
        Assert.assertNotEquals((String)"RecordIdentifier <> ReaderKey", (Object)left, (Object)rkRight);
    }
}

