/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import java.io.IOException;
import java.util.Arrays;
import java.util.Properties;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorAssignRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorDeserializeRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorExtractRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorRandomRowSource;
import org.apache.hadoop.hive.ql.exec.vector.VectorSerializeRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorVerifyFast;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatchCtx;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.ByteStream;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.binarysortable.fast.BinarySortableDeserializeRead;
import org.apache.hadoop.hive.serde2.binarysortable.fast.BinarySortableSerializeWrite;
import org.apache.hadoop.hive.serde2.fast.DeserializeRead;
import org.apache.hadoop.hive.serde2.fast.SerializeWrite;
import org.apache.hadoop.hive.serde2.lazy.LazySerDeParameters;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.hive.serde2.lazy.VerifyLazy;
import org.apache.hadoop.hive.serde2.lazy.fast.LazySimpleDeserializeRead;
import org.apache.hadoop.hive.serde2.lazy.fast.LazySimpleSerializeWrite;
import org.apache.hadoop.hive.serde2.lazybinary.fast.LazyBinaryDeserializeRead;
import org.apache.hadoop.hive.serde2.lazybinary.fast.LazyBinarySerializeWrite;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.UnionObject;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;

public class TestVectorSerDeRow
extends TestCase {
    private void verifyRead(DeserializeRead deserializeRead, TypeInfo typeInfo, Object expectedObject) throws IOException {
        if (typeInfo.getCategory() == ObjectInspector.Category.PRIMITIVE) {
            VectorVerifyFast.verifyDeserializeRead(deserializeRead, typeInfo, expectedObject);
        } else {
            Object complexFieldObj = VectorVerifyFast.deserializeReadComplexType(deserializeRead, typeInfo);
            if (expectedObject == null) {
                if (complexFieldObj != null) {
                    TestCase.fail((String)("Field reports not null but object is null (class " + complexFieldObj.getClass().getName() + ", " + complexFieldObj.toString() + ")"));
                }
            } else if (complexFieldObj == null) {
                UnionObject expectedUnion;
                if (expectedObject instanceof UnionObject && (expectedUnion = (UnionObject)expectedObject).getObject() == null) {
                    return;
                }
                TestCase.fail((String)("Field reports null but object is not null (class " + expectedObject.getClass().getName() + ", " + expectedObject.toString() + ")"));
            }
            if (!VerifyLazy.lazyCompare((TypeInfo)typeInfo, (Object)complexFieldObj, (Object)expectedObject)) {
                TestCase.fail((String)("Comparision failed typeInfo " + typeInfo.toString()));
            }
        }
    }

    void deserializeAndVerify(ByteStream.Output output, DeserializeRead deserializeRead, VectorRandomRowSource source, Object[] expectedRow) throws HiveException, IOException {
        deserializeRead.set(output.getData(), 0, output.getLength());
        TypeInfo[] typeInfos = source.typeInfos();
        for (int i = 0; i < typeInfos.length; ++i) {
            Object expected = expectedRow[i];
            TypeInfo typeInfo = typeInfos[i];
            this.verifyRead(deserializeRead, typeInfo, expected);
        }
        TestCase.assertTrue((boolean)deserializeRead.isEndOfInputReached());
    }

    void serializeBatch(VectorizedRowBatch batch, VectorSerializeRow vectorSerializeRow, DeserializeRead deserializeRead, VectorRandomRowSource source, Object[][] randomRows, int firstRandomRowIndex) throws HiveException, IOException {
        ByteStream.Output output = new ByteStream.Output();
        for (int i = 0; i < batch.size; ++i) {
            output.reset();
            vectorSerializeRow.setOutput(output);
            vectorSerializeRow.serializeWrite(batch, i);
            Object[] expectedRow = randomRows[firstRandomRowIndex + i];
            byte[] bytes = output.getData();
            int length = output.getLength();
            char[] chars = new char[length];
            for (int c = 0; c < chars.length; ++c) {
                chars[c] = (char)(bytes[c] & 0xFF);
            }
            this.deserializeAndVerify(output, deserializeRead, source, expectedRow);
        }
    }

    void testVectorSerializeRow(Random r, SerializationType serializationType) throws HiveException, IOException, SerDeException {
        for (int i = 0; i < 20; ++i) {
            this.innerTestVectorSerializeRow(r, serializationType);
        }
    }

    void innerTestVectorSerializeRow(Random r, SerializationType serializationType) throws HiveException, IOException, SerDeException {
        BinarySortableSerializeWrite serializeWrite;
        BinarySortableDeserializeRead deserializeRead;
        String[] emptyScratchTypeNames = new String[]{};
        VectorRandomRowSource source = new VectorRandomRowSource();
        source.init(r, VectorRandomRowSource.SupportedTypes.ALL, 4, false);
        VectorizedRowBatchCtx batchContext = new VectorizedRowBatchCtx();
        batchContext.init(source.rowStructObjectInspector(), emptyScratchTypeNames);
        VectorizedRowBatch batch = batchContext.createVectorizedRowBatch();
        VectorAssignRow vectorAssignRow = new VectorAssignRow();
        vectorAssignRow.init(source.typeNames());
        int fieldCount = source.typeNames().size();
        switch (serializationType) {
            case BINARY_SORTABLE: {
                deserializeRead = new BinarySortableDeserializeRead(source.typeInfos(), false);
                serializeWrite = new BinarySortableSerializeWrite(fieldCount);
                break;
            }
            case LAZY_BINARY: {
                deserializeRead = new LazyBinaryDeserializeRead(source.typeInfos(), false);
                serializeWrite = new LazyBinarySerializeWrite(fieldCount);
                break;
            }
            case LAZY_SIMPLE: {
                StructObjectInspector rowObjectInspector = source.rowStructObjectInspector();
                byte[] separators = new byte[]{9, 2, 3, 4, 5, 6, 7, 8};
                LazySerDeParameters lazySerDeParams = this.getSerDeParams(rowObjectInspector, separators);
                deserializeRead = new LazySimpleDeserializeRead(source.typeInfos(), false, lazySerDeParams);
                serializeWrite = new LazySimpleSerializeWrite(fieldCount, lazySerDeParams);
                break;
            }
            default: {
                throw new Error("Unknown serialization type " + serializationType);
            }
        }
        VectorSerializeRow vectorSerializeRow = new VectorSerializeRow((SerializeWrite)serializeWrite);
        vectorSerializeRow.init(source.typeNames());
        Object[][] randomRows = source.randomRows(2000);
        int firstRandomRowIndex = 0;
        for (int i = 0; i < randomRows.length; ++i) {
            Object[] row = randomRows[i];
            vectorAssignRow.assignRow(batch, batch.size, row);
            ++batch.size;
            if (batch.size != 1024) continue;
            this.serializeBatch(batch, vectorSerializeRow, (DeserializeRead)deserializeRead, source, randomRows, firstRandomRowIndex);
            firstRandomRowIndex = i + 1;
            batch.reset();
        }
        if (batch.size > 0) {
            this.serializeBatch(batch, vectorSerializeRow, (DeserializeRead)deserializeRead, source, randomRows, firstRandomRowIndex);
        }
    }

    void examineBatch(VectorizedRowBatch batch, VectorExtractRow vectorExtractRow, TypeInfo[] typeInfos, Object[][] randomRows, int firstRandomRowIndex) {
        int rowSize = vectorExtractRow.getCount();
        Object[] row = new Object[rowSize];
        for (int i = 0; i < batch.size; ++i) {
            vectorExtractRow.extractRow(batch, i, row);
            Object[] expectedRow = randomRows[firstRandomRowIndex + i];
            for (int c = 0; c < rowSize; ++c) {
                Object rowObj = row[c];
                Object expectedObj = expectedRow[c];
                if (rowObj == null) {
                    if (expectedObj == null) continue;
                    TestVectorSerDeRow.fail((String)("Unexpected NULL from extractRow.  Expected class " + typeInfos[c].getCategory() + " value " + expectedObj + " batch index " + i + " firstRandomRowIndex " + firstRandomRowIndex));
                }
                if (rowObj.equals(expectedObj)) continue;
                TestVectorSerDeRow.fail((String)("Row " + (firstRandomRowIndex + i) + " and column " + c + " mismatch (" + typeInfos[c].getCategory() + " actual value " + rowObj + " and expected value " + expectedObj + ")"));
            }
        }
    }

    private ByteStream.Output serializeRow(Object[] row, VectorRandomRowSource source, SerializeWrite serializeWrite) throws HiveException, IOException {
        ByteStream.Output output = new ByteStream.Output();
        serializeWrite.set(output);
        TypeInfo[] typeInfos = source.typeInfos();
        for (int i = 0; i < typeInfos.length; ++i) {
            VectorVerifyFast.serializeWrite(serializeWrite, typeInfos[i], row[i]);
        }
        return output;
    }

    private void addToProperties(Properties tbl, String fieldNames, String fieldTypes) {
        tbl.setProperty("serialization.format", "9");
        tbl.setProperty("columns", fieldNames);
        tbl.setProperty("columns.types", fieldTypes);
        tbl.setProperty("serialization.null.format", "\\N");
    }

    private LazySerDeParameters getSerDeParams(StructObjectInspector rowObjectInspector, byte[] separators) throws SerDeException {
        return this.getSerDeParams(new Configuration(), new Properties(), rowObjectInspector, separators);
    }

    private LazySerDeParameters getSerDeParams(Configuration conf, Properties tbl, StructObjectInspector rowObjectInspector, byte[] separators) throws SerDeException {
        String fieldNames = ObjectInspectorUtils.getFieldNames((StructObjectInspector)rowObjectInspector);
        String fieldTypes = ObjectInspectorUtils.getFieldTypes((StructObjectInspector)rowObjectInspector);
        this.addToProperties(tbl, fieldNames, fieldTypes);
        LazySerDeParameters lazySerDeParams = new LazySerDeParameters(conf, tbl, LazySimpleSerDe.class.getName());
        for (int i = 0; i < separators.length; ++i) {
            lazySerDeParams.setSeparator(i, separators[i]);
        }
        return lazySerDeParams;
    }

    void testVectorDeserializeRow(Random r, SerializationType serializationType, boolean alternate1, boolean alternate2, boolean useExternalBuffer) throws HiveException, IOException, SerDeException {
        for (int i = 0; i < 20; ++i) {
            this.innerTestVectorDeserializeRow(r, serializationType, alternate1, alternate2, useExternalBuffer);
        }
    }

    void innerTestVectorDeserializeRow(Random r, SerializationType serializationType, boolean alternate1, boolean alternate2, boolean useExternalBuffer) throws HiveException, IOException, SerDeException {
        int i;
        LazyBinarySerializeWrite serializeWrite;
        LazyBinaryDeserializeRead deserializeRead;
        String[] emptyScratchTypeNames = new String[]{};
        VectorRandomRowSource source = new VectorRandomRowSource();
        source.init(r, VectorRandomRowSource.SupportedTypes.ALL, 4, false);
        VectorizedRowBatchCtx batchContext = new VectorizedRowBatchCtx();
        batchContext.init(source.rowStructObjectInspector(), emptyScratchTypeNames);
        VectorizedRowBatch batch = batchContext.createVectorizedRowBatch();
        for (ColumnVector cv : batch.cols) {
            Arrays.fill(cv.isNull, true);
        }
        TypeInfo[] typeInfos = source.typeInfos();
        int fieldCount = source.typeNames().size();
        switch (serializationType) {
            case BINARY_SORTABLE: {
                boolean useColumnSortOrderIsDesc = alternate1;
                if (!useColumnSortOrderIsDesc) {
                    deserializeRead = new BinarySortableDeserializeRead(source.typeInfos(), useExternalBuffer);
                    serializeWrite = new BinarySortableSerializeWrite(fieldCount);
                } else {
                    boolean[] columnSortOrderIsDesc = new boolean[fieldCount];
                    for (int i2 = 0; i2 < fieldCount; ++i2) {
                        columnSortOrderIsDesc[i2] = r.nextBoolean();
                    }
                    byte[] columnNullMarker = new byte[fieldCount];
                    byte[] columnNotNullMarker = new byte[fieldCount];
                    for (i = 0; i < fieldCount; ++i) {
                        if (columnSortOrderIsDesc[i]) {
                            columnNullMarker[i] = 0;
                            columnNotNullMarker[i] = 1;
                            continue;
                        }
                        columnNullMarker[i] = 0;
                        columnNotNullMarker[i] = 1;
                    }
                    serializeWrite = new BinarySortableSerializeWrite(columnSortOrderIsDesc, columnNullMarker, columnNotNullMarker);
                    deserializeRead = new BinarySortableDeserializeRead(source.typeInfos(), useExternalBuffer, columnSortOrderIsDesc, columnNullMarker, columnNotNullMarker);
                }
                boolean useBinarySortableCharsNeedingEscape = alternate2;
                if (!useBinarySortableCharsNeedingEscape) break;
                source.addBinarySortableAlphabets();
                break;
            }
            case LAZY_BINARY: {
                deserializeRead = new LazyBinaryDeserializeRead(source.typeInfos(), useExternalBuffer);
                serializeWrite = new LazyBinarySerializeWrite(fieldCount);
                break;
            }
            case LAZY_SIMPLE: {
                StructObjectInspector rowObjectInspector = source.rowStructObjectInspector();
                Configuration conf = new Configuration();
                Properties tbl = new Properties();
                tbl.setProperty("field.delim", "\t");
                tbl.setProperty("line.delim", "\n");
                byte separator = 9;
                boolean useLazySimpleEscapes = alternate1;
                if (useLazySimpleEscapes) {
                    tbl.setProperty("quote.delim", "'");
                    String escapeString = "\\";
                    tbl.setProperty("escape.delim", escapeString);
                }
                LazySerDeParameters lazySerDeParams = this.getSerDeParams(conf, tbl, rowObjectInspector, new byte[]{separator});
                if (useLazySimpleEscapes) {
                    String needsEscapeStr;
                    boolean[] needsEscape = lazySerDeParams.getNeedsEscape();
                    StringBuilder sb = new StringBuilder();
                    if (needsEscape[10]) {
                        sb.append('\n');
                    }
                    if (needsEscape[13]) {
                        sb.append('\r');
                    }
                    if ((needsEscapeStr = sb.toString()).length() > 0) {
                        source.addEscapables(needsEscapeStr);
                    }
                }
                deserializeRead = new LazySimpleDeserializeRead(source.typeInfos(), useExternalBuffer, lazySerDeParams);
                serializeWrite = new LazySimpleSerializeWrite(fieldCount, lazySerDeParams);
                break;
            }
            default: {
                throw new Error("Unknown serialization type " + serializationType);
            }
        }
        VectorDeserializeRow vectorDeserializeRow = new VectorDeserializeRow((DeserializeRead)deserializeRead);
        vectorDeserializeRow.init();
        for (ColumnVector cv : batch.cols) {
            Arrays.fill(cv.isNull, true);
            cv.noNulls = false;
        }
        VectorExtractRow vectorExtractRow = new VectorExtractRow();
        vectorExtractRow.init(source.typeNames());
        Object[][] randomRows = source.randomRows(2000);
        int firstRandomRowIndex = 0;
        for (i = 0; i < randomRows.length; ++i) {
            Object[] row = randomRows[i];
            ByteStream.Output output = this.serializeRow(row, source, (SerializeWrite)serializeWrite);
            vectorDeserializeRow.setBytes(output.getData(), 0, output.getLength());
            try {
                vectorDeserializeRow.deserialize(batch, batch.size);
            }
            catch (Exception e) {
                throw new HiveException("\nDeserializeRead details: " + vectorDeserializeRow.getDetailedReadPositionString(), (Throwable)e);
            }
            ++batch.size;
            if (batch.size != 1024) continue;
            this.examineBatch(batch, vectorExtractRow, typeInfos, randomRows, firstRandomRowIndex);
            firstRandomRowIndex = i + 1;
            batch.reset();
        }
        if (batch.size > 0) {
            this.examineBatch(batch, vectorExtractRow, typeInfos, randomRows, firstRandomRowIndex);
        }
    }

    public void testVectorBinarySortableSerializeRow() throws Throwable {
        Random r = new Random(8732L);
        this.testVectorSerializeRow(r, SerializationType.BINARY_SORTABLE);
    }

    public void testVectorLazyBinarySerializeRow() throws Throwable {
        Random r = new Random(8732L);
        this.testVectorSerializeRow(r, SerializationType.LAZY_BINARY);
    }

    public void testVectorLazySimpleSerializeRow() throws Throwable {
        Random r = new Random(8732L);
        this.testVectorSerializeRow(r, SerializationType.LAZY_SIMPLE);
    }

    public void testVectorBinarySortableDeserializeRow() throws Throwable {
        Random r = new Random(8732L);
        this.testVectorDeserializeRow(r, SerializationType.BINARY_SORTABLE, false, false, false);
        this.testVectorDeserializeRow(r, SerializationType.BINARY_SORTABLE, true, false, false);
        this.testVectorDeserializeRow(r, SerializationType.BINARY_SORTABLE, false, false, true);
        this.testVectorDeserializeRow(r, SerializationType.BINARY_SORTABLE, true, false, true);
        this.testVectorDeserializeRow(r, SerializationType.BINARY_SORTABLE, false, true, false);
        this.testVectorDeserializeRow(r, SerializationType.BINARY_SORTABLE, true, true, false);
        this.testVectorDeserializeRow(r, SerializationType.BINARY_SORTABLE, false, true, true);
        this.testVectorDeserializeRow(r, SerializationType.BINARY_SORTABLE, true, true, true);
    }

    public void testVectorLazyBinaryDeserializeRow() throws Throwable {
        Random r = new Random(8732L);
        this.testVectorDeserializeRow(r, SerializationType.LAZY_BINARY, false, false, false);
        this.testVectorDeserializeRow(r, SerializationType.LAZY_BINARY, false, false, true);
    }

    public void testVectorLazySimpleDeserializeRow() throws Throwable {
        Random r = new Random(8732L);
        this.testVectorDeserializeRow(r, SerializationType.LAZY_SIMPLE, false, false, false);
        this.testVectorDeserializeRow(r, SerializationType.LAZY_SIMPLE, false, false, true);
        this.testVectorDeserializeRow(r, SerializationType.LAZY_SIMPLE, true, false, false);
        this.testVectorDeserializeRow(r, SerializationType.LAZY_SIMPLE, true, false, true);
    }

    public static enum SerializationType {
        NONE,
        BINARY_SORTABLE,
        LAZY_BINARY,
        LAZY_SIMPLE;

    }
}

