/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import javax.security.auth.login.LoginException;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.tez.TezSessionPoolManager;
import org.apache.hadoop.hive.ql.exec.tez.TezSessionPoolSession;
import org.apache.hadoop.hive.ql.exec.tez.TezSessionState;
import org.apache.hadoop.hive.ql.exec.tez.WmTezSession;
import org.apache.hadoop.hive.shims.Utils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.tez.dag.api.TezException;

public class SampleTezSessionState
extends WmTezSession {
    private boolean open;
    private final String sessionId;
    private final HiveConf hiveConf;
    private String user;
    private boolean doAsEnabled;
    private ListenableFuture<Boolean> waitForAmRegFuture;

    public SampleTezSessionState(String sessionId, TezSessionPoolSession.Manager parent, HiveConf conf) {
        super(sessionId, parent, parent instanceof TezSessionPoolManager ? ((TezSessionPoolManager)parent).getExpirationTracker() : null, conf);
        this.sessionId = sessionId;
        this.hiveConf = conf;
        this.waitForAmRegFuture = this.createDefaultWaitForAmRegistryFuture();
    }

    private SettableFuture<Boolean> createDefaultWaitForAmRegistryFuture() {
        SettableFuture noWait = SettableFuture.create();
        noWait.set((Object)true);
        return noWait;
    }

    public boolean isOpen() {
        return this.open;
    }

    public void setOpen(boolean open) {
        this.open = open;
    }

    public void open() throws LoginException, IOException {
        UserGroupInformation ugi = Utils.getUGI();
        this.user = ugi.getShortUserName();
        this.doAsEnabled = this.hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_ENABLE_DOAS);
        this.setOpen(true);
    }

    public void open(TezSessionState.HiveResources resources) throws LoginException, IOException {
        this.open();
    }

    public void open(String[] additionalFiles) throws IOException, LoginException {
        this.open();
    }

    void close(boolean keepTmpDir) throws TezException, IOException {
        this.open = keepTmpDir;
    }

    public HiveConf getConf() {
        return this.hiveConf;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getUser() {
        return this.user;
    }

    public boolean getDoAsEnabled() {
        return this.doAsEnabled;
    }

    public SettableFuture<WmTezSession> waitForAmRegistryAsync(int timeoutMs, ScheduledExecutorService timeoutPool) {
        final SampleTezSessionState session = this;
        final SettableFuture future = SettableFuture.create();
        Futures.addCallback(this.waitForAmRegFuture, (FutureCallback)new FutureCallback<Boolean>(){

            public void onSuccess(Boolean result) {
                future.set((Object)session);
            }

            public void onFailure(Throwable t) {
                future.setException(t);
            }
        }, (Executor)MoreExecutors.directExecutor());
        return future;
    }

    public void setWaitForAmRegistryFuture(ListenableFuture<Boolean> future) {
        this.waitForAmRegFuture = future != null ? future : this.createDefaultWaitForAmRegistryFuture();
    }
}

