/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.time.ZoneId;
import java.util.TimeZone;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.common.type.TimestampTZ;
import org.apache.hadoop.hive.common.type.TimestampTZUtil;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.io.TimestampWritableV2;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorConverter;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableTimestampObjectInspector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Description(name="from_utc_timestamp", value="from_utc_timestamp(timestamp, string timezone) - Assumes given timestamp is UTC and converts to given timezone (as of Hive 0.8.0)")
public class GenericUDFFromUtcTimestamp
extends GenericUDF {
    static final Logger LOG = LoggerFactory.getLogger(GenericUDFFromUtcTimestamp.class);
    private transient PrimitiveObjectInspector[] argumentOIs;
    private transient PrimitiveObjectInspectorConverter.TimestampConverter timestampConverter;
    private transient PrimitiveObjectInspectorConverter.TextConverter textConverter;
    private transient TimeZone tzUTC = TimeZone.getTimeZone("UTC");

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length != 2) {
            throw new UDFArgumentLengthException("The function " + this.getName() + " requires two argument, got " + arguments.length);
        }
        try {
            this.argumentOIs = new PrimitiveObjectInspector[2];
            this.argumentOIs[0] = (PrimitiveObjectInspector)arguments[0];
            this.argumentOIs[1] = (PrimitiveObjectInspector)arguments[1];
        }
        catch (ClassCastException e) {
            throw new UDFArgumentException("The function " + this.getName() + " takes only primitive types");
        }
        this.timestampConverter = new PrimitiveObjectInspectorConverter.TimestampConverter(this.argumentOIs[0], (SettableTimestampObjectInspector)PrimitiveObjectInspectorFactory.writableTimestampObjectInspector);
        this.textConverter = new PrimitiveObjectInspectorConverter.TextConverter(this.argumentOIs[1]);
        return PrimitiveObjectInspectorFactory.javaTimestampObjectInspector;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        TimeZone toTz;
        TimeZone fromTz;
        Object o0 = arguments[0].get();
        if (o0 == null) {
            return null;
        }
        Object o1 = arguments[1].get();
        if (o1 == null) {
            return null;
        }
        Object converted_o0 = this.timestampConverter.convert(o0);
        if (converted_o0 == null) {
            return null;
        }
        Timestamp inputTs = ((TimestampWritableV2)converted_o0).getTimestamp();
        String tzStr = this.textConverter.convert(o1).toString();
        TimeZone timezone = TimeZone.getTimeZone(tzStr);
        if (this.invert()) {
            fromTz = timezone;
            toTz = this.tzUTC;
        } else {
            fromTz = this.tzUTC;
            toTz = timezone;
        }
        TimestampTZ fromTs = TimestampTZUtil.parse((String)inputTs.toString(), (ZoneId)fromTz.toZoneId());
        if (fromTs == null) {
            return null;
        }
        Timestamp result = Timestamp.valueOf((String)fromTs.getZonedDateTime().withZoneSameInstant(toTz.toZoneId()).toLocalDateTime().toString());
        return result;
    }

    @Override
    public String getDisplayString(String[] children) {
        StringBuilder sb = new StringBuilder();
        sb.append("Converting field ");
        sb.append(children[0]);
        sb.append(" from UTC to timezone: ");
        if (children.length > 1) {
            sb.append(children[1]);
        }
        return sb.toString();
    }

    public String getName() {
        return "from_utc_timestamp";
    }

    protected boolean invert() {
        return false;
    }
}

