/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import com.mapr.fs.MapRFileSystem;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.SymLinkUtils;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.exec.DummyStoreOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Writable;

public abstract class AbstractMapOperator
extends Operator<MapWork>
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private Configuration internalConf;
    protected final transient LongWritable deserialize_error_count = new LongWritable();
    protected final transient LongWritable recordCounter = new LongWritable();
    protected transient long numRows = 0L;
    private final Map<Integer, DummyStoreOperator> connectedOperators = new TreeMap<Integer, DummyStoreOperator>();
    private final transient Map<Path, Path> normalizedPaths = new HashMap<Path, Path>();

    private Path normalizePath(Path onefile, boolean schemaless) {
        Path path = this.normalizedPaths.get(onefile);
        if (path == null) {
            path = onefile;
            if (schemaless && path.toUri().getScheme() != null) {
                path = new Path(path.toUri().getPath());
            }
            this.normalizedPaths.put(onefile, path);
        }
        return path;
    }

    protected String getNominalPath(Path fpath) {
        Path nominal = null;
        boolean schemaless = fpath.toUri().getScheme() == null;
        for (Path onefile : ((MapWork)this.conf).getPathToAliases().keySet()) {
            Path onepath = this.normalizePath(onefile, schemaless);
            try {
                if (FileSystem.get((Configuration)this.internalConf) instanceof MapRFileSystem && SymLinkUtils.isSymLinkSupportEnabled((Configuration)this.internalConf)) {
                    FileSystem maprFS = MapRFileSystem.get((Configuration)this.internalConf);
                    FileStatus fileStatus = maprFS.getFileStatus(onepath);
                    boolean isFound = false;
                    if (fileStatus.isSymlink()) {
                        onepath = FileUtil.fixSymlinkFileStatus((FileStatus)fileStatus);
                        isFound = true;
                    } else {
                        FileStatus[] fileStatuses;
                        for (FileStatus each : fileStatuses = maprFS.listStatus(onepath)) {
                            Path p;
                            if (!each.isSymlink() || maprFS.getFileStatus(p = FileUtil.fixSymlinkFileStatus((FileStatus)each)).compareTo(maprFS.getFileStatus(fpath)) != 0) continue;
                            onepath = p.getParent();
                            isFound = true;
                            break;
                        }
                    }
                    if (!isFound) {
                        Path p;
                        Stack<String> nodes = new Stack<String>();
                        nodes.push(onepath.getName());
                        for (p = onepath.getParent(); p != null; p = p.getParent()) {
                            fileStatus = maprFS.getFileStatus(p);
                            if (fileStatus.isSymlink()) {
                                p = FileUtil.fixSymlinkFileStatus((FileStatus)fileStatus);
                                isFound = true;
                                break;
                            }
                            nodes.push(p.getName());
                        }
                        if (isFound) {
                            Object processedPath = p.toString();
                            while (!nodes.isEmpty()) {
                                processedPath = (String)processedPath + "/" + (String)nodes.pop();
                            }
                            onepath = new Path((String)processedPath);
                        }
                    }
                }
            }
            catch (IOException maprFS) {
                // empty catch block
            }
            Path curfpath = fpath;
            if (!schemaless && onepath.toUri().getScheme() == null) {
                curfpath = new Path(fpath.toUri().getPath());
            }
            if (onepath.toUri().relativize(curfpath.toUri()).equals(curfpath.toUri())) continue;
            if (nominal != null) {
                throw new IllegalStateException("Ambiguous input path " + fpath);
            }
            nominal = onefile;
            break;
        }
        if (nominal == null) {
            throw new IllegalStateException("Invalid input path " + fpath);
        }
        return nominal.toString();
    }

    public abstract void initEmptyInputChildren(List<Operator<?>> var1, Configuration var2) throws SerDeException, Exception;

    protected AbstractMapOperator() {
    }

    public AbstractMapOperator(CompilationOpContext ctx) {
        super(ctx);
    }

    public abstract void setChildren(Configuration var1) throws Exception;

    public void initializeMapOperator(Configuration hconf) throws HiveException {
        this.state = Operator.State.INIT;
        this.internalConf = hconf;
        this.statsMap.put(Counter.DESERIALIZE_ERRORS.toString(), this.deserialize_error_count);
        this.numRows = 0L;
        Object context = hconf.get("__hive.context.name", "");
        if (context != null && !((String)context).isEmpty()) {
            context = "_" + ((String)context).replace(" ", "_");
        }
        this.statsMap.put(Counter.RECORDS_IN + (String)context, this.recordCounter);
    }

    public abstract void initializeContexts() throws HiveException;

    public abstract Deserializer getCurrentDeserializer();

    public abstract void process(Writable var1) throws HiveException;

    @Override
    public void closeOp(boolean abort) throws HiveException {
        this.recordCounter.set(this.numRows);
        super.closeOp(abort);
    }

    public void clearConnectedOperators() {
        this.connectedOperators.clear();
    }

    public void setConnectedOperators(int tag, DummyStoreOperator dummyOp) {
        this.connectedOperators.put(tag, dummyOp);
    }

    public Map<Integer, DummyStoreOperator> getConnectedOperators() {
        return this.connectedOperators;
    }

    public static enum Counter {
        DESERIALIZE_ERRORS,
        RECORDS_IN;

    }
}

