/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.sql.Date;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.io.DateWritableV2;
import org.apache.hadoop.hive.serde2.io.TimestampWritableV2;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;

@Description(name="datetime_legacy_hybrid_calendar", value="_FUNC_(date/timestamp) - Converts a date/timestamp to new proleptic Gregorian calendar \nassuming that its internal days/milliseconds since epoch is calculated using legacy Gregorian-Julian hybrid calendar.", extended="Converts a date/timestamp to new proleptic Gregorian calendar (ISO 8601 standard), which is produced \nby extending the Gregorian calendar backward to dates preceding its official introduction in 1582, assuming \nthat its internal days/milliseconds since epoch is calculated using legacy Gregorian-Julian hybrid calendar, \ni.e., calendar that supports both the Julian and Gregorian calendar systems with the support of a single \ndiscontinuity, which corresponds by default to the Gregorian date when the Gregorian calendar was instituted.")
public class GenericUDFDatetimeLegacyHybridCalendar
extends GenericUDF {
    private transient PrimitiveObjectInspector inputOI;
    private transient PrimitiveObjectInspector resultOI;
    private transient ObjectInspectorConverters.Converter converter;
    private transient SimpleDateFormat formatter;
    private DateWritableV2 dateWritable = new DateWritableV2();
    private TimestampWritableV2 timestampWritable = new TimestampWritableV2();

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length < 1) {
            throw new UDFArgumentLengthException("The function datetime_legacy_hybrid_calendar requires at least one argument, got " + arguments.length);
        }
        try {
            this.inputOI = (PrimitiveObjectInspector)arguments[0];
            PrimitiveObjectInspector.PrimitiveCategory pc = this.inputOI.getPrimitiveCategory();
            switch (pc) {
                case DATE: {
                    this.formatter = new SimpleDateFormat("yyyy-MM-dd");
                    this.formatter.setLenient(false);
                    this.formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
                    this.converter = ObjectInspectorConverters.getConverter((ObjectInspector)this.inputOI, (ObjectInspector)PrimitiveObjectInspectorFactory.writableDateObjectInspector);
                    this.resultOI = PrimitiveObjectInspectorFactory.writableDateObjectInspector;
                    break;
                }
                case TIMESTAMP: {
                    this.formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    this.formatter.setLenient(false);
                    this.formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
                    this.converter = ObjectInspectorConverters.getConverter((ObjectInspector)this.inputOI, (ObjectInspector)PrimitiveObjectInspectorFactory.writableTimestampObjectInspector);
                    this.resultOI = PrimitiveObjectInspectorFactory.writableTimestampObjectInspector;
                    break;
                }
                default: {
                    throw new UDFArgumentException("datetime_legacy_hybrid_calendar only allows date or timestamp types");
                }
            }
        }
        catch (ClassCastException e) {
            throw new UDFArgumentException("The function datetime_legacy_hybrid_calendar takes only primitive types");
        }
        return this.resultOI;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        Object input = arguments[0].get();
        if (input == null) {
            return null;
        }
        input = this.converter.convert(input);
        switch (this.resultOI.getPrimitiveCategory()) {
            case DATE: {
                org.apache.hadoop.hive.common.type.Date date = ((DateWritableV2)input).get();
                Date oldDate = new Date(date.toEpochMilli());
                this.dateWritable.set(org.apache.hadoop.hive.common.type.Date.valueOf((String)this.formatter.format(oldDate)));
                return this.dateWritable;
            }
            case TIMESTAMP: {
                org.apache.hadoop.hive.common.type.Timestamp timestamp = ((TimestampWritableV2)input).getTimestamp();
                org.apache.hadoop.hive.common.type.Timestamp adjustedTimestamp = org.apache.hadoop.hive.common.type.Timestamp.valueOf((String)this.formatter.format(new Timestamp(timestamp.toEpochMilli())));
                adjustedTimestamp.setNanos(timestamp.getNanos());
                this.timestampWritable.set(adjustedTimestamp);
                return this.timestampWritable;
            }
        }
        throw new IllegalStateException("Unexpected type in evaluating datetime_legacy_hybrid_calendar: " + this.inputOI.getPrimitiveCategory());
    }

    @Override
    public String getDisplayString(String[] children) {
        return this.getStandardDisplayString(this.getFuncName(), children);
    }

    @Override
    protected String getFuncName() {
        return "datetime_legacy_hybrid_calendar";
    }
}

