/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.opa;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.HiveMetaStore;
import org.apache.hadoop.hive.metastore.MetaStorePreEventListener;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.events.PreEventContext;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeObject;
import org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.HiveMetaStoreAuthorizableEvent;
import org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.HiveMetaStoreAuthzInfo;
import org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.events.AddPartitionEvent;
import org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.events.AlterDatabaseEvent;
import org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.events.AlterPartitionEvent;
import org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.events.AlterTableEvent;
import org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.events.CreateDatabaseEvent;
import org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.events.CreateFunctionEvent;
import org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.events.CreateTableEvent;
import org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.events.DropDatabaseEvent;
import org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.events.DropFunctionEvent;
import org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.events.DropPartitionEvent;
import org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.events.DropTableEvent;
import org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.events.LoadPartitionDoneEvent;
import org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.events.ReadDatabaseEvent;
import org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.events.ReadTableEvent;
import org.apache.hadoop.security.UserGroupInformation;

public class OPAMetaStoreAuthorizer
extends MetaStorePreEventListener {
    private static final Log LOG = LogFactory.getLog(OPAMetaStoreAuthorizer.class);
    private final String OPA_URL;
    private final String CATALOG = "datalakehouse";
    private String eventType;

    public OPAMetaStoreAuthorizer(Configuration config) {
        super(config);
        this.OPA_URL = config.get(MetastoreConf.ConfVars.HIVE_METASTORE_OPA_URL.getHiveName());
    }

    public final void onEvent(PreEventContext preEventContext) throws MetaException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> OPAMetaStoreAuthorizer.onEvent(): preEventContext event type = " + preEventContext.getEventType()));
        }
        if (!this.isSuperUser(this.getCurrentUser())) {
            HiveMetaStoreAuthzInfo authzContext = this.buildAuthzContext(preEventContext);
            this.checkPrivileges(authzContext, preEventContext);
        }
    }

    private HiveMetaStoreAuthzInfo buildAuthzContext(PreEventContext preEventContext) throws MetaException {
        HiveMetaStoreAuthorizableEvent authzEvent = null;
        String create = "CREATE";
        String alter = "ALTER";
        String drop = "DELETE";
        String read = "READ";
        switch (preEventContext.getEventType()) {
            case CREATE_DATABASE: {
                authzEvent = new CreateDatabaseEvent(preEventContext);
                this.eventType = create;
                break;
            }
            case ALTER_DATABASE: {
                authzEvent = new AlterDatabaseEvent(preEventContext);
                this.eventType = alter;
                break;
            }
            case DROP_DATABASE: {
                authzEvent = new DropDatabaseEvent(preEventContext);
                this.eventType = drop;
                break;
            }
            case CREATE_TABLE: {
                authzEvent = new CreateTableEvent(preEventContext);
                this.eventType = create;
                break;
            }
            case ALTER_TABLE: {
                authzEvent = new AlterTableEvent(preEventContext);
                this.eventType = alter;
                break;
            }
            case DROP_TABLE: {
                authzEvent = new DropTableEvent(preEventContext);
                this.eventType = drop;
                break;
            }
            case ADD_PARTITION: {
                authzEvent = new AddPartitionEvent(preEventContext);
                this.eventType = alter;
                break;
            }
            case ALTER_PARTITION: {
                authzEvent = new AlterPartitionEvent(preEventContext);
                this.eventType = alter;
                break;
            }
            case LOAD_PARTITION_DONE: {
                authzEvent = new LoadPartitionDoneEvent(preEventContext);
                this.eventType = alter;
                break;
            }
            case DROP_PARTITION: {
                authzEvent = new DropPartitionEvent(preEventContext);
                this.eventType = alter;
                break;
            }
            case READ_TABLE: {
                authzEvent = new ReadTableEvent(preEventContext);
                this.eventType = read;
                break;
            }
            case READ_DATABASE: {
                authzEvent = new ReadDatabaseEvent(preEventContext);
                this.eventType = read;
                break;
            }
            case CREATE_FUNCTION: {
                authzEvent = new CreateFunctionEvent(preEventContext);
                this.eventType = create;
                break;
            }
            case DROP_FUNCTION: {
                authzEvent = new DropFunctionEvent(preEventContext);
                this.eventType = drop;
                break;
            }
            case AUTHORIZATION_API_CALL: 
            case READ_ISCHEMA: 
            case CREATE_ISCHEMA: 
            case DROP_ISCHEMA: 
            case ALTER_ISCHEMA: 
            case ADD_SCHEMA_VERSION: 
            case ALTER_SCHEMA_VERSION: 
            case DROP_SCHEMA_VERSION: 
            case READ_SCHEMA_VERSION: 
            case CREATE_CATALOG: 
            case ALTER_CATALOG: 
            case DROP_CATALOG: {
                if (this.isSuperUser(this.getCurrentUser())) break;
                throw new MetaException(" Operation type " + preEventContext.getEventType().name() + " not allowed for user: " + this.getCurrentUser());
            }
        }
        return authzEvent != null ? authzEvent.getAuthzContext() : null;
    }

    private void checkPrivileges(HiveMetaStoreAuthzInfo authzContext, PreEventContext preEventContext) throws MetaException {
        List<HivePrivilegeObject> inputHObjs;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> OPAMetaStoreAuthorizer.checkPrivileges(): event type = " + preEventContext.getEventType()));
        }
        if ((inputHObjs = authzContext.getInputHObjs()).isEmpty()) {
            String message = "No input objects provided for authorization even though authorization is enabled.";
            LOG.error((Object)message);
            throw new MetaException(message);
        }
        for (HivePrivilegeObject obj : inputHObjs) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("==> OPAMetaStoreAuthorizer.checkPrivileges(): object = " + obj));
            }
            String databaseName = obj.getDbname();
            String tableName = obj.getObjectName();
            String user = this.getCurrentUser();
            HashMap<String, Object> input = new HashMap<String, Object>();
            input.put("input_grant", null);
            input.put("input_resource", Map.of("groups", List.of(), "resource", this.constructInputResource(this.CATALOG, null, null, databaseName, tableName), "user", user));
            input.put("operation", this.eventType);
            input.put("target_resource", null);
            boolean isAllowed = this.queryOPA(input);
            if (isAllowed) continue;
            throw new MetaException(" Operation is not allowed by OPA policy. Operation: " + preEventContext.getEventType() + ", User: " + user);
        }
    }

    private Map<String, Object> constructInputResource(String catalog, String columns, String propertyName, String schemaName, String tableName) {
        HashMap<String, Object> inputResource = new HashMap<String, Object>();
        inputResource.put("catalog", catalog);
        inputResource.put("columns", columns);
        inputResource.put("propertyName", propertyName);
        inputResource.put("schemaName", schemaName);
        inputResource.put("tableName", tableName);
        return inputResource;
    }

    private boolean queryOPA(Map<String, Object> input) throws MetaException {
        try {
            Map<String, Map<String, Object>> requestBody = Map.of("input", input);
            ObjectMapper objectMapper = new ObjectMapper();
            String requestBodyJson = objectMapper.writeValueAsString(requestBody);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("==> OPAMetaStoreAuthorizer.queryOPA(): input = " + requestBodyJson));
            }
            HttpClient client = HttpClient.newHttpClient();
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(this.OPA_URL)).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(requestBodyJson)).build();
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("==> OPAMetaStoreAuthorizer.queryOPA(): response = " + response.body()));
            }
            Map responseBody = (Map)objectMapper.readValue(response.body(), Map.class);
            return responseBody.getOrDefault("result", false);
        }
        catch (Exception e) {
            LOG.error((Object)("Error querying OPA at " + this.OPA_URL), (Throwable)e);
            throw new MetaException("Authorization query to OPA failed: " + e.getMessage());
        }
    }

    private boolean isSuperUser(String userName) {
        Configuration conf = this.getConf();
        String ipAddress = HiveMetaStore.HMSHandler.getIPAddress();
        return MetaStoreUtils.checkUserHasHostProxyPrivileges((String)userName, (Configuration)conf, (String)ipAddress);
    }

    private String getCurrentUser() {
        try {
            return UserGroupInformation.getCurrentUser().getShortUserName();
        }
        catch (IOException ioException) {
            LOG.error((Object)"Error getting current user: ", (Throwable)ioException);
            return null;
        }
    }
}

