/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFWidthBucket;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.JavaIntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.JavaLongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.IntWritable;
import org.junit.Assert;
import org.junit.Test;

public class TestGenericUDFWidthBucket {
    @Test
    public void testExprLessThanMinValue() throws HiveException {
        Assert.assertEquals((long)0L, (long)this.testWidthBucketWithValues(99L, 100L, 5000L, 10).get());
    }

    @Test
    public void testExprEqualsMinValue() throws HiveException {
        Assert.assertEquals((long)1L, (long)this.testWidthBucketWithValues(100L, 100L, 5000L, 10).get());
    }

    @Test
    public void testExprEqualsBoundaryValue() throws HiveException {
        Assert.assertEquals((long)2L, (long)this.testWidthBucketWithValues(590L, 100L, 5000L, 10).get());
    }

    @Test
    public void testExprEqualsMaxValue() throws HiveException {
        Assert.assertEquals((long)11L, (long)this.testWidthBucketWithValues(5000L, 100L, 5000L, 10).get());
    }

    @Test
    public void testExprAboveMaxValue() throws HiveException {
        Assert.assertEquals((long)11L, (long)this.testWidthBucketWithValues(6000L, 100L, 5000L, 10).get());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNegativeBucketValue() throws HiveException {
        this.testWidthBucketWithValues(100L, 100L, 5000L, -1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testZeroBucketValue() throws HiveException {
        this.testWidthBucketWithValues(100L, 100L, 5000L, 0);
    }

    private IntWritable testWidthBucketWithValues(Long expr, Long minValue, Long maxValue, Integer numBuckets) throws HiveException {
        GenericUDFWidthBucket udf = new GenericUDFWidthBucket();
        JavaLongObjectInspector valueOI1 = PrimitiveObjectInspectorFactory.javaLongObjectInspector;
        JavaLongObjectInspector valueOI2 = PrimitiveObjectInspectorFactory.javaLongObjectInspector;
        JavaLongObjectInspector valueOI3 = PrimitiveObjectInspectorFactory.javaLongObjectInspector;
        JavaIntObjectInspector valueOI4 = PrimitiveObjectInspectorFactory.javaIntObjectInspector;
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI1, valueOI2, valueOI3, valueOI4};
        udf.initialize(arguments);
        GenericUDF.DeferredJavaObject valueObj1 = new GenericUDF.DeferredJavaObject((Object)expr);
        GenericUDF.DeferredJavaObject valueObj2 = new GenericUDF.DeferredJavaObject((Object)minValue);
        GenericUDF.DeferredJavaObject valueObj3 = new GenericUDF.DeferredJavaObject((Object)maxValue);
        GenericUDF.DeferredJavaObject valueObj4 = new GenericUDF.DeferredJavaObject((Object)numBuckets);
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{valueObj1, valueObj2, valueObj3, valueObj4};
        return (IntWritable)udf.evaluate(args);
    }
}

