/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.authorization;

import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.DDLSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ParseDriver;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.authorization.AuthorizationTestUtil;
import org.apache.hadoop.hive.ql.parse.authorization.HiveAuthorizationTaskFactoryImpl;
import org.apache.hadoop.hive.ql.parse.authorization.ListSizeMatcher;
import org.apache.hadoop.hive.ql.plan.DDLWork;
import org.apache.hadoop.hive.ql.plan.GrantDesc;
import org.apache.hadoop.hive.ql.plan.GrantRevokeRoleDDL;
import org.apache.hadoop.hive.ql.plan.PrincipalDesc;
import org.apache.hadoop.hive.ql.plan.PrivilegeDesc;
import org.apache.hadoop.hive.ql.plan.PrivilegeObjectDesc;
import org.apache.hadoop.hive.ql.plan.RevokeDesc;
import org.apache.hadoop.hive.ql.plan.RoleDDLDesc;
import org.apache.hadoop.hive.ql.plan.ShowGrantDesc;
import org.apache.hadoop.hive.ql.security.HadoopDefaultAuthenticator;
import org.apache.hadoop.hive.ql.security.authorization.Privilege;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestHiveAuthorizationTaskFactory {
    private static final String SELECT = "SELECT";
    private static final String DB = "default";
    private static final String TABLE = "table1";
    private static final String TABLE_QNAME = "default.table1";
    private static final String GROUP = "group1";
    private static final String ROLE = "role1";
    private static final String USER = "user1";
    private ParseDriver parseDriver;
    private DDLSemanticAnalyzer analyzer;
    private QueryState queryState;
    private Context context;
    private String currentUser;
    private Hive db;
    private Table table;
    private Partition partition;

    @Before
    public void setup() throws Exception {
        this.queryState = new QueryState.Builder().build();
        HiveConf conf = this.queryState.getConf();
        conf.set("fs.defaultFS", "file:///");
        conf.setVar(HiveConf.ConfVars.HIVE_AUTHORIZATION_TASK_FACTORY, DummyHiveAuthorizationTaskFactoryImpl.class.getName());
        conf.setVar(HiveConf.ConfVars.HIVE_AUTHORIZATION_MANAGER, "org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.SQLStdHiveAuthorizerFactory");
        this.db = (Hive)Mockito.mock(Hive.class);
        this.table = new Table(DB, TABLE);
        this.partition = new Partition(this.table);
        SessionState.start((HiveConf)conf);
        this.context = new Context((Configuration)conf);
        this.parseDriver = new ParseDriver();
        this.analyzer = new DDLSemanticAnalyzer(this.queryState, this.db);
        Mockito.when((Object)this.db.getTable(DB, TABLE, false)).thenReturn((Object)this.table);
        Mockito.when((Object)this.db.getTable(TABLE_QNAME, false)).thenReturn((Object)this.table);
        Mockito.when((Object)this.db.getPartition(this.table, new HashMap(), false)).thenReturn((Object)this.partition);
        HadoopDefaultAuthenticator auth = new HadoopDefaultAuthenticator();
        auth.setConf((Configuration)conf);
        this.currentUser = auth.getUserName();
        DummyHiveAuthorizationTaskFactoryImpl.reset();
    }

    @Test
    public void testCreateRole() throws Exception {
        DDLWork work = this.analyze("CREATE ROLE role1");
        RoleDDLDesc roleDesc = work.getRoleDDLDesc();
        Assert.assertNotNull((String)"Role should not be null", (Object)roleDesc);
        Assert.assertEquals((Object)RoleDDLDesc.RoleOperation.CREATE_ROLE, (Object)roleDesc.getOperation());
        Assert.assertFalse((String)"Did not expect a group", (boolean)roleDesc.getGroup());
        Assert.assertEquals((Object)ROLE, (Object)roleDesc.getName());
    }

    @Test
    public void testDropRole() throws Exception {
        DDLWork work = this.analyze("DROp ROLE role1");
        RoleDDLDesc roleDesc = work.getRoleDDLDesc();
        Assert.assertNotNull((String)"Role should not be null", (Object)roleDesc);
        Assert.assertEquals((Object)RoleDDLDesc.RoleOperation.DROP_ROLE, (Object)roleDesc.getOperation());
        Assert.assertFalse((String)"Did not expect a group", (boolean)roleDesc.getGroup());
        Assert.assertEquals((Object)ROLE, (Object)roleDesc.getName());
    }

    @Test
    public void testGrantUserTable() throws Exception {
        DDLWork work = this.analyze("GRANT SELECT ON TABLE table1 TO USER user1");
        GrantDesc grantDesc = work.getGrantDesc();
        Assert.assertNotNull((String)"Grant should not be null", (Object)grantDesc);
        for (PrincipalDesc principal : ListSizeMatcher.inList(grantDesc.getPrincipals()).ofSize(1)) {
            Assert.assertEquals((Object)PrincipalType.USER, (Object)principal.getType());
            Assert.assertEquals((Object)USER, (Object)principal.getName());
        }
        for (PrivilegeDesc privilege : ListSizeMatcher.inList(grantDesc.getPrivileges()).ofSize(1)) {
            Assert.assertEquals((Object)Privilege.SELECT, (Object)privilege.getPrivilege());
        }
        Assert.assertTrue((String)"Expected table", (boolean)grantDesc.getPrivilegeSubjectDesc().getTable());
        Assert.assertEquals((Object)TABLE_QNAME, (Object)grantDesc.getPrivilegeSubjectDesc().getObject());
    }

    @Test
    public void testGrantRoleTable() throws Exception {
        DDLWork work = this.analyze("GRANT SELECT ON TABLE table1 TO ROLE role1");
        GrantDesc grantDesc = work.getGrantDesc();
        Assert.assertNotNull((String)"Grant should not be null", (Object)grantDesc);
        for (PrincipalDesc principal : ListSizeMatcher.inList(grantDesc.getPrincipals()).ofSize(1)) {
            Assert.assertEquals((Object)PrincipalType.ROLE, (Object)principal.getType());
            Assert.assertEquals((Object)ROLE, (Object)principal.getName());
        }
        for (PrivilegeDesc privilege : ListSizeMatcher.inList(grantDesc.getPrivileges()).ofSize(1)) {
            Assert.assertEquals((Object)Privilege.SELECT, (Object)privilege.getPrivilege());
        }
        Assert.assertTrue((String)"Expected table", (boolean)grantDesc.getPrivilegeSubjectDesc().getTable());
        Assert.assertEquals((Object)TABLE_QNAME, (Object)grantDesc.getPrivilegeSubjectDesc().getObject());
    }

    @Test
    public void testGrantGroupTable() throws Exception {
        DDLWork work = this.analyze("GRANT SELECT ON TABLE table1 TO GROUP group1");
        GrantDesc grantDesc = work.getGrantDesc();
        Assert.assertNotNull((String)"Grant should not be null", (Object)grantDesc);
        for (PrincipalDesc principal : ListSizeMatcher.inList(grantDesc.getPrincipals()).ofSize(1)) {
            Assert.assertEquals((Object)PrincipalType.GROUP, (Object)principal.getType());
            Assert.assertEquals((Object)GROUP, (Object)principal.getName());
        }
        for (PrivilegeDesc privilege : ListSizeMatcher.inList(grantDesc.getPrivileges()).ofSize(1)) {
            Assert.assertEquals((Object)Privilege.SELECT, (Object)privilege.getPrivilege());
        }
        Assert.assertTrue((String)"Expected table", (boolean)grantDesc.getPrivilegeSubjectDesc().getTable());
        Assert.assertEquals((Object)TABLE_QNAME, (Object)grantDesc.getPrivilegeSubjectDesc().getObject());
    }

    @Test
    public void testRevokeUserTable() throws Exception {
        DDLWork work = this.analyze("REVOKE SELECT ON TABLE table1 FROM USER user1");
        RevokeDesc grantDesc = work.getRevokeDesc();
        Assert.assertNotNull((String)"Revoke should not be null", (Object)grantDesc);
        for (PrincipalDesc principal : ListSizeMatcher.inList(grantDesc.getPrincipals()).ofSize(1)) {
            Assert.assertEquals((Object)PrincipalType.USER, (Object)principal.getType());
            Assert.assertEquals((Object)USER, (Object)principal.getName());
        }
        for (PrivilegeDesc privilege : ListSizeMatcher.inList(grantDesc.getPrivileges()).ofSize(1)) {
            Assert.assertEquals((Object)Privilege.SELECT, (Object)privilege.getPrivilege());
        }
        Assert.assertTrue((String)"Expected table", (boolean)grantDesc.getPrivilegeSubjectDesc().getTable());
        Assert.assertEquals((Object)TABLE_QNAME, (Object)grantDesc.getPrivilegeSubjectDesc().getObject());
    }

    @Test
    public void testRevokeRoleTable() throws Exception {
        DDLWork work = this.analyze("REVOKE SELECT ON TABLE table1 FROM ROLE role1");
        RevokeDesc grantDesc = work.getRevokeDesc();
        Assert.assertNotNull((String)"Revoke should not be null", (Object)grantDesc);
        for (PrincipalDesc principal : ListSizeMatcher.inList(grantDesc.getPrincipals()).ofSize(1)) {
            Assert.assertEquals((Object)PrincipalType.ROLE, (Object)principal.getType());
            Assert.assertEquals((Object)ROLE, (Object)principal.getName());
        }
        for (PrivilegeDesc privilege : ListSizeMatcher.inList(grantDesc.getPrivileges()).ofSize(1)) {
            Assert.assertEquals((Object)Privilege.SELECT, (Object)privilege.getPrivilege());
        }
        Assert.assertTrue((String)"Expected table", (boolean)grantDesc.getPrivilegeSubjectDesc().getTable());
        Assert.assertEquals((Object)TABLE_QNAME, (Object)grantDesc.getPrivilegeSubjectDesc().getObject());
    }

    @Test
    public void testRevokeGroupTable() throws Exception {
        DDLWork work = this.analyze("REVOKE SELECT ON TABLE table1 FROM GROUP group1");
        RevokeDesc grantDesc = work.getRevokeDesc();
        Assert.assertNotNull((String)"Revoke should not be null", (Object)grantDesc);
        for (PrincipalDesc principal : ListSizeMatcher.inList(grantDesc.getPrincipals()).ofSize(1)) {
            Assert.assertEquals((Object)PrincipalType.GROUP, (Object)principal.getType());
            Assert.assertEquals((Object)GROUP, (Object)principal.getName());
        }
        for (PrivilegeDesc privilege : ListSizeMatcher.inList(grantDesc.getPrivileges()).ofSize(1)) {
            Assert.assertEquals((Object)Privilege.SELECT, (Object)privilege.getPrivilege());
        }
        Assert.assertTrue((String)"Expected table", (boolean)grantDesc.getPrivilegeSubjectDesc().getTable());
        Assert.assertEquals((Object)TABLE_QNAME, (Object)grantDesc.getPrivilegeSubjectDesc().getObject());
    }

    @Test
    public void testGrantRoleUser() throws Exception {
        DDLWork work = this.analyze("GRANT ROLE role1 TO USER user1");
        GrantRevokeRoleDDL grantDesc = work.getGrantRevokeRoleDDL();
        Assert.assertNotNull((String)"Grant should not be null", (Object)grantDesc);
        Assert.assertTrue((String)"Expected grant ", (boolean)grantDesc.getGrant());
        Assert.assertFalse((String)"With admin option is not specified", (boolean)grantDesc.isGrantOption());
        Assert.assertEquals((Object)this.currentUser, (Object)grantDesc.getGrantor());
        Assert.assertEquals((Object)PrincipalType.USER, (Object)grantDesc.getGrantorType());
        for (String role : ListSizeMatcher.inList(grantDesc.getRoles()).ofSize(1)) {
            Assert.assertEquals((Object)ROLE, (Object)role);
        }
        for (PrincipalDesc principal : ListSizeMatcher.inList(grantDesc.getPrincipalDesc()).ofSize(1)) {
            Assert.assertEquals((Object)PrincipalType.USER, (Object)principal.getType());
            Assert.assertEquals((Object)USER, (Object)principal.getName());
        }
    }

    @Test
    public void testGrantRoleRole() throws Exception {
        DDLWork work = this.analyze("GRANT ROLE role1 TO ROLE role1");
        GrantRevokeRoleDDL grantDesc = work.getGrantRevokeRoleDDL();
        Assert.assertNotNull((String)"Grant should not be null", (Object)grantDesc);
        Assert.assertTrue((String)"Expected grant ", (boolean)grantDesc.getGrant());
        Assert.assertFalse((String)"With admin option is not specified", (boolean)grantDesc.isGrantOption());
        Assert.assertEquals((Object)this.currentUser, (Object)grantDesc.getGrantor());
        Assert.assertEquals((Object)PrincipalType.USER, (Object)grantDesc.getGrantorType());
        for (String role : ListSizeMatcher.inList(grantDesc.getRoles()).ofSize(1)) {
            Assert.assertEquals((Object)ROLE, (Object)role);
        }
        for (PrincipalDesc principal : ListSizeMatcher.inList(grantDesc.getPrincipalDesc()).ofSize(1)) {
            Assert.assertEquals((Object)PrincipalType.ROLE, (Object)principal.getType());
            Assert.assertEquals((Object)ROLE, (Object)principal.getName());
        }
    }

    @Test
    public void testGrantRoleGroup() throws Exception {
        DDLWork work = this.analyze("GRANT ROLE role1 TO GROUP group1");
        GrantRevokeRoleDDL grantDesc = work.getGrantRevokeRoleDDL();
        Assert.assertNotNull((String)"Grant should not be null", (Object)grantDesc);
        Assert.assertTrue((String)"Expected grant ", (boolean)grantDesc.getGrant());
        Assert.assertFalse((String)"With admin option is not specified", (boolean)grantDesc.isGrantOption());
        Assert.assertEquals((Object)this.currentUser, (Object)grantDesc.getGrantor());
        Assert.assertEquals((Object)PrincipalType.USER, (Object)grantDesc.getGrantorType());
        for (String role : ListSizeMatcher.inList(grantDesc.getRoles()).ofSize(1)) {
            Assert.assertEquals((Object)ROLE, (Object)role);
        }
        for (PrincipalDesc principal : ListSizeMatcher.inList(grantDesc.getPrincipalDesc()).ofSize(1)) {
            Assert.assertEquals((Object)PrincipalType.GROUP, (Object)principal.getType());
            Assert.assertEquals((Object)GROUP, (Object)principal.getName());
        }
    }

    @Test
    public void testRevokeRoleUser() throws Exception {
        DDLWork work = this.analyze("REVOKE ROLE role1 FROM USER user1");
        GrantRevokeRoleDDL grantDesc = work.getGrantRevokeRoleDDL();
        Assert.assertNotNull((String)"Grant should not be null", (Object)grantDesc);
        Assert.assertFalse((String)"Did not expect grant ", (boolean)grantDesc.getGrant());
        Assert.assertFalse((String)"With admin option is not specified", (boolean)grantDesc.isGrantOption());
        Assert.assertEquals((Object)this.currentUser, (Object)grantDesc.getGrantor());
        Assert.assertEquals((Object)PrincipalType.USER, (Object)grantDesc.getGrantorType());
        for (String role : ListSizeMatcher.inList(grantDesc.getRoles()).ofSize(1)) {
            Assert.assertEquals((Object)ROLE, (Object)role);
        }
        for (PrincipalDesc principal : ListSizeMatcher.inList(grantDesc.getPrincipalDesc()).ofSize(1)) {
            Assert.assertEquals((Object)PrincipalType.USER, (Object)principal.getType());
            Assert.assertEquals((Object)USER, (Object)principal.getName());
        }
    }

    @Test
    public void testRevokeRoleRole() throws Exception {
        DDLWork work = this.analyze("REVOKE ROLE role1 FROM ROLE role1");
        GrantRevokeRoleDDL grantDesc = work.getGrantRevokeRoleDDL();
        Assert.assertNotNull((String)"Grant should not be null", (Object)grantDesc);
        Assert.assertFalse((String)"Did not expect grant ", (boolean)grantDesc.getGrant());
        Assert.assertFalse((String)"With admin option is not specified", (boolean)grantDesc.isGrantOption());
        Assert.assertEquals((Object)this.currentUser, (Object)grantDesc.getGrantor());
        Assert.assertEquals((Object)PrincipalType.USER, (Object)grantDesc.getGrantorType());
        for (String role : ListSizeMatcher.inList(grantDesc.getRoles()).ofSize(1)) {
            Assert.assertEquals((Object)ROLE, (Object)role);
        }
        for (PrincipalDesc principal : ListSizeMatcher.inList(grantDesc.getPrincipalDesc()).ofSize(1)) {
            Assert.assertEquals((Object)PrincipalType.ROLE, (Object)principal.getType());
            Assert.assertEquals((Object)ROLE, (Object)principal.getName());
        }
    }

    @Test
    public void testRevokeRoleGroup() throws Exception {
        DDLWork work = this.analyze("REVOKE ROLE role1 FROM GROUP group1");
        GrantRevokeRoleDDL grantDesc = work.getGrantRevokeRoleDDL();
        Assert.assertNotNull((String)"Grant should not be null", (Object)grantDesc);
        Assert.assertFalse((String)"Did not expect grant ", (boolean)grantDesc.getGrant());
        Assert.assertFalse((String)"With admin option is not specified", (boolean)grantDesc.isGrantOption());
        Assert.assertEquals((Object)this.currentUser, (Object)grantDesc.getGrantor());
        Assert.assertEquals((Object)PrincipalType.USER, (Object)grantDesc.getGrantorType());
        for (String role : ListSizeMatcher.inList(grantDesc.getRoles()).ofSize(1)) {
            Assert.assertEquals((Object)ROLE, (Object)role);
        }
        for (PrincipalDesc principal : ListSizeMatcher.inList(grantDesc.getPrincipalDesc()).ofSize(1)) {
            Assert.assertEquals((Object)PrincipalType.GROUP, (Object)principal.getType());
            Assert.assertEquals((Object)GROUP, (Object)principal.getName());
        }
    }

    @Test
    public void testShowRoleGrantUser() throws Exception {
        DDLWork work = this.analyze("SHOW ROLE GRANT USER user1");
        RoleDDLDesc roleDesc = work.getRoleDDLDesc();
        Assert.assertNotNull((String)"Role should not be null", (Object)roleDesc);
        Assert.assertEquals((Object)RoleDDLDesc.RoleOperation.SHOW_ROLE_GRANT, (Object)roleDesc.getOperation());
        Assert.assertEquals((Object)PrincipalType.USER, (Object)roleDesc.getPrincipalType());
        Assert.assertEquals((Object)USER, (Object)roleDesc.getName());
    }

    @Test
    public void testShowRoleGrantRole() throws Exception {
        DDLWork work = this.analyze("SHOW ROLE GRANT ROLE role1");
        RoleDDLDesc roleDesc = work.getRoleDDLDesc();
        Assert.assertNotNull((String)"Role should not be null", (Object)roleDesc);
        Assert.assertEquals((Object)RoleDDLDesc.RoleOperation.SHOW_ROLE_GRANT, (Object)roleDesc.getOperation());
        Assert.assertEquals((Object)PrincipalType.ROLE, (Object)roleDesc.getPrincipalType());
        Assert.assertEquals((Object)ROLE, (Object)roleDesc.getName());
    }

    @Test
    public void testShowRoleGrantGroup() throws Exception {
        DDLWork work = this.analyze("SHOW ROLE GRANT GROUP group1");
        RoleDDLDesc roleDesc = work.getRoleDDLDesc();
        Assert.assertNotNull((String)"Role should not be null", (Object)roleDesc);
        Assert.assertEquals((Object)RoleDDLDesc.RoleOperation.SHOW_ROLE_GRANT, (Object)roleDesc.getOperation());
        Assert.assertEquals((Object)PrincipalType.GROUP, (Object)roleDesc.getPrincipalType());
        Assert.assertEquals((Object)GROUP, (Object)roleDesc.getName());
    }

    @Test
    public void testShowGrantUserOnTable() throws Exception {
        DDLWork work = this.analyze("SHOW GRANT USER user1 ON TABLE table1");
        ShowGrantDesc grantDesc = work.getShowGrantDesc();
        Assert.assertNotNull((String)"Show grant should not be null", (Object)grantDesc);
        Assert.assertEquals((Object)PrincipalType.USER, (Object)grantDesc.getPrincipalDesc().getType());
        Assert.assertEquals((Object)USER, (Object)grantDesc.getPrincipalDesc().getName());
        Assert.assertTrue((String)"Expected table", (boolean)grantDesc.getHiveObj().getTable());
        Assert.assertEquals((Object)TABLE_QNAME, (Object)grantDesc.getHiveObj().getObject());
        Assert.assertTrue((String)"Expected table", (boolean)grantDesc.getHiveObj().getTable());
    }

    @Test
    public void testShowGrantRoleOnTable() throws Exception {
        DDLWork work = this.analyze("SHOW GRANT ROLE role1 ON TABLE table1");
        ShowGrantDesc grantDesc = work.getShowGrantDesc();
        Assert.assertNotNull((String)"Show grant should not be null", (Object)grantDesc);
        Assert.assertEquals((Object)PrincipalType.ROLE, (Object)grantDesc.getPrincipalDesc().getType());
        Assert.assertEquals((Object)ROLE, (Object)grantDesc.getPrincipalDesc().getName());
        Assert.assertTrue((String)"Expected table", (boolean)grantDesc.getHiveObj().getTable());
        Assert.assertEquals((Object)TABLE_QNAME, (Object)grantDesc.getHiveObj().getObject());
        Assert.assertTrue((String)"Expected table", (boolean)grantDesc.getHiveObj().getTable());
    }

    @Test
    public void testShowGrantGroupOnTable() throws Exception {
        DDLWork work = this.analyze("SHOW GRANT GROUP group1 ON TABLE table1");
        ShowGrantDesc grantDesc = work.getShowGrantDesc();
        Assert.assertNotNull((String)"Show grant should not be null", (Object)grantDesc);
        Assert.assertEquals((Object)PrincipalType.GROUP, (Object)grantDesc.getPrincipalDesc().getType());
        Assert.assertEquals((Object)GROUP, (Object)grantDesc.getPrincipalDesc().getName());
        Assert.assertTrue((String)"Expected table", (boolean)grantDesc.getHiveObj().getTable());
        Assert.assertEquals((Object)TABLE_QNAME, (Object)grantDesc.getHiveObj().getObject());
        Assert.assertTrue((String)"Expected table", (boolean)grantDesc.getHiveObj().getTable());
    }

    @Test
    public void testGrantUri() throws Exception {
        String uriPath = "/tmp";
        try {
            this.analyze("GRANT ALL ON URI '" + uriPath + "' TO USER user2");
            Assert.fail((String)"Grant on URI should fail");
        }
        catch (SemanticException e) {
            Assert.assertEquals((Object)uriPath, (Object)DummyHiveAuthorizationTaskFactoryImpl.uriPath);
        }
    }

    @Test
    public void testGrantServer() throws Exception {
        String serverName = "foo";
        try {
            this.analyze("GRANT ALL ON SERVER " + serverName + " TO USER user2");
            Assert.fail((String)"Grant on Server should fail");
        }
        catch (SemanticException e) {
            Assert.assertEquals((Object)serverName, (Object)DummyHiveAuthorizationTaskFactoryImpl.serverName);
        }
    }

    private DDLWork analyze(String command) throws Exception {
        return AuthorizationTestUtil.analyze(command, this.queryState, this.db);
    }

    public static class DummyHiveAuthorizationTaskFactoryImpl
    extends HiveAuthorizationTaskFactoryImpl {
        static String uriPath = "";
        static String serverName = "";

        public DummyHiveAuthorizationTaskFactoryImpl(HiveConf conf, Hive db) {
            super(conf, db);
        }

        protected PrivilegeObjectDesc parsePrivObject(ASTNode ast) throws SemanticException {
            ASTNode child = (ASTNode)ast.getChild(0);
            ASTNode gchild = (ASTNode)child.getChild(0);
            if (child.getType() == 1094) {
                uriPath = gchild.getText().replaceAll("'", "").replaceAll("\"", "");
            } else if (child.getType() == 991) {
                serverName = gchild.getText();
            }
            return super.parsePrivObject(ast);
        }

        public static void reset() {
            uriPath = "";
            serverName = "";
        }
    }
}

