/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.spark;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import org.apache.hadoop.hive.common.metrics.common.Metrics;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.spark.SparkTask;
import org.apache.hadoop.hive.ql.exec.spark.SparkUtilities;
import org.apache.hadoop.hive.ql.exec.spark.Statistic.SparkStatistics;
import org.apache.hadoop.hive.ql.exec.spark.Statistic.SparkStatisticsBuilder;
import org.apache.hadoop.hive.ql.exec.spark.status.RemoteSparkJobMonitor;
import org.apache.hadoop.hive.ql.exec.spark.status.impl.RemoteSparkJobStatus;
import org.apache.hadoop.hive.ql.plan.BaseWork;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.SparkWork;
import org.apache.hive.spark.client.JobHandle;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestSparkTask {
    @Test
    public void sparkTask_updates_Metrics() throws IOException {
        Metrics mockMetrics = (Metrics)Mockito.mock(Metrics.class);
        SparkTask sparkTask = new SparkTask();
        sparkTask.updateTaskMetrics(mockMetrics);
        ((Metrics)Mockito.verify((Object)mockMetrics, (VerificationMode)Mockito.times((int)1))).incrementCounter("hive_spark_tasks");
        ((Metrics)Mockito.verify((Object)mockMetrics, (VerificationMode)Mockito.never())).incrementCounter("hive_tez_tasks");
        ((Metrics)Mockito.verify((Object)mockMetrics, (VerificationMode)Mockito.never())).incrementCounter("hive_mapred_tasks");
    }

    @Test
    public void removeEmptySparkTask() {
        SparkTask grandpa = new SparkTask();
        SparkWork grandpaWork = new SparkWork("grandpa");
        grandpaWork.add((BaseWork)new MapWork());
        grandpa.setWork((Serializable)grandpaWork);
        SparkTask parent = new SparkTask();
        SparkWork parentWork = new SparkWork("parent");
        parentWork.add((BaseWork)new MapWork());
        parent.setWork((Serializable)parentWork);
        SparkTask child1 = new SparkTask();
        SparkWork childWork1 = new SparkWork("child1");
        childWork1.add((BaseWork)new MapWork());
        child1.setWork((Serializable)childWork1);
        grandpa.addDependentTask((Task)parent);
        parent.addDependentTask((Task)child1);
        Assert.assertEquals((long)grandpa.getChildTasks().size(), (long)1L);
        Assert.assertEquals((long)child1.getParentTasks().size(), (long)1L);
        if (this.isEmptySparkWork((SparkWork)parent.getWork())) {
            SparkUtilities.removeEmptySparkTask((SparkTask)parent);
        }
        Assert.assertEquals((long)grandpa.getChildTasks().size(), (long)0L);
        Assert.assertEquals((long)child1.getParentTasks().size(), (long)0L);
    }

    @Test
    public void testRemoteSparkCancel() {
        RemoteSparkJobStatus jobSts = (RemoteSparkJobStatus)Mockito.mock(RemoteSparkJobStatus.class);
        Mockito.when((Object)jobSts.getRemoteJobState()).thenReturn((Object)JobHandle.State.CANCELLED);
        Mockito.when((Object)jobSts.isRemoteActive()).thenReturn((Object)true);
        HiveConf hiveConf = new HiveConf();
        hiveConf.set("fs.defaultFS", "file:///");
        RemoteSparkJobMonitor remoteSparkJobMonitor = new RemoteSparkJobMonitor(hiveConf, jobSts);
        Assert.assertEquals((long)remoteSparkJobMonitor.startMonitor(), (long)3L);
    }

    @Test
    public void testSparkStatisticsToString() {
        SparkStatisticsBuilder statsBuilder = new SparkStatisticsBuilder();
        statsBuilder.add("TEST", "stat1", "1");
        statsBuilder.add("TEST", "stat2", "1");
        String statsString = SparkTask.sparkStatisticsToString((SparkStatistics)statsBuilder.build(), (int)10);
        Assert.assertTrue((boolean)statsString.contains("10"));
        Assert.assertTrue((boolean)statsString.contains("TEST"));
        Assert.assertTrue((boolean)statsString.contains("stat1"));
        Assert.assertTrue((boolean)statsString.contains("stat2"));
        Assert.assertTrue((boolean)statsString.contains("1"));
    }

    private boolean isEmptySparkWork(SparkWork sparkWork) {
        List allWorks = sparkWork.getAllWork();
        boolean allWorksIsEmtpy = true;
        for (BaseWork work : allWorks) {
            if (work.getAllOperators().size() <= 0) continue;
            allWorksIsEmtpy = false;
            break;
        }
        return allWorksIsEmtpy;
    }
}

