/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import com.google.common.base.Objects;
import java.io.Serializable;
import java.util.LinkedHashMap;
import org.apache.hadoop.hive.ql.parse.JoinCond;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JoinCondDesc
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int left;
    private int right;
    private int type;
    private boolean preserved;
    protected static final Logger LOG = LoggerFactory.getLogger((String)JoinCondDesc.class.getName());

    public JoinCondDesc() {
    }

    public JoinCondDesc(int left, int right, int type) {
        this.left = left;
        this.right = right;
        this.type = type;
    }

    public JoinCondDesc(JoinCond condn) {
        this.left = condn.getLeft();
        this.right = condn.getRight();
        this.preserved = condn.getPreserved();
        switch (condn.getJoinType()) {
            case INNER: {
                this.type = 0;
                break;
            }
            case LEFTOUTER: {
                this.type = 1;
                break;
            }
            case RIGHTOUTER: {
                this.type = 2;
                break;
            }
            case FULLOUTER: {
                this.type = 3;
                break;
            }
            case UNIQUE: {
                this.type = 4;
                break;
            }
            case LEFTSEMI: {
                this.type = 5;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    public boolean getPreserved() {
        return this.preserved;
    }

    public void setPreserved(boolean preserved) {
        this.preserved = preserved;
    }

    public int getLeft() {
        return this.left;
    }

    public void setLeft(int left) {
        this.left = left;
    }

    public int getRight() {
        return this.right;
    }

    public void setRight(int right) {
        this.right = right;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    @Explain(explainLevels={Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getJoinCondString() {
        StringBuilder sb = new StringBuilder();
        switch (this.type) {
            case 0: {
                sb.append("Inner Join ");
                break;
            }
            case 3: {
                sb.append("Outer Join ");
                break;
            }
            case 1: {
                sb.append("Left Outer Join ");
                break;
            }
            case 2: {
                sb.append("Right Outer Join ");
                break;
            }
            case 4: {
                sb.append("Unique Join ");
                break;
            }
            case 5: {
                sb.append("Left Semi Join ");
                break;
            }
            default: {
                sb.append("Unknown Join ");
            }
        }
        sb.append(this.left);
        sb.append(" to ");
        sb.append(this.right);
        return sb.toString();
    }

    @Explain(explainLevels={Explain.Level.USER})
    public String getUserLevelJoinCondString() {
        JSONObject join = new JSONObject(new LinkedHashMap());
        try {
            switch (this.type) {
                case 0: {
                    join.put("type", (Object)"Inner");
                    break;
                }
                case 3: {
                    join.put("type", (Object)"Outer");
                    break;
                }
                case 1: {
                    join.put("type", (Object)"Left Outer");
                    break;
                }
                case 2: {
                    join.put("type", (Object)"Right Outer");
                    break;
                }
                case 4: {
                    join.put("type", (Object)"Unique");
                    break;
                }
                case 5: {
                    join.put("type", (Object)"Left Semi");
                    break;
                }
                default: {
                    join.put("type", (Object)"Unknown Join");
                }
            }
            join.put("left", this.left);
            join.put("right", this.right);
        }
        catch (JSONException e) {
            LOG.trace(e.getMessage());
        }
        return join.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JoinCondDesc)) {
            return false;
        }
        JoinCondDesc other = (JoinCondDesc)obj;
        return this.type == other.type && this.left == other.left && this.right == other.right && this.preserved == other.preserved;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.type, this.left, this.right, this.preserved});
    }
}

