/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.sql.Date;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;

public class CastLongToDate
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private int inputColumn;
    private transient Date date = new Date(0L);

    public CastLongToDate() {
    }

    public CastLongToDate(int inputColumn, int outputColumnNum) {
        super(outputColumnNum);
        this.inputColumn = inputColumn;
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        LongColumnVector inV = (LongColumnVector)batch.cols[this.inputColumn];
        int[] sel = batch.selected;
        int n = batch.size;
        LongColumnVector outV = (LongColumnVector)batch.cols[this.outputColumnNum];
        if (n == 0) {
            return;
        }
        PrimitiveObjectInspector.PrimitiveCategory primitiveCategory = ((PrimitiveTypeInfo)this.inputTypeInfos[0]).getPrimitiveCategory();
        switch (primitiveCategory) {
            case DATE: {
                inV.copySelected(batch.selectedInUse, batch.selected, batch.size, (ColumnVector)outV);
                break;
            }
            default: {
                throw new Error("Unsupported input type " + primitiveCategory.name());
            }
        }
    }

    @Override
    public String vectorExpressionParameters() {
        return this.getColumnParamString(0, this.inputColumn);
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        VectorExpressionDescriptor.Builder b = new VectorExpressionDescriptor.Builder();
        b.setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(1).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.DATE).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN);
        return b.build();
    }
}

