/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.persistence;

import java.io.ObjectOutputStream;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.apache.hadoop.hive.ql.exec.persistence.AbstractRowContainer;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinObjectSerDeContext;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinRowContainer;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Writable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlatRowContainer
extends AbstractCollection<Object>
implements MapJoinRowContainer,
AbstractRowContainer.RowIterator<List<Object>>,
List<Object> {
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private static final int UNKNOWN = Integer.MAX_VALUE;
    private static Logger LOG = LoggerFactory.getLogger(FlatRowContainer.class);
    private Object[] array;
    private int rowLength = Integer.MAX_VALUE;
    private byte aliasFilter = (byte)-1;
    private boolean isAliasFilterSet = true;

    public FlatRowContainer() {
        this.array = EMPTY_OBJECT_ARRAY;
    }

    public void add(MapJoinObjectSerDeContext context, BytesWritable value) throws HiveException {
        AbstractSerDe serde = context.getSerDe();
        boolean bl = this.isAliasFilterSet = !context.hasFilterTag();
        if (this.rowLength == Integer.MAX_VALUE) {
            try {
                this.rowLength = ObjectInspectorUtils.getStructSize((ObjectInspector)serde.getObjectInspector());
            }
            catch (SerDeException ex) {
                throw new HiveException("Get structure size error", ex);
            }
            if (this.rowLength == 0) {
                this.array = EMPTY_OBJECT_ARRAY;
            }
        }
        if (this.rowLength > 0) {
            int rowCount = this.array.length / this.rowLength;
            this.listRealloc(this.array.length + this.rowLength);
            this.read(serde, (Writable)value, rowCount);
        } else {
            --this.rowLength;
        }
    }

    @Override
    public void addRow(List<Object> t) throws HiveException {
        LOG.debug("Add is called with " + t.size() + " objects");
        int offset = this.prepareForAdd(t.size());
        if (offset < 0) {
            return;
        }
        for (int i = 0; i < t.size(); ++i) {
            this.array[offset + i] = t.get(i);
        }
    }

    @Override
    public void addRow(Object[] value) throws HiveException {
        LOG.debug("Add is called with " + value.length + " objects");
        int offset = this.prepareForAdd(value.length);
        if (offset < 0) {
            return;
        }
        System.arraycopy(value, 0, this.array, offset, value.length);
    }

    private int prepareForAdd(int len) throws HiveException {
        if (this.rowLength < 0) {
            if (len != 0) {
                throw new HiveException("Different size rows: 0 and " + len);
            }
            --this.rowLength;
            return -1;
        }
        if (this.rowLength != len) {
            throw new HiveException("Different size rows: " + this.rowLength + " and " + len);
        }
        int oldLen = this.array.length;
        this.listRealloc(oldLen + len);
        return oldLen;
    }

    @Override
    public void write(MapJoinObjectSerDeContext valueContext, ObjectOutputStream out) {
        throw new UnsupportedOperationException(this.getClass().getName() + " cannot be serialized");
    }

    @Override
    public AbstractRowContainer.RowIterator<List<Object>> rowIter() throws HiveException {
        if (this.array.length == this.rowLength) {
            return this;
        }
        return this.rowLength > 0 ? new RowIterator() : new EmptyRowIterator(-this.rowLength);
    }

    @Override
    public List<Object> first() throws HiveException {
        if (this.array.length != this.rowLength) {
            throw new AssertionError((Object)"Incorrect iterator usage, not single-row");
        }
        return this;
    }

    @Override
    public List<Object> next() {
        return null;
    }

    private void read(AbstractSerDe serde, Writable writable, int rowOffset) throws HiveException {
        try {
            ObjectInspectorUtils.copyStructToArray((Object)serde.deserialize(writable), (ObjectInspector)serde.getObjectInspector(), (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE, (Object[])this.array, (int)(rowOffset * this.rowLength));
        }
        catch (SerDeException ex) {
            throw new HiveException("Lazy deserialize error", ex);
        }
    }

    @Override
    public boolean hasRows() throws HiveException {
        return this.rowCount() > 0;
    }

    @Override
    public boolean isSingleRow() throws HiveException {
        return this.rowCount() == 1;
    }

    @Override
    public int rowCount() throws HiveException {
        return this.rowLength > 0 ? this.array.length / this.rowLength : -this.rowLength;
    }

    @Override
    public void clearRows() {
        this.array = EMPTY_OBJECT_ARRAY;
        this.rowLength = 0;
    }

    @Override
    public byte getAliasFilter() throws HiveException {
        this.ensureAliasFilter();
        return this.aliasFilter;
    }

    private void ensureAliasFilter() throws HiveException {
        if (!this.isAliasFilterSet && this.rowLength > 0) {
            for (int offset = this.rowLength - 1; offset < this.array.length; offset += this.rowLength) {
                this.aliasFilter = (byte)(this.aliasFilter & ((ShortWritable)this.array[offset]).get());
            }
        }
        this.isAliasFilterSet = true;
    }

    @Override
    public MapJoinRowContainer copy() throws HiveException {
        FlatRowContainer result = new FlatRowContainer();
        result.array = new Object[this.array.length];
        System.arraycopy(this.array, 0, result.array, 0, this.array.length);
        result.rowLength = this.rowLength;
        result.aliasFilter = this.aliasFilter;
        return result;
    }

    private void listRealloc(int length) {
        Object[] array = new Object[length];
        if (this.array.length > 0) {
            System.arraycopy(this.array, 0, array, 0, this.array.length);
        }
        this.array = array;
    }

    @Override
    public int size() {
        this.checkSingleRow();
        return this.array.length;
    }

    @Override
    public Object get(int index) {
        return this.array[index];
    }

    @Override
    public Object[] toArray() {
        this.checkSingleRow();
        return this.array;
    }

    @Override
    public Iterator<Object> iterator() {
        return this.listIterator();
    }

    @Override
    public ListIterator<Object> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<Object> listIterator(int index) {
        this.checkSingleRow();
        return this.listIteratorInternal(index, 0, this.array.length);
    }

    private ListIterator<Object> listIteratorInternal(final int index, final int iterMinPos, final int iterMaxPos) {
        return new ListIterator<Object>(){
            private int pos;
            {
                this.pos = index - 1;
            }

            @Override
            public int nextIndex() {
                return this.pos + 1;
            }

            @Override
            public int previousIndex() {
                return this.pos - 1;
            }

            @Override
            public boolean hasNext() {
                return this.nextIndex() < iterMaxPos;
            }

            @Override
            public boolean hasPrevious() {
                return this.previousIndex() >= iterMinPos;
            }

            @Override
            public Object next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return FlatRowContainer.this.get(++this.pos);
            }

            @Override
            public Object previous() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                return FlatRowContainer.this.get(--this.pos);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void set(Object e) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void add(Object e) {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public int indexOf(Object o) {
        this.checkSingleRow();
        for (int i = 0; i < this.array.length; ++i) {
            if (!(o == null ? this.array[i] == null : o.equals(this.array[i]))) continue;
            return i;
        }
        return -1;
    }

    private void checkSingleRow() throws AssertionError {
        if (this.array.length != this.rowLength) {
            throw new AssertionError((Object)"Incorrect list usage, not single-row");
        }
    }

    @Override
    public int lastIndexOf(Object o) {
        this.checkSingleRow();
        for (int i = this.array.length - 1; i >= 0; --i) {
            if (!(o == null ? this.array[i] == null : o.equals(this.array[i]))) continue;
            return i;
        }
        return -1;
    }

    @Override
    public List<Object> subList(int fromIndex, int toIndex) {
        this.checkSingleRow();
        return new ReadOnlySubList(fromIndex, toIndex - fromIndex);
    }

    @Override
    public boolean addAll(int index, Collection<? extends Object> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object set(int index, Object element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int index, Object element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object remove(int index) {
        throw new UnsupportedOperationException();
    }

    private class ReadOnlySubList
    extends AbstractList<Object> {
        private int offset;
        private int size;

        ReadOnlySubList(int from, int size) {
            this.offset = from;
            this.size = size;
        }

        @Override
        public Object get(int index) {
            return FlatRowContainer.this.array[index + this.offset];
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public Iterator<Object> iterator() {
            return super.listIterator();
        }

        @Override
        public ListIterator<Object> listIterator(int index) {
            return FlatRowContainer.this.listIteratorInternal(this.offset + index, this.offset, this.offset + this.size);
        }

        @Override
        public List<Object> subList(int fromIndex, int toIndex) {
            return new ReadOnlySubList(this.offset + fromIndex, toIndex - fromIndex);
        }

        @Override
        public Object[] toArray() {
            Object[] result = new Object[this.size];
            System.arraycopy(FlatRowContainer.this.array, this.offset, result, 0, this.size);
            return result;
        }
    }

    private class RowIterator
    implements AbstractRowContainer.RowIterator<List<Object>> {
        private int index = 0;

        private RowIterator() {
        }

        @Override
        public List<Object> first() throws HiveException {
            this.index = 0;
            if (FlatRowContainer.this.array.length > 0) {
                return new ReadOnlySubList(0, FlatRowContainer.this.rowLength);
            }
            return null;
        }

        @Override
        public List<Object> next() {
            this.index += FlatRowContainer.this.rowLength;
            if (this.index < FlatRowContainer.this.array.length) {
                return new ReadOnlySubList(this.index, FlatRowContainer.this.rowLength);
            }
            return null;
        }
    }

    private static class EmptyRowIterator
    implements AbstractRowContainer.RowIterator<List<Object>> {
        private static final List<Object> EMPTY_ROW = new ArrayList<Object>();
        private int rowCount;

        public EmptyRowIterator(int rowCount) {
            this.rowCount = rowCount;
        }

        @Override
        public List<Object> first() throws HiveException {
            return this.next();
        }

        @Override
        public List<Object> next() throws HiveException {
            return --this.rowCount < 0 ? null : EMPTY_ROW;
        }
    }
}

