/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.math.BigDecimal;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.exec.vector.expressions.MathExpr;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBRound;
import org.apache.hadoop.hive.ql.udf.generic.RoundUtils;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ConstantObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableDoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableFloatObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableHiveDecimalObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.junit.Assert;
import org.junit.Test;

public class TestGenericUDFBRound {
    @Test
    public void testDouble() throws HiveException {
        GenericUDFBRound udf = new GenericUDFBRound();
        WritableDoubleObjectInspector valueOI0 = PrimitiveObjectInspectorFactory.writableDoubleObjectInspector;
        IntWritable scale = new IntWritable(0);
        ConstantObjectInspector valueOI1 = PrimitiveObjectInspectorFactory.getPrimitiveWritableConstantObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.intTypeInfo, (Object)scale);
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI0, valueOI1};
        udf.initialize(arguments);
        this.runDouble(2.5, scale, 2.0, (GenericUDF)udf);
        this.runDouble(3.5, scale, 4.0, (GenericUDF)udf);
        this.runDouble(2.49, scale, 2.0, (GenericUDF)udf);
        this.runDouble(3.49, scale, 3.0, (GenericUDF)udf);
        this.runDouble(2.51, scale, 3.0, (GenericUDF)udf);
        this.runDouble(3.51, scale, 4.0, (GenericUDF)udf);
        this.runDouble(2.4, scale, 2.0, (GenericUDF)udf);
        this.runDouble(3.4, scale, 3.0, (GenericUDF)udf);
        this.runDouble(2.6, scale, 3.0, (GenericUDF)udf);
        this.runDouble(3.6, scale, 4.0, (GenericUDF)udf);
    }

    @Test
    public void testDoubleScaleMinus1() throws HiveException {
        GenericUDFBRound udf = new GenericUDFBRound();
        WritableDoubleObjectInspector valueOI0 = PrimitiveObjectInspectorFactory.writableDoubleObjectInspector;
        IntWritable scale = new IntWritable(-1);
        ConstantObjectInspector valueOI1 = PrimitiveObjectInspectorFactory.getPrimitiveWritableConstantObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.intTypeInfo, (Object)scale);
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI0, valueOI1};
        udf.initialize(arguments);
        this.runDouble(55.0, scale, 60.0, (GenericUDF)udf);
        this.runDouble(45.0, scale, 40.0, (GenericUDF)udf);
        this.runDouble(54.9, scale, 50.0, (GenericUDF)udf);
        this.runDouble(44.9, scale, 40.0, (GenericUDF)udf);
        this.runDouble(55.1, scale, 60.0, (GenericUDF)udf);
        this.runDouble(45.1, scale, 50.0, (GenericUDF)udf);
        this.runDouble(-55.0, scale, -60.0, (GenericUDF)udf);
        this.runDouble(-45.0, scale, -40.0, (GenericUDF)udf);
        this.runDouble(-54.9, scale, -50.0, (GenericUDF)udf);
        this.runDouble(-44.9, scale, -40.0, (GenericUDF)udf);
        this.runDouble(-55.1, scale, -60.0, (GenericUDF)udf);
        this.runDouble(-45.1, scale, -50.0, (GenericUDF)udf);
    }

    @Test
    public void testFloat() throws HiveException {
        GenericUDFBRound udf = new GenericUDFBRound();
        WritableFloatObjectInspector valueOI0 = PrimitiveObjectInspectorFactory.writableFloatObjectInspector;
        IntWritable scale = new IntWritable(0);
        ConstantObjectInspector valueOI1 = PrimitiveObjectInspectorFactory.getPrimitiveWritableConstantObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.intTypeInfo, (Object)scale);
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI0, valueOI1};
        udf.initialize(arguments);
        this.runFloat(2.5f, scale, Float.valueOf(2.0f), (GenericUDF)udf);
        this.runFloat(3.5f, scale, Float.valueOf(4.0f), (GenericUDF)udf);
        this.runFloat(2.49f, scale, Float.valueOf(2.0f), (GenericUDF)udf);
        this.runFloat(3.49f, scale, Float.valueOf(3.0f), (GenericUDF)udf);
        this.runFloat(2.51f, scale, Float.valueOf(3.0f), (GenericUDF)udf);
        this.runFloat(3.51f, scale, Float.valueOf(4.0f), (GenericUDF)udf);
        this.runFloat(2.4f, scale, Float.valueOf(2.0f), (GenericUDF)udf);
        this.runFloat(3.4f, scale, Float.valueOf(3.0f), (GenericUDF)udf);
        this.runFloat(2.6f, scale, Float.valueOf(3.0f), (GenericUDF)udf);
        this.runFloat(3.6f, scale, Float.valueOf(4.0f), (GenericUDF)udf);
    }

    @Test
    public void testDecimal() throws HiveException {
        GenericUDFBRound udf = new GenericUDFBRound();
        WritableHiveDecimalObjectInspector valueOI0 = PrimitiveObjectInspectorFactory.writableHiveDecimalObjectInspector;
        IntWritable scale = new IntWritable(0);
        ConstantObjectInspector valueOI1 = PrimitiveObjectInspectorFactory.getPrimitiveWritableConstantObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.intTypeInfo, (Object)scale);
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI0, valueOI1};
        udf.initialize(arguments);
        this.runDecimal(2.5, scale, 2.0, (GenericUDF)udf);
        this.runDecimal(3.5, scale, 4.0, (GenericUDF)udf);
        this.runDecimal(2.49, scale, 2.0, (GenericUDF)udf);
        this.runDecimal(3.49, scale, 3.0, (GenericUDF)udf);
        this.runDecimal(2.51, scale, 3.0, (GenericUDF)udf);
        this.runDecimal(3.51, scale, 4.0, (GenericUDF)udf);
        this.runDecimal(2.4, scale, 2.0, (GenericUDF)udf);
        this.runDecimal(3.4, scale, 3.0, (GenericUDF)udf);
        this.runDecimal(2.6, scale, 3.0, (GenericUDF)udf);
        this.runDecimal(3.6, scale, 4.0, (GenericUDF)udf);
    }

    @Test
    public void testMathExprBround() throws HiveException {
        double[] vArr;
        for (double v : vArr = new double[]{1.5, 2.5, -1.5, -2.5, 1.49, 1.51}) {
            double v1 = RoundUtils.bround((double)v, (int)0);
            double v2 = MathExpr.bround((double)v);
            Assert.assertEquals((double)v1, (double)v2, (double)1.0E-5);
            double v3 = BigDecimal.valueOf(v).setScale(0, 6).doubleValue();
            Assert.assertEquals((double)v3, (double)v2, (double)1.0E-5);
        }
    }

    private void runDouble(double v, IntWritable scale, Double expV, GenericUDF udf) throws HiveException {
        GenericUDF.DeferredJavaObject valueObj0 = new GenericUDF.DeferredJavaObject((Object)new DoubleWritable(v));
        GenericUDF.DeferredJavaObject valueObj1 = new GenericUDF.DeferredJavaObject((Object)scale);
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{valueObj0, valueObj1};
        DoubleWritable output = (DoubleWritable)udf.evaluate(args);
        Assert.assertEquals((String)"bround() test ", (double)expV, (double)output.get(), (double)1.0E-5);
    }

    private void runFloat(float v, IntWritable scale, Float expV, GenericUDF udf) throws HiveException {
        GenericUDF.DeferredJavaObject valueObj0 = new GenericUDF.DeferredJavaObject((Object)new FloatWritable(v));
        GenericUDF.DeferredJavaObject valueObj1 = new GenericUDF.DeferredJavaObject((Object)scale);
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{valueObj0, valueObj1};
        FloatWritable output = (FloatWritable)udf.evaluate(args);
        Assert.assertEquals((String)"bround() test ", (float)expV.floatValue(), (float)output.get(), (float)0.001f);
    }

    private void runDecimal(double v, IntWritable scale, Double expV, GenericUDF udf) throws HiveException {
        HiveDecimal hd = HiveDecimal.create((BigDecimal)BigDecimal.valueOf(v));
        GenericUDF.DeferredJavaObject valueObj0 = new GenericUDF.DeferredJavaObject((Object)new HiveDecimalWritable(hd));
        GenericUDF.DeferredJavaObject valueObj1 = new GenericUDF.DeferredJavaObject((Object)scale);
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{valueObj0, valueObj1};
        HiveDecimalWritable output = (HiveDecimalWritable)udf.evaluate(args);
        Assert.assertEquals((String)"bround() test ", (double)expV, (double)output.getHiveDecimal().doubleValue(), (double)1.0E-5);
    }
}

