/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import junit.framework.TestCase;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFAddMonths;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritableV2;
import org.apache.hadoop.hive.serde2.objectinspector.ConstantObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableByteObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableIntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableLongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableShortObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableStringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableTimestampObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;

public class TestGenericUDFAddMonths
extends TestCase {
    private final Text fmtTextWithTime = new Text("YYYY-MM-dd HH:mm:ss");
    private final Text fmtTextWithTimeAndms = new Text("YYYY-MM-dd HH:mm:ss.SSS");
    private final Text fmtTextWithoutTime = new Text("YYYY-MM-dd");
    private final Text fmtTextInvalid = new Text("YYYY-abcdz");

    public void testAddMonthsInt() throws HiveException {
        GenericUDFAddMonths udf = new GenericUDFAddMonths();
        WritableStringObjectInspector valueOI0 = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        WritableIntObjectInspector valueOI1 = PrimitiveObjectInspectorFactory.writableIntObjectInspector;
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI0, valueOI1};
        udf.initialize(arguments);
        this.runAndVerify("2014-01-14", 1, "2014-02-14", (GenericUDF)udf);
        this.runAndVerify("2014-01-31", 1, "2014-02-28", (GenericUDF)udf);
        this.runAndVerify("2014-02-28", -1, "2014-01-31", (GenericUDF)udf);
        this.runAndVerify("2014-02-28", 2, "2014-04-30", (GenericUDF)udf);
        this.runAndVerify("2014-04-30", -2, "2014-02-28", (GenericUDF)udf);
        this.runAndVerify("2015-02-28", 12, "2016-02-29", (GenericUDF)udf);
        this.runAndVerify("2016-02-29", -12, "2015-02-28", (GenericUDF)udf);
        this.runAndVerify("2016-01-29", 1, "2016-02-29", (GenericUDF)udf);
        this.runAndVerify("2016-02-29", -1, "2016-01-31", (GenericUDF)udf);
        this.runAndVerify("2014-01-14 10:30:00", 1, "2014-02-14", (GenericUDF)udf);
        this.runAndVerify("2014-01-31 10:30:00", 1, "2014-02-28", (GenericUDF)udf);
        this.runAndVerify("2014-02-28 10:30:00.1", -1, "2014-01-31", (GenericUDF)udf);
        this.runAndVerify("2014-02-28 10:30:00.100", 2, "2014-04-30", (GenericUDF)udf);
        this.runAndVerify("2014-04-30 10:30:00.001", -2, "2014-02-28", (GenericUDF)udf);
        this.runAndVerify("2015-02-28 10:30:00.000000001", 12, "2016-02-29", (GenericUDF)udf);
        this.runAndVerify("2016-02-29 10:30:00", -12, "2015-02-28", (GenericUDF)udf);
        this.runAndVerify("2016-01-29 10:30:00", 1, "2016-02-29", (GenericUDF)udf);
        this.runAndVerify("2016-02-29 10:30:00", -1, "2016-01-31", (GenericUDF)udf);
        this.runAndVerify("2016-02-29 10:30:00", -1, this.fmtTextWithoutTime, "2016-01-31", (GenericUDF)udf);
    }

    public void testAddMonthsStringWithTime() throws HiveException {
        GenericUDFAddMonths udf = new GenericUDFAddMonths();
        WritableStringObjectInspector valueOI0 = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        WritableIntObjectInspector valueOI1 = PrimitiveObjectInspectorFactory.writableIntObjectInspector;
        ConstantObjectInspector valueOI2 = PrimitiveObjectInspectorFactory.getPrimitiveWritableConstantObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.stringTypeInfo, (Object)this.fmtTextWithTime);
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI0, valueOI1, valueOI2};
        udf.initialize(arguments);
        this.runAndVerify("2018-05-10 08:15:12", -1, this.fmtTextWithTime, "2018-04-10 08:15:12", (GenericUDF)udf);
        this.runAndVerify("2017-12-31 14:15:16", 2, this.fmtTextWithTime, "2018-02-28 14:15:16", (GenericUDF)udf);
        this.runAndVerify("2017-12-31 14:15:16.001", 2, this.fmtTextWithTime, "2018-02-28 14:15:16", (GenericUDF)udf);
    }

    public void testAddMonthsInvalidFormatter() throws HiveException {
        GenericUDFAddMonths udf = new GenericUDFAddMonths();
        WritableStringObjectInspector valueOI0 = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        WritableIntObjectInspector valueOI1 = PrimitiveObjectInspectorFactory.writableIntObjectInspector;
        ConstantObjectInspector valueOI2 = PrimitiveObjectInspectorFactory.getPrimitiveWritableConstantObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.stringTypeInfo, (Object)this.fmtTextInvalid);
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI0, valueOI1, valueOI2};
        try {
            udf.initialize(arguments);
            TestGenericUDFAddMonths.fail((String)"Expected to throw an exception for invalid DateFormat");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testAddMonthsStringWithTimeWithms() throws HiveException {
        GenericUDFAddMonths udf = new GenericUDFAddMonths();
        WritableStringObjectInspector valueOI0 = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        WritableIntObjectInspector valueOI1 = PrimitiveObjectInspectorFactory.writableIntObjectInspector;
        ConstantObjectInspector valueOI2 = PrimitiveObjectInspectorFactory.getPrimitiveWritableConstantObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.stringTypeInfo, (Object)this.fmtTextWithTimeAndms);
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI0, valueOI1, valueOI2};
        udf.initialize(arguments);
        this.runAndVerify("2017-12-31 14:15:16.350", 2, this.fmtTextWithTimeAndms, "2018-02-28 14:15:16.350", (GenericUDF)udf);
        this.runAndVerify("2017-12-31 14:15:16.001", 2, this.fmtTextWithTimeAndms, "2018-02-28 14:15:16.001", (GenericUDF)udf);
        this.runAndVerify("2017-12-31 14:15:16", 2, this.fmtTextWithTimeAndms, "2018-02-28 14:15:16.000", (GenericUDF)udf);
    }

    public void testAddMonthsWithNullFormatter() throws HiveException {
        GenericUDFAddMonths udf = new GenericUDFAddMonths();
        WritableStringObjectInspector valueOI0 = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        WritableIntObjectInspector valueOI1 = PrimitiveObjectInspectorFactory.writableIntObjectInspector;
        ConstantObjectInspector valueOI2 = PrimitiveObjectInspectorFactory.getPrimitiveWritableConstantObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.stringTypeInfo, null);
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI0, valueOI1, valueOI2};
        udf.initialize(arguments);
        this.runAndVerify("2017-12-31 14:15:16.350", 2, null, "2018-02-28", (GenericUDF)udf);
        this.runAndVerify("2017-12-31", 2, null, "2018-02-28", (GenericUDF)udf);
    }

    public void testAddMonthsTimestamp() throws HiveException {
        GenericUDFAddMonths udf = new GenericUDFAddMonths();
        WritableTimestampObjectInspector valueOI0 = PrimitiveObjectInspectorFactory.writableTimestampObjectInspector;
        WritableIntObjectInspector valueOI1 = PrimitiveObjectInspectorFactory.writableIntObjectInspector;
        ConstantObjectInspector valueOI2 = PrimitiveObjectInspectorFactory.getPrimitiveWritableConstantObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.stringTypeInfo, (Object)this.fmtTextWithTime);
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI0, valueOI1, valueOI2};
        udf.initialize(arguments);
        this.runAndVerify(Timestamp.valueOf((String)"2018-05-10 08:15:12"), 1, this.fmtTextWithTime, "2018-06-10 08:15:12", (GenericUDF)udf);
        this.runAndVerify(Timestamp.valueOf((String)"2017-12-31 14:15:16"), 2, this.fmtTextWithTime, "2018-02-28 14:15:16", (GenericUDF)udf);
    }

    public void testWrongDateStr() throws HiveException {
        GenericUDFAddMonths udf = new GenericUDFAddMonths();
        WritableStringObjectInspector valueOI0 = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        WritableIntObjectInspector valueOI1 = PrimitiveObjectInspectorFactory.writableIntObjectInspector;
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI0, valueOI1};
        udf.initialize(arguments);
        this.runAndVerify("2014-02-30", 1, "2014-04-02", (GenericUDF)udf);
        this.runAndVerify("2014-02-32", 1, "2014-04-04", (GenericUDF)udf);
        this.runAndVerify("2014-01", 1, null, (GenericUDF)udf);
    }

    public void testWrongTsStr() throws HiveException {
        GenericUDFAddMonths udf = new GenericUDFAddMonths();
        WritableStringObjectInspector valueOI0 = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        WritableIntObjectInspector valueOI1 = PrimitiveObjectInspectorFactory.writableIntObjectInspector;
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI0, valueOI1};
        udf.initialize(arguments);
        this.runAndVerify("2014-02-30 10:30:00", 1, "2014-04-02", (GenericUDF)udf);
        this.runAndVerify("2014-02-32 10:30:00", 1, "2014-04-04", (GenericUDF)udf);
        this.runAndVerify("2014/01/31 10:30:00", 1, null, (GenericUDF)udf);
        this.runAndVerify("2014-01-31T10:30:00", 1, "2014-02-28", (GenericUDF)udf);
    }

    public void testAddMonthsShort() throws HiveException {
        GenericUDFAddMonths udf = new GenericUDFAddMonths();
        WritableStringObjectInspector valueOI0 = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        WritableShortObjectInspector valueOI1 = PrimitiveObjectInspectorFactory.writableShortObjectInspector;
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI0, valueOI1};
        udf.initialize(arguments);
        this.runAndVerify("2014-01-14", (short)1, "2014-02-14", (GenericUDF)udf);
    }

    public void testAddMonthsByte() throws HiveException {
        GenericUDFAddMonths udf = new GenericUDFAddMonths();
        WritableStringObjectInspector valueOI0 = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        WritableByteObjectInspector valueOI1 = PrimitiveObjectInspectorFactory.writableByteObjectInspector;
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI0, valueOI1};
        udf.initialize(arguments);
        this.runAndVerify("2014-01-14", (byte)1, "2014-02-14", (GenericUDF)udf);
    }

    public void testAddMonthsLong() throws HiveException {
        GenericUDFAddMonths udf = new GenericUDFAddMonths();
        WritableStringObjectInspector valueOI0 = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        WritableLongObjectInspector valueOI1 = PrimitiveObjectInspectorFactory.writableLongObjectInspector;
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI0, valueOI1};
        try {
            udf.initialize(arguments);
            TestGenericUDFAddMonths.assertTrue((String)"add_months exception expected", (boolean)false);
        }
        catch (UDFArgumentTypeException e) {
            TestGenericUDFAddMonths.assertEquals((String)"add_months test", (String)"add_months only takes INT/SHORT/BYTE types as 2nd argument, got LONG", (String)e.getMessage());
        }
    }

    private void runAndVerify(String str, int months, String expResult, GenericUDF udf) throws HiveException {
        GenericUDF.DeferredJavaObject valueObj0 = new GenericUDF.DeferredJavaObject((Object)new Text(str));
        GenericUDF.DeferredJavaObject valueObj1 = new GenericUDF.DeferredJavaObject((Object)new IntWritable(months));
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{valueObj0, valueObj1};
        Text output = (Text)udf.evaluate(args);
        TestGenericUDFAddMonths.assertEquals((String)"add_months() test ", (String)expResult, (String)(output != null ? output.toString() : null));
    }

    private void runAndVerify(String str, int months, Text dateFormat, String expResult, GenericUDF udf) throws HiveException {
        GenericUDF.DeferredJavaObject valueObj0 = new GenericUDF.DeferredJavaObject((Object)new Text(str));
        GenericUDF.DeferredJavaObject valueObj1 = new GenericUDF.DeferredJavaObject((Object)new IntWritable(months));
        GenericUDF.DeferredJavaObject valueObj2 = new GenericUDF.DeferredJavaObject((Object)dateFormat);
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{valueObj0, valueObj1, valueObj2};
        Text output = (Text)udf.evaluate(args);
        TestGenericUDFAddMonths.assertEquals((String)"add_months() test with time part", (String)expResult, (String)(output != null ? output.toString() : null));
    }

    private void runAndVerify(Timestamp ts, int months, Text dateFormat, String expResult, GenericUDF udf) throws HiveException {
        GenericUDF.DeferredJavaObject valueObj0 = new GenericUDF.DeferredJavaObject((Object)new TimestampWritableV2(ts));
        GenericUDF.DeferredJavaObject valueObj1 = new GenericUDF.DeferredJavaObject((Object)new IntWritable(months));
        GenericUDF.DeferredJavaObject valueObj2 = new GenericUDF.DeferredJavaObject((Object)dateFormat);
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{valueObj0, valueObj1, valueObj2};
        Text output = (Text)udf.evaluate(args);
        TestGenericUDFAddMonths.assertEquals((String)"add_months() test for timestamp", (String)expResult, (String)(output != null ? output.toString() : null));
    }

    private void runAndVerify(String str, short months, String expResult, GenericUDF udf) throws HiveException {
        GenericUDF.DeferredJavaObject valueObj0 = new GenericUDF.DeferredJavaObject((Object)new Text(str));
        GenericUDF.DeferredJavaObject valueObj1 = new GenericUDF.DeferredJavaObject((Object)new ShortWritable(months));
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{valueObj0, valueObj1};
        Text output = (Text)udf.evaluate(args);
        TestGenericUDFAddMonths.assertEquals((String)"add_months() test ", (String)expResult, (String)(output != null ? output.toString() : null));
    }

    private void runAndVerify(String str, byte months, String expResult, GenericUDF udf) throws HiveException {
        GenericUDF.DeferredJavaObject valueObj0 = new GenericUDF.DeferredJavaObject((Object)new Text(str));
        GenericUDF.DeferredJavaObject valueObj1 = new GenericUDF.DeferredJavaObject((Object)new ByteWritable(months));
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{valueObj0, valueObj1};
        Text output = (Text)udf.evaluate(args);
        TestGenericUDFAddMonths.assertEquals((String)"add_months() test ", (String)expResult, (String)(output != null ? output.toString() : null));
    }
}

