/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf;

import junit.framework.TestCase;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.UDFSha1;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Text;

public class TestUDFSha1
extends TestCase {
    public void testSha1Str() throws HiveException {
        UDFSha1 udf = new UDFSha1();
        this.runAndVerifyStr("ABC", "3c01bdbb26f358bab27f267924aa2c9a03fcfdb8", udf);
        this.runAndVerifyStr("", "da39a3ee5e6b4b0d3255bfef95601890afd80709", udf);
        this.runAndVerifyStr(null, null, udf);
    }

    public void testSha1Bin() throws HiveException {
        UDFSha1 udf = new UDFSha1();
        this.runAndVerifyBin(new byte[]{65, 66, 67}, "3c01bdbb26f358bab27f267924aa2c9a03fcfdb8", udf);
        this.runAndVerifyBin(new byte[0], "da39a3ee5e6b4b0d3255bfef95601890afd80709", udf);
        this.runAndVerifyBin(null, null, udf);
    }

    private void runAndVerifyStr(String str, String expResult, UDFSha1 udf) throws HiveException {
        Text t = str != null ? new Text(str) : null;
        Text output = udf.evaluate(t);
        TestUDFSha1.assertEquals((String)"sha1() test ", (String)expResult, (String)(output != null ? output.toString() : null));
    }

    private void runAndVerifyBin(byte[] binV, String expResult, UDFSha1 udf) throws HiveException {
        BytesWritable binWr = binV != null ? new BytesWritable(binV) : null;
        Text output = udf.evaluate(binWr);
        TestUDFSha1.assertEquals((String)"sha1() test ", (String)expResult, (String)(output != null ? output.toString() : null));
    }
}

