/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.metadata;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.UnknownDBException;
import org.apache.hadoop.hive.ql.metadata.TableIterable;
import org.apache.thrift.TException;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class TestTableIterable {
    @Test
    public void testNumReturned() throws MetaException, InvalidOperationException, UnknownDBException, TException {
        HiveMetaStoreClient msc = (HiveMetaStoreClient)Mockito.mock(HiveMetaStoreClient.class);
        List<Table> threeTables = Arrays.asList(new Table(), new Table(), new Table());
        Mockito.when((Object)msc.getTableObjectsByName(Mockito.anyString(), ArgumentMatchers.anyList())).thenReturn(threeTables);
        List<String> tableNames = Arrays.asList("a", "b", "c", "d", "e", "f");
        TableIterable tIterable = new TableIterable((IMetaStoreClient)msc, "dummy", tableNames, threeTables.size());
        tIterable.iterator();
        Iterator tIter = tIterable.iterator();
        int size = 0;
        while (tIter.hasNext()) {
            ++size;
            tIter.next();
        }
        Assert.assertEquals((String)"Number of table objects returned", (long)size, (long)tableNames.size());
        ((HiveMetaStoreClient)Mockito.verify((Object)msc)).getTableObjectsByName("dummy", Arrays.asList("a", "b", "c"));
        ((HiveMetaStoreClient)Mockito.verify((Object)msc)).getTableObjectsByName("dummy", Arrays.asList("d", "e", "f"));
    }
}

