/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import java.io.File;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatchCtx;
import org.apache.hadoop.hive.ql.io.AcidOutputFormat;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.io.BucketCodec;
import org.apache.hadoop.hive.ql.io.RecordIdentifier;
import org.apache.hadoop.hive.ql.io.orc.OrcInputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcRecordUpdater;
import org.apache.hadoop.hive.ql.io.orc.OrcSplit;
import org.apache.hadoop.hive.ql.io.orc.TestOrcFile;
import org.apache.hadoop.hive.ql.io.orc.VectorizedOrcAcidRowBatchReader;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reporter;
import org.apache.orc.TypeDescription;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestVectorizedOrcAcidRowBatchReader {
    private static final long NUM_ROWID_PER_OWID = 15000L;
    private static final long NUM_OWID = 10L;
    private JobConf conf;
    private FileSystem fs;
    private Path root;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Before
    public void setup() throws Exception {
        this.conf = new JobConf();
        this.conf.set("fs.defaultFS", "file:///");
        this.conf.set("bucket_count", "1");
        this.conf.set("transactional", "true");
        this.conf.setBoolean(HiveConf.ConfVars.HIVE_TRANSACTIONAL_TABLE_SCAN.varname, true);
        this.conf.set("transactional_properties", "default");
        this.conf.setInt(HiveConf.ConfVars.HIVE_TXN_OPERATIONAL_PROPERTIES.varname, AcidUtils.AcidOperationalProperties.getDefault().toInt());
        this.conf.set("schema.evolution.columns", DummyRow.getColumnNamesProperty());
        this.conf.set("schema.evolution.columns.types", DummyRow.getColumnTypesProperty());
        this.conf.setBoolean(HiveConf.ConfVars.HIVE_VECTORIZATION_ENABLED.varname, true);
        this.conf.set(HiveConf.ConfVars.HIVE_ORC_SPLIT_STRATEGY.varname, "BI");
        Path workDir = new Path(System.getProperty("test.tmp.dir", "target" + File.separator + "test" + File.separator + "tmp"));
        this.root = new Path(workDir, "TestVectorizedOrcAcidRowBatch.testDump");
        this.fs = this.root.getFileSystem((Configuration)this.conf);
        this.root = this.fs.makeQualified(this.root);
        this.fs.delete(this.root, true);
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            long j;
            long i;
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(DummyRow.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            int bucket = 0;
            AcidOutputFormat.Options options = new AcidOutputFormat.Options((Configuration)this.conf).filesystem(this.fs).bucket(bucket).writingBase(false).minimumWriteId(1L).maximumWriteId(10L).inspector(inspector).reporter(Reporter.NULL).recordIdColumn(1).finalDestination(this.root);
            OrcRecordUpdater updater = new OrcRecordUpdater(this.root, options);
            for (long i2 = 1L; i2 <= 10L; ++i2) {
                for (long j2 = 0L; j2 < 15000L; ++j2) {
                    long payload = (i2 - 1L) * 15000L + j2;
                    updater.insert(i2, (Object)new DummyRow(payload, j2, i2, bucket));
                }
            }
            updater.close(false);
            long currTxnId = 11L;
            options.minimumWriteId(currTxnId).maximumWriteId(currTxnId);
            updater = new OrcRecordUpdater(this.root, options);
            for (i = 1L; i <= 10L; ++i) {
                for (j = 0L; j < 15000L; ++j) {
                    if (j % 2L != 0L || j % 3L == 0L) continue;
                    updater.delete(currTxnId, (Object)new DummyRow(-1L, j, i, bucket));
                }
            }
            updater.close(false);
            currTxnId = 12L;
            options.minimumWriteId(currTxnId).maximumWriteId(currTxnId);
            updater = new OrcRecordUpdater(this.root, options);
            for (i = 1L; i <= 10L; ++i) {
                for (j = 0L; j < 15000L; ++j) {
                    if (j % 2L == 0L || j % 3L != 0L) continue;
                    updater.delete(currTxnId, (Object)new DummyRow(-1L, j, i, bucket));
                }
            }
            updater.close(false);
            currTxnId = 13L;
            options.minimumWriteId(currTxnId).maximumWriteId(currTxnId);
            updater = new OrcRecordUpdater(this.root, options);
            for (i = 1L; i <= 10L; ++i) {
                for (j = 0L; j < 15000L; ++j) {
                    if (j % 2L != 0L || j % 3L != 0L) continue;
                    updater.delete(currTxnId, (Object)new DummyRow(-1L, j, i, bucket));
                }
            }
            updater.close(false);
            return;
        }
    }

    private List<OrcSplit> getSplits() throws Exception {
        this.conf.setInt(HiveConf.ConfVars.HIVE_TXN_OPERATIONAL_PROPERTIES.varname, AcidUtils.AcidOperationalProperties.getDefault().toInt());
        OrcInputFormat.Context context = new OrcInputFormat.Context((Configuration)this.conf);
        OrcInputFormat.FileGenerator gen = new OrcInputFormat.FileGenerator(context, this.fs, this.root, false, null);
        OrcInputFormat.AcidDirInfo adi = gen.call();
        List splitStrategies = OrcInputFormat.determineSplitStrategies(null, (OrcInputFormat.Context)context, (FileSystem)adi.fs, (Path)adi.splitPath, (List)adi.baseFiles, (List)adi.deleteEvents, null, null, (boolean)true);
        Assert.assertEquals((long)1L, (long)splitStrategies.size());
        List splits = ((OrcInputFormat.ACIDSplitStrategy)splitStrategies.get(0)).getSplits();
        Assert.assertEquals((long)1L, (long)splits.size());
        Assert.assertEquals((Object)(this.root.toUri().toString() + File.separator + "delta_0000001_0000010_0000/bucket_00000"), (Object)((OrcSplit)splits.get(0)).getPath().toUri().toString());
        Assert.assertFalse((boolean)((OrcSplit)splits.get(0)).isOriginal());
        return splits;
    }

    @Test
    public void testVectorizedOrcAcidRowBatchReader() throws Exception {
        this.testVectorizedOrcAcidRowBatchReader(VectorizedOrcAcidRowBatchReader.ColumnizedDeleteEventRegistry.class.getName());
        int oldValue = this.conf.getInt(HiveConf.ConfVars.HIVE_TRANSACTIONAL_NUM_EVENTS_IN_MEMORY.varname, 1000000);
        this.conf.setInt(HiveConf.ConfVars.HIVE_TRANSACTIONAL_NUM_EVENTS_IN_MEMORY.varname, 1000);
        this.testVectorizedOrcAcidRowBatchReader(VectorizedOrcAcidRowBatchReader.SortMergedDeleteEventRegistry.class.getName());
        this.conf.setInt(HiveConf.ConfVars.HIVE_TRANSACTIONAL_NUM_EVENTS_IN_MEMORY.varname, oldValue);
    }

    private void testVectorizedOrcAcidRowBatchReader(String deleteEventRegistry) throws Exception {
        List<OrcSplit> splits = this.getSplits();
        this.conf.set("hive.txn.valid.writeids", "tbl:14:1:1:5");
        VectorizedOrcAcidRowBatchReader vectorizedReader = new VectorizedOrcAcidRowBatchReader(splits.get(0), this.conf, Reporter.NULL, new VectorizedRowBatchCtx());
        if (deleteEventRegistry.equals(VectorizedOrcAcidRowBatchReader.ColumnizedDeleteEventRegistry.class.getName())) {
            Assert.assertTrue((boolean)(vectorizedReader.getDeleteEventRegistry() instanceof VectorizedOrcAcidRowBatchReader.ColumnizedDeleteEventRegistry));
        }
        if (deleteEventRegistry.equals(VectorizedOrcAcidRowBatchReader.SortMergedDeleteEventRegistry.class.getName())) {
            Assert.assertTrue((boolean)(vectorizedReader.getDeleteEventRegistry() instanceof VectorizedOrcAcidRowBatchReader.SortMergedDeleteEventRegistry));
        }
        TypeDescription schema = OrcInputFormat.getDesiredRowTypeDescr((Configuration)this.conf, (boolean)true, (int)Integer.MAX_VALUE);
        VectorizedRowBatch vectorizedRowBatch = schema.createRowBatchV2();
        vectorizedRowBatch.setPartitionInfo(1, 0);
        long previousPayload = Long.MIN_VALUE;
        while (vectorizedReader.next(null, vectorizedRowBatch)) {
            Assert.assertTrue((boolean)vectorizedRowBatch.selectedInUse);
            LongColumnVector col = (LongColumnVector)vectorizedRowBatch.cols[0];
            for (int i = 0; i < vectorizedRowBatch.size; ++i) {
                int idx = vectorizedRowBatch.selected[i];
                long payload = col.vector[idx];
                long owid = payload / 15000L + 1L;
                long rowId = payload % 15000L;
                Assert.assertFalse((rowId % 2L == 0L || rowId % 3L == 0L ? 1 : 0) != 0);
                Assert.assertTrue((owid != 5L ? 1 : 0) != 0);
                Assert.assertTrue((payload > previousPayload ? 1 : 0) != 0);
                previousPayload = payload;
            }
        }
    }

    public static class DummyRow {
        LongWritable field;
        RecordIdentifier ROW__ID;

        DummyRow(long val) {
            this.field = new LongWritable(val);
            this.ROW__ID = null;
        }

        DummyRow(long val, long rowId, long origTxn, int bucket) {
            this.field = new LongWritable(val);
            bucket = BucketCodec.V1.encode(new AcidOutputFormat.Options(null).bucket(bucket));
            this.ROW__ID = new RecordIdentifier(origTxn, bucket, rowId);
        }

        static String getColumnNamesProperty() {
            return "field";
        }

        static String getColumnTypesProperty() {
            return "bigint";
        }
    }
}

