/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.vector.VectorExtractRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContextRegion;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.util.FakeCaptureOutputOperator;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;

public class FakeCaptureVectorToRowOutputOperator
extends FakeCaptureOutputOperator
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Operator<? extends OperatorDesc> op;
    private TypeInfo[] outputTypeInfos;
    private ObjectInspector[] outputObjectInspectors;
    private VectorExtractRow vectorExtractRow;

    protected FakeCaptureVectorToRowOutputOperator() {
    }

    public FakeCaptureVectorToRowOutputOperator(CompilationOpContext ctx, Operator<? extends OperatorDesc> op) {
        super(ctx);
        this.op = op;
    }

    public static FakeCaptureVectorToRowOutputOperator addCaptureOutputChild(CompilationOpContext ctx, Operator<? extends OperatorDesc> op) {
        FakeCaptureVectorToRowOutputOperator out = new FakeCaptureVectorToRowOutputOperator(ctx, op);
        ArrayList<Operator<? extends OperatorDesc>> listParents = new ArrayList<Operator<? extends OperatorDesc>>(1);
        listParents.add(op);
        out.setParentOperators(listParents);
        ArrayList<FakeCaptureVectorToRowOutputOperator> listChildren = new ArrayList<FakeCaptureVectorToRowOutputOperator>(1);
        listChildren.add(out);
        op.setChildOperators(listChildren);
        return out;
    }

    @Override
    public void initializeOp(Configuration conf) throws HiveException {
        super.initializeOp(conf);
        VectorizationContextRegion vectorizationContextRegion = (VectorizationContextRegion)this.op;
        VectorizationContext outputVectorizationContext = vectorizationContextRegion.getOutputVectorizationContext();
        this.outputTypeInfos = outputVectorizationContext.getInitialTypeInfos();
        int outputLength = this.outputTypeInfos.length;
        this.outputObjectInspectors = new ObjectInspector[outputLength];
        for (int i = 0; i < outputLength; ++i) {
            TypeInfo typeInfo = this.outputTypeInfos[i];
            this.outputObjectInspectors[i] = TypeInfoUtils.getStandardWritableObjectInspectorFromTypeInfo((TypeInfo)typeInfo);
        }
        this.vectorExtractRow = new VectorExtractRow();
        this.vectorExtractRow.init(this.outputTypeInfos);
    }

    @Override
    public void process(Object row, int tag) throws HiveException {
        VectorizedRowBatch batch = (VectorizedRowBatch)row;
        boolean selectedInUse = batch.selectedInUse;
        int[] selected = batch.selected;
        for (int logical = 0; logical < batch.size; ++logical) {
            int batchIndex = selectedInUse ? selected[logical] : logical;
            Object[] rowObjects = new Object[this.outputObjectInspectors.length];
            this.vectorExtractRow.extractRow(batch, batchIndex, rowObjects);
            block5: for (int c = 0; c < rowObjects.length; ++c) {
                switch (this.outputTypeInfos[c].getCategory()) {
                    case PRIMITIVE: {
                        rowObjects[c] = ((PrimitiveObjectInspector)this.outputObjectInspectors[c]).copyObject(rowObjects[c]);
                        continue block5;
                    }
                    case STRUCT: {
                        StructTypeInfo structTypeInfo = (StructTypeInfo)this.outputTypeInfos[c];
                        StandardStructObjectInspector structInspector = (StandardStructObjectInspector)this.outputObjectInspectors[c];
                        ArrayList fieldTypeInfos = structTypeInfo.getAllStructFieldTypeInfos();
                        int size = fieldTypeInfos.size();
                        List structFields = structInspector.getAllStructFieldRefs();
                        Object oldStruct = rowObjects[c];
                        if (oldStruct == null) continue block5;
                        List currentStructData = structInspector.getStructFieldsDataAsList(oldStruct);
                        Object newStruct = structInspector.create();
                        for (int i = 0; i < size; ++i) {
                            StructField structField = (StructField)structFields.get(i);
                            Object oldValue = currentStructData.get(i);
                            Object newValue = oldValue != null ? ((PrimitiveObjectInspector)structField.getFieldObjectInspector()).copyObject(oldValue) : null;
                            structInspector.setStructFieldData(newStruct, structField, newValue);
                        }
                        rowObjects[c] = ((ArrayList)newStruct).toArray();
                        continue block5;
                    }
                    default: {
                        throw new RuntimeException("Unexpected category " + this.outputTypeInfos[c].getCategory());
                    }
                }
            }
            super.process(rowObjects, 0);
        }
    }
}

