/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import java.security.PrivilegedExceptionAction;
import org.apache.hadoop.hive.ql.exec.tez.DagUtils;
import org.apache.hadoop.hive.ql.plan.BaseWork;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.tez.dag.api.DAG;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestDagUtils {
    @Test
    public void testCredentialsNotOverwritten() throws Exception {
        UserGroupInformation testUser = UserGroupInformation.createUserForTesting((String)"test_user", (String[])new String[0]);
        final DagUtils dagUtils = DagUtils.getInstance();
        Credentials originalCredentials = new Credentials();
        Text testTokenAlias = new Text("my_test_token");
        Token testToken = (Token)Mockito.mock(Token.class);
        originalCredentials.addToken(testTokenAlias, testToken);
        Credentials testUserCredentials = new Credentials();
        testUser.addCredentials(testUserCredentials);
        final BaseWork work = (BaseWork)Mockito.mock(BaseWork.class);
        final DAG dag = DAG.create((String)"test_credentials_dag");
        dag.setCredentials(originalCredentials);
        testUser.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                dagUtils.addCredentials(work, dag);
                return null;
            }
        });
        Token actualToken = dag.getCredentials().getToken(testTokenAlias);
        Assert.assertEquals((Object)testToken, (Object)actualToken);
    }
}

