/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql;

import java.io.File;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.TestTxnCommands2;
import org.apache.hadoop.hive.ql.TxnCommandsBaseForTests;
import org.apache.hadoop.hive.ql.processors.CommandProcessorResponse;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Ignore
public class TestTxnLoadData
extends TxnCommandsBaseForTests {
    private static final Logger LOG = LoggerFactory.getLogger(TestTxnLoadData.class);
    private static final String TEST_DATA_DIR = new File(System.getProperty("java.io.tmpdir") + File.separator + TestTxnLoadData.class.getCanonicalName() + "-" + System.currentTimeMillis()).getPath().replaceAll("\\\\", "/");
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();

    @Override
    String getTestDataDir() {
        return TEST_DATA_DIR;
    }

    @Test
    public void loadData() throws Exception {
        this.loadData(false);
    }

    @Test
    public void loadDataVectorized() throws Exception {
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_VECTORIZATION_ENABLED, true);
        this.loadData(true);
    }

    @Test
    public void loadDataUpdate() throws Exception {
        this.loadDataUpdate(false);
    }

    @Test
    public void loadDataUpdateVectorized() throws Exception {
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_VECTORIZATION_ENABLED, true);
        this.loadDataUpdate(true);
    }

    @Test
    public void loadDataNonAcid2AcidConversion() throws Exception {
        this.loadDataNonAcid2AcidConversion(false);
    }

    @Test
    public void loadDataNonAcid2AcidConversionVectorized() throws Exception {
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_VECTORIZATION_ENABLED, true);
        this.loadDataNonAcid2AcidConversion(true);
    }

    @Test
    public void testMultiStatement() throws Exception {
        this.testMultiStatement(false);
    }

    @Test
    public void testMultiStatementVectorized() throws Exception {
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_VECTORIZATION_ENABLED, true);
        this.testMultiStatement(true);
    }

    private void loadDataUpdate(boolean isVectorized) throws Exception {
        this.runStatementOnDriver("drop table if exists T");
        this.runStatementOnDriver("drop table if exists Tstage");
        this.runStatementOnDriver("create table T (a int, b int) stored as orc tblproperties('transactional'='true')");
        this.runStatementOnDriver("create table Tstage (a int, b int) stored as orc tblproperties('transactional'='false')");
        this.runStatementOnDriver("insert into Tstage values(1,2),(3,4)");
        this.runStatementOnDriver("export table Tstage to '" + this.getWarehouseDir() + "/1'");
        this.runStatementOnDriver("truncate table Tstage");
        this.runStatementOnDriver("load data local inpath '" + this.getWarehouseDir() + "/1/data' into table T");
        String testQuery = isVectorized ? "select ROW__ID, a, b from T order by ROW__ID" : "select ROW__ID, a, b, INPUT__FILE__NAME from T order by ROW__ID";
        String[][] expected = new String[][]{{"{\"writeid\":1,\"bucketid\":536870912,\"rowid\":0}\t1\t2", "t/delta_0000001_0000001_0000/000000_0"}, {"{\"writeid\":1,\"bucketid\":536870912,\"rowid\":1}\t3\t4", "t/delta_0000001_0000001_0000/000000_0"}};
        this.checkResult(expected, testQuery, isVectorized, "load data inpath");
        this.runStatementOnDriver("update T set b = 17 where a = 1");
        String[][] expected2 = new String[][]{{"{\"writeid\":1,\"bucketid\":536870912,\"rowid\":1}\t3\t4", "t/delta_0000001_0000001_0000/000000_0"}, {"{\"writeid\":2,\"bucketid\":536870912,\"rowid\":0}\t1\t17", "t/delta_0000002_0000002_0000/bucket_00000"}};
        this.checkResult(expected2, testQuery, isVectorized, "update");
        this.runStatementOnDriver("insert into T values(2,2)");
        this.runStatementOnDriver("delete from T where a = 3");
        this.runStatementOnDriver("alter table T compact 'minor'");
        TestTxnCommands2.runWorker(this.hiveConf);
        String[][] expected3 = new String[][]{{"{\"writeid\":2,\"bucketid\":536870912,\"rowid\":0}\t1\t17", "t/delta_0000001_0000004/bucket_00000"}, {"{\"writeid\":3,\"bucketid\":536870912,\"rowid\":0}\t2\t2", "t/delta_0000001_0000004/bucket_00000"}};
        this.checkResult(expected3, testQuery, isVectorized, "delete compact minor");
        this.runStatementOnDriver("load data local inpath '" + this.getWarehouseDir() + "/1/data' overwrite into table T");
        String[][] expected4 = new String[][]{{"{\"writeid\":5,\"bucketid\":536870912,\"rowid\":0}\t1\t2", "t/base_0000005/000000_0"}, {"{\"writeid\":5,\"bucketid\":536870912,\"rowid\":1}\t3\t4", "t/base_0000005/000000_0"}};
        this.checkResult(expected4, testQuery, isVectorized, "load data inpath overwrite");
        this.runStatementOnDriver("load data local inpath '" + this.getWarehouseDir() + "/1/data' into table T");
        this.runStatementOnDriver("update T set b = 17 where a = 1");
        this.runStatementOnDriver("delete from T where a = 3");
        this.runStatementOnDriver("insert into T values(2,2)");
        String[][] expected5 = new String[][]{{"{\"writeid\":7,\"bucketid\":536870912,\"rowid\":0}\t1\t17", "t/delta_0000007_0000007_0000/bucket_00000"}, {"{\"writeid\":7,\"bucketid\":536870912,\"rowid\":1}\t1\t17", "t/delta_0000007_0000007_0000/bucket_00000"}, {"{\"writeid\":9,\"bucketid\":536870912,\"rowid\":0}\t2\t2", "t/delta_0000009_0000009_0000/bucket_00000"}};
        this.checkResult(expected5, testQuery, isVectorized, "load data inpath overwrite update");
        this.runStatementOnDriver("alter table T compact 'major'");
        TestTxnCommands2.runWorker(this.hiveConf);
        String[][] expected6 = new String[][]{{"{\"writeid\":7,\"bucketid\":536870912,\"rowid\":0}\t1\t17", "t/base_0000009/bucket_00000"}, {"{\"writeid\":7,\"bucketid\":536870912,\"rowid\":1}\t1\t17", "t/base_0000009/bucket_00000"}, {"{\"writeid\":9,\"bucketid\":536870912,\"rowid\":0}\t2\t2", "t/base_0000009/bucket_00000"}};
        this.checkResult(expected6, testQuery, isVectorized, "load data inpath compact major");
    }

    private void loadData(boolean isVectorized) throws Exception {
        this.runStatementOnDriver("drop table if exists T");
        this.runStatementOnDriver("drop table if exists Tstage");
        this.runStatementOnDriver("create table T (a int, b int) stored as orc tblproperties('transactional'='true')");
        this.runStatementOnDriver("insert into T values(0,2),(0,4)");
        this.runStatementOnDriver("create table Tstage (a int, b int) stored as orc tblproperties('transactional'='false')");
        this.runStatementOnDriver("insert into Tstage values(1,2),(3,4)");
        this.runStatementOnDriver("export table Tstage to '" + this.getWarehouseDir() + "/1'");
        this.runStatementOnDriver("truncate table Tstage");
        this.runStatementOnDriver("load data local inpath '" + this.getWarehouseDir() + "/1/data' into table T");
        String testQuery = isVectorized ? "select ROW__ID, a, b from T order by ROW__ID" : "select ROW__ID, a, b, INPUT__FILE__NAME from T order by ROW__ID";
        String[][] expected = new String[][]{{"{\"writeid\":1,\"bucketid\":536870912,\"rowid\":0}\t0\t2", "t/delta_0000001_0000001_0000/bucket_00000"}, {"{\"writeid\":1,\"bucketid\":536870912,\"rowid\":1}\t0\t4", "t/delta_0000001_0000001_0000/bucket_00000"}, {"{\"writeid\":2,\"bucketid\":536870912,\"rowid\":0}\t1\t2", "t/delta_0000002_0000002_0000/000000_0"}, {"{\"writeid\":2,\"bucketid\":536870912,\"rowid\":1}\t3\t4", "t/delta_0000002_0000002_0000/000000_0"}};
        this.checkResult(expected, testQuery, isVectorized, "load data inpath");
        this.runStatementOnDriver("alter table T compact 'minor'");
        TestTxnCommands2.runWorker(this.hiveConf);
        String[][] expected1 = new String[][]{{"{\"writeid\":1,\"bucketid\":536870912,\"rowid\":0}\t0\t2", "t/delta_0000001_0000002/bucket_00000"}, {"{\"writeid\":1,\"bucketid\":536870912,\"rowid\":1}\t0\t4", "t/delta_0000001_0000002/bucket_00000"}, {"{\"writeid\":2,\"bucketid\":536870912,\"rowid\":0}\t1\t2", "t/delta_0000001_0000002/bucket_00000"}, {"{\"writeid\":2,\"bucketid\":536870912,\"rowid\":1}\t3\t4", "t/delta_0000001_0000002/bucket_00000"}};
        this.checkResult(expected1, testQuery, isVectorized, "load data inpath (minor)");
        this.runStatementOnDriver("insert into T values(2,2)");
        this.runStatementOnDriver("alter table T compact 'major'");
        TestTxnCommands2.runWorker(this.hiveConf);
        String[][] expected2 = new String[][]{{"{\"writeid\":1,\"bucketid\":536870912,\"rowid\":0}\t0\t2", "t/base_0000003/bucket_00000"}, {"{\"writeid\":1,\"bucketid\":536870912,\"rowid\":1}\t0\t4", "t/base_0000003/bucket_00000"}, {"{\"writeid\":2,\"bucketid\":536870912,\"rowid\":0}\t1\t2", "t/base_0000003/bucket_00000"}, {"{\"writeid\":2,\"bucketid\":536870912,\"rowid\":1}\t3\t4", "t/base_0000003/bucket_00000"}, {"{\"writeid\":3,\"bucketid\":536870912,\"rowid\":0}\t2\t2", "t/base_0000003/bucket_00000"}};
        this.checkResult(expected2, testQuery, isVectorized, "load data inpath (major)");
        this.runStatementOnDriver("insert into Tstage values(5,6),(7,8)");
        this.runStatementOnDriver("export table Tstage to '" + this.getWarehouseDir() + "/2'");
        this.runStatementOnDriver("load data inpath '" + this.getWarehouseDir() + "/2/data' overwrite into table T");
        String[][] expected3 = new String[][]{{"{\"writeid\":4,\"bucketid\":536870912,\"rowid\":0}\t5\t6", "t/base_0000004/000000_0"}, {"{\"writeid\":4,\"bucketid\":536870912,\"rowid\":1}\t7\t8", "t/base_0000004/000000_0"}};
        this.checkResult(expected3, testQuery, isVectorized, "load data inpath overwrite");
        this.runStatementOnDriver("insert into T values(6,6)");
        this.runStatementOnDriver("alter table T compact 'major'");
        TestTxnCommands2.runWorker(this.hiveConf);
        String[][] expected4 = new String[][]{{"{\"writeid\":4,\"bucketid\":536870912,\"rowid\":0}\t5\t6", "t/base_0000005/bucket_00000"}, {"{\"writeid\":4,\"bucketid\":536870912,\"rowid\":1}\t7\t8", "t/base_0000005/bucket_00000"}, {"{\"writeid\":5,\"bucketid\":536870912,\"rowid\":0}\t6\t6", "t/base_0000005/bucket_00000"}};
        this.checkResult(expected4, testQuery, isVectorized, "load data inpath overwrite (major)");
    }

    private void loadDataNonAcid2AcidConversion(boolean isVectorized) throws Exception {
        this.runStatementOnDriver("drop table if exists T");
        this.runStatementOnDriver("drop table if exists Tstage");
        this.runStatementOnDriver("create table T (a int, b int) stored as orc tblproperties('transactional'='false')");
        this.runStatementOnDriver("insert into T values(0,2),(0,4)");
        this.runStatementOnDriver("create table Tstage (a int, b int) stored as orc tblproperties('transactional'='false')");
        this.runStatementOnDriver("insert into Tstage values(1,2),(3,4)");
        this.runStatementOnDriver("insert into Tstage values(2,2),(3,3)");
        this.runStatementOnDriver("insert into Tstage values(4,4),(5,5)");
        this.runStatementOnDriver("export table Tstage to '" + this.getWarehouseDir() + "/1'");
        this.runStatementOnDriver("truncate table Tstage");
        this.runStatementOnDriver("alter table T SET TBLPROPERTIES ('transactional' = 'true')");
        this.runStatementOnDriver("load data local inpath '" + this.getWarehouseDir() + "/1/data' into table T");
        String testQuery = isVectorized ? "select ROW__ID, a, b from T order by ROW__ID" : "select ROW__ID, a, b, INPUT__FILE__NAME from T order by ROW__ID";
        String[][] expected = new String[][]{{"{\"writeid\":0,\"bucketid\":536870912,\"rowid\":0}\t0\t2", "t/000000_0"}, {"{\"writeid\":0,\"bucketid\":536870912,\"rowid\":1}\t0\t4", "t/000000_0"}, {"{\"writeid\":10000001,\"bucketid\":536870912,\"rowid\":0}\t1\t2", "t/delta_10000001_10000001_0000/000000_0"}, {"{\"writeid\":10000001,\"bucketid\":536870912,\"rowid\":1}\t3\t4", "t/delta_10000001_10000001_0000/000000_0"}, {"{\"writeid\":10000001,\"bucketid\":536936448,\"rowid\":0}\t2\t2", "t/delta_10000001_10000001_0000/000001_0"}, {"{\"writeid\":10000001,\"bucketid\":536936448,\"rowid\":1}\t3\t3", "t/delta_10000001_10000001_0000/000001_0"}, {"{\"writeid\":10000001,\"bucketid\":537001984,\"rowid\":0}\t4\t4", "t/delta_10000001_10000001_0000/000002_0"}, {"{\"writeid\":10000001,\"bucketid\":537001984,\"rowid\":1}\t5\t5", "t/delta_10000001_10000001_0000/000002_0"}};
        this.checkResult(expected, testQuery, isVectorized, "load data inpath");
        this.runStatementOnDriver("insert into Tstage values(5,6),(7,8)");
        this.runStatementOnDriver("insert into Tstage values(8,8)");
        this.runStatementOnDriver("export table Tstage to '" + this.getWarehouseDir() + "/2'");
        this.runStatementOnDriver("load data local inpath '" + this.getWarehouseDir() + "/2/data' overwrite into table T");
        String[][] expected2 = new String[][]{{"{\"writeid\":10000002,\"bucketid\":536870912,\"rowid\":0}\t5\t6", "t/base_10000002/000000_0"}, {"{\"writeid\":10000002,\"bucketid\":536870912,\"rowid\":1}\t7\t8", "t/base_10000002/000000_0"}, {"{\"writeid\":10000002,\"bucketid\":536936448,\"rowid\":0}\t8\t8", "t/base_10000002/000001_0"}};
        this.checkResult(expected2, testQuery, isVectorized, "load data inpath overwrite");
        this.runStatementOnDriver("insert into T values(9,9)");
        this.runStatementOnDriver("alter table T compact 'major'");
        TestTxnCommands2.runWorker(this.hiveConf);
        String[][] expected3 = new String[][]{{"{\"writeid\":10000002,\"bucketid\":536870912,\"rowid\":0}\t5\t6", "t/base_10000003/bucket_00000"}, {"{\"writeid\":10000002,\"bucketid\":536870912,\"rowid\":1}\t7\t8", "t/base_10000003/bucket_00000"}, {"{\"writeid\":10000002,\"bucketid\":536936448,\"rowid\":0}\t8\t8", "t/base_10000003/bucket_00001"}, {"{\"writeid\":10000003,\"bucketid\":536870912,\"rowid\":0}\t9\t9", "t/base_10000003/bucket_00000"}};
        this.checkResult(expected3, testQuery, isVectorized, "load data inpath overwrite (major)");
    }

    @Test
    public void loadDataPartitioned() throws Exception {
        this.runStatementOnDriver("drop table if exists T");
        this.runStatementOnDriver("drop table if exists Tstage");
        this.runStatementOnDriver("create table T (a int, b int) partitioned by (p int) stored as orc tblproperties('transactional'='true')");
        this.runStatementOnDriver("create table Tstage (a int, b int) stored as orc tblproperties('transactional'='false')");
        this.runStatementOnDriver("insert into Tstage values(0,2),(0,4)");
        this.runStatementOnDriver("export table Tstage to '" + this.getWarehouseDir() + "/1'");
        this.runStatementOnDriver("truncate table Tstage");
        this.runStatementOnDriver("load data local inpath '" + this.getWarehouseDir() + "/1/data' into table T partition(p=0)");
        this.runStatementOnDriver("insert into Tstage values(1,2),(1,4)");
        this.runStatementOnDriver("export table Tstage to '" + this.getWarehouseDir() + "/2'");
        this.runStatementOnDriver("truncate table Tstage");
        this.runStatementOnDriver("load data local inpath '" + this.getWarehouseDir() + "/2/data' into table T partition(p=1)");
        this.runStatementOnDriver("insert into Tstage values(2,2),(2,4)");
        this.runStatementOnDriver("export table Tstage to '" + this.getWarehouseDir() + "/3'");
        this.runStatementOnDriver("truncate table Tstage");
        this.runStatementOnDriver("load data local inpath '" + this.getWarehouseDir() + "/3/data' into table T partition(p=1)");
        List<String> rs = this.runStatementOnDriver("select ROW__ID, p, a, b, INPUT__FILE__NAME from T order by p, ROW__ID");
        String[][] expected = new String[][]{{"{\"writeid\":1,\"bucketid\":536870912,\"rowid\":0}\t0\t0\t2", "t/p=0/delta_0000001_0000001_0000/000000_0"}, {"{\"writeid\":1,\"bucketid\":536870912,\"rowid\":1}\t0\t0\t4", "t/p=0/delta_0000001_0000001_0000/000000_0"}, {"{\"writeid\":2,\"bucketid\":536870912,\"rowid\":0}\t1\t1\t2", "t/p=1/delta_0000002_0000002_0000/000000_0"}, {"{\"writeid\":2,\"bucketid\":536870912,\"rowid\":1}\t1\t1\t4", "t/p=1/delta_0000002_0000002_0000/000000_0"}, {"{\"writeid\":3,\"bucketid\":536870912,\"rowid\":0}\t1\t2\t2", "t/p=1/delta_0000003_0000003_0000/000000_0"}, {"{\"writeid\":3,\"bucketid\":536870912,\"rowid\":1}\t1\t2\t4", "t/p=1/delta_0000003_0000003_0000/000000_0"}};
        this.checkExpected(rs, expected, "load data inpath partitioned");
        this.runStatementOnDriver("insert into Tstage values(5,2),(5,4)");
        this.runStatementOnDriver("export table Tstage to '" + this.getWarehouseDir() + "/4'");
        this.runStatementOnDriver("truncate table Tstage");
        this.runStatementOnDriver("load data inpath '" + this.getWarehouseDir() + "/4/data' overwrite into table T partition(p=1)");
        String[][] expected2 = new String[][]{{"{\"writeid\":1,\"bucketid\":536870912,\"rowid\":0}\t0\t0\t2", "t/p=0/delta_0000001_0000001_0000/000000_0"}, {"{\"writeid\":1,\"bucketid\":536870912,\"rowid\":1}\t0\t0\t4", "t/p=0/delta_0000001_0000001_0000/000000_0"}, {"{\"writeid\":4,\"bucketid\":536870912,\"rowid\":0}\t1\t5\t2", "t/p=1/base_0000004/000000_0"}, {"{\"writeid\":4,\"bucketid\":536870912,\"rowid\":1}\t1\t5\t4", "t/p=1/base_0000004/000000_0"}};
        rs = this.runStatementOnDriver("select ROW__ID, p, a, b, INPUT__FILE__NAME from T order by p, ROW__ID");
        this.checkExpected(rs, expected2, "load data inpath partitioned overwrite");
    }

    @Test
    public void testValidations() throws Exception {
        this.runStatementOnDriver("drop table if exists T");
        this.runStatementOnDriver("drop table if exists Tstage");
        this.runStatementOnDriver("create table T (a int, b int) clustered by (a) into 2 buckets stored as orc tblproperties('transactional'='true')");
        File createdFile = this.folder.newFile("myfile.txt");
        FileUtils.writeStringToFile((File)createdFile, (String)"hello world");
        this.runStatementOnDriver("create table Tstage (a int, b int) stored as orc tblproperties('transactional'='false')");
        this.runStatementOnDriver("insert into Tstage values(1,2),(3,4)");
        this.runStatementOnDriver("load data local inpath '" + this.getWarehouseDir() + "/Tstage' into table T");
    }

    private void checkExpected(List<String> rs, String[][] expected, String msg) {
        super.checkExpected(rs, expected, msg, LOG, true);
    }

    @Test
    public void testMMOrcTable() throws Exception {
        this.runStatementOnDriver("drop table if exists T");
        this.runStatementOnDriver("create table T (a int, b int) stored as orc tblproperties('transactional'='true', 'transactional_properties'='insert_only')");
        int[][] values = new int[][]{{1, 2}, {3, 4}};
        this.runStatementOnDriver("insert into T " + this.makeValuesClause(values));
        List<String> rs = this.runStatementOnDriver("select a, b from T order by b");
        Assert.assertEquals((String)"", this.stringifyValues(values), rs);
    }

    private void testMultiStatement(boolean isVectorized) throws Exception {
        this.runStatementOnDriver("drop table if exists T");
        this.runStatementOnDriver("drop table if exists Tstage");
        this.runStatementOnDriver("create table T (a int, b int) stored as orc tblproperties('transactional'='true')");
        this.runStatementOnDriver("create table Tstage (a int, b int) stored as orc tblproperties('transactional'='false')");
        this.runStatementOnDriver("insert into Tstage values(5,5),(6,6)");
        this.runStatementOnDriver("export table Tstage to '" + this.getWarehouseDir() + "/1'");
        this.runStatementOnDriver("START TRANSACTION");
        this.runStatementOnDriver("insert into T values(1,2),(3,4)");
        this.runStatementOnDriver("load data local inpath '" + this.getWarehouseDir() + "/1/data' into table T");
        this.runStatementOnDriver("COMMIT");
        String testQuery = isVectorized ? "select ROW__ID, a, b from T order by ROW__ID" : "select ROW__ID, a, b, INPUT__FILE__NAME from T order by ROW__ID";
        String[][] expected = new String[][]{{"{\"writeid\":1,\"bucketid\":536870912,\"rowid\":0}\t1\t2", "t/delta_0000001_0000001_0000/bucket_00000"}, {"{\"writeid\":1,\"bucketid\":536870912,\"rowid\":1}\t3\t4", "t/delta_0000001_0000001_0000/bucket_00000"}, {"{\"writeid\":1,\"bucketid\":536870913,\"rowid\":0}\t5\t5", "t/delta_0000001_0000001_0001/000000_0"}, {"{\"writeid\":1,\"bucketid\":536870913,\"rowid\":1}\t6\t6", "t/delta_0000001_0000001_0001/000000_0"}};
        this.checkResult(expected, testQuery, isVectorized, "load data inpath");
        this.runStatementOnDriver("alter table T compact 'major'");
        TestTxnCommands2.runWorker(this.hiveConf);
        String[][] expected2 = new String[][]{{"{\"writeid\":1,\"bucketid\":536870912,\"rowid\":0}\t1\t2", "t/base_0000001/bucket_00000"}, {"{\"writeid\":1,\"bucketid\":536870912,\"rowid\":1}\t3\t4", "t/base_0000001/bucket_00000"}, {"{\"writeid\":1,\"bucketid\":536870913,\"rowid\":0}\t5\t5", "t/base_0000001/bucket_00000"}, {"{\"writeid\":1,\"bucketid\":536870913,\"rowid\":1}\t6\t6", "t/base_0000001/bucket_00000"}};
        this.checkResult(expected2, testQuery, isVectorized, "load data inpath (major)");
    }

    @Test
    public void testAbort() throws Exception {
        boolean isVectorized = false;
        this.runStatementOnDriver("drop table if exists T");
        this.runStatementOnDriver("drop table if exists Tstage");
        this.runStatementOnDriver("create table T (a int, b int) stored as orc tblproperties('transactional'='true')");
        this.runStatementOnDriver("create table Tstage (a int, b int) stored as orc tblproperties('transactional'='false')");
        this.runStatementOnDriver("insert into Tstage values(5,5),(6,6)");
        this.runStatementOnDriver("export table Tstage to '" + this.getWarehouseDir() + "/1'");
        this.runStatementOnDriver("insert into T values(1,2),(3,4)");
        this.runStatementOnDriver("START TRANSACTION");
        this.runStatementOnDriver("load data local inpath '" + this.getWarehouseDir() + "/1/data' into table T");
        this.runStatementOnDriver("ROLLBACK");
        String testQuery = isVectorized ? "select ROW__ID, a, b from T order by ROW__ID" : "select ROW__ID, a, b, INPUT__FILE__NAME from T order by ROW__ID";
        String[][] expected = new String[][]{{"{\"writeid\":1,\"bucketid\":536870912,\"rowid\":0}\t1\t2", "t/delta_0000001_0000001_0000/bucket_00000"}, {"{\"writeid\":1,\"bucketid\":536870912,\"rowid\":1}\t3\t4", "t/delta_0000001_0000001_0000/bucket_00000"}};
        this.checkResult(expected, testQuery, isVectorized, "load data inpath");
    }

    void checkResult(String[][] expectedResult, String query, boolean isVectorized, String msg) throws Exception {
        this.checkResult(expectedResult, query, isVectorized, msg, LOG);
    }

    @Test
    public void testLoadAcidFile() throws Exception {
        MetastoreConf.setBoolVar((Configuration)this.hiveConf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CREATE_TABLES_AS_ACID, (boolean)true);
        this.runStatementOnDriver("drop table if exists T");
        this.runStatementOnDriver("drop table if exists T2");
        this.runStatementOnDriver("create table T (a int, b int) stored as orc");
        this.runStatementOnDriver("create table T2(a int, b int) stored as orc");
        this.runStatementOnDriver("insert into T values(1,2)");
        List<String> rs = this.runStatementOnDriver("select INPUT__FILE__NAME from T");
        Assert.assertEquals((long)1L, (long)rs.size());
        Assert.assertTrue((String)"Unexpcted file name", (boolean)rs.get(0).endsWith("t/delta_0000001_0000001_0000/bucket_00000"));
        CommandProcessorResponse cpr = this.runStatementOnDriverNegative("load data local inpath '" + rs.get(0) + "' into table T2");
        Assert.assertEquals((String)"Unexpected error code", (long)ErrorMsg.LOAD_DATA_ACID_FILE.getErrorCode(), (long)cpr.getErrorCode());
    }
}

