/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.ptf;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorDeserializeRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorSerializeRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedBatchUtil;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.ptf.VectorPTFEvaluatorBase;
import org.apache.hadoop.hive.ql.exec.vector.ptf.VectorPTFOperator;
import org.apache.hadoop.hive.ql.exec.vector.rowbytescontainer.VectorRowBytesContainer;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveUtils;
import org.apache.hadoop.hive.serde2.ByteStream;
import org.apache.hadoop.hive.serde2.lazybinary.fast.LazyBinaryDeserializeRead;
import org.apache.hadoop.hive.serde2.lazybinary.fast.LazyBinarySerializeWrite;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;

public class VectorPTFGroupBatches {
    private static final long serialVersionUID = 1L;
    private static final String CLASS_NAME = VectorPTFGroupBatches.class.getName();
    private static final Log LOG = LogFactory.getLog((String)CLASS_NAME);
    private Configuration hconf;
    private VectorPTFEvaluatorBase[] evaluators;
    private int[] outputProjectionColumnMap;
    private int[] keyInputColumnMap;
    private int bufferedColumnCount;
    private int[] bufferedColumnMap;
    private TypeInfo[] bufferedTypeInfos;
    private ArrayList<VectorizedRowBatch> bufferedBatches;
    private VectorizedRowBatch overflowBatch;
    private int allocatedBufferedBatchCount;
    private int currentBufferedBatchCount;
    private int spillLimitBufferedBatchCount;
    private boolean didSpillToDisk;
    private String spillLocalDirs;
    private long spillRowCount;
    private VectorRowBytesContainer spillRowBytesContainer;
    private transient VectorSerializeRow bufferedBatchVectorSerializeRow;
    private transient VectorDeserializeRow bufferedBatchVectorDeserializeRow;

    public VectorPTFGroupBatches(Configuration hconf, int vectorizedPTFMaxMemoryBufferingBatchCount) {
        this.hconf = hconf;
        this.allocatedBufferedBatchCount = 0;
        this.currentBufferedBatchCount = 0;
        this.spillLocalDirs = HiveUtils.getLocalDirList(hconf);
        this.spillLimitBufferedBatchCount = Math.max(1, vectorizedPTFMaxMemoryBufferingBatchCount);
        this.didSpillToDisk = false;
        this.spillLocalDirs = null;
        this.spillRowBytesContainer = null;
        this.bufferedBatchVectorSerializeRow = null;
        this.bufferedBatchVectorDeserializeRow = null;
    }

    public void init(TypeInfo[] reducerBatchTypeInfos, VectorPTFEvaluatorBase[] evaluators, int[] outputProjectionColumnMap, TypeInfo[] outputTypeInfos, int[] keyInputColumnMap, int[] nonKeyInputColumnMap, int[] streamingEvaluatorNums, VectorizedRowBatch overflowBatch) {
        int i;
        this.evaluators = evaluators;
        this.outputProjectionColumnMap = outputProjectionColumnMap;
        this.keyInputColumnMap = keyInputColumnMap;
        int nonKeyInputColumnCount = nonKeyInputColumnMap.length;
        int streamingEvaluatorCount = streamingEvaluatorNums.length;
        this.bufferedColumnCount = nonKeyInputColumnCount + streamingEvaluatorCount;
        this.bufferedColumnMap = new int[this.bufferedColumnCount];
        this.bufferedTypeInfos = new TypeInfo[this.bufferedColumnCount];
        for (i = 0; i < nonKeyInputColumnCount; ++i) {
            int columnNum;
            this.bufferedColumnMap[i] = columnNum = nonKeyInputColumnMap[i];
            this.bufferedTypeInfos[i] = reducerBatchTypeInfos[columnNum];
        }
        for (i = 0; i < streamingEvaluatorCount; ++i) {
            int streamingEvaluatorNum = streamingEvaluatorNums[i];
            int bufferedMapIndex = nonKeyInputColumnCount + i;
            this.bufferedColumnMap[bufferedMapIndex] = outputProjectionColumnMap[streamingEvaluatorNum];
            this.bufferedTypeInfos[bufferedMapIndex] = outputTypeInfos[streamingEvaluatorNum];
        }
        this.overflowBatch = overflowBatch;
        this.bufferedBatches = new ArrayList(0);
    }

    private VectorRowBytesContainer getSpillRowBytesContainer() throws HiveException {
        if (this.spillRowBytesContainer == null) {
            this.spillRowBytesContainer = new VectorRowBytesContainer(this.spillLocalDirs);
            if (this.bufferedBatchVectorSerializeRow == null) {
                this.bufferedBatchVectorSerializeRow = new VectorSerializeRow<LazyBinarySerializeWrite>(new LazyBinarySerializeWrite(this.bufferedColumnMap.length));
                this.bufferedBatchVectorSerializeRow.init(this.bufferedTypeInfos);
                this.bufferedBatchVectorDeserializeRow = new VectorDeserializeRow<LazyBinaryDeserializeRead>(new LazyBinaryDeserializeRead(this.bufferedTypeInfos, true));
                this.bufferedBatchVectorDeserializeRow.init(this.bufferedColumnMap);
            }
        }
        return this.spillRowBytesContainer;
    }

    private void releaseSpillRowBytesContainer() {
        this.spillRowBytesContainer.clear();
        this.spillRowBytesContainer = null;
    }

    public void evaluateStreamingGroupBatch(VectorizedRowBatch batch, boolean isLastGroupBatch) throws HiveException {
        for (VectorPTFEvaluatorBase evaluator : this.evaluators) {
            evaluator.evaluateGroupBatch(batch, isLastGroupBatch);
        }
    }

    public void evaluateGroupBatch(VectorizedRowBatch batch, boolean isLastGroupBatch) throws HiveException {
        for (VectorPTFEvaluatorBase evaluator : this.evaluators) {
            evaluator.evaluateGroupBatch(batch, isLastGroupBatch);
        }
    }

    private void fillGroupResults(VectorizedRowBatch batch) {
        block5: for (VectorPTFEvaluatorBase evaluator : this.evaluators) {
            boolean isGroupResultNull;
            int outputColumnNum = evaluator.getOutputColumnNum();
            if (evaluator.streamsResult()) continue;
            ColumnVector outputColVector = batch.cols[outputColumnNum];
            outputColVector.isRepeating = true;
            outputColVector.isNull[0] = isGroupResultNull = evaluator.isGroupResultNull();
            if (isGroupResultNull) {
                outputColVector.noNulls = false;
                continue;
            }
            switch (evaluator.getResultColumnVectorType()) {
                case LONG: {
                    ((LongColumnVector)outputColVector).vector[0] = evaluator.getLongGroupResult();
                    continue block5;
                }
                case DOUBLE: {
                    ((DoubleColumnVector)outputColVector).vector[0] = evaluator.getDoubleGroupResult();
                    continue block5;
                }
                case DECIMAL: {
                    ((DecimalColumnVector)outputColVector).set(0, evaluator.getDecimalGroupResult());
                    continue block5;
                }
                default: {
                    throw new RuntimeException("Unexpected column vector type " + evaluator.getResultColumnVectorType());
                }
            }
        }
    }

    private void forwardBufferedBatches(VectorPTFOperator vecPTFOperator, int index) throws HiveException {
        VectorizedRowBatch bufferedBatch = this.bufferedBatches.get(index);
        int size = bufferedBatch.size;
        int bufferedColumnCount = this.bufferedColumnMap.length;
        for (int i = 0; i < bufferedColumnCount; ++i) {
            VectorizedBatchUtil.copyNonSelectedColumnVector(bufferedBatch, i, this.overflowBatch, this.bufferedColumnMap[i], size);
        }
        this.overflowBatch.size = size;
        this.fillGroupResults(this.overflowBatch);
        vecPTFOperator.forward((Object)this.overflowBatch, null);
    }

    private void forwardSpilledBatches(VectorPTFOperator vecPTFOperator, VectorizedRowBatch lastBatch) throws HiveException {
        this.overflowBatch.reset();
        this.copyPartitionAndOrderColumnsToOverflow(lastBatch);
        long spillRowsRead = 0L;
        try {
            VectorRowBytesContainer rowBytesContainer = this.getSpillRowBytesContainer();
            rowBytesContainer.prepareForReading();
            while (rowBytesContainer.readNext()) {
                byte[] bytes = rowBytesContainer.currentBytes();
                int offset = rowBytesContainer.currentOffset();
                int length = rowBytesContainer.currentLength();
                this.bufferedBatchVectorDeserializeRow.setBytes(bytes, offset, length);
                try {
                    this.bufferedBatchVectorDeserializeRow.deserialize(this.overflowBatch, this.overflowBatch.size);
                }
                catch (Exception e) {
                    throw new HiveException("\nDeserializeRead detail: " + this.bufferedBatchVectorDeserializeRow.getDetailedReadPositionString(), e);
                }
                ++this.overflowBatch.size;
                ++spillRowsRead;
                if (this.overflowBatch.size != 1024) continue;
                this.fillGroupResults(this.overflowBatch);
                vecPTFOperator.forward((Object)this.overflowBatch, null);
                this.overflowBatch.reset();
                this.copyPartitionAndOrderColumnsToOverflow(lastBatch);
            }
            if (this.overflowBatch.size > 0) {
                this.fillGroupResults(this.overflowBatch);
                vecPTFOperator.forward((Object)this.overflowBatch, null);
                this.overflowBatch.reset();
                this.copyPartitionAndOrderColumnsToOverflow(lastBatch);
            }
            Preconditions.checkState((spillRowsRead == this.spillRowCount ? 1 : 0) != 0);
            this.releaseSpillRowBytesContainer();
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    private void copyPartitionAndOrderColumnsToOverflow(VectorizedRowBatch lastBatch) {
        for (int keyColumnNum : this.keyInputColumnMap) {
            Preconditions.checkState((this.overflowBatch.cols[keyColumnNum] != null ? 1 : 0) != 0);
            VectorizedBatchUtil.copyRepeatingColumn(lastBatch, keyColumnNum, this.overflowBatch, keyColumnNum, false);
        }
    }

    public void fillGroupResultsAndForward(VectorPTFOperator vecPTFOperator, VectorizedRowBatch lastBatch) throws HiveException {
        if (this.didSpillToDisk) {
            this.forwardSpilledBatches(vecPTFOperator, lastBatch);
            this.didSpillToDisk = false;
        }
        if (this.currentBufferedBatchCount > 0) {
            this.overflowBatch.reset();
            this.copyPartitionAndOrderColumnsToOverflow(lastBatch);
            for (int i = 0; i < this.currentBufferedBatchCount; ++i) {
                this.forwardBufferedBatches(vecPTFOperator, i);
            }
            this.currentBufferedBatchCount = 0;
        }
        this.fillGroupResults(lastBatch);
        int[] originalProjections = lastBatch.projectedColumns;
        int originalProjectionSize = lastBatch.projectionSize;
        lastBatch.projectionSize = this.outputProjectionColumnMap.length;
        lastBatch.projectedColumns = this.outputProjectionColumnMap;
        vecPTFOperator.forward((Object)lastBatch, null);
        lastBatch.projectionSize = originalProjectionSize;
        lastBatch.projectedColumns = originalProjections;
    }

    public void resetEvaluators() {
        for (VectorPTFEvaluatorBase evaluator : this.evaluators) {
            evaluator.resetEvaluator();
        }
    }

    private VectorizedRowBatch newBufferedBatch(VectorizedRowBatch batch) throws HiveException {
        int bufferedColumnCount = this.bufferedColumnMap.length;
        VectorizedRowBatch newBatch = new VectorizedRowBatch(bufferedColumnCount);
        for (int i = 0; i < bufferedColumnCount; ++i) {
            newBatch.cols[i] = VectorizedBatchUtil.makeLikeColumnVector(batch.cols[this.bufferedColumnMap[i]]);
            newBatch.cols[i].init();
        }
        return newBatch;
    }

    public void bufferGroupBatch(VectorizedRowBatch batch) throws HiveException {
        try {
            if (this.currentBufferedBatchCount >= this.spillLimitBufferedBatchCount) {
                VectorRowBytesContainer rowBytesContainer = this.getSpillRowBytesContainer();
                if (!this.didSpillToDisk) {
                    this.didSpillToDisk = true;
                    this.spillRowCount = 0L;
                }
                VectorizedRowBatch oldestBufferedBatch = this.bufferedBatches.remove(0);
                boolean selectedInUse = oldestBufferedBatch.selectedInUse;
                int[] selected = oldestBufferedBatch.selected;
                int size = oldestBufferedBatch.size;
                for (int logicalIndex = 0; logicalIndex < size; ++logicalIndex) {
                    int batchIndex = selectedInUse ? selected[logicalIndex] : logicalIndex;
                    ByteStream.Output output = rowBytesContainer.getOuputForRowBytes();
                    this.bufferedBatchVectorSerializeRow.setOutputAppend(output);
                    this.bufferedBatchVectorSerializeRow.serializeWrite(oldestBufferedBatch, batchIndex);
                    rowBytesContainer.finishRow();
                    ++this.spillRowCount;
                }
                oldestBufferedBatch.reset();
                this.bufferedBatches.add(oldestBufferedBatch);
                --this.currentBufferedBatchCount;
            }
            int bufferedColumnCount = this.bufferedColumnMap.length;
            if (this.allocatedBufferedBatchCount <= this.currentBufferedBatchCount) {
                VectorizedRowBatch newBatch = this.newBufferedBatch(batch);
                this.bufferedBatches.add(newBatch);
                ++this.allocatedBufferedBatchCount;
            }
            VectorizedRowBatch bufferedBatch = this.bufferedBatches.get(this.currentBufferedBatchCount++);
            int size = batch.size;
            for (int i = 0; i < bufferedColumnCount; ++i) {
                VectorizedBatchUtil.copyNonSelectedColumnVector(batch, this.bufferedColumnMap[i], bufferedBatch, i, size);
            }
            bufferedBatch.size = size;
        }
        catch (IOException e) {
            throw new HiveException(e);
        }
    }
}

