/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.tez.AmPluginNode;
import org.apache.hadoop.hive.ql.exec.tez.SessionExpirationTracker;
import org.apache.hadoop.hive.ql.exec.tez.TezSessionPoolSession;
import org.apache.hadoop.hive.ql.exec.tez.WorkloadManager;
import org.apache.hadoop.hive.registry.impl.TezAmInstance;
import org.apache.hadoop.security.token.Token;
import org.apache.hive.common.util.Ref;
import org.apache.tez.common.security.JobTokenIdentifier;

@JsonSerialize
public class WmTezSession
extends TezSessionPoolSession
implements AmPluginNode {
    @JsonProperty(value="poolName")
    private String poolName;
    @JsonProperty(value="clusterFraction")
    private Double clusterFraction;
    @JsonProperty(value="killReason")
    private String killReason = null;
    private final Object amPluginInfoLock = new Object();
    @JsonProperty(value="amPluginInfo")
    private AmPluginNode.AmPluginInfo amPluginInfo = null;
    private Integer amPluginEndpointVersion = null;
    private SettableFuture<WmTezSession> amRegistryFuture = null;
    private ScheduledFuture<?> timeoutTimer = null;
    @JsonProperty(value="queryId")
    private String queryId;
    private SettableFuture<Boolean> returnFuture = null;
    private final WorkloadManager wmParent;
    private final ActualWmState actualState = new ActualWmState();

    public WmTezSession(String sessionId, WorkloadManager parent, SessionExpirationTracker expiration, HiveConf conf) {
        super(sessionId, parent, expiration, conf);
        this.wmParent = parent;
    }

    @VisibleForTesting
    WmTezSession(String sessionId, TezSessionPoolSession.Manager testParent, SessionExpirationTracker expiration, HiveConf conf) {
        super(sessionId, testParent, expiration, conf);
        this.wmParent = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<WmTezSession> waitForAmRegistryAsync(int timeoutMs, ScheduledExecutorService timeoutPool) {
        SettableFuture future = SettableFuture.create();
        Object object = this.amPluginInfoLock;
        synchronized (object) {
            if (this.amPluginInfo != null) {
                future.set((Object)this);
                return future;
            }
            if (this.amRegistryFuture != null) {
                future.setException((Throwable)new RuntimeException("Multiple waits are not suported"));
                return future;
            }
            this.amRegistryFuture = future;
            if (timeoutMs <= 0) {
                return future;
            }
            this.timeoutTimer = timeoutPool.schedule(new TimeoutRunnable(), (long)timeoutMs, TimeUnit.MILLISECONDS);
        }
        return future;
    }

    @Override
    void updateFromRegistry(TezAmInstance si, int ephSeqVersion) {
        this.updateAmEndpointInfo(si, ephSeqVersion);
        if (si != null) {
            this.handleGuaranteedTasksChange(si.getGuaranteedCount());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAmEndpointInfo(TezAmInstance si, int ephSeqVersion) {
        AmPluginNode.AmPluginInfo info = si == null ? null : new AmPluginNode.AmPluginInfo(si.getHost(), si.getPluginPort(), (Token<JobTokenIdentifier>)si.getPluginToken(), si.getPluginTokenJobId());
        Object object = this.amPluginInfoLock;
        synchronized (object) {
            if (this.amPluginEndpointVersion != null && (this.amPluginEndpointVersion > ephSeqVersion || this.amPluginEndpointVersion == ephSeqVersion && info != null)) {
                LOG.info("Ignoring an outdated info update {}: {}", (Object)ephSeqVersion, (Object)si);
                return;
            }
            this.amPluginEndpointVersion = ephSeqVersion;
            this.amPluginInfo = info;
            if (info != null) {
                if (this.amRegistryFuture != null) {
                    this.amRegistryFuture.set((Object)this);
                    this.amRegistryFuture = null;
                }
                if (this.timeoutTimer != null) {
                    this.timeoutTimer.cancel(true);
                    this.timeoutTimer = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleGuaranteedTasksChange(int guaranteedCount) {
        boolean doNotify = false;
        ActualWmState actualWmState = this.actualState;
        synchronized (actualWmState) {
            if (this.actualState.sending != -1 || this.actualState.sent == guaranteedCount) {
                return;
            }
            this.actualState.sent = guaranteedCount;
            doNotify = this.actualState.target != guaranteedCount;
        }
        if (!doNotify) {
            return;
        }
        this.wmParent.notifyOfInconsistentAllocation(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AmPluginNode.AmPluginInfo getAmPluginInfo(Ref<Integer> version) {
        Object object = this.amPluginInfoLock;
        synchronized (object) {
            version.value = this.amPluginEndpointVersion;
            return this.amPluginInfo;
        }
    }

    void setPoolName(String poolName) {
        this.poolName = poolName;
    }

    public String getPoolName() {
        return this.poolName;
    }

    void setClusterFraction(double fraction) {
        this.clusterFraction = fraction;
    }

    void clearWm() {
        this.poolName = null;
        this.clusterFraction = null;
    }

    public boolean hasClusterFraction() {
        return this.clusterFraction != null;
    }

    public double getClusterFraction() {
        return this.clusterFraction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Integer setSendingGuaranteed(Integer intAlloc) {
        assert (intAlloc == null || intAlloc >= 0);
        ActualWmState actualWmState = this.actualState;
        synchronized (actualWmState) {
            if (intAlloc != null) {
                this.actualState.target = intAlloc;
            } else {
                intAlloc = this.actualState.target;
            }
            if (this.actualState.sending != -1) {
                return null;
            }
            if (this.actualState.sent == intAlloc) {
                return null;
            }
            this.actualState.sending = intAlloc;
            return intAlloc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAllocationState() {
        ActualWmState actualWmState = this.actualState;
        synchronized (actualWmState) {
            return "actual/target " + this.actualState.sent + "/" + this.actualState.target + (this.actualState.sending >= 0 ? "; sending" : "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int setSentGuaranteed() {
        ActualWmState actualWmState = this.actualState;
        synchronized (actualWmState) {
            assert (this.actualState.sending != -1);
            this.actualState.sent = this.actualState.sending;
            this.actualState.sending = -1;
            return this.actualState.sent == this.actualState.target ? -1 : this.actualState.target;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean setFailedToSendGuaranteed() {
        ActualWmState actualWmState = this.actualState;
        synchronized (actualWmState) {
            assert (this.actualState.sending != -1);
            this.actualState.sending = -1;
            return this.actualState.sent == this.actualState.target;
        }
    }

    public void handleUpdateError(int endpointVersion) {
        this.wmParent.addUpdateError(this, endpointVersion);
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    public boolean equals(Object obj) {
        return obj == this;
    }

    boolean isIrrelevantForWm() {
        return this.killReason != null;
    }

    String getReasonForKill() {
        return this.killReason;
    }

    void setIsIrrelevantForWm(String killReason) {
        if (killReason == null) {
            throw new AssertionError((Object)("Cannot reset the kill reason " + this.killReason));
        }
        this.killReason = killReason;
    }

    public void setQueryId(String queryId) {
        this.queryId = queryId;
    }

    public String getQueryId() {
        return this.queryId;
    }

    void createAndSetReturnFuture() {
        this.returnFuture = SettableFuture.create();
        if (this.getWmContext() != null) {
            this.getWmContext().setReturnEventFuture((Future<Boolean>)this.returnFuture);
        }
    }

    void resolveReturnFuture() {
        if (this.returnFuture != null) {
            this.returnFuture.set((Object)true);
            this.returnFuture = null;
        }
    }

    @Override
    public String toString() {
        return super.toString() + ", WM state poolName=" + this.poolName + ", clusterFraction=" + this.clusterFraction + ", queryId=" + this.queryId + ", killReason=" + this.killReason;
    }

    private final class TimeoutRunnable
    implements Runnable {
        private TimeoutRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = WmTezSession.this.amPluginInfoLock;
            synchronized (object) {
                WmTezSession.this.timeoutTimer = null;
                if (WmTezSession.this.amRegistryFuture == null || WmTezSession.this.amRegistryFuture.isDone()) {
                    return;
                }
                WmTezSession.this.amRegistryFuture.cancel(true);
                WmTezSession.this.amRegistryFuture = null;
            }
        }
    }

    private static final class ActualWmState {
        int sending = -1;
        int sent = -1;
        int target = 0;

        private ActualWmState() {
        }
    }
}

