/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFLikeAll;
import org.apache.hadoop.hive.serde2.io.HiveVarcharWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableHiveVarcharObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableStringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableVoidObjectInspector;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Test;

public class TestGenericUDFLikeAll {
    GenericUDFLikeAll udf = null;

    @Test
    public void testTrue() throws HiveException {
        this.udf = new GenericUDFLikeAll();
        WritableStringObjectInspector valueOIOne = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        WritableStringObjectInspector valueOITwo = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        WritableHiveVarcharObjectInspector valueOIThree = PrimitiveObjectInspectorFactory.writableHiveVarcharObjectInspector;
        ObjectInspector[] arguments = new ObjectInspector[]{valueOIOne, valueOITwo, valueOIThree};
        this.udf.initialize(arguments);
        GenericUDF.DeferredJavaObject valueObjOne = new GenericUDF.DeferredJavaObject((Object)new Text("abc"));
        GenericUDF.DeferredJavaObject valueObjTwo = new GenericUDF.DeferredJavaObject((Object)new Text("%b%"));
        HiveVarchar vc = new HiveVarchar();
        vc.setValue("a%");
        GenericUDF.DeferredJavaObject[] args = new GenericUDF.DeferredJavaObject[]{valueObjOne, valueObjTwo, new GenericUDF.DeferredJavaObject((Object)new HiveVarcharWritable(vc))};
        BooleanWritable output = (BooleanWritable)this.udf.evaluate((GenericUDF.DeferredObject[])args);
        Assert.assertEquals((Object)true, (Object)output.get());
    }

    @Test(expected=UDFArgumentException.class)
    public void expectException() throws HiveException {
        this.udf = new GenericUDFLikeAll();
        WritableStringObjectInspector valueOIOne = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        ObjectInspector[] arguments = new ObjectInspector[]{valueOIOne};
        this.udf.initialize(arguments);
    }

    @Test
    public void testNull() throws HiveException {
        this.udf = new GenericUDFLikeAll();
        WritableStringObjectInspector valueOIOne = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        WritableStringObjectInspector valueOITwo = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        WritableVoidObjectInspector valueOIThree = PrimitiveObjectInspectorFactory.writableVoidObjectInspector;
        ObjectInspector[] arguments = new ObjectInspector[]{valueOIOne, valueOITwo, valueOIThree};
        this.udf.initialize(arguments);
        GenericUDF.DeferredJavaObject valueObjOne = new GenericUDF.DeferredJavaObject((Object)new Text("linkedin"));
        GenericUDF.DeferredJavaObject valueObjTwo = new GenericUDF.DeferredJavaObject((Object)new Text("%oo%"));
        GenericUDF.DeferredJavaObject valueObjThree = new GenericUDF.DeferredJavaObject((Object)NullWritable.get());
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{valueObjOne, valueObjTwo, valueObjThree};
        BooleanWritable output = (BooleanWritable)this.udf.evaluate(args);
        Assert.assertEquals(null, (Object)output);
    }
}

