/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.arrow;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.type.HiveChar;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.HiveIntervalDayTime;
import org.apache.hadoop.hive.common.type.HiveIntervalYearMonth;
import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.io.arrow.ArrowColumnarBatchSerDe;
import org.apache.hadoop.hive.ql.io.arrow.ArrowWrapperWritable;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeUtils;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DateWritableV2;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveCharWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.HiveIntervalDayTimeWritable;
import org.apache.hadoop.hive.serde2.io.HiveIntervalYearMonthWritable;
import org.apache.hadoop.hive.serde2.io.HiveVarcharWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritableV2;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestArrowColumnarBatchSerDe {
    private Configuration conf;
    private static final Object[][] INTEGER_ROWS = new Object[][]{{TestArrowColumnarBatchSerDe.byteW(0), TestArrowColumnarBatchSerDe.shortW(0), TestArrowColumnarBatchSerDe.intW(0), TestArrowColumnarBatchSerDe.longW(0L)}, {TestArrowColumnarBatchSerDe.byteW(1), TestArrowColumnarBatchSerDe.shortW(1), TestArrowColumnarBatchSerDe.intW(1), TestArrowColumnarBatchSerDe.longW(1L)}, {TestArrowColumnarBatchSerDe.byteW(-1), TestArrowColumnarBatchSerDe.shortW(-1), TestArrowColumnarBatchSerDe.intW(-1), TestArrowColumnarBatchSerDe.longW(-1L)}, {TestArrowColumnarBatchSerDe.byteW(-128), TestArrowColumnarBatchSerDe.shortW(Short.MIN_VALUE), TestArrowColumnarBatchSerDe.intW(Integer.MIN_VALUE), TestArrowColumnarBatchSerDe.longW(Long.MIN_VALUE)}, {TestArrowColumnarBatchSerDe.byteW(127), TestArrowColumnarBatchSerDe.shortW(Short.MAX_VALUE), TestArrowColumnarBatchSerDe.intW(Integer.MAX_VALUE), TestArrowColumnarBatchSerDe.longW(Long.MAX_VALUE)}, {null, null, null, null}};
    private static final Object[][] FLOAT_ROWS = new Object[][]{{TestArrowColumnarBatchSerDe.floatW(0.0f), TestArrowColumnarBatchSerDe.doubleW(0.0)}, {TestArrowColumnarBatchSerDe.floatW(1.0f), TestArrowColumnarBatchSerDe.doubleW(1.0)}, {TestArrowColumnarBatchSerDe.floatW(-1.0f), TestArrowColumnarBatchSerDe.doubleW(-1.0)}, {TestArrowColumnarBatchSerDe.floatW(Float.MIN_VALUE), TestArrowColumnarBatchSerDe.doubleW(Double.MIN_VALUE)}, {TestArrowColumnarBatchSerDe.floatW(-1.4E-45f), TestArrowColumnarBatchSerDe.doubleW(-4.9E-324)}, {TestArrowColumnarBatchSerDe.floatW(Float.MAX_VALUE), TestArrowColumnarBatchSerDe.doubleW(Double.MAX_VALUE)}, {TestArrowColumnarBatchSerDe.floatW(-3.4028235E38f), TestArrowColumnarBatchSerDe.doubleW(-1.7976931348623157E308)}, {TestArrowColumnarBatchSerDe.floatW(Float.POSITIVE_INFINITY), TestArrowColumnarBatchSerDe.doubleW(Double.POSITIVE_INFINITY)}, {TestArrowColumnarBatchSerDe.floatW(Float.NEGATIVE_INFINITY), TestArrowColumnarBatchSerDe.doubleW(Double.NEGATIVE_INFINITY)}, {null, null}};
    private static final Object[][] STRING_ROWS = new Object[][]{{TestArrowColumnarBatchSerDe.text(""), TestArrowColumnarBatchSerDe.charW("", 10), TestArrowColumnarBatchSerDe.varcharW("", 10)}, {TestArrowColumnarBatchSerDe.text("Hello"), TestArrowColumnarBatchSerDe.charW("Hello", 10), TestArrowColumnarBatchSerDe.varcharW("Hello", 10)}, {TestArrowColumnarBatchSerDe.text("world!"), TestArrowColumnarBatchSerDe.charW("world!", 10), TestArrowColumnarBatchSerDe.varcharW("world!", 10)}, {null, null, null}};
    private static final long TIME_IN_MILLIS = TimeUnit.DAYS.toMillis(399L);
    private static final long NEGATIVE_TIME_IN_MILLIS = TimeUnit.DAYS.toMillis(-3251L);
    private static final Timestamp TIMESTAMP = Timestamp.ofEpochMilli((long)TIME_IN_MILLIS);
    private static final Timestamp NEGATIVE_TIMESTAMP_WITHOUT_NANOS = Timestamp.ofEpochMilli((long)NEGATIVE_TIME_IN_MILLIS);
    private static final Object[][] DTI_ROWS = new Object[][]{{new DateWritableV2(DateWritableV2.millisToDays((long)TIME_IN_MILLIS)), new TimestampWritableV2(TIMESTAMP), new HiveIntervalYearMonthWritable(new HiveIntervalYearMonth(1, 2)), new HiveIntervalDayTimeWritable(new HiveIntervalDayTime(1, 2, 3, 4, 5000000))}, {new DateWritableV2(DateWritableV2.millisToDays((long)NEGATIVE_TIME_IN_MILLIS)), new TimestampWritableV2(NEGATIVE_TIMESTAMP_WITHOUT_NANOS), null, null}, {null, null, null, null}};
    private static final Object[][] DECIMAL_ROWS = new Object[][]{{TestArrowColumnarBatchSerDe.decimalW(HiveDecimal.ZERO)}, {TestArrowColumnarBatchSerDe.decimalW(HiveDecimal.ONE)}, {TestArrowColumnarBatchSerDe.decimalW(HiveDecimal.ONE.negate())}, {TestArrowColumnarBatchSerDe.decimalW(HiveDecimal.create((String)"0.000001"))}, {TestArrowColumnarBatchSerDe.decimalW(HiveDecimal.create((String)"100000"))}, {null}};
    private static final Object[][] BOOLEAN_ROWS = new Object[][]{{new BooleanWritable(true)}, {new BooleanWritable(false)}, {null}};
    private static final Object[][] BINARY_ROWS = new Object[][]{{new BytesWritable("".getBytes())}, {new BytesWritable("Hello".getBytes())}, {new BytesWritable("world!".getBytes())}, {null}};

    @Before
    public void setUp() {
        this.conf = new Configuration();
        this.conf.set("fs.defaultFS", "file:///");
    }

    private static ByteWritable byteW(int value) {
        return new ByteWritable((byte)value);
    }

    private static ShortWritable shortW(int value) {
        return new ShortWritable((short)value);
    }

    private static IntWritable intW(int value) {
        return new IntWritable(value);
    }

    private static LongWritable longW(long value) {
        return new LongWritable(value);
    }

    private static FloatWritable floatW(float value) {
        return new FloatWritable(value);
    }

    private static DoubleWritable doubleW(double value) {
        return new DoubleWritable(value);
    }

    private static Text text(String value) {
        return new Text(value);
    }

    private static HiveCharWritable charW(String value, int length) {
        return new HiveCharWritable(new HiveChar(value, length));
    }

    private static HiveVarcharWritable varcharW(String value, int length) {
        return new HiveVarcharWritable(new HiveVarchar(value, length));
    }

    private static HiveDecimalWritable decimalW(HiveDecimal value) {
        return new HiveDecimalWritable(value);
    }

    private void initAndSerializeAndDeserialize(String[][] schema, Object[][] rows) throws SerDeException {
        ArrowColumnarBatchSerDe serDe = new ArrowColumnarBatchSerDe();
        StructObjectInspector rowOI = this.initSerDe((AbstractSerDe)serDe, schema);
        this.serializeAndDeserialize(serDe, rows, rowOI);
    }

    private StructObjectInspector initSerDe(AbstractSerDe serDe, String[][] schema) throws SerDeException {
        List<String> fieldNameList = this.newArrayList(new String[0]);
        List<String> fieldTypeList = this.newArrayList(new String[0]);
        List<TypeInfo> typeInfoList = this.newArrayList(new TypeInfo[0]);
        for (String[] nameAndType : schema) {
            String name = nameAndType[0];
            String type = nameAndType[1];
            fieldNameList.add(name);
            fieldTypeList.add(type);
            typeInfoList.add(TypeInfoUtils.getTypeInfoFromTypeString((String)type));
        }
        String fieldNames = Joiner.on((char)',').join(fieldNameList);
        String fieldTypes = Joiner.on((char)',').join(fieldTypeList);
        Properties schemaProperties = new Properties();
        schemaProperties.setProperty("columns", fieldNames);
        schemaProperties.setProperty("columns.types", fieldTypes);
        SerDeUtils.initializeSerDe((Deserializer)serDe, (Configuration)this.conf, (Properties)schemaProperties, null);
        return (StructObjectInspector)TypeInfoUtils.getStandardWritableObjectInspectorFromTypeInfo((TypeInfo)TypeInfoFactory.getStructTypeInfo(fieldNameList, typeInfoList));
    }

    private void serializeAndDeserialize(ArrowColumnarBatchSerDe serDe, Object[][] rows, StructObjectInspector rowOI) {
        ArrowWrapperWritable serialized = null;
        for (Object[] row : rows) {
            serialized = serDe.serialize((Object)row, (ObjectInspector)rowOI);
        }
        if (serialized == null) {
            serialized = serDe.serialize(null, (ObjectInspector)rowOI);
        }
        Object[][] deserializedRows = (Object[][])serDe.deserialize(serialized);
        for (int rowIndex = 0; rowIndex < Math.min(deserializedRows.length, rows.length); ++rowIndex) {
            Object[] row = rows[rowIndex];
            Object[] deserializedRow = deserializedRows[rowIndex];
            Assert.assertEquals((long)row.length, (long)deserializedRow.length);
            List fields = rowOI.getAllStructFieldRefs();
            block11: for (int fieldIndex = 0; fieldIndex < fields.size(); ++fieldIndex) {
                StructField field = (StructField)fields.get(fieldIndex);
                ObjectInspector fieldObjInspector = field.getFieldObjectInspector();
                switch (fieldObjInspector.getCategory()) {
                    case PRIMITIVE: {
                        PrimitiveObjectInspector primitiveObjInspector = (PrimitiveObjectInspector)fieldObjInspector;
                        switch (primitiveObjInspector.getPrimitiveCategory()) {
                            case STRING: 
                            case VARCHAR: 
                            case CHAR: {
                                Assert.assertEquals((Object)Objects.toString(row[fieldIndex]), (Object)Objects.toString(deserializedRow[fieldIndex]));
                                continue block11;
                            }
                        }
                        Assert.assertEquals((Object)row[fieldIndex], (Object)deserializedRow[fieldIndex]);
                        continue block11;
                    }
                    case STRUCT: {
                        Object[] rowStruct = (Object[])row[fieldIndex];
                        List deserializedRowStruct = (List)deserializedRow[fieldIndex];
                        if (rowStruct == null) {
                            Assert.assertNull((Object)deserializedRowStruct);
                            continue block11;
                        }
                        Assert.assertArrayEquals((Object[])rowStruct, (Object[])deserializedRowStruct.toArray());
                        continue block11;
                    }
                    case LIST: 
                    case UNION: {
                        Assert.assertEquals((Object)row[fieldIndex], (Object)deserializedRow[fieldIndex]);
                        continue block11;
                    }
                    case MAP: {
                        Map rowMap = (Map)row[fieldIndex];
                        Map deserializedRowMap = (Map)deserializedRow[fieldIndex];
                        if (rowMap == null) {
                            Assert.assertNull((Object)deserializedRowMap);
                            continue block11;
                        }
                        Set rowMapKeySet = rowMap.keySet();
                        Set deserializedRowMapKeySet = deserializedRowMap.keySet();
                        Assert.assertEquals(rowMapKeySet, deserializedRowMapKeySet);
                        for (Object key : rowMapKeySet) {
                            Assert.assertEquals(rowMap.get(key), deserializedRowMap.get(key));
                        }
                        continue block11;
                    }
                }
            }
        }
    }

    @Test
    public void testComprehensive() throws SerDeException {
        String[][] schema = new String[][]{{"datatypes.c1", "int"}, {"datatypes.c2", "boolean"}, {"datatypes.c3", "double"}, {"datatypes.c4", "string"}, {"datatypes.c5", "array<int>"}, {"datatypes.c6", "map<int,string>"}, {"datatypes.c7", "map<string,string>"}, {"datatypes.c8", "struct<r:string,s:int,t:double>"}, {"datatypes.c9", "tinyint"}, {"datatypes.c10", "smallint"}, {"datatypes.c11", "float"}, {"datatypes.c12", "bigint"}, {"datatypes.c13", "array<array<string>>"}, {"datatypes.c14", "map<int,map<int,int>>"}, {"datatypes.c15", "struct<r:int,s:struct<a:int,b:string>>"}, {"datatypes.c16", "array<struct<m:map<string,string>,n:int>>"}, {"datatypes.c17", "timestamp"}, {"datatypes.c18", "decimal(16,7)"}, {"datatypes.c19", "binary"}, {"datatypes.c20", "date"}, {"datatypes.c21", "varchar(20)"}, {"datatypes.c22", "char(15)"}, {"datatypes.c23", "binary"}};
        Object[][] comprehensiveRows = new Object[][]{{TestArrowColumnarBatchSerDe.intW(0), new BooleanWritable(false), TestArrowColumnarBatchSerDe.doubleW(0.0), TestArrowColumnarBatchSerDe.text("Hello"), this.newArrayList(TestArrowColumnarBatchSerDe.intW(0), TestArrowColumnarBatchSerDe.intW(1), TestArrowColumnarBatchSerDe.intW(2)), Maps.toMap(this.newArrayList(TestArrowColumnarBatchSerDe.intW(0), TestArrowColumnarBatchSerDe.intW(1), TestArrowColumnarBatchSerDe.intW(2)), input -> TestArrowColumnarBatchSerDe.text("Number " + input)), Maps.toMap(this.newArrayList(TestArrowColumnarBatchSerDe.text("apple"), TestArrowColumnarBatchSerDe.text("banana"), TestArrowColumnarBatchSerDe.text("carrot")), input -> TestArrowColumnarBatchSerDe.text(input.toString().toUpperCase())), new Object[]{TestArrowColumnarBatchSerDe.text("0"), TestArrowColumnarBatchSerDe.intW(1), TestArrowColumnarBatchSerDe.doubleW(2.0)}, TestArrowColumnarBatchSerDe.byteW(0), TestArrowColumnarBatchSerDe.shortW(0), TestArrowColumnarBatchSerDe.floatW(0.0f), TestArrowColumnarBatchSerDe.longW(0L), this.newArrayList(this.newArrayList(TestArrowColumnarBatchSerDe.text("a"), TestArrowColumnarBatchSerDe.text("b"), TestArrowColumnarBatchSerDe.text("c")), this.newArrayList(TestArrowColumnarBatchSerDe.text("A"), TestArrowColumnarBatchSerDe.text("B"), TestArrowColumnarBatchSerDe.text("C"))), Maps.toMap(this.newArrayList(TestArrowColumnarBatchSerDe.intW(0), TestArrowColumnarBatchSerDe.intW(1), TestArrowColumnarBatchSerDe.intW(2)), x -> Maps.toMap(this.newArrayList(x, TestArrowColumnarBatchSerDe.intW(x.get() * 2)), y -> y)), new Object[]{TestArrowColumnarBatchSerDe.intW(0), this.newArrayList(TestArrowColumnarBatchSerDe.intW(1), TestArrowColumnarBatchSerDe.text("Hello"))}, Collections.singletonList(this.newArrayList(Maps.toMap(this.newArrayList(TestArrowColumnarBatchSerDe.text("hello")), input -> TestArrowColumnarBatchSerDe.text(input.toString().toUpperCase())), TestArrowColumnarBatchSerDe.intW(0))), new TimestampWritableV2(TIMESTAMP), TestArrowColumnarBatchSerDe.decimalW(HiveDecimal.create((long)0L, (int)0)), new BytesWritable("Hello".getBytes()), new DateWritableV2(123), TestArrowColumnarBatchSerDe.varcharW("x", 20), TestArrowColumnarBatchSerDe.charW("y", 15), new BytesWritable("world!".getBytes())}, {null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null}};
        this.initAndSerializeAndDeserialize(schema, comprehensiveRows);
    }

    private <E> List<E> newArrayList(E ... elements) {
        return Lists.newArrayList((Object[])elements);
    }

    @Test
    public void testPrimitiveInteger() throws SerDeException {
        String[][] schema = new String[][]{{"tinyint1", "tinyint"}, {"smallint1", "smallint"}, {"int1", "int"}, {"bigint1", "bigint"}};
        this.initAndSerializeAndDeserialize(schema, INTEGER_ROWS);
    }

    @Test
    public void testPrimitiveBigInt10000() throws SerDeException {
        String[][] schema = new String[][]{{"bigint1", "bigint"}};
        int batchSize = 1000;
        Object[][] integerRows = new Object[1000][];
        ArrowColumnarBatchSerDe serDe = new ArrowColumnarBatchSerDe();
        StructObjectInspector rowOI = this.initSerDe((AbstractSerDe)serDe, schema);
        for (int j = 0; j < 10; ++j) {
            for (int i = 0; i < 1000; ++i) {
                integerRows[i] = new Object[]{TestArrowColumnarBatchSerDe.longW(i + j * 1000)};
            }
            this.serializeAndDeserialize(serDe, integerRows, rowOI);
        }
    }

    @Test
    public void testPrimitiveBigIntRandom() {
        try {
            String[][] schema = new String[][]{{"bigint1", "bigint"}};
            ArrowColumnarBatchSerDe serDe = new ArrowColumnarBatchSerDe();
            StructObjectInspector rowOI = this.initSerDe((AbstractSerDe)serDe, schema);
            Random random = new Random();
            for (int j = 0; j < 1000; ++j) {
                int batchSize = random.nextInt(1000);
                Object[][] integerRows = new Object[batchSize][];
                for (int i = 0; i < batchSize; ++i) {
                    integerRows[i] = new Object[]{TestArrowColumnarBatchSerDe.longW(random.nextLong())};
                }
                this.serializeAndDeserialize(serDe, integerRows, rowOI);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void testPrimitiveFloat() throws SerDeException {
        String[][] schema = new String[][]{{"float1", "float"}, {"double1", "double"}};
        this.initAndSerializeAndDeserialize(schema, FLOAT_ROWS);
    }

    @Test(expected=AssertionError.class)
    public void testPrimitiveFloatNaN() throws SerDeException {
        String[][] schema = new String[][]{{"float1", "float"}};
        Object[][] rows = new Object[][]{{new FloatWritable(Float.NaN)}};
        this.initAndSerializeAndDeserialize(schema, rows);
    }

    @Test(expected=AssertionError.class)
    public void testPrimitiveDoubleNaN() throws SerDeException {
        String[][] schema = new String[][]{{"double1", "double"}};
        Object[][] rows = new Object[][]{{new DoubleWritable(Double.NaN)}};
        this.initAndSerializeAndDeserialize(schema, rows);
    }

    @Test
    public void testPrimitiveString() throws SerDeException {
        String[][] schema = new String[][]{{"string1", "string"}, {"char1", "char(10)"}, {"varchar1", "varchar(10)"}};
        this.initAndSerializeAndDeserialize(schema, STRING_ROWS);
    }

    @Test
    public void testPrimitiveDTI() throws SerDeException {
        String[][] schema = new String[][]{{"date1", "date"}, {"timestamp1", "timestamp"}, {"interval_year_month1", "interval_year_month"}, {"interval_day_time1", "interval_day_time"}};
        this.initAndSerializeAndDeserialize(schema, DTI_ROWS);
    }

    @Test
    public void testPrimitiveRandomTimestamp() throws SerDeException {
        String[][] schema = new String[][]{{"timestamp1", "timestamp"}};
        int size = HiveConf.getIntVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_ARROW_BATCH_SIZE);
        Random rand = new Random(294722773L);
        Object[][] rows = new Object[size][];
        for (int i = 0; i < size; ++i) {
            long millis = (long)rand.nextInt(Integer.MAX_VALUE) * 1000L;
            Timestamp timestamp = Timestamp.ofEpochMilli((long)(rand.nextBoolean() ? millis : -millis));
            timestamp.setNanos(rand.nextInt(1000) * 1000);
            rows[i] = new Object[]{new TimestampWritableV2(timestamp)};
        }
        this.initAndSerializeAndDeserialize(schema, rows);
    }

    @Test
    public void testPrimitiveDecimal() throws SerDeException {
        String[][] schema = new String[][]{{"decimal1", "decimal(38,10)"}};
        this.initAndSerializeAndDeserialize(schema, DECIMAL_ROWS);
    }

    @Test
    public void testPrimitiveBoolean() throws SerDeException {
        String[][] schema = new String[][]{{"boolean1", "boolean"}};
        this.initAndSerializeAndDeserialize(schema, BOOLEAN_ROWS);
    }

    @Test
    public void testPrimitiveBinary() throws SerDeException {
        String[][] schema = new String[][]{{"binary1", "binary"}};
        this.initAndSerializeAndDeserialize(schema, BINARY_ROWS);
    }

    private List[][] toList(Object[][] rows) {
        List[][] array = new List[rows.length][];
        for (int rowIndex = 0; rowIndex < rows.length; ++rowIndex) {
            Object[] row = rows[rowIndex];
            array[rowIndex] = new List[row.length];
            for (int fieldIndex = 0; fieldIndex < row.length; ++fieldIndex) {
                array[rowIndex][fieldIndex] = this.newArrayList(row[fieldIndex]);
            }
        }
        return array;
    }

    @Test
    public void testListInteger() throws SerDeException {
        String[][] schema = new String[][]{{"tinyint_list", "array<tinyint>"}, {"smallint_list", "array<smallint>"}, {"int_list", "array<int>"}, {"bigint_list", "array<bigint>"}};
        this.initAndSerializeAndDeserialize(schema, this.toList(INTEGER_ROWS));
    }

    @Test
    public void testListFloat() throws SerDeException {
        String[][] schema = new String[][]{{"float_list", "array<float>"}, {"double_list", "array<double>"}};
        this.initAndSerializeAndDeserialize(schema, this.toList(FLOAT_ROWS));
    }

    @Test
    public void testListString() throws SerDeException {
        String[][] schema = new String[][]{{"string_list", "array<string>"}, {"char_list", "array<char(10)>"}, {"varchar_list", "array<varchar(10)>"}};
        this.initAndSerializeAndDeserialize(schema, this.toList(STRING_ROWS));
    }

    @Test
    public void testListDTI() throws SerDeException {
        String[][] schema = new String[][]{{"date_list", "array<date>"}, {"timestamp_list", "array<timestamp>"}, {"interval_year_month_list", "array<interval_year_month>"}, {"interval_day_time_list", "array<interval_day_time>"}};
        this.initAndSerializeAndDeserialize(schema, this.toList(DTI_ROWS));
    }

    @Test
    public void testListBoolean() throws SerDeException {
        String[][] schema = new String[][]{{"boolean_list", "array<boolean>"}};
        this.initAndSerializeAndDeserialize(schema, this.toList(BOOLEAN_ROWS));
    }

    @Test
    public void testListBinary() throws SerDeException {
        String[][] schema = new String[][]{{"binary_list", "array<binary>"}};
        this.initAndSerializeAndDeserialize(schema, this.toList(BINARY_ROWS));
    }

    private Object[][][] toStruct(Object[][] rows) {
        Object[][][] struct = new Object[rows.length][][];
        for (int rowIndex = 0; rowIndex < rows.length; ++rowIndex) {
            Object[] row = rows[rowIndex];
            struct[rowIndex] = new Object[][]{row};
        }
        return struct;
    }

    @Test
    public void testStructInteger() throws SerDeException {
        String[][] schema = new String[][]{{"int_struct", "struct<tinyint1:tinyint,smallint1:smallint,int1:int,bigint1:bigint>"}};
        this.initAndSerializeAndDeserialize(schema, (Object[][])this.toStruct(INTEGER_ROWS));
    }

    @Test
    public void testStructFloat() throws SerDeException {
        String[][] schema = new String[][]{{"float_struct", "struct<float1:float,double1:double>"}};
        this.initAndSerializeAndDeserialize(schema, (Object[][])this.toStruct(FLOAT_ROWS));
    }

    @Test
    public void testStructString() throws SerDeException {
        String[][] schema = new String[][]{{"string_struct", "struct<string1:string,char1:char(10),varchar1:varchar(10)>"}};
        this.initAndSerializeAndDeserialize(schema, (Object[][])this.toStruct(STRING_ROWS));
    }

    @Test
    public void testStructDTI() throws SerDeException {
        String[][] schema = new String[][]{{"date_struct", "struct<date1:date,timestamp1:timestamp,interval_year_month1:interval_year_month,interval_day_time1:interval_day_time>"}};
        this.initAndSerializeAndDeserialize(schema, (Object[][])this.toStruct(DTI_ROWS));
    }

    @Test
    public void testStructDecimal() throws SerDeException {
        String[][] schema = new String[][]{{"decimal_struct", "struct<decimal1:decimal(38,10)>"}};
        this.initAndSerializeAndDeserialize(schema, (Object[][])this.toStruct(DECIMAL_ROWS));
    }

    @Test
    public void testStructBoolean() throws SerDeException {
        String[][] schema = new String[][]{{"boolean_struct", "struct<boolean1:boolean>"}};
        this.initAndSerializeAndDeserialize(schema, (Object[][])this.toStruct(BOOLEAN_ROWS));
    }

    @Test
    public void testStructBinary() throws SerDeException {
        String[][] schema = new String[][]{{"binary_struct", "struct<binary1:binary>"}};
        this.initAndSerializeAndDeserialize(schema, (Object[][])this.toStruct(BINARY_ROWS));
    }

    private Object[][] toMap(Object[][] rows) {
        Object[][] array = new Map[rows.length][];
        for (int rowIndex = 0; rowIndex < rows.length; ++rowIndex) {
            Object[] row = rows[rowIndex];
            array[rowIndex] = new Map[row.length];
            for (int fieldIndex = 0; fieldIndex < row.length; ++fieldIndex) {
                HashMap map = Maps.newHashMap();
                map.put(new Text(String.valueOf(row[fieldIndex])), row[fieldIndex]);
                array[rowIndex][fieldIndex] = map;
            }
        }
        return array;
    }

    @Test
    public void testMapInteger() throws SerDeException {
        String[][] schema = new String[][]{{"tinyint_map", "map<string,tinyint>"}, {"smallint_map", "map<string,smallint>"}, {"int_map", "map<string,int>"}, {"bigint_map", "map<string,bigint>"}};
        this.initAndSerializeAndDeserialize(schema, this.toMap(INTEGER_ROWS));
    }

    @Test
    public void testMapFloat() throws SerDeException {
        String[][] schema = new String[][]{{"float_map", "map<string,float>"}, {"double_map", "map<string,double>"}};
        this.initAndSerializeAndDeserialize(schema, this.toMap(FLOAT_ROWS));
    }

    @Test
    public void testMapString() throws SerDeException {
        String[][] schema = new String[][]{{"string_map", "map<string,string>"}, {"char_map", "map<string,char(10)>"}, {"varchar_map", "map<string,varchar(10)>"}};
        this.initAndSerializeAndDeserialize(schema, this.toMap(STRING_ROWS));
    }

    @Test
    public void testMapDTI() throws SerDeException {
        String[][] schema = new String[][]{{"date_map", "map<string,date>"}, {"timestamp_map", "map<string,timestamp>"}, {"interval_year_month_map", "map<string,interval_year_month>"}, {"interval_day_time_map", "map<string,interval_day_time>"}};
        this.initAndSerializeAndDeserialize(schema, this.toMap(DTI_ROWS));
    }

    @Test
    public void testMapBoolean() throws SerDeException {
        String[][] schema = new String[][]{{"boolean_map", "map<string,boolean>"}};
        this.initAndSerializeAndDeserialize(schema, this.toMap(BOOLEAN_ROWS));
    }

    @Test
    public void testMapBinary() throws SerDeException {
        String[][] schema = new String[][]{{"binary_map", "map<string,binary>"}};
        this.initAndSerializeAndDeserialize(schema, this.toMap(BINARY_ROWS));
    }

    public void testMapDecimal() throws SerDeException {
        String[][] schema = new String[][]{{"decimal_map", "map<string,decimal(38,10)>"}};
        this.initAndSerializeAndDeserialize(schema, this.toMap(DECIMAL_ROWS));
    }

    public void testListDecimal() throws SerDeException {
        String[][] schema = new String[][]{{"decimal_list", "array<decimal(38,10)>"}};
        this.initAndSerializeAndDeserialize(schema, this.toList(DECIMAL_ROWS));
    }
}

