/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import com.google.common.collect.SortedSetMultimap;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.linq4j.function.Function2;
import org.apache.calcite.plan.Context;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCostImpl;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.hep.HepPlanner;
import org.apache.calcite.plan.hep.HepProgram;
import org.apache.calcite.plan.hep.HepRelVertex;
import org.apache.calcite.rel.BiRel;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelShuttle;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Correlate;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.core.Values;
import org.apache.calcite.rel.logical.LogicalCorrelate;
import org.apache.calcite.rel.metadata.RelMdUtil;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexOver;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexSubQuery;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.sql.SemiJoinType;
import org.apache.calcite.sql.SqlBinaryOperator;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlCountAggFunction;
import org.apache.calcite.sql.fun.SqlSingleValueAggFunction;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.Bug;
import org.apache.calcite.util.Holder;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.calcite.util.Litmus;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.ReflectUtil;
import org.apache.calcite.util.ReflectiveVisitor;
import org.apache.calcite.util.Stacks;
import org.apache.calcite.util.Util;
import org.apache.calcite.util.mapping.Mappings;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelFactories;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelOptUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelShuttleImpl;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveAggregate;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveFilter;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveIntersect;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveJoin;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveProject;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveRelNode;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveSemiJoin;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveSortLimit;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveUnion;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveFilterJoinRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveFilterProjectTransposeRule;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HiveRelDecorrelator
implements ReflectiveVisitor {
    protected static final Logger LOG = LoggerFactory.getLogger(HiveRelDecorrelator.class);
    private final RelBuilder relBuilder;
    private CorelMap cm;
    private final ReflectUtil.MethodDispatcher<Frame> dispatcher = ReflectUtil.createMethodDispatcher(Frame.class, (ReflectiveVisitor)this, (String)"decorrelateRel", RelNode.class, (Class[])new Class[0]);
    private final RexBuilder rexBuilder;
    private RelNode currentRel;
    private final Context context;
    private final Map<RelNode, Frame> map = new HashMap<RelNode, Frame>();
    private final HashSet<LogicalCorrelate> generatedCorRels = Sets.newHashSet();
    private Stack valueGen = new Stack();

    private HiveRelDecorrelator(RelOptCluster cluster, CorelMap cm, Context context) {
        this.cm = cm;
        this.rexBuilder = cluster.getRexBuilder();
        this.context = context;
        this.relBuilder = HiveRelFactories.HIVE_BUILDER.create(cluster, null);
    }

    public static RelNode decorrelateQuery(RelNode rootRel) {
        CorelMap corelMap = new CorelMapBuilder().build(rootRel);
        if (!corelMap.hasCorrelation()) {
            return rootRel;
        }
        RelOptCluster cluster = rootRel.getCluster();
        HiveRelDecorrelator decorrelator = new HiveRelDecorrelator(cluster, corelMap, cluster.getPlanner().getContext());
        RelNode newRootRel = decorrelator.removeCorrelationViaRule(rootRel);
        if (!decorrelator.cm.mapCorToCorRel.isEmpty()) {
            newRootRel = decorrelator.decorrelate(newRootRel);
        }
        return newRootRel;
    }

    private void setCurrent(RelNode root, LogicalCorrelate corRel) {
        this.currentRel = corRel;
        if (corRel != null) {
            this.cm = new CorelMapBuilder().build((RelNode)Util.first((Object)root, (Object)corRel));
        }
    }

    private RelNode decorrelate(RelNode root) {
        HepProgram program = HepProgram.builder().addRuleInstance((RelOptRule)new AdjustProjectForCountAggregateRule(false)).addRuleInstance((RelOptRule)new AdjustProjectForCountAggregateRule(true)).addRuleInstance((RelOptRule)HiveFilterJoinRule.FILTER_ON_JOIN).addRuleInstance((RelOptRule)HiveFilterProjectTransposeRule.INSTANCE).build();
        HepPlanner planner = this.createPlanner(program);
        planner.setRoot(root);
        root = planner.findBestExp();
        this.map.clear();
        Frame frame = this.getInvoke(root, null);
        if (frame != null) {
            HepProgram program2 = HepProgram.builder().addRuleInstance((RelOptRule)HiveFilterJoinRule.FILTER_ON_JOIN).addRuleInstance((RelOptRule)HiveFilterJoinRule.JOIN).build();
            HepPlanner planner2 = this.createPlanner(program2);
            RelNode newRoot = frame.r;
            planner2.setRoot(newRoot);
            return planner2.findBestExp();
        }
        assert (this.valueGen.isEmpty());
        return root;
    }

    private Function2<RelNode, RelNode, Void> createCopyHook() {
        return new Function2<RelNode, RelNode, Void>(){

            public Void apply(RelNode oldNode, RelNode newNode) {
                if (HiveRelDecorrelator.this.cm.mapRefRelToCorRef.containsKey((Object)oldNode)) {
                    CorelMap corelMap = new CorelMapBuilder().build(newNode);
                    if (!corelMap.mapRefRelToCorRef.isEmpty()) {
                        HiveRelDecorrelator.this.cm.mapRefRelToCorRef.putAll((Object)newNode, (Iterable)corelMap.mapRefRelToCorRef.get((Object)newNode));
                    }
                }
                if (oldNode instanceof LogicalCorrelate && newNode instanceof LogicalCorrelate) {
                    LogicalCorrelate oldCor = (LogicalCorrelate)oldNode;
                    CorrelationId c = oldCor.getCorrelationId();
                    if (HiveRelDecorrelator.this.cm.mapCorToCorRel.get(c) == oldNode) {
                        HiveRelDecorrelator.this.cm.mapCorToCorRel.put(c, newNode);
                    }
                    if (HiveRelDecorrelator.this.generatedCorRels.contains(oldNode)) {
                        HiveRelDecorrelator.this.generatedCorRels.add((LogicalCorrelate)newNode);
                    }
                }
                return null;
            }
        };
    }

    private HepPlanner createPlanner(HepProgram program) {
        return new HepPlanner(program, this.context, true, this.createCopyHook(), RelOptCostImpl.FACTORY);
    }

    public RelNode removeCorrelationViaRule(RelNode root) {
        HepProgram program = HepProgram.builder().addRuleInstance((RelOptRule)new RemoveSingleAggregateRule()).addRuleInstance((RelOptRule)new RemoveCorrelationForScalarProjectRule()).addRuleInstance((RelOptRule)new RemoveCorrelationForScalarAggregateRule()).build();
        HepPlanner planner = this.createPlanner(program);
        planner.setRoot(root);
        return planner.findBestExp();
    }

    protected RexNode decorrelateExpr(RexNode exp, boolean valueGenerator) {
        DecorrelateRexShuttle shuttle = new DecorrelateRexShuttle();
        shuttle.setValueGenerator(valueGenerator);
        return (RexNode)exp.accept((RexVisitor)shuttle);
    }

    protected RexNode decorrelateExpr(RexNode exp) {
        DecorrelateRexShuttle shuttle = new DecorrelateRexShuttle();
        shuttle.setValueGenerator(true);
        return (RexNode)exp.accept((RexVisitor)shuttle);
    }

    protected RexNode removeCorrelationExpr(RexNode exp, boolean projectPulledAboveLeftCorrelator) {
        RemoveCorrelationRexShuttle shuttle = new RemoveCorrelationRexShuttle(this.rexBuilder, projectPulledAboveLeftCorrelator, null, (Set<Integer>)ImmutableSet.of());
        return (RexNode)exp.accept((RexVisitor)shuttle);
    }

    protected RexNode removeCorrelationExpr(RexNode exp, boolean projectPulledAboveLeftCorrelator, RexInputRef nullIndicator) {
        RemoveCorrelationRexShuttle shuttle = new RemoveCorrelationRexShuttle(this.rexBuilder, projectPulledAboveLeftCorrelator, nullIndicator, (Set<Integer>)ImmutableSet.of());
        return (RexNode)exp.accept((RexVisitor)shuttle);
    }

    protected RexNode removeCorrelationExpr(RexNode exp, boolean projectPulledAboveLeftCorrelator, Set<Integer> isCount) {
        RemoveCorrelationRexShuttle shuttle = new RemoveCorrelationRexShuttle(this.rexBuilder, projectPulledAboveLeftCorrelator, null, isCount);
        return (RexNode)exp.accept((RexVisitor)shuttle);
    }

    public Frame decorrelateRel(RelNode rel) {
        RelNode newRel = rel.copy(rel.getTraitSet(), rel.getInputs());
        if (rel.getInputs().size() > 0) {
            List oldInputs = rel.getInputs();
            ArrayList newInputs = Lists.newArrayList();
            for (int i = 0; i < oldInputs.size(); ++i) {
                Frame frame = this.getInvoke((RelNode)oldInputs.get(i), rel);
                if (frame == null || !frame.corDefOutputs.isEmpty()) {
                    return null;
                }
                newInputs.add(frame.r);
                newRel.replaceInput(i, frame.r);
            }
            if (!Util.equalShallow((List)oldInputs, (List)newInputs)) {
                newRel = rel.copy(rel.getTraitSet(), (List)newInputs);
            }
        }
        return this.register(rel, newRel, HiveRelDecorrelator.identityMap(rel.getRowType().getFieldCount()), (SortedMap<CorDef, Integer>)ImmutableSortedMap.of());
    }

    public Frame decorrelateRel(HiveSortLimit rel) {
        assert (!this.cm.mapRefRelToCorRef.containsKey((Object)rel));
        RelNode oldInput = rel.getInput();
        Frame frame = this.getInvoke(oldInput, rel);
        if (frame == null) {
            return null;
        }
        RelNode newInput = frame.r;
        Mappings.TargetMapping mapping = Mappings.target(frame.oldToNewOutputs, (int)oldInput.getRowType().getFieldCount(), (int)newInput.getRowType().getFieldCount());
        RelCollation oldCollation = rel.getCollation();
        RelCollation newCollation = RexUtil.apply((Mappings.TargetMapping)mapping, (RelCollation)oldCollation);
        HiveSortLimit newSort = HiveSortLimit.create(newInput, newCollation, rel.offset, rel.fetch);
        return this.register(rel, newSort, (Map<Integer, Integer>)frame.oldToNewOutputs, (SortedMap<CorDef, Integer>)frame.corDefOutputs);
    }

    public Frame decorrelateRel(Sort rel) {
        assert (!this.cm.mapRefRelToCorRef.containsKey((Object)rel));
        RelNode oldInput = rel.getInput();
        Frame frame = this.getInvoke(oldInput, (RelNode)rel);
        if (frame == null) {
            return null;
        }
        RelNode newInput = frame.r;
        Mappings.TargetMapping mapping = Mappings.target(frame.oldToNewOutputs, (int)oldInput.getRowType().getFieldCount(), (int)newInput.getRowType().getFieldCount());
        RelCollation oldCollation = rel.getCollation();
        RelCollation newCollation = RexUtil.apply((Mappings.TargetMapping)mapping, (RelCollation)oldCollation);
        HiveSortLimit newSort = HiveSortLimit.create(newInput, newCollation, rel.offset, rel.fetch);
        return this.register((RelNode)rel, newSort, (Map<Integer, Integer>)frame.oldToNewOutputs, (SortedMap<CorDef, Integer>)frame.corDefOutputs);
    }

    public Frame decorrelateRel(Values rel) {
        return null;
    }

    public Frame decorrelateRel(Aggregate rel) throws SemanticException {
        if (rel.getGroupType() != Aggregate.Group.SIMPLE) {
            throw new AssertionError(false);
        }
        assert (!this.cm.mapRefRelToCorRef.containsKey((Object)rel));
        RelNode oldInput = rel.getInput();
        Frame frame = this.getInvoke(oldInput, (RelNode)rel);
        if (frame == null) {
            return null;
        }
        RelNode newInput = frame.r;
        HashMap<Integer, Integer> mapNewInputToProjOutputs = new HashMap<Integer, Integer>();
        int oldGroupKeyCount = rel.getGroupSet().cardinality();
        ArrayList projects = Lists.newArrayList();
        List newInputOutput = newInput.getRowType().getFieldList();
        int newPos = 0;
        TreeMap<Integer, RexLiteral> omittedConstants = new TreeMap<Integer, RexLiteral>();
        for (int i = 0; i < oldGroupKeyCount; ++i) {
            RexLiteral constant = HiveRelDecorrelator.projectedLiteral(newInput, i);
            if (constant != null) {
                omittedConstants.put(i, constant);
                continue;
            }
            int newInputPos = (Integer)frame.oldToNewOutputs.get((Object)i);
            projects.add(RexInputRef.of2((int)newInputPos, (List)newInputOutput));
            mapNewInputToProjOutputs.put(newInputPos, newPos);
            ++newPos;
        }
        TreeMap<CorDef, Integer> corDefOutputs = new TreeMap<CorDef, Integer>();
        if (!frame.corDefOutputs.isEmpty()) {
            for (Map.Entry entry : frame.corDefOutputs.entrySet()) {
                projects.add(RexInputRef.of2((int)((Integer)entry.getValue()), (List)newInputOutput));
                corDefOutputs.put((CorDef)entry.getKey(), newPos);
                mapNewInputToProjOutputs.put((Integer)entry.getValue(), newPos);
                ++newPos;
            }
        }
        int newGroupKeyCount = newPos;
        for (int i = 0; i < newInputOutput.size(); ++i) {
            if (mapNewInputToProjOutputs.containsKey(i)) continue;
            projects.add(RexInputRef.of2((int)i, (List)newInputOutput));
            mapNewInputToProjOutputs.put(i, newPos);
            ++newPos;
        }
        assert (newPos == newInputOutput.size());
        HiveProject newProject = HiveProject.create(newInput, Pair.left((List)projects), Pair.right((List)projects));
        HashMap combinedMap = Maps.newHashMap();
        for (Integer oldInputPos : frame.oldToNewOutputs.keySet()) {
            combinedMap.put(oldInputPos, (Integer)mapNewInputToProjOutputs.get(frame.oldToNewOutputs.get((Object)oldInputPos)));
        }
        this.register(oldInput, newProject, combinedMap, corDefOutputs);
        ImmutableBitSet newGroupSet = ImmutableBitSet.range((int)newGroupKeyCount);
        ArrayList newAggCalls = Lists.newArrayList();
        List oldAggCalls = rel.getAggCallList();
        int oldInputOutputFieldCount = rel.getGroupSet().cardinality();
        int newInputOutputFieldCount = newGroupSet.cardinality();
        int i = -1;
        for (AggregateCall oldAggCall : oldAggCalls) {
            ++i;
            List oldAggArgs = oldAggCall.getArgList();
            ArrayList aggArgs = Lists.newArrayList();
            Iterator iterator = oldAggArgs.iterator();
            while (iterator.hasNext()) {
                int oldPos = (Integer)iterator.next();
                aggArgs.add((Integer)combinedMap.get(oldPos));
            }
            int filterArg = oldAggCall.filterArg < 0 ? oldAggCall.filterArg : (Integer)combinedMap.get(oldAggCall.filterArg);
            newAggCalls.add(oldAggCall.adaptTo((RelNode)newProject, (List)aggArgs, filterArg, oldGroupKeyCount, newGroupKeyCount));
            combinedMap.put(oldInputOutputFieldCount + i, newInputOutputFieldCount + i);
        }
        this.relBuilder.push((RelNode)newProject).aggregate(this.relBuilder.groupKey(newGroupSet, null), (List)newAggCalls);
        if (!omittedConstants.isEmpty()) {
            ArrayList<RexNode> postProjects = new ArrayList<RexNode>((Collection<RexNode>)this.relBuilder.fields());
            for (Map.Entry entry : omittedConstants.descendingMap().entrySet()) {
                postProjects.add((Integer)entry.getKey() + frame.corDefOutputs.size(), (RexNode)entry.getValue());
            }
            this.relBuilder.project(postProjects);
        }
        return this.register((RelNode)rel, this.relBuilder.build(), combinedMap, corDefOutputs);
    }

    public Frame getInvoke(RelNode r, RelNode parent) {
        Frame frame = (Frame)this.dispatcher.invoke(new Object[]{r});
        if (frame != null) {
            this.map.put(r, frame);
        }
        this.currentRel = parent;
        return frame;
    }

    private static RexLiteral projectedLiteral(RelNode rel, int i) {
        Project project;
        RexNode node;
        if (rel instanceof Project && (node = (RexNode)(project = (Project)rel).getProjects().get(i)) instanceof RexLiteral) {
            return (RexLiteral)node;
        }
        return null;
    }

    public Frame decorrelateRel(HiveAggregate rel) throws SemanticException {
        if (rel.getGroupType() != Aggregate.Group.SIMPLE) {
            throw new AssertionError(false);
        }
        assert (!this.cm.mapRefRelToCorRef.containsKey((Object)rel));
        RelNode oldInput = rel.getInput();
        Frame frame = this.getInvoke(oldInput, rel);
        if (frame == null) {
            return null;
        }
        RelNode newInput = frame.r;
        HashMap<Integer, Integer> mapNewInputToProjOutputs = new HashMap<Integer, Integer>();
        int oldGroupKeyCount = rel.getGroupSet().cardinality();
        ArrayList projects = Lists.newArrayList();
        List newInputOutput = newInput.getRowType().getFieldList();
        int newPos = 0;
        for (int i = 0; i < oldGroupKeyCount; ++i) {
            int newInputPos = (Integer)frame.oldToNewOutputs.get((Object)i);
            projects.add(RexInputRef.of2((int)newInputPos, (List)newInputOutput));
            mapNewInputToProjOutputs.put(newInputPos, newPos);
            ++newPos;
        }
        TreeMap<CorDef, Integer> corDefOutputs = new TreeMap<CorDef, Integer>();
        if (!frame.corDefOutputs.isEmpty()) {
            for (Map.Entry entry : frame.corDefOutputs.entrySet()) {
                projects.add(RexInputRef.of2((int)((Integer)entry.getValue()), (List)newInputOutput));
                corDefOutputs.put((CorDef)entry.getKey(), newPos);
                mapNewInputToProjOutputs.put((Integer)entry.getValue(), newPos);
                ++newPos;
            }
        }
        int newGroupKeyCount = newPos;
        for (int i = 0; i < newInputOutput.size(); ++i) {
            if (mapNewInputToProjOutputs.containsKey(i)) continue;
            projects.add(RexInputRef.of2((int)i, (List)newInputOutput));
            mapNewInputToProjOutputs.put(i, newPos);
            ++newPos;
        }
        assert (newPos == newInputOutput.size());
        HiveProject newProject = HiveProject.create(newInput, Pair.left((List)projects), Pair.right((List)projects));
        HashMap combinedMap = Maps.newHashMap();
        for (Integer oldInputPos : frame.oldToNewOutputs.keySet()) {
            combinedMap.put(oldInputPos, (Integer)mapNewInputToProjOutputs.get(frame.oldToNewOutputs.get((Object)oldInputPos)));
        }
        this.register(oldInput, newProject, combinedMap, corDefOutputs);
        ImmutableBitSet newGroupSet = ImmutableBitSet.range((int)newGroupKeyCount);
        ArrayList newAggCalls = Lists.newArrayList();
        List oldAggCalls = rel.getAggCallList();
        int oldInputOutputFieldCount = rel.getGroupSet().cardinality();
        int newInputOutputFieldCount = newGroupSet.cardinality();
        int i = -1;
        for (AggregateCall oldAggCall : oldAggCalls) {
            ++i;
            List oldAggArgs = oldAggCall.getArgList();
            ArrayList aggArgs = Lists.newArrayList();
            Iterator iterator = oldAggArgs.iterator();
            while (iterator.hasNext()) {
                int oldPos = (Integer)iterator.next();
                aggArgs.add((Integer)combinedMap.get(oldPos));
            }
            int filterArg = oldAggCall.filterArg < 0 ? oldAggCall.filterArg : (Integer)combinedMap.get(oldAggCall.filterArg);
            newAggCalls.add(oldAggCall.adaptTo((RelNode)newProject, (List)aggArgs, filterArg, oldGroupKeyCount, newGroupKeyCount));
            combinedMap.put(oldInputOutputFieldCount + i, newInputOutputFieldCount + i);
        }
        this.relBuilder.push((RelNode)new HiveAggregate(rel.getCluster(), rel.getTraitSet(), newProject, newGroupSet, null, newAggCalls));
        return this.register(rel, this.relBuilder.build(), combinedMap, corDefOutputs);
    }

    public Frame decorrelateRel(HiveProject rel) throws SemanticException {
        int newPos;
        RelNode oldInput = rel.getInput();
        Frame frame = this.getInvoke(oldInput, rel);
        if (frame == null) {
            return null;
        }
        List oldProjects = rel.getProjects();
        List relOutput = rel.getRowType().getFieldList();
        ArrayList projects = Lists.newArrayList();
        if (this.cm.mapRefRelToCorRef.containsKey((Object)rel)) {
            frame = this.decorrelateInputWithValueGenerator(rel);
        }
        HashMap<Integer, Integer> mapOldToNewOutputs = new HashMap<Integer, Integer>();
        for (newPos = 0; newPos < oldProjects.size(); ++newPos) {
            projects.add(newPos, Pair.of((Object)this.decorrelateExpr((RexNode)oldProjects.get(newPos)), (Object)((RelDataTypeField)relOutput.get(newPos)).getName()));
            mapOldToNewOutputs.put(newPos, newPos);
        }
        TreeMap<CorDef, Integer> corDefOutputs = new TreeMap<CorDef, Integer>();
        for (Map.Entry entry : frame.corDefOutputs.entrySet()) {
            projects.add(RexInputRef.of2((int)((Integer)entry.getValue()), (List)frame.r.getRowType().getFieldList()));
            corDefOutputs.put((CorDef)entry.getKey(), newPos);
            ++newPos;
        }
        HiveProject newProject = HiveProject.create(frame.r, Pair.left((List)projects), SqlValidatorUtil.uniquify((List)Pair.right((List)projects)));
        return this.register(rel, newProject, mapOldToNewOutputs, corDefOutputs);
    }

    public Frame decorrelateRel(Project rel) throws SemanticException {
        int newPos;
        RelNode oldInput = rel.getInput();
        Frame frame = this.getInvoke(oldInput, (RelNode)rel);
        if (frame == null) {
            return null;
        }
        List oldProjects = rel.getProjects();
        List relOutput = rel.getRowType().getFieldList();
        ArrayList projects = Lists.newArrayList();
        if (this.cm.mapRefRelToCorRef.containsKey((Object)rel)) {
            frame = this.decorrelateInputWithValueGenerator((RelNode)rel);
        }
        HashMap<Integer, Integer> mapOldToNewOutputs = new HashMap<Integer, Integer>();
        for (newPos = 0; newPos < oldProjects.size(); ++newPos) {
            projects.add(newPos, Pair.of((Object)this.decorrelateExpr((RexNode)oldProjects.get(newPos)), (Object)((RelDataTypeField)relOutput.get(newPos)).getName()));
            mapOldToNewOutputs.put(newPos, newPos);
        }
        TreeMap<CorDef, Integer> corDefOutputs = new TreeMap<CorDef, Integer>();
        for (Map.Entry entry : frame.corDefOutputs.entrySet()) {
            projects.add(RexInputRef.of2((int)((Integer)entry.getValue()), (List)frame.r.getRowType().getFieldList()));
            corDefOutputs.put((CorDef)entry.getKey(), newPos);
            ++newPos;
        }
        HiveProject newProject = HiveProject.create(frame.r, Pair.left((List)projects), Pair.right((List)projects));
        return this.register((RelNode)rel, newProject, mapOldToNewOutputs, corDefOutputs);
    }

    private RelNode createValueGenerator(Iterable<CorRef> correlations, int valueGenFieldOffset, SortedMap<CorDef, Integer> corDefOutputs) {
        RelNode oldInput;
        HashMap<RelNode, List<Integer>> mapNewInputToOutputs = new HashMap<RelNode, List<Integer>>();
        HashMap<RelNode, Integer> mapNewInputToNewOffset = new HashMap<RelNode, Integer>();
        for (CorRef corVar : correlations) {
            int newCorVarOffset;
            int oldCorVarOffset = corVar.field;
            RelNode oldInput2 = this.getCorRel(corVar);
            assert (oldInput2 != null);
            Frame frame = this.map.get(oldInput2);
            assert (frame != null);
            RelNode newInput = frame.r;
            List newLocalOutputs = !mapNewInputToOutputs.containsKey(newInput) ? new ArrayList() : (List)mapNewInputToOutputs.get(newInput);
            if (!newLocalOutputs.contains(newCorVarOffset = ((Integer)frame.oldToNewOutputs.get((Object)oldCorVarOffset)).intValue())) {
                newLocalOutputs.add(newCorVarOffset);
            }
            mapNewInputToOutputs.put(newInput, newLocalOutputs);
        }
        int offset = 0;
        HashSet<RelNode> joinedInputs = new HashSet<RelNode>();
        RelNode r = null;
        for (CorRef corVar : correlations) {
            oldInput = this.getCorRel(corVar);
            assert (oldInput != null);
            RelNode newInput = this.map.get((Object)oldInput).r;
            assert (newInput != null);
            if (joinedInputs.contains(newInput)) continue;
            RelNode project = RelOptUtil.createProject((RelFactories.ProjectFactory)HiveRelFactories.HIVE_PROJECT_FACTORY, (RelNode)newInput, (List)((List)mapNewInputToOutputs.get(newInput)));
            RelNode distinct = this.relBuilder.push(project).distinct().build();
            RelOptCluster cluster = distinct.getCluster();
            joinedInputs.add(newInput);
            mapNewInputToNewOffset.put(newInput, offset);
            offset += distinct.getRowType().getFieldCount();
            if (r == null) {
                r = distinct;
                continue;
            }
            r = this.relBuilder.push(r).push(distinct).join(JoinRelType.INNER, (RexNode)cluster.getRexBuilder().makeLiteral(true)).build();
        }
        for (CorRef corRef : correlations) {
            oldInput = this.getCorRel(corRef);
            assert (oldInput != null);
            Frame frame = this.map.get(oldInput);
            RelNode newInput = frame.r;
            assert (newInput != null);
            List newLocalOutputs = (List)mapNewInputToOutputs.get(newInput);
            int newLocalOutput = (Integer)frame.oldToNewOutputs.get((Object)corRef.field);
            int newOutput = newLocalOutputs.indexOf(newLocalOutput) + (Integer)mapNewInputToNewOffset.get(newInput) + valueGenFieldOffset;
            corDefOutputs.put(corRef.def(), newOutput);
        }
        return r;
    }

    private RelNode getCorRel(CorRef corVar) {
        RelNode r = (RelNode)this.cm.mapCorToCorRel.get(corVar.corr);
        RelNode ret = r.getInput(0);
        return ret;
    }

    private Frame decorrelateInputWithValueGenerator(RelNode rel) {
        assert (rel.getInputs().size() == 1);
        RelNode oldInput = rel.getInput(0);
        Frame frame = this.map.get(oldInput);
        TreeMap<CorDef, Integer> corDefOutputs = new TreeMap<CorDef, Integer>((SortedMap<CorDef, Integer>)frame.corDefOutputs);
        Collection corVarList = this.cm.mapRefRelToCorRef.get((Object)rel);
        if (rel instanceof Filter) {
            TreeMap<CorDef, Integer> coreMap = new TreeMap<CorDef, Integer>();
            for (CorRef correlation : corVarList) {
                CorDef def = correlation.def();
                if (corDefOutputs.containsKey(def) || coreMap.containsKey(def)) continue;
                try {
                    this.findCorrelationEquivalent(correlation, ((Filter)rel).getCondition());
                }
                catch (Util.FoundOne e) {
                    def.setPredicateKind((SqlOperator)((Pair)((Pair)e.getNode()).getValue()).getKey());
                    def.setIsLeft((Boolean)((Pair)((Pair)e.getNode()).getValue()).getValue());
                    coreMap.put(def, (Integer)((Pair)e.getNode()).getKey());
                }
            }
            if (coreMap.size() == corVarList.size()) {
                coreMap.putAll((Map<CorDef, Integer>)frame.corDefOutputs);
                return this.register(oldInput, frame.r, (Map<Integer, Integer>)frame.oldToNewOutputs, (SortedMap<CorDef, Integer>)coreMap);
            }
        }
        int leftInputOutputCount = frame.r.getRowType().getFieldCount();
        RelNode valueGenRel = this.createValueGenerator(corVarList, leftInputOutputCount, corDefOutputs);
        RelNode join = this.relBuilder.push(frame.r).push(valueGenRel).join(JoinRelType.INNER, (RexNode)this.rexBuilder.makeLiteral(true)).build();
        return this.register(oldInput, join, (Map<Integer, Integer>)frame.oldToNewOutputs, (SortedMap<CorDef, Integer>)corDefOutputs);
    }

    private void findCorrelationEquivalent(CorRef correlation, RexNode e) throws Util.FoundOne {
        if (e instanceof RexCall) {
            switch (e.getKind()) {
                case AND: {
                    for (RexNode operand : ((RexCall)e).getOperands()) {
                        this.findCorrelationEquivalent(correlation, operand);
                    }
                    break;
                }
            }
            RexCall call = (RexCall)e;
            List operands = call.getOperands();
            if (operands.size() == 2) {
                if (this.references((RexNode)operands.get(0), correlation) && operands.get(1) instanceof RexInputRef) {
                    if (e.getKind() != SqlKind.EQUALS && ((Boolean)this.valueGen.peek()).booleanValue()) {
                        return;
                    }
                    throw new Util.FoundOne((Object)Pair.of((Object)((RexInputRef)operands.get(1)).getIndex(), (Object)Pair.of((Object)((RexCall)e).getOperator(), (Object)true)));
                }
                if (this.references((RexNode)operands.get(1), correlation) && operands.get(0) instanceof RexInputRef) {
                    if (e.getKind() != SqlKind.EQUALS && ((Boolean)this.valueGen.peek()).booleanValue()) {
                        return;
                    }
                    throw new Util.FoundOne((Object)Pair.of((Object)((RexInputRef)operands.get(0)).getIndex(), (Object)Pair.of((Object)((RexCall)e).getOperator(), (Object)false)));
                }
            }
        }
    }

    private boolean references(RexNode e, CorRef correlation) {
        switch (e.getKind()) {
            case CAST: {
                RexNode operand = (RexNode)((RexCall)e).getOperands().get(0);
                if (this.isWidening(e.getType(), operand.getType())) {
                    return this.references(operand, correlation);
                }
                return false;
            }
            case FIELD_ACCESS: {
                RexFieldAccess f = (RexFieldAccess)e;
                if (f.getField().getIndex() != correlation.field || !(f.getReferenceExpr() instanceof RexCorrelVariable) || ((RexCorrelVariable)f.getReferenceExpr()).id != correlation.corr) break;
                return true;
            }
        }
        return false;
    }

    private boolean isWidening(RelDataType type, RelDataType type1) {
        return type.getSqlTypeName() == type1.getSqlTypeName() && type.getPrecision() >= type1.getPrecision();
    }

    public Frame decorrelateRel(HiveFilter rel) throws SemanticException {
        RelNode oldInput = rel.getInput();
        Frame frame = this.getInvoke(oldInput, rel);
        if (frame == null) {
            return null;
        }
        Frame oldInputFrame = frame;
        if (this.cm.mapRefRelToCorRef.containsKey((Object)rel)) {
            frame = this.decorrelateInputWithValueGenerator(rel);
        }
        boolean valueGenerator = true;
        if (frame.r == oldInputFrame.r) {
            valueGenerator = false;
        }
        if (oldInput instanceof LogicalCorrelate && ((LogicalCorrelate)oldInput).getJoinType() == SemiJoinType.SEMI && !this.cm.mapRefRelToCorRef.containsKey((Object)rel)) {
            HiveSemiJoin join = (HiveSemiJoin)frame.r;
            ArrayList<RexNode> conditions = new ArrayList<RexNode>();
            RexNode joinCond = join.getCondition();
            conditions.add(joinCond);
            conditions.add(this.decorrelateExpr(rel.getCondition(), valueGenerator));
            RexNode condition = RexUtil.composeConjunction((RexBuilder)this.rexBuilder, conditions, (boolean)false);
            HiveSemiJoin newRel = HiveSemiJoin.getSemiJoin(frame.r.getCluster(), frame.r.getTraitSet(), join.getLeft(), join.getRight(), condition, join.getLeftKeys(), join.getRightKeys());
            return this.register(rel, newRel, (Map<Integer, Integer>)frame.oldToNewOutputs, (SortedMap<CorDef, Integer>)frame.corDefOutputs);
        }
        this.relBuilder.push(frame.r).filter(new RexNode[]{this.decorrelateExpr(rel.getCondition(), valueGenerator)});
        return this.register(rel, this.relBuilder.build(), (Map<Integer, Integer>)frame.oldToNewOutputs, (SortedMap<CorDef, Integer>)frame.corDefOutputs);
    }

    public Frame decorrelateRel(Filter rel) {
        RelNode oldInput = rel.getInput();
        Frame frame = this.getInvoke(oldInput, (RelNode)rel);
        if (frame == null) {
            return null;
        }
        if (this.cm.mapRefRelToCorRef.containsKey((Object)rel)) {
            frame = this.decorrelateInputWithValueGenerator((RelNode)rel);
        }
        boolean valueGenerator = true;
        if (frame.r == oldInput) {
            valueGenerator = false;
        }
        if (oldInput instanceof LogicalCorrelate && ((LogicalCorrelate)oldInput).getJoinType() == SemiJoinType.SEMI && !this.cm.mapRefRelToCorRef.containsKey((Object)rel)) {
            HiveSemiJoin join = (HiveSemiJoin)frame.r;
            ArrayList<RexNode> conditions = new ArrayList<RexNode>();
            RexNode joinCond = join.getCondition();
            conditions.add(joinCond);
            conditions.add(this.decorrelateExpr(rel.getCondition(), valueGenerator));
            RexNode condition = RexUtil.composeConjunction((RexBuilder)this.rexBuilder, conditions, (boolean)false);
            HiveSemiJoin newRel = HiveSemiJoin.getSemiJoin(frame.r.getCluster(), frame.r.getTraitSet(), join.getLeft(), join.getRight(), condition, join.getLeftKeys(), join.getRightKeys());
            return this.register((RelNode)rel, newRel, (Map<Integer, Integer>)frame.oldToNewOutputs, (SortedMap<CorDef, Integer>)frame.corDefOutputs);
        }
        this.relBuilder.push(frame.r).filter(new RexNode[]{this.decorrelateExpr(rel.getCondition(), valueGenerator)});
        return this.register((RelNode)rel, this.relBuilder.build(), (Map<Integer, Integer>)frame.oldToNewOutputs, (SortedMap<CorDef, Integer>)frame.corDefOutputs);
    }

    public Frame decorrelateRel(LogicalCorrelate rel) {
        RelNode oldLeft = rel.getInput(0);
        RelNode oldRight = rel.getInput(1);
        boolean mightRequireValueGen = new findIfValueGenRequired().traverse(oldRight);
        this.valueGen.push(mightRequireValueGen);
        Frame leftFrame = this.getInvoke(oldLeft, (RelNode)rel);
        Frame rightFrame = this.getInvoke(oldRight, (RelNode)rel);
        if (leftFrame == null || rightFrame == null) {
            return null;
        }
        if (rightFrame.corDefOutputs.isEmpty()) {
            return null;
        }
        assert (rel.getRequiredColumns().cardinality() <= rightFrame.corDefOutputs.keySet().size());
        TreeMap<CorDef, Integer> corDefOutputs = new TreeMap<CorDef, Integer>((SortedMap<CorDef, Integer>)rightFrame.corDefOutputs);
        ArrayList<RexNode> conditions = new ArrayList<RexNode>();
        List newLeftOutput = leftFrame.r.getRowType().getFieldList();
        int newLeftFieldCount = newLeftOutput.size();
        List newRightOutput = rightFrame.r.getRowType().getFieldList();
        for (Map.Entry rightOutput : new ArrayList(corDefOutputs.entrySet())) {
            SqlBinaryOperator callOp;
            CorDef corDef = (CorDef)rightOutput.getKey();
            if (!corDef.corr.equals((Object)rel.getCorrelationId())) continue;
            int newLeftPos = (Integer)leftFrame.oldToNewOutputs.get((Object)corDef.field);
            int newRightPos = (Integer)rightOutput.getValue();
            Object object = callOp = corDef.getPredicateKind() == null ? SqlStdOperatorTable.EQUALS : corDef.getPredicateKind();
            if (corDef.isLeft) {
                conditions.add(this.rexBuilder.makeCall((SqlOperator)callOp, new RexNode[]{RexInputRef.of((int)newLeftPos, (List)newLeftOutput), new RexInputRef(newLeftFieldCount + newRightPos, ((RelDataTypeField)newRightOutput.get(newRightPos)).getType())}));
            } else {
                conditions.add(this.rexBuilder.makeCall((SqlOperator)callOp, new RexNode[]{new RexInputRef(newLeftFieldCount + newRightPos, ((RelDataTypeField)newRightOutput.get(newRightPos)).getType()), RexInputRef.of((int)newLeftPos, (List)newLeftOutput)}));
            }
            corDefOutputs.remove(corDef);
        }
        for (CorDef corDef : corDefOutputs.keySet()) {
            int newPos = (Integer)corDefOutputs.get(corDef) + newLeftFieldCount;
            corDefOutputs.put(corDef, newPos);
        }
        corDefOutputs.putAll((Map<CorDef, Integer>)leftFrame.corDefOutputs);
        HashMap<Integer, Integer> mapOldToNewOutputs = new HashMap<Integer, Integer>();
        int oldLeftFieldCount = oldLeft.getRowType().getFieldCount();
        int oldRightFieldCount = oldRight.getRowType().getFieldCount();
        mapOldToNewOutputs.putAll((Map<Integer, Integer>)leftFrame.oldToNewOutputs);
        RexNode condition = RexUtil.composeConjunction((RexBuilder)this.rexBuilder, conditions, (boolean)false);
        RelNode newJoin = null;
        if (rel.getJoinType() == SemiJoinType.SEMI) {
            ArrayList leftKeys = new ArrayList();
            ArrayList rightKeys = new ArrayList();
            RelNode[] inputRels = new RelNode[]{leftFrame.r, rightFrame.r};
            newJoin = HiveSemiJoin.getSemiJoin(rel.getCluster(), rel.getCluster().traitSetOf((RelTrait)HiveRelNode.CONVENTION), leftFrame.r, rightFrame.r, condition, ImmutableIntList.copyOf(leftKeys), ImmutableIntList.copyOf(rightKeys));
        } else {
            for (int i = 0; i < oldRightFieldCount; ++i) {
                mapOldToNewOutputs.put(i + oldLeftFieldCount, (Integer)rightFrame.oldToNewOutputs.get((Object)i) + newLeftFieldCount);
            }
            newJoin = this.relBuilder.push(leftFrame.r).push(rightFrame.r).join(rel.getJoinType().toJoinType(), condition).build();
        }
        this.valueGen.pop();
        return this.register((RelNode)rel, newJoin, mapOldToNewOutputs, corDefOutputs);
    }

    public Frame decorrelateRel(HiveJoin rel) throws SemanticException {
        RelNode oldLeft = rel.getInput(0);
        RelNode oldRight = rel.getInput(1);
        Frame leftFrame = this.getInvoke(oldLeft, rel);
        Frame rightFrame = this.getInvoke(oldRight, rel);
        if (leftFrame == null || rightFrame == null) {
            return null;
        }
        HiveJoin newJoin = HiveJoin.getJoin(rel.getCluster(), leftFrame.r, rightFrame.r, this.decorrelateExpr(rel.getCondition()), rel.getJoinType());
        HashMap mapOldToNewOutputs = Maps.newHashMap();
        int oldLeftFieldCount = oldLeft.getRowType().getFieldCount();
        int newLeftFieldCount = leftFrame.r.getRowType().getFieldCount();
        int oldRightFieldCount = oldRight.getRowType().getFieldCount();
        assert (rel.getRowType().getFieldCount() == oldLeftFieldCount + oldRightFieldCount);
        mapOldToNewOutputs.putAll(leftFrame.oldToNewOutputs);
        for (int i = 0; i < oldRightFieldCount; ++i) {
            mapOldToNewOutputs.put(i + oldLeftFieldCount, (Integer)rightFrame.oldToNewOutputs.get((Object)i) + newLeftFieldCount);
        }
        TreeMap<CorDef, Integer> corDefOutputs = new TreeMap<CorDef, Integer>((SortedMap<CorDef, Integer>)leftFrame.corDefOutputs);
        for (Map.Entry entry : rightFrame.corDefOutputs.entrySet()) {
            corDefOutputs.put((CorDef)entry.getKey(), (Integer)entry.getValue() + newLeftFieldCount);
        }
        return this.register(rel, newJoin, mapOldToNewOutputs, corDefOutputs);
    }

    public Frame decorrelateRel(Join rel) {
        RelNode oldLeft = rel.getInput(0);
        RelNode oldRight = rel.getInput(1);
        Frame leftFrame = this.getInvoke(oldLeft, (RelNode)rel);
        Frame rightFrame = this.getInvoke(oldRight, (RelNode)rel);
        if (leftFrame == null || rightFrame == null) {
            return null;
        }
        HiveJoin newJoin = HiveJoin.getJoin(rel.getCluster(), leftFrame.r, rightFrame.r, this.decorrelateExpr(rel.getCondition()), rel.getJoinType());
        HashMap mapOldToNewOutputs = Maps.newHashMap();
        int oldLeftFieldCount = oldLeft.getRowType().getFieldCount();
        int newLeftFieldCount = leftFrame.r.getRowType().getFieldCount();
        int oldRightFieldCount = oldRight.getRowType().getFieldCount();
        assert (rel.getRowType().getFieldCount() == oldLeftFieldCount + oldRightFieldCount);
        mapOldToNewOutputs.putAll(leftFrame.oldToNewOutputs);
        for (int i = 0; i < oldRightFieldCount; ++i) {
            mapOldToNewOutputs.put(i + oldLeftFieldCount, (Integer)rightFrame.oldToNewOutputs.get((Object)i) + newLeftFieldCount);
        }
        TreeMap<CorDef, Integer> corDefOutputs = new TreeMap<CorDef, Integer>((SortedMap<CorDef, Integer>)leftFrame.corDefOutputs);
        for (Map.Entry entry : rightFrame.corDefOutputs.entrySet()) {
            corDefOutputs.put((CorDef)entry.getKey(), (Integer)entry.getValue() + newLeftFieldCount);
        }
        return this.register((RelNode)rel, newJoin, mapOldToNewOutputs, corDefOutputs);
    }

    private RexInputRef getNewForOldInputRef(RexInputRef oldInputRef) {
        int oldLocalOrdinal;
        int oldOrdinal;
        assert (this.currentRel != null);
        int oldOrdinalNo = oldOrdinal = oldInputRef.getIndex();
        int newOrdinal = 0;
        RelNode oldInput = null;
        for (RelNode oldInput0 : this.currentRel.getInputs()) {
            RelDataType oldInputType = oldInput0.getRowType();
            int n = oldInputType.getFieldCount();
            if (oldOrdinal < n) {
                oldInput = oldInput0;
                break;
            }
            RelNode newInput = this.map.get((Object)oldInput0).r;
            newOrdinal += newInput.getRowType().getFieldCount();
            oldOrdinal -= n;
        }
        if (oldInput == null && this.currentRel.getInputs().size() == 1 && this.currentRel.getInput(0) instanceof LogicalCorrelate) {
            Frame newFrame = this.map.get(this.currentRel.getInput(0));
            if (newFrame.r instanceof HiveSemiJoin) {
                int oldFieldSize = this.currentRel.getInput(0).getRowType().getFieldCount();
                int newOrd = newFrame.r.getRowType().getFieldCount() + oldOrdinalNo - oldFieldSize;
                return new RexInputRef(newOrd, oldInputRef.getType());
            }
        }
        assert (oldInput != null);
        Frame frame = this.map.get(oldInput);
        assert (frame != null);
        int newLocalOrdinal = oldLocalOrdinal = oldOrdinal;
        if (!frame.oldToNewOutputs.isEmpty()) {
            newLocalOrdinal = (Integer)frame.oldToNewOutputs.get((Object)oldLocalOrdinal);
        }
        return new RexInputRef(newOrdinal += newLocalOrdinal, ((RelDataTypeField)frame.r.getRowType().getFieldList().get(newLocalOrdinal)).getType());
    }

    private RelNode projectJoinOutputWithNullability(Join join, Project project, int nullIndicatorPos) {
        RelDataTypeFactory typeFactory = join.getCluster().getTypeFactory();
        RelNode left = join.getLeft();
        JoinRelType joinType = join.getJoinType();
        RexInputRef nullIndicator = new RexInputRef(nullIndicatorPos, typeFactory.createTypeWithNullability(((RelDataTypeField)join.getRowType().getFieldList().get(nullIndicatorPos)).getType(), true));
        ArrayList newProjExprs = Lists.newArrayList();
        List leftInputFields = left.getRowType().getFieldList();
        for (int i = 0; i < leftInputFields.size(); ++i) {
            newProjExprs.add(RexInputRef.of2((int)i, (List)leftInputFields));
        }
        boolean projectPulledAboveLeftCorrelator = joinType.generatesNullsOnRight();
        for (Pair pair : project.getNamedProjects()) {
            RexNode newProjExpr = this.removeCorrelationExpr((RexNode)pair.left, projectPulledAboveLeftCorrelator, nullIndicator);
            newProjExprs.add(Pair.of((Object)newProjExpr, (Object)((String)pair.right)));
        }
        return RelOptUtil.createProject((RelNode)join, (List)Pair.left((List)newProjExprs), (List)Pair.right((List)newProjExprs), (boolean)false, (RelBuilder)this.relBuilder);
    }

    private RelNode aggregateCorrelatorOutput(Correlate correlate, Project project, Set<Integer> isCount) {
        RelNode left = correlate.getLeft();
        JoinRelType joinType = correlate.getJoinType().toJoinType();
        ArrayList newProjects = Lists.newArrayList();
        List leftInputFields = left.getRowType().getFieldList();
        for (int i = 0; i < leftInputFields.size(); ++i) {
            newProjects.add(RexInputRef.of2((int)i, (List)leftInputFields));
        }
        boolean projectPulledAboveLeftCorrelator = joinType.generatesNullsOnRight();
        for (Pair pair : project.getNamedProjects()) {
            RexNode newProjExpr = this.removeCorrelationExpr((RexNode)pair.left, projectPulledAboveLeftCorrelator, isCount);
            newProjects.add(Pair.of((Object)newProjExpr, (Object)((String)pair.right)));
        }
        return RelOptUtil.createProject((RelNode)correlate, (List)Pair.left((List)newProjects), (List)Pair.right((List)newProjects), (boolean)false, (RelBuilder)this.relBuilder);
    }

    private boolean checkCorVars(LogicalCorrelate correlate, Project project, Filter filter, List<RexFieldAccess> correlatedJoinKeys) {
        if (filter != null) {
            assert (correlatedJoinKeys != null);
            HashSet corVarInFilter = Sets.newHashSet((Iterable)this.cm.mapRefRelToCorRef.get((Object)filter));
            for (RexFieldAccess correlatedJoinKey : correlatedJoinKeys) {
                corVarInFilter.remove(this.cm.mapFieldAccessToCorRef.get(correlatedJoinKey));
            }
            if (!corVarInFilter.isEmpty()) {
                return false;
            }
            corVarInFilter.addAll(this.cm.mapRefRelToCorRef.get((Object)filter));
            for (CorRef corVar : corVarInFilter) {
                if (this.cm.mapCorToCorRel.get(corVar.corr) == correlate) continue;
                return false;
            }
        }
        if (project != null && this.cm.mapRefRelToCorRef.containsKey((Object)project)) {
            for (CorRef corVar : this.cm.mapRefRelToCorRef.get((Object)project)) {
                if (this.cm.mapCorToCorRel.get(corVar.corr) == correlate) continue;
                return false;
            }
        }
        return true;
    }

    private void removeCorVarFromTree(LogicalCorrelate correlate) {
        if (this.cm.mapCorToCorRel.get(correlate.getCorrelationId()) == correlate) {
            this.cm.mapCorToCorRel.remove(correlate.getCorrelationId());
        }
    }

    private RelNode createProjectWithAdditionalExprs(RelNode input, List<Pair<RexNode, String>> additionalExprs) {
        List fieldList = input.getRowType().getFieldList();
        ArrayList projects = Lists.newArrayList();
        for (Ord field : Ord.zip((List)fieldList)) {
            projects.add(Pair.of((Object)this.rexBuilder.makeInputRef(((RelDataTypeField)field.e).getType(), field.i), (Object)((RelDataTypeField)field.e).getName()));
        }
        projects.addAll(additionalExprs);
        return RelOptUtil.createProject((RelNode)input, (List)Pair.left((List)projects), (List)Pair.right((List)projects), (boolean)false, (RelBuilder)this.relBuilder);
    }

    static Map<Integer, Integer> identityMap(int count) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (int i = 0; i < count; ++i) {
            builder.put((Object)i, (Object)i);
        }
        return builder.build();
    }

    Frame register(RelNode rel, RelNode newRel, Map<Integer, Integer> oldToNewOutputs, SortedMap<CorDef, Integer> corDefOutputs) {
        Frame frame = new Frame(rel, newRel, corDefOutputs, oldToNewOutputs);
        this.map.put(rel, frame);
        return frame;
    }

    static boolean allLessThan(Collection<Integer> integers, int limit, Litmus ret) {
        for (int value : integers) {
            if (value < limit) continue;
            return ret.fail("out of range; value: " + value + ", limit: " + limit, new Object[0]);
        }
        return ret.succeed();
    }

    private static RelNode stripHep(RelNode rel) {
        if (rel instanceof HepRelVertex) {
            HepRelVertex hepRelVertex = (HepRelVertex)rel;
            rel = hepRelVertex.getCurrentRel();
        }
        return rel;
    }

    static class Frame {
        private final RelNode r;
        private final ImmutableSortedMap<CorDef, Integer> corDefOutputs;
        private final ImmutableSortedMap<Integer, Integer> oldToNewOutputs;

        Frame(RelNode oldRel, RelNode r, SortedMap<CorDef, Integer> corDefOutputs, Map<Integer, Integer> oldToNewOutputs) {
            this.r = (RelNode)Preconditions.checkNotNull((Object)r);
            this.corDefOutputs = ImmutableSortedMap.copyOf(corDefOutputs);
            this.oldToNewOutputs = ImmutableSortedMap.copyOf(oldToNewOutputs);
            assert (HiveRelDecorrelator.allLessThan(corDefOutputs.values(), r.getRowType().getFieldCount(), Litmus.THROW));
            assert (HiveRelDecorrelator.allLessThan(oldToNewOutputs.keySet(), oldRel.getRowType().getFieldCount(), Litmus.THROW));
            assert (HiveRelDecorrelator.allLessThan(oldToNewOutputs.values(), r.getRowType().getFieldCount(), Litmus.THROW));
        }
    }

    private static class CorelMapBuilder
    extends HiveRelShuttleImpl {
        private final SortedMap<CorrelationId, RelNode> mapCorToCorRel = new TreeMap<CorrelationId, RelNode>();
        private final SortedSetMultimap<RelNode, CorRef> mapRefRelToCorRef = Multimaps.newSortedSetMultimap(new HashMap(), (Supplier)new Supplier<TreeSet<CorRef>>(){

            public TreeSet<CorRef> get() {
                Bug.upgrade((String)"use MultimapBuilder when we're on Guava-16");
                return Sets.newTreeSet();
            }
        });
        private final Map<RexFieldAccess, CorRef> mapFieldAccessToCorVar = new HashMap<RexFieldAccess, CorRef>();
        private final Holder<Integer> offset = Holder.of((Object)0);
        private int corrIdGenerator = 0;
        private final List<RelNode> stack = new ArrayList<RelNode>();

        private CorelMapBuilder() {
        }

        CorelMap build(RelNode rel) {
            HiveRelDecorrelator.stripHep(rel).accept((RelShuttle)this);
            return new CorelMap((Multimap<RelNode, CorRef>)this.mapRefRelToCorRef, this.mapCorToCorRel, this.mapFieldAccessToCorVar);
        }

        @Override
        public RelNode visit(HiveJoin join) {
            try {
                Stacks.push(this.stack, (Object)join);
                join.getCondition().accept(this.rexVisitor(join));
            }
            finally {
                Stacks.pop(this.stack, (Object)join);
            }
            return this.visitJoin((BiRel)join);
        }

        @Override
        protected RelNode visitChild(RelNode parent, int i, RelNode input) {
            return super.visitChild(parent, i, HiveRelDecorrelator.stripHep(input));
        }

        @Override
        public RelNode visit(LogicalCorrelate correlate) {
            this.mapCorToCorRel.put(correlate.getCorrelationId(), (RelNode)correlate);
            return this.visitJoin((BiRel)correlate);
        }

        private RelNode visitJoin(BiRel join) {
            int x = (Integer)this.offset.get();
            this.visitChild((RelNode)join, 0, join.getLeft());
            this.offset.set((Object)(x + join.getLeft().getRowType().getFieldCount()));
            this.visitChild((RelNode)join, 1, join.getRight());
            this.offset.set((Object)x);
            return join;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public RelNode visit(HiveProject project) {
            try {
                Stacks.push(this.stack, (Object)project);
                for (RexNode node : project.getProjects()) {
                    node.accept(this.rexVisitor(project));
                }
            }
            finally {
                Stacks.pop(this.stack, (Object)project);
            }
            return super.visit(project);
        }

        @Override
        public RelNode visit(HiveFilter filter) {
            try {
                Stacks.push(this.stack, (Object)filter);
                filter.getCondition().accept(this.rexVisitor(filter));
            }
            finally {
                Stacks.pop(this.stack, (Object)filter);
            }
            return super.visit(filter);
        }

        private RexVisitorImpl<Void> rexVisitor(final RelNode rel) {
            return new RexVisitorImpl<Void>(true){

                public Void visitFieldAccess(RexFieldAccess fieldAccess) {
                    RexNode ref = fieldAccess.getReferenceExpr();
                    if (ref instanceof RexCorrelVariable) {
                        RexCorrelVariable var = (RexCorrelVariable)ref;
                        if (mapFieldAccessToCorVar.containsKey(fieldAccess)) {
                            mapRefRelToCorRef.put((Object)rel, (Object)mapFieldAccessToCorVar.get(fieldAccess));
                        } else {
                            CorRef correlation = new CorRef(var.id, fieldAccess.getField().getIndex(), corrIdGenerator++);
                            mapFieldAccessToCorVar.put(fieldAccess, correlation);
                            mapRefRelToCorRef.put((Object)rel, (Object)correlation);
                        }
                    }
                    return (Void)super.visitFieldAccess(fieldAccess);
                }

                public Void visitSubQuery(RexSubQuery subQuery) {
                    subQuery.rel.accept((RelShuttle)this);
                    return (Void)super.visitSubQuery(subQuery);
                }
            };
        }
    }

    private static class findIfValueGenRequired
    extends HiveRelShuttleImpl {
        private boolean mightRequireValueGen = true;

        findIfValueGenRequired() {
        }

        private boolean hasRexOver(List<RexNode> projects) {
            for (RexNode expr : projects) {
                if (!(expr instanceof RexOver)) continue;
                return true;
            }
            return false;
        }

        @Override
        public RelNode visit(HiveJoin rel) {
            this.mightRequireValueGen = true;
            return rel;
        }

        public RelNode visit(HiveSortLimit rel) {
            this.mightRequireValueGen = true;
            return rel;
        }

        public RelNode visit(HiveUnion rel) {
            this.mightRequireValueGen = true;
            return rel;
        }

        public RelNode visit(HiveIntersect rel) {
            this.mightRequireValueGen = true;
            return rel;
        }

        @Override
        public RelNode visit(HiveProject rel) {
            if (!this.hasRexOver(rel.getProjects())) {
                this.mightRequireValueGen = false;
                return super.visit(rel);
            }
            this.mightRequireValueGen = true;
            return rel;
        }

        @Override
        public RelNode visit(HiveAggregate rel) {
            if (rel.getAggCallList().isEmpty() && !rel.indicator) {
                this.mightRequireValueGen = false;
                return super.visit(rel);
            }
            this.mightRequireValueGen = true;
            return rel;
        }

        @Override
        public RelNode visit(LogicalCorrelate rel) {
            return rel;
        }

        public boolean traverse(RelNode root) {
            root.accept((RelShuttle)this);
            return this.mightRequireValueGen;
        }
    }

    private static final class CorelMap {
        private final Multimap<RelNode, CorRef> mapRefRelToCorRef;
        private final SortedMap<CorrelationId, RelNode> mapCorToCorRel;
        private final Map<RexFieldAccess, CorRef> mapFieldAccessToCorRef;

        private CorelMap(Multimap<RelNode, CorRef> mapRefRelToCorRef, SortedMap<CorrelationId, RelNode> mapCorToCorRel, Map<RexFieldAccess, CorRef> mapFieldAccessToCorRef) {
            this.mapRefRelToCorRef = mapRefRelToCorRef;
            this.mapCorToCorRel = mapCorToCorRel;
            this.mapFieldAccessToCorRef = ImmutableMap.copyOf(mapFieldAccessToCorRef);
        }

        public String toString() {
            return "mapRefRelToCorRef=" + this.mapRefRelToCorRef + "\nmapCorToCorRel=" + this.mapCorToCorRel + "\nmapFieldAccessToCorRef=" + this.mapFieldAccessToCorRef + "\n";
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof CorelMap && this.mapRefRelToCorRef.equals(((CorelMap)obj).mapRefRelToCorRef) && this.mapCorToCorRel.equals(((CorelMap)obj).mapCorToCorRel) && this.mapFieldAccessToCorRef.equals(((CorelMap)obj).mapFieldAccessToCorRef);
        }

        public int hashCode() {
            return Objects.hash(this.mapRefRelToCorRef, this.mapCorToCorRel, this.mapFieldAccessToCorRef);
        }

        public static CorelMap of(SortedSetMultimap<RelNode, CorRef> mapRefRelToCorVar, SortedMap<CorrelationId, RelNode> mapCorToCorRel, Map<RexFieldAccess, CorRef> mapFieldAccessToCorVar) {
            return new CorelMap((Multimap<RelNode, CorRef>)mapRefRelToCorVar, mapCorToCorRel, mapFieldAccessToCorVar);
        }

        public boolean hasCorrelation() {
            return !this.mapCorToCorRel.isEmpty();
        }
    }

    static class CorDef
    implements Comparable<CorDef> {
        private final CorrelationId corr;
        private final int field;
        private SqlOperator predicateKind;
        private boolean isLeft;

        CorDef(CorrelationId corr, int field) {
            this.corr = corr;
            this.field = field;
            this.predicateKind = null;
            this.isLeft = false;
        }

        public String toString() {
            return this.corr.getName() + "." + this.field;
        }

        public int hashCode() {
            return Objects.hash(this.corr, this.field);
        }

        public boolean equals(Object o) {
            return this == o || o instanceof CorDef && this.corr == ((CorDef)o).corr && this.field == ((CorDef)o).field;
        }

        @Override
        public int compareTo(@Nonnull CorDef o) {
            int c = this.corr.compareTo(o.corr);
            if (c != 0) {
                return c;
            }
            return Integer.compare(this.field, o.field);
        }

        public SqlOperator getPredicateKind() {
            return this.predicateKind;
        }

        public void setPredicateKind(SqlOperator predKind) {
            this.predicateKind = predKind;
        }

        public boolean getIsLeft() {
            return this.isLeft;
        }

        public void setIsLeft(boolean isLeft) {
            this.isLeft = isLeft;
        }
    }

    static class CorRef
    implements Comparable<CorRef> {
        private final int uniqueKey;
        private final CorrelationId corr;
        private final int field;

        CorRef(CorrelationId corr, int field, int uniqueKey) {
            this.corr = corr;
            this.field = field;
            this.uniqueKey = uniqueKey;
        }

        public String toString() {
            return this.corr.getName() + "." + this.field;
        }

        public int hashCode() {
            return Objects.hash(this.uniqueKey, this.corr, this.field);
        }

        public boolean equals(Object o) {
            return this == o || o instanceof CorRef && this.uniqueKey == ((CorRef)o).uniqueKey && this.corr == ((CorRef)o).corr && this.field == ((CorRef)o).field;
        }

        @Override
        public int compareTo(@Nonnull CorRef o) {
            int c = this.corr.compareTo(o.corr);
            if (c != 0) {
                return c;
            }
            c = Integer.compare(this.field, o.field);
            if (c != 0) {
                return c;
            }
            return Integer.compare(this.uniqueKey, o.uniqueKey);
        }

        public CorDef def() {
            return new CorDef(this.corr, this.field);
        }
    }

    private final class AdjustProjectForCountAggregateRule
    extends RelOptRule {
        private final boolean flavor;

        AdjustProjectForCountAggregateRule(boolean flavor) {
            super(flavor ? AdjustProjectForCountAggregateRule.operand(LogicalCorrelate.class, (RelOptRuleOperand)AdjustProjectForCountAggregateRule.operand(RelNode.class, (RelOptRuleOperandChildren)AdjustProjectForCountAggregateRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[]{AdjustProjectForCountAggregateRule.operand(Project.class, (RelOptRuleOperand)AdjustProjectForCountAggregateRule.operand(Aggregate.class, (RelOptRuleOperandChildren)AdjustProjectForCountAggregateRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[0])}) : AdjustProjectForCountAggregateRule.operand(LogicalCorrelate.class, (RelOptRuleOperand)AdjustProjectForCountAggregateRule.operand(RelNode.class, (RelOptRuleOperandChildren)AdjustProjectForCountAggregateRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[]{AdjustProjectForCountAggregateRule.operand(Aggregate.class, (RelOptRuleOperandChildren)AdjustProjectForCountAggregateRule.any())}));
            this.flavor = flavor;
        }

        public void onMatch(RelOptRuleCall call) {
            Aggregate aggregate;
            Project aggOutputProject;
            LogicalCorrelate correlate = (LogicalCorrelate)call.rel(0);
            RelNode left = call.rel(1);
            if (this.flavor) {
                aggOutputProject = (Project)call.rel(2);
                aggregate = (Aggregate)call.rel(3);
            } else {
                aggregate = (Aggregate)call.rel(2);
                ArrayList projects = Lists.newArrayList();
                List fields = aggregate.getRowType().getFieldList();
                for (int i = 0; i < fields.size(); ++i) {
                    projects.add(RexInputRef.of2((int)projects.size(), (List)fields));
                }
                aggOutputProject = (Project)RelOptUtil.createProject((RelNode)aggregate, (List)Pair.left((List)projects), (List)Pair.right((List)projects), (boolean)false, (RelBuilder)HiveRelDecorrelator.this.relBuilder);
            }
            this.onMatch2(call, correlate, left, aggOutputProject, aggregate);
        }

        private void onMatch2(RelOptRuleCall call, LogicalCorrelate correlate, RelNode leftInput, Project aggOutputProject, Aggregate aggregate) {
            if (HiveRelDecorrelator.this.generatedCorRels.contains(correlate)) {
                return;
            }
            HiveRelDecorrelator.this.setCurrent(call.getPlanner().getRoot(), correlate);
            List aggOutputProjExprs = aggOutputProject.getProjects();
            if (aggOutputProjExprs.size() != 1) {
                return;
            }
            if (correlate.getJoinType() != SemiJoinType.LEFT) {
                return;
            }
            JoinRelType joinType = correlate.getJoinType().toJoinType();
            RexLiteral joinCond = HiveRelDecorrelator.this.rexBuilder.makeLiteral(true);
            if (joinType != JoinRelType.LEFT || joinCond != HiveRelDecorrelator.this.rexBuilder.makeLiteral(true)) {
                return;
            }
            if (!aggregate.getGroupSet().isEmpty()) {
                return;
            }
            List aggCalls = aggregate.getAggCallList();
            HashSet isCount = Sets.newHashSet();
            int i = -1;
            for (AggregateCall aggCall : aggCalls) {
                ++i;
                if (!(aggCall.getAggregation() instanceof SqlCountAggFunction)) continue;
                isCount.add(i);
            }
            LogicalCorrelate newCorrelate = LogicalCorrelate.create((RelNode)leftInput, (RelNode)aggregate, (CorrelationId)correlate.getCorrelationId(), (ImmutableBitSet)correlate.getRequiredColumns(), (SemiJoinType)correlate.getJoinType());
            HiveRelDecorrelator.this.generatedCorRels.add(newCorrelate);
            if (HiveRelDecorrelator.this.cm.mapCorToCorRel.get(correlate.getCorrelationId()) == correlate) {
                HiveRelDecorrelator.this.cm.mapCorToCorRel.put(correlate.getCorrelationId(), (RelNode)newCorrelate);
            }
            RelNode newOutput = HiveRelDecorrelator.this.aggregateCorrelatorOutput((Correlate)newCorrelate, aggOutputProject, isCount);
            call.transformTo(newOutput);
        }
    }

    private final class RemoveCorrelationForScalarAggregateRule
    extends RelOptRule {
        RemoveCorrelationForScalarAggregateRule() {
            super(RemoveCorrelationForScalarAggregateRule.operand(LogicalCorrelate.class, (RelOptRuleOperand)RemoveCorrelationForScalarAggregateRule.operand(RelNode.class, (RelOptRuleOperandChildren)RemoveCorrelationForScalarAggregateRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[]{RemoveCorrelationForScalarAggregateRule.operand(Project.class, (RelOptRuleOperand)RemoveCorrelationForScalarAggregateRule.operand(Aggregate.class, null, (Predicate)Aggregate.IS_SIMPLE, (RelOptRuleOperand)RemoveCorrelationForScalarAggregateRule.operand(Project.class, (RelOptRuleOperand)RemoveCorrelationForScalarAggregateRule.operand(RelNode.class, (RelOptRuleOperandChildren)RemoveCorrelationForScalarAggregateRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), (RelOptRuleOperand[])new RelOptRuleOperand[0]), (RelOptRuleOperand[])new RelOptRuleOperand[0])}));
        }

        public void onMatch(RelOptRuleCall call) {
            LogicalCorrelate correlate = (LogicalCorrelate)call.rel(0);
            RelNode left = call.rel(1);
            Project aggOutputProject = (Project)call.rel(2);
            Aggregate aggregate = (Aggregate)call.rel(3);
            Project aggInputProject = (Project)call.rel(4);
            RelNode right = call.rel(5);
            RelOptCluster cluster = correlate.getCluster();
            HiveRelDecorrelator.this.setCurrent(call.getPlanner().getRoot(), correlate);
            List aggOutputProjects = aggOutputProject.getProjects();
            if (aggOutputProjects.size() != 1) {
                return;
            }
            if (correlate.getJoinType() != SemiJoinType.LEFT) {
                return;
            }
            JoinRelType joinType = correlate.getJoinType().toJoinType();
            RexLiteral joinCond = HiveRelDecorrelator.this.rexBuilder.makeLiteral(true);
            if (joinType != JoinRelType.LEFT || joinCond != HiveRelDecorrelator.this.rexBuilder.makeLiteral(true)) {
                return;
            }
            if (!aggregate.getGroupSet().isEmpty()) {
                return;
            }
            List aggInputProjects = aggInputProject.getProjects();
            List aggCalls = aggregate.getAggCallList();
            HashSet isCountStar = Sets.newHashSet();
            int k = -1;
            for (AggregateCall aggCall : aggCalls) {
                ++k;
                if (!(aggCall.getAggregation() instanceof SqlCountAggFunction) || aggCall.getArgList().size() != 0) continue;
                isCountStar.add(k);
            }
            if (right instanceof Filter && HiveRelDecorrelator.this.cm.mapRefRelToCorRef.containsKey((Object)right)) {
                Filter filter = (Filter)right;
                right = filter.getInput();
                assert (right instanceof HepRelVertex);
                if (RelOptUtil.getVariablesUsed((RelNode)(right = ((HepRelVertex)right).getCurrentRel())).size() > 0) {
                    return;
                }
                ArrayList rightJoinKeys = Lists.newArrayList();
                ArrayList tmpCorrelatedJoinKeys = Lists.newArrayList();
                HiveRelOptUtil.splitCorrelatedFilterCondition(filter, rightJoinKeys, tmpCorrelatedJoinKeys, true);
                ArrayList correlatedJoinKeys = Lists.newArrayList();
                ArrayList correlatedInputRefJoinKeys = Lists.newArrayList();
                for (RexNode joinKey : tmpCorrelatedJoinKeys) {
                    assert (joinKey instanceof RexFieldAccess);
                    correlatedJoinKeys.add((RexFieldAccess)joinKey);
                    RexNode correlatedInputRef = HiveRelDecorrelator.this.removeCorrelationExpr(joinKey, false);
                    assert (correlatedInputRef instanceof RexInputRef);
                    correlatedInputRefJoinKeys.add((RexInputRef)correlatedInputRef);
                }
                if (correlatedInputRefJoinKeys.isEmpty()) {
                    return;
                }
                RelMetadataQuery mq = call.getMetadataQuery();
                if (!RelMdUtil.areColumnsDefinitelyUniqueWhenNullsFiltered((RelMetadataQuery)mq, (RelNode)left, (List)correlatedInputRefJoinKeys)) {
                    return;
                }
                if (!HiveRelDecorrelator.this.checkCorVars(correlate, aggInputProject, filter, correlatedJoinKeys)) {
                    return;
                }
                joinCond = HiveRelDecorrelator.this.removeCorrelationExpr(filter.getCondition(), false);
            } else if (HiveRelDecorrelator.this.cm.mapRefRelToCorRef.containsKey((Object)aggInputProject)) {
                if (RelOptUtil.getVariablesUsed((RelNode)right).size() > 0) {
                    return;
                }
                if (!HiveRelDecorrelator.this.checkCorVars(correlate, aggInputProject, null, null)) {
                    return;
                }
                int nFields = left.getRowType().getFieldCount();
                ImmutableBitSet allCols = ImmutableBitSet.range((int)nFields);
                RelMetadataQuery mq = call.getMetadataQuery();
                if (!RelMdUtil.areColumnsDefinitelyUnique((RelMetadataQuery)mq, (RelNode)left, (ImmutableBitSet)allCols)) {
                    return;
                }
            } else {
                return;
            }
            RelDataType leftInputFieldType = left.getRowType();
            int leftInputFieldCount = leftInputFieldType.getFieldCount();
            int joinOutputProjExprCount = leftInputFieldCount + aggInputProjects.size() + 1;
            right = HiveRelDecorrelator.this.createProjectWithAdditionalExprs(right, (List<Pair<RexNode, String>>)ImmutableList.of((Object)Pair.of((Object)HiveRelDecorrelator.this.rexBuilder.makeLiteral(true), (Object)"nullIndicator")));
            Join join = (Join)HiveRelDecorrelator.this.relBuilder.push(left).push(right).join(joinType, (RexNode)joinCond).build();
            int nullIndicatorPos = join.getRowType().getFieldCount() - 1;
            RexInputRef nullIndicator = new RexInputRef(nullIndicatorPos, cluster.getTypeFactory().createTypeWithNullability(((RelDataTypeField)join.getRowType().getFieldList().get(nullIndicatorPos)).getType(), true));
            ArrayList joinOutputProjects = Lists.newArrayList();
            for (int i = 0; i < leftInputFieldCount; ++i) {
                joinOutputProjects.add(HiveRelDecorrelator.this.rexBuilder.makeInputRef(((RelDataTypeField)leftInputFieldType.getFieldList().get(i)).getType(), i));
            }
            for (RexNode aggInputProjExpr : aggInputProjects) {
                joinOutputProjects.add(HiveRelDecorrelator.this.removeCorrelationExpr(aggInputProjExpr, joinType.generatesNullsOnRight(), nullIndicator));
            }
            joinOutputProjects.add(HiveRelDecorrelator.this.rexBuilder.makeInputRef((RelNode)join, nullIndicatorPos));
            RelNode joinOutputProject = RelOptUtil.createProject((RelNode)join, (List)joinOutputProjects, null, (boolean)false, (RelBuilder)HiveRelDecorrelator.this.relBuilder);
            nullIndicatorPos = joinOutputProjExprCount - 1;
            int groupCount = leftInputFieldCount;
            ArrayList newAggCalls = Lists.newArrayList();
            k = -1;
            for (AggregateCall aggCall : aggCalls) {
                List<Object> argList;
                if (isCountStar.contains(++k)) {
                    argList = Collections.singletonList(nullIndicatorPos);
                } else {
                    argList = Lists.newArrayList();
                    Iterator iterator = aggCall.getArgList().iterator();
                    while (iterator.hasNext()) {
                        int aggArg = (Integer)iterator.next();
                        argList.add(aggArg + groupCount);
                    }
                }
                int filterArg = aggCall.filterArg < 0 ? aggCall.filterArg : aggCall.filterArg + groupCount;
                newAggCalls.add(aggCall.adaptTo(joinOutputProject, argList, filterArg, aggregate.getGroupCount(), groupCount));
            }
            ImmutableBitSet groupSet = ImmutableBitSet.range((int)groupCount);
            Aggregate newAggregate = (Aggregate)HiveRelDecorrelator.this.relBuilder.push(joinOutputProject).aggregate(HiveRelDecorrelator.this.relBuilder.groupKey(groupSet, null), (List)newAggCalls).build();
            ArrayList newAggOutputProjectList = Lists.newArrayList();
            Iterator filterArg = groupSet.iterator();
            while (filterArg.hasNext()) {
                int i = (Integer)filterArg.next();
                newAggOutputProjectList.add(HiveRelDecorrelator.this.rexBuilder.makeInputRef((RelNode)newAggregate, i));
            }
            RexNode newAggOutputProjects = HiveRelDecorrelator.this.removeCorrelationExpr((RexNode)aggOutputProjects.get(0), false);
            newAggOutputProjectList.add(HiveRelDecorrelator.this.rexBuilder.makeCast(cluster.getTypeFactory().createTypeWithNullability(newAggOutputProjects.getType(), true), newAggOutputProjects));
            RelNode newAggOutputProject = RelOptUtil.createProject((RelNode)newAggregate, (List)newAggOutputProjectList, null, (boolean)false, (RelBuilder)HiveRelDecorrelator.this.relBuilder);
            call.transformTo(newAggOutputProject);
            HiveRelDecorrelator.this.removeCorVarFromTree(correlate);
        }
    }

    private final class RemoveCorrelationForScalarProjectRule
    extends RelOptRule {
        RemoveCorrelationForScalarProjectRule() {
            super(RemoveCorrelationForScalarProjectRule.operand(LogicalCorrelate.class, (RelOptRuleOperand)RemoveCorrelationForScalarProjectRule.operand(RelNode.class, (RelOptRuleOperandChildren)RemoveCorrelationForScalarProjectRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[]{RemoveCorrelationForScalarProjectRule.operand(Aggregate.class, (RelOptRuleOperand)RemoveCorrelationForScalarProjectRule.operand(Project.class, (RelOptRuleOperand)RemoveCorrelationForScalarProjectRule.operand(RelNode.class, (RelOptRuleOperandChildren)RemoveCorrelationForScalarProjectRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), (RelOptRuleOperand[])new RelOptRuleOperand[0])}));
        }

        public void onMatch(RelOptRuleCall call) {
            int nullIndicatorPos;
            LogicalCorrelate correlate = (LogicalCorrelate)call.rel(0);
            RelNode left = call.rel(1);
            Aggregate aggregate = (Aggregate)call.rel(2);
            Project project = (Project)call.rel(3);
            RelNode right = call.rel(4);
            RelOptCluster cluster = correlate.getCluster();
            HiveRelDecorrelator.this.setCurrent(call.getPlanner().getRoot(), correlate);
            if (correlate.getJoinType() != SemiJoinType.LEFT) {
                return;
            }
            JoinRelType joinType = correlate.getJoinType().toJoinType();
            RexLiteral joinCond = HiveRelDecorrelator.this.rexBuilder.makeLiteral(true);
            if (joinType != JoinRelType.LEFT || joinCond != HiveRelDecorrelator.this.rexBuilder.makeLiteral(true)) {
                return;
            }
            if (!aggregate.getGroupSet().isEmpty() || aggregate.getAggCallList().size() != 1 || !(((AggregateCall)aggregate.getAggCallList().get(0)).getAggregation() instanceof SqlSingleValueAggFunction)) {
                return;
            }
            if (project.getProjects().size() != 1) {
                return;
            }
            if (right instanceof Filter && HiveRelDecorrelator.this.cm.mapRefRelToCorRef.containsKey((Object)right)) {
                Filter filter = (Filter)right;
                right = filter.getInput();
                assert (right instanceof HepRelVertex);
                if (RelOptUtil.getVariablesUsed((RelNode)(right = ((HepRelVertex)right).getCurrentRel())).size() > 0) {
                    return;
                }
                ArrayList tmpRightJoinKeys = Lists.newArrayList();
                ArrayList correlatedJoinKeys = Lists.newArrayList();
                HiveRelOptUtil.splitCorrelatedFilterCondition(filter, tmpRightJoinKeys, correlatedJoinKeys, false);
                ArrayList<RexInputRef> rightJoinKeys = new ArrayList<RexInputRef>();
                for (RexNode key : tmpRightJoinKeys) {
                    assert (key instanceof RexInputRef);
                    rightJoinKeys.add((RexInputRef)key);
                }
                if (rightJoinKeys.isEmpty()) {
                    return;
                }
                RelMetadataQuery mq = call.getMetadataQuery();
                if (!RelMdUtil.areColumnsDefinitelyUniqueWhenNullsFiltered((RelMetadataQuery)mq, (RelNode)right, rightJoinKeys)) {
                    return;
                }
                RexUtil.FieldAccessFinder visitor = new RexUtil.FieldAccessFinder();
                RexUtil.apply((RexVisitor)visitor, (List)correlatedJoinKeys, null);
                List correlatedKeyList = visitor.getFieldAccessList();
                if (!HiveRelDecorrelator.this.checkCorVars(correlate, project, filter, correlatedKeyList)) {
                    return;
                }
                joinCond = HiveRelDecorrelator.this.removeCorrelationExpr(filter.getCondition(), false);
                nullIndicatorPos = left.getRowType().getFieldCount() + ((RexInputRef)rightJoinKeys.get(0)).getIndex();
            } else if (HiveRelDecorrelator.this.cm.mapRefRelToCorRef.containsKey((Object)project)) {
                if (RelOptUtil.getVariablesUsed((RelNode)right).size() > 0) {
                    return;
                }
                if (!HiveRelDecorrelator.this.checkCorVars(correlate, project, null, null)) {
                    return;
                }
                right = HiveRelDecorrelator.this.createProjectWithAdditionalExprs(right, (List<Pair<RexNode, String>>)ImmutableList.of((Object)Pair.of((Object)HiveRelDecorrelator.this.rexBuilder.makeLiteral(true), (Object)"nullIndicator")));
                right = HiveRelOptUtil.createSingleValueAggRel(cluster, right, HiveRelFactories.HIVE_AGGREGATE_FACTORY);
                nullIndicatorPos = left.getRowType().getFieldCount() + right.getRowType().getFieldCount() - 1;
            } else {
                return;
            }
            Join join = (Join)HiveRelDecorrelator.this.relBuilder.push(left).push(right).join(joinType, (RexNode)joinCond).build();
            RelNode newProject = HiveRelDecorrelator.this.projectJoinOutputWithNullability(join, project, nullIndicatorPos);
            call.transformTo(newProject);
            HiveRelDecorrelator.this.removeCorVarFromTree(correlate);
        }
    }

    private final class RemoveSingleAggregateRule
    extends RelOptRule {
        RemoveSingleAggregateRule() {
            super(RemoveSingleAggregateRule.operand(Aggregate.class, (RelOptRuleOperand)RemoveSingleAggregateRule.operand(Project.class, (RelOptRuleOperand)RemoveSingleAggregateRule.operand(Aggregate.class, (RelOptRuleOperandChildren)RemoveSingleAggregateRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), (RelOptRuleOperand[])new RelOptRuleOperand[0]));
        }

        public void onMatch(RelOptRuleCall call) {
            Aggregate singleAggregate = (Aggregate)call.rel(0);
            Project project = (Project)call.rel(1);
            Aggregate aggregate = (Aggregate)call.rel(2);
            if (!singleAggregate.getGroupSet().isEmpty() || singleAggregate.getAggCallList().size() != 1 || !(((AggregateCall)singleAggregate.getAggCallList().get(0)).getAggregation() instanceof SqlSingleValueAggFunction)) {
                return;
            }
            List projExprs = project.getProjects();
            if (projExprs.size() != 1) {
                return;
            }
            if (!aggregate.getGroupSet().isEmpty()) {
                return;
            }
            RelOptCluster cluster = project.getCluster();
            RelNode newProject = RelOptUtil.createProject((RelNode)aggregate, (List)ImmutableList.of((Object)HiveRelDecorrelator.this.rexBuilder.makeCast(cluster.getTypeFactory().createTypeWithNullability(((RexNode)projExprs.get(0)).getType(), true), (RexNode)projExprs.get(0))), null, (boolean)false, (RelBuilder)HiveRelDecorrelator.this.relBuilder);
            call.transformTo(newProject);
        }
    }

    private class RemoveCorrelationRexShuttle
    extends RexShuttle {
        private final RexBuilder rexBuilder;
        private final RelDataTypeFactory typeFactory;
        private final boolean projectPulledAboveLeftCorrelator;
        private final RexInputRef nullIndicator;
        private final ImmutableSet<Integer> isCount;

        RemoveCorrelationRexShuttle(RexBuilder rexBuilder, boolean projectPulledAboveLeftCorrelator, RexInputRef nullIndicator, Set<Integer> isCount) {
            this.projectPulledAboveLeftCorrelator = projectPulledAboveLeftCorrelator;
            this.nullIndicator = nullIndicator;
            this.isCount = ImmutableSet.copyOf(isCount);
            this.rexBuilder = rexBuilder;
            this.typeFactory = rexBuilder.getTypeFactory();
        }

        private RexNode createCaseExpression(RexInputRef nullInputRef, RexLiteral lit, RexNode rexNode) {
            RexNode[] caseOperands = new RexNode[]{this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NULL, new RexNode[]{new RexInputRef(nullInputRef.getIndex(), this.typeFactory.createTypeWithNullability(nullInputRef.getType(), true))}), this.rexBuilder.makeCast(this.typeFactory.createTypeWithNullability(rexNode.getType(), true), (RexNode)lit), this.rexBuilder.makeCast(this.typeFactory.createTypeWithNullability(rexNode.getType(), true), rexNode)};
            return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.CASE, caseOperands);
        }

        public RexNode visitFieldAccess(RexFieldAccess fieldAccess) {
            if (HiveRelDecorrelator.this.cm.mapFieldAccessToCorRef.containsKey(fieldAccess)) {
                CorRef corVar = HiveRelDecorrelator.this.cm.mapFieldAccessToCorRef.get(fieldAccess);
                RexInputRef newRexNode = new RexInputRef(corVar.field, fieldAccess.getType());
                if (this.projectPulledAboveLeftCorrelator && this.nullIndicator != null) {
                    newRexNode = this.createCaseExpression(this.nullIndicator, this.rexBuilder.constantNull(), (RexNode)newRexNode);
                }
                return newRexNode;
            }
            return fieldAccess;
        }

        public RexNode visitInputRef(RexInputRef inputRef) {
            if (HiveRelDecorrelator.this.currentRel instanceof LogicalCorrelate) {
                int leftInputFieldCount = ((LogicalCorrelate)HiveRelDecorrelator.this.currentRel).getLeft().getRowType().getFieldCount();
                RelDataType newType = inputRef.getType();
                if (this.projectPulledAboveLeftCorrelator) {
                    newType = this.typeFactory.createTypeWithNullability(newType, true);
                }
                int pos = inputRef.getIndex();
                RexInputRef newInputRef = new RexInputRef(leftInputFieldCount + pos, newType);
                if (this.isCount != null && this.isCount.contains((Object)pos)) {
                    return this.createCaseExpression(newInputRef, this.rexBuilder.makeExactLiteral(BigDecimal.ZERO), (RexNode)newInputRef);
                }
                return newInputRef;
            }
            return inputRef;
        }

        public RexNode visitLiteral(RexLiteral literal) {
            if (!RexUtil.isNull((RexNode)literal) && this.projectPulledAboveLeftCorrelator && this.nullIndicator != null) {
                return this.createCaseExpression(this.nullIndicator, this.rexBuilder.constantNull(), (RexNode)literal);
            }
            return literal;
        }

        public RexNode visitCall(RexCall call) {
            RexCall newCall;
            boolean[] update = new boolean[]{false};
            List clonedOperands = this.visitList((List)call.operands, update);
            if (update[0]) {
                SqlFunction function;
                SqlOperator operator = call.getOperator();
                boolean isSpecialCast = false;
                if (operator instanceof SqlFunction && (function = (SqlFunction)operator).getKind() == SqlKind.CAST && call.operands.size() < 2) {
                    isSpecialCast = true;
                }
                newCall = !isSpecialCast ? this.rexBuilder.ensureType(call.getType(), this.rexBuilder.makeCall(this.rexBuilder.deriveReturnType(operator, clonedOperands), operator, clonedOperands), true) : this.rexBuilder.makeCall(call.getType(), operator, clonedOperands);
            } else {
                newCall = call;
            }
            if (this.projectPulledAboveLeftCorrelator && this.nullIndicator != null) {
                return this.createCaseExpression(this.nullIndicator, this.rexBuilder.constantNull(), (RexNode)newCall);
            }
            return newCall;
        }
    }

    private class DecorrelateRexShuttle
    extends RexShuttle {
        private boolean valueGenerator;

        private DecorrelateRexShuttle() {
        }

        public void setValueGenerator(boolean valueGenerator) {
            this.valueGenerator = valueGenerator;
        }

        public RexNode visitCall(RexCall call) {
            if (!this.valueGenerator && call.getOperands().size() == 2) {
                ArrayList operands = new ArrayList(call.operands);
                RexNode o0 = (RexNode)operands.get(0);
                RexNode o1 = (RexNode)operands.get(1);
                boolean isCorrelated = false;
                if (o0 instanceof RexFieldAccess && HiveRelDecorrelator.this.cm.mapFieldAccessToCorRef.get(o0) != null) {
                    o0 = this.decorrFieldAccess((RexFieldAccess)o0);
                    isCorrelated = true;
                }
                if (o1 instanceof RexFieldAccess && HiveRelDecorrelator.this.cm.mapFieldAccessToCorRef.get(o1) != null) {
                    o1 = this.decorrFieldAccess((RexFieldAccess)o1);
                    isCorrelated = true;
                }
                if (isCorrelated && RexUtil.eq((RexNode)o0, (RexNode)o1)) {
                    return HiveRelDecorrelator.this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, new RexNode[]{o0});
                }
                ArrayList<RexNode> newOperands = new ArrayList<RexNode>();
                newOperands.add(o0);
                newOperands.add(o1);
                boolean[] update = new boolean[]{false};
                List clonedOperands = this.visitList(newOperands, update);
                return HiveRelDecorrelator.this.relBuilder.call(call.getOperator(), (Iterable)clonedOperands);
            }
            return super.visitCall(call);
        }

        public RexNode visitFieldAccess(RexFieldAccess fieldAccess) {
            return this.decorrFieldAccess(fieldAccess);
        }

        public RexNode visitInputRef(RexInputRef inputRef) {
            RexInputRef ref = HiveRelDecorrelator.this.getNewForOldInputRef(inputRef);
            if (ref.getIndex() == inputRef.getIndex() && ref.getType() == inputRef.getType()) {
                return inputRef;
            }
            return ref;
        }

        private RexNode decorrFieldAccess(RexFieldAccess fieldAccess) {
            int newInputOutputOffset = 0;
            for (RelNode input : HiveRelDecorrelator.this.currentRel.getInputs()) {
                Frame frame = HiveRelDecorrelator.this.map.get(input);
                if (frame != null) {
                    Integer newInputPos;
                    CorRef corRef = HiveRelDecorrelator.this.cm.mapFieldAccessToCorRef.get(fieldAccess);
                    if (corRef != null && (newInputPos = (Integer)frame.corDefOutputs.get((Object)corRef.def())) != null) {
                        return new RexInputRef(newInputPos + newInputOutputOffset, ((RelDataTypeField)frame.r.getRowType().getFieldList().get(newInputPos)).getType());
                    }
                    newInputOutputOffset += frame.r.getRowType().getFieldCount();
                    continue;
                }
                newInputOutputOffset += input.getRowType().getFieldCount();
            }
            return fieldAccess;
        }
    }
}

