/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet.serde;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.io.parquet.serde.ArrayWritableObjectInspector;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.FieldNode;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeSpec;
import org.apache.hadoop.hive.serde2.SerDeStats;
import org.apache.hadoop.hive.serde2.io.ParquetHiveRecord;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

@SerDeSpec(schemaProps={"columns", "columns.types", "parquet.compression"})
public class ParquetHiveSerDe
extends AbstractSerDe {
    public static final Text MAP_KEY = new Text("key");
    public static final Text MAP_VALUE = new Text("value");
    public static final Text MAP = new Text("map");
    public static final Text ARRAY = new Text("bag");
    public static final Text LIST = new Text("list");
    public static final int[] PRECISION_TO_BYTE_COUNT = new int[38];
    private SerDeStats stats;
    private ObjectInspector objInspector;
    private LAST_OPERATION status;
    private long serializedSize;
    private long deserializedSize;
    private ParquetHiveRecord parquetRow = new ParquetHiveRecord();

    public ParquetHiveSerDe() {
        this.stats = new SerDeStats();
    }

    public final void initialize(Configuration conf, Properties tbl) throws SerDeException {
        String rawPrunedColumnPaths;
        String columnNameProperty = tbl.getProperty("columns");
        String columnTypeProperty = tbl.getProperty("columns.types");
        String columnNameDelimiter = tbl.containsKey("column.name.delimiter") ? tbl.getProperty("column.name.delimiter") : String.valueOf(',');
        List<Object> columnNames = columnNameProperty.length() == 0 ? new ArrayList() : Arrays.asList(columnNameProperty.split(columnNameDelimiter));
        ArrayList columnTypes = columnTypeProperty.length() == 0 ? new ArrayList() : TypeInfoUtils.getTypeInfosFromTypeString((String)columnTypeProperty);
        if (columnNames.size() != columnTypes.size()) {
            throw new IllegalArgumentException("ParquetHiveSerde initialization failed. Number of column name and column type differs. columnNames = " + columnNames + ", columnTypes = " + columnTypes);
        }
        StructTypeInfo completeTypeInfo = (StructTypeInfo)TypeInfoFactory.getStructTypeInfo(columnNames, columnTypes);
        StructTypeInfo prunedTypeInfo = null;
        if (conf != null && (rawPrunedColumnPaths = conf.get("hive.io.file.readNestedColumn.paths")) != null) {
            List<String> prunedColumnPaths = ParquetHiveSerDe.processRawPrunedPaths(rawPrunedColumnPaths);
            prunedTypeInfo = ParquetHiveSerDe.pruneFromPaths(completeTypeInfo, prunedColumnPaths);
        }
        this.objInspector = new ArrayWritableObjectInspector(completeTypeInfo, prunedTypeInfo);
        this.serializedSize = 0L;
        this.deserializedSize = 0L;
        this.status = LAST_OPERATION.UNKNOWN;
    }

    public Object deserialize(Writable blob) throws SerDeException {
        this.status = LAST_OPERATION.DESERIALIZE;
        this.deserializedSize = 0L;
        if (blob instanceof ArrayWritable) {
            this.deserializedSize = ((ArrayWritable)blob).get().length;
            return blob;
        }
        return null;
    }

    public ObjectInspector getObjectInspector() throws SerDeException {
        return this.objInspector;
    }

    public Class<? extends Writable> getSerializedClass() {
        return ParquetHiveRecord.class;
    }

    public Writable serialize(Object obj, ObjectInspector objInspector) throws SerDeException {
        if (!objInspector.getCategory().equals((Object)ObjectInspector.Category.STRUCT)) {
            throw new SerDeException("Cannot serialize " + objInspector.getCategory() + ". Can only serialize a struct");
        }
        this.serializedSize = ((StructObjectInspector)objInspector).getAllStructFieldRefs().size();
        this.status = LAST_OPERATION.SERIALIZE;
        this.parquetRow.value = obj;
        this.parquetRow.inspector = (StructObjectInspector)objInspector;
        return this.parquetRow;
    }

    public SerDeStats getSerDeStats() {
        assert (this.status != LAST_OPERATION.UNKNOWN);
        if (this.status == LAST_OPERATION.SERIALIZE) {
            this.stats.setRawDataSize(this.serializedSize);
        } else {
            this.stats.setRawDataSize(this.deserializedSize);
        }
        return this.stats;
    }

    public static boolean isParquetTable(Table table) {
        return table == null ? false : ParquetHiveSerDe.class.getName().equals(table.getSerializationLib());
    }

    private static List<String> processRawPrunedPaths(String prunedPaths) {
        List<FieldNode> fieldNodes = new ArrayList<FieldNode>();
        for (String p : prunedPaths.split(",")) {
            fieldNodes = FieldNode.mergeFieldNodes(fieldNodes, FieldNode.fromPath(p));
        }
        ArrayList<String> prunedPathList = new ArrayList<String>();
        for (FieldNode fn : fieldNodes) {
            prunedPathList.addAll(fn.toPaths());
        }
        return prunedPathList;
    }

    private static StructTypeInfo pruneFromPaths(StructTypeInfo originalTypeInfo, List<String> prunedPaths) {
        PrunedStructTypeInfo prunedTypeInfo = new PrunedStructTypeInfo(originalTypeInfo);
        for (String path : prunedPaths) {
            ParquetHiveSerDe.pruneFromSinglePath(prunedTypeInfo, path);
        }
        return prunedTypeInfo.prune();
    }

    private static void pruneFromSinglePath(PrunedStructTypeInfo prunedInfo, String path) {
        Preconditions.checkArgument((prunedInfo != null ? 1 : 0) != 0, (Object)("PrunedStructTypeInfo for path '" + path + "' should not be null"));
        int index = path.indexOf(46);
        if (index < 0) {
            index = path.length();
        }
        String fieldName = path.substring(0, index);
        prunedInfo.markSelected(fieldName);
        if (index < path.length()) {
            ParquetHiveSerDe.pruneFromSinglePath(prunedInfo.getChild(fieldName), path.substring(index + 1));
        }
    }

    static {
        for (int prec = 1; prec <= 38; ++prec) {
            ParquetHiveSerDe.PRECISION_TO_BYTE_COUNT[prec - 1] = (int)Math.ceil((Math.log(Math.pow(10.0, prec) - 1.0) / Math.log(2.0) + 1.0) / 8.0);
        }
    }

    private static class PrunedStructTypeInfo {
        final StructTypeInfo typeInfo;
        final Map<String, PrunedStructTypeInfo> children;
        final boolean[] selected;

        PrunedStructTypeInfo(StructTypeInfo typeInfo) {
            this.typeInfo = typeInfo;
            this.children = new HashMap<String, PrunedStructTypeInfo>();
            this.selected = new boolean[typeInfo.getAllStructFieldTypeInfos().size()];
            for (int i = 0; i < typeInfo.getAllStructFieldTypeInfos().size(); ++i) {
                TypeInfo ti = (TypeInfo)typeInfo.getAllStructFieldTypeInfos().get(i);
                if (ti.getCategory() != ObjectInspector.Category.STRUCT) continue;
                this.children.put(((String)typeInfo.getAllStructFieldNames().get(i)).toLowerCase(), new PrunedStructTypeInfo((StructTypeInfo)ti));
            }
        }

        PrunedStructTypeInfo getChild(String fieldName) {
            return this.children.get(fieldName.toLowerCase());
        }

        void markSelected(String fieldName) {
            for (int i = 0; i < this.typeInfo.getAllStructFieldNames().size(); ++i) {
                if (!((String)this.typeInfo.getAllStructFieldNames().get(i)).equalsIgnoreCase(fieldName)) continue;
                this.selected[i] = true;
                break;
            }
        }

        StructTypeInfo prune() {
            ArrayList<String> newNames = new ArrayList<String>();
            ArrayList<Object> newTypes = new ArrayList<Object>();
            ArrayList oldNames = this.typeInfo.getAllStructFieldNames();
            ArrayList oldTypes = this.typeInfo.getAllStructFieldTypeInfos();
            for (int i = 0; i < oldNames.size(); ++i) {
                String fn = (String)oldNames.get(i);
                if (!this.selected[i]) continue;
                newNames.add(fn);
                if (this.children.containsKey(fn.toLowerCase())) {
                    newTypes.add(this.children.get(fn.toLowerCase()).prune());
                    continue;
                }
                newTypes.add((TypeInfo)oldTypes.get(i));
            }
            return (StructTypeInfo)TypeInfoFactory.getStructTypeInfo(newNames, newTypes);
        }
    }

    private static enum LAST_OPERATION {
        SERIALIZE,
        DESERIALIZE,
        UNKNOWN;

    }
}

