/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.events;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.events.PreCreateDatabaseEvent;
import org.apache.hadoop.hive.metastore.events.PreEventContext;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveOperationType;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeObject;
import org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.HiveMetaStoreAuthorizableEvent;
import org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.HiveMetaStoreAuthzInfo;

public class CreateDatabaseEvent
extends HiveMetaStoreAuthorizableEvent {
    private static final Log LOG = LogFactory.getLog(CreateDatabaseEvent.class);
    private String COMMAND_STR = "create database";

    public CreateDatabaseEvent(PreEventContext preEventContext) {
        super(preEventContext);
    }

    @Override
    public HiveMetaStoreAuthzInfo getAuthzContext() {
        HiveMetaStoreAuthzInfo ret = new HiveMetaStoreAuthzInfo(this.preEventContext, HiveOperationType.CREATEDATABASE, this.getInputHObjs(), this.getOutputHObjs(), this.COMMAND_STR);
        return ret;
    }

    private List<HivePrivilegeObject> getInputHObjs() {
        return Collections.emptyList();
    }

    private List<HivePrivilegeObject> getOutputHObjs() {
        String uri;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> CreateDatabaseEvent.getOutputHObjs()");
        }
        ArrayList<HivePrivilegeObject> ret = new ArrayList<HivePrivilegeObject>();
        PreCreateDatabaseEvent event = (PreCreateDatabaseEvent)this.preEventContext;
        Database database = event.getDatabase();
        String string = uri = database != null ? database.getLocationUri() : "";
        if (database != null) {
            ret.add(this.getHivePrivilegeObject(database));
            if (StringUtils.isNotEmpty(uri)) {
                ret.add(this.getHivePrivilegeObjectDfsUri(uri));
            }
            this.COMMAND_STR = this.buildCommandString(this.COMMAND_STR, database);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("<== CreateDatabaseEvent.getOutputHObjs(): ret=" + ret));
            }
        }
        return ret;
    }

    private String buildCommandString(String cmdStr, Database db) {
        Object ret = cmdStr;
        if (db != null) {
            String dbName = db.getName();
            ret = (String)ret + (String)(StringUtils.isNotEmpty(dbName) ? " " + dbName : "");
        }
        return ret;
    }
}

