/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.hooks;

import java.io.Serializable;
import java.net.URI;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.ql.metadata.DummyPartition;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;

public class Entity
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Database database;
    private Type typ;
    private Table t;
    private Partition p;
    private Path d;
    private String stringObject;
    private String className;
    private final String name;
    private boolean complete;

    public boolean isComplete() {
        return this.complete;
    }

    public void setComplete(boolean complete) {
        this.complete = complete;
    }

    public String getName() {
        return this.name;
    }

    public Database getDatabase() {
        return this.database;
    }

    public void setDatabase(Database database) {
        this.database = database;
    }

    public Type getTyp() {
        return this.typ;
    }

    public void setTyp(Type typ) {
        this.typ = typ;
    }

    public Table getT() {
        return this.t;
    }

    public void setT(Table t) {
        this.t = t;
    }

    public Partition getP() {
        return this.p;
    }

    public void setP(Partition p) {
        this.p = p;
    }

    public Path getD() {
        return this.d;
    }

    public void setD(Path d) {
        this.d = d;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getFunctionName() {
        if (this.typ == Type.FUNCTION) {
            return this.stringObject;
        }
        return null;
    }

    public void setFunctionName(String funcName) {
        if (this.typ != Type.FUNCTION) {
            throw new IllegalArgumentException("Set function can't be called on entity if the entity type is not " + Type.FUNCTION);
        }
        this.stringObject = funcName;
    }

    public String getServiceName() {
        if (this.typ == Type.SERVICE_NAME) {
            return this.stringObject;
        }
        return null;
    }

    public Entity() {
        this.name = null;
    }

    public Entity(Database database, boolean complete) {
        this.database = database;
        this.typ = Type.DATABASE;
        this.name = this.computeName();
        this.complete = complete;
    }

    public Entity(String name, Type t) {
        this.stringObject = name;
        this.typ = t;
        this.name = this.computeName();
    }

    public Entity(Table t, boolean complete) {
        this.d = null;
        this.p = null;
        this.t = t;
        this.typ = Type.TABLE;
        this.name = this.computeName();
        this.complete = complete;
    }

    public Entity(Partition p, boolean complete) {
        this.d = null;
        this.p = p;
        this.t = p.getTable();
        this.typ = Type.PARTITION;
        this.name = this.computeName();
        this.complete = complete;
    }

    public Entity(DummyPartition p, boolean complete) {
        this.d = null;
        this.p = p;
        this.t = p.getTable();
        this.typ = Type.DUMMYPARTITION;
        this.name = this.computeName();
        this.complete = complete;
    }

    public Entity(Path d, boolean islocal, boolean complete) {
        this.d = d;
        this.p = null;
        this.t = null;
        this.typ = islocal ? Type.LOCAL_DIR : Type.DFS_DIR;
        this.name = this.computeName();
        this.complete = complete;
    }

    public Entity(Database database, String strObj, String className, Type type) {
        if (type != Type.FUNCTION) {
            throw new IllegalArgumentException("This constructor is supported only for type:" + Type.FUNCTION);
        }
        this.database = database;
        this.stringObject = strObj;
        this.className = className;
        this.typ = type;
        this.complete = true;
        this.name = this.computeName();
    }

    public Map<String, String> getParameters() {
        if (this.p != null) {
            return this.p.getParameters();
        }
        return this.t.getParameters();
    }

    public Type getType() {
        return this.typ;
    }

    public boolean isPathType() {
        return this.typ == Type.DFS_DIR || this.typ == Type.LOCAL_DIR;
    }

    public URI getLocation() throws Exception {
        if (this.typ == Type.DATABASE) {
            String location = this.database.getLocationUri();
            return location == null ? null : new URI(location);
        }
        if (this.typ == Type.TABLE) {
            Path path = this.t.getDataLocation();
            return path == null ? null : path.toUri();
        }
        if (this.typ == Type.PARTITION) {
            Path path = this.p.getDataLocation();
            return path == null ? null : path.toUri();
        }
        if (this.typ == Type.DFS_DIR || this.typ == Type.LOCAL_DIR) {
            return this.d.toUri();
        }
        return null;
    }

    public Partition getPartition() {
        return this.p;
    }

    public Table getTable() {
        return this.t;
    }

    public boolean isDummy() {
        if (this.typ == Type.DATABASE) {
            return this.database.getName().equals("_dummy_database");
        }
        if (this.typ == Type.TABLE) {
            return this.t.isDummyTable();
        }
        return false;
    }

    public String toString() {
        return this.getName();
    }

    private String computeName() {
        return this.doComputeName().intern();
    }

    private String doComputeName() {
        switch (this.typ) {
            case DATABASE: {
                return "database:" + this.database.getName();
            }
            case TABLE: {
                return this.t.getDbName() + "@" + this.t.getTableName();
            }
            case PARTITION: {
                return this.t.getDbName() + "@" + this.t.getTableName() + "@" + this.p.getName();
            }
            case DUMMYPARTITION: {
                return this.p.getName();
            }
            case FUNCTION: {
                if (this.database != null) {
                    return this.database.getName() + "." + this.stringObject;
                }
                return this.stringObject;
            }
            case SERVICE_NAME: {
                return this.stringObject;
            }
        }
        return this.d.toString();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof Entity) {
            Entity ore = (Entity)o;
            return this.getName().equalsIgnoreCase(ore.getName());
        }
        return false;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public static enum Type {
        DATABASE,
        TABLE,
        PARTITION,
        DUMMYPARTITION,
        DFS_DIR,
        LOCAL_DIR,
        FUNCTION,
        SERVICE_NAME;

    }
}

