/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.HiveDriverRunHook;
import org.apache.hadoop.hive.ql.HiveDriverRunHookContext;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.hooks.ExecuteWithHookContext;
import org.apache.hadoop.hive.ql.hooks.Hook;
import org.apache.hadoop.hive.ql.hooks.HookContext;
import org.apache.hadoop.hive.ql.hooks.HookUtils;
import org.apache.hadoop.hive.ql.hooks.MetricsQueryLifeTimeHook;
import org.apache.hadoop.hive.ql.hooks.QueryLifeTimeHook;
import org.apache.hadoop.hive.ql.hooks.QueryLifeTimeHookContextImpl;
import org.apache.hadoop.hive.ql.hooks.QueryLifeTimeHookWithParseHooks;
import org.apache.hadoop.hive.ql.log.PerfLogger;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.HiveSemanticAnalyzerHook;
import org.apache.hadoop.hive.ql.parse.HiveSemanticAnalyzerHookContext;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hive.common.util.HiveStringUtils;

public class HookRunner {
    private static final String CLASS_NAME = Driver.class.getName();
    private final HiveConf conf;
    private SessionState.LogHelper console;
    private List<QueryLifeTimeHook> queryHooks = new ArrayList<QueryLifeTimeHook>();
    private List<HiveSemanticAnalyzerHook> saHooks = new ArrayList<HiveSemanticAnalyzerHook>();
    private List<HiveDriverRunHook> driverRunHooks = new ArrayList<HiveDriverRunHook>();
    private List<ExecuteWithHookContext> preExecHooks = new ArrayList<ExecuteWithHookContext>();
    private List<ExecuteWithHookContext> postExecHooks = new ArrayList<ExecuteWithHookContext>();
    private List<ExecuteWithHookContext> onFailureHooks = new ArrayList<ExecuteWithHookContext>();
    private boolean initialized = false;

    HookRunner(HiveConf conf, SessionState.LogHelper console) {
        this.conf = conf;
        this.console = console;
    }

    public void initialize() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        this.queryHooks.addAll(this.loadHooksFromConf(HiveConf.ConfVars.HIVE_QUERY_LIFETIME_HOOKS, QueryLifeTimeHook.class));
        this.saHooks.addAll(this.loadHooksFromConf(HiveConf.ConfVars.SEMANTIC_ANALYZER_HOOK, HiveSemanticAnalyzerHook.class));
        this.driverRunHooks.addAll(this.loadHooksFromConf(HiveConf.ConfVars.HIVE_DRIVER_RUN_HOOKS, HiveDriverRunHook.class));
        this.preExecHooks.addAll(this.loadHooksFromConf(HiveConf.ConfVars.PREEXECHOOKS, ExecuteWithHookContext.class));
        this.postExecHooks.addAll(this.loadHooksFromConf(HiveConf.ConfVars.POSTEXECHOOKS, ExecuteWithHookContext.class));
        this.onFailureHooks.addAll(this.loadHooksFromConf(HiveConf.ConfVars.ONFAILUREHOOKS, ExecuteWithHookContext.class));
        if (this.conf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_METRICS_ENABLED)) {
            this.queryHooks.add(new MetricsQueryLifeTimeHook());
        }
    }

    private <T extends Hook> List<T> loadHooksFromConf(HiveConf.ConfVars hookConfVar, Class<T> clazz) {
        try {
            return HookUtils.readHooksFromConf(this.conf, hookConfVar);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            String message = "Error loading hooks(" + hookConfVar + "): " + HiveStringUtils.stringifyException(e);
            throw new RuntimeException(message, e);
        }
    }

    void runBeforeParseHook(String command) {
        this.initialize();
        if (!this.queryHooks.isEmpty()) {
            QueryLifeTimeHookContextImpl qhc = new QueryLifeTimeHookContextImpl.Builder().withHiveConf(this.conf).withCommand(command).build();
            for (QueryLifeTimeHook hook : this.queryHooks) {
                if (!(hook instanceof QueryLifeTimeHookWithParseHooks)) continue;
                ((QueryLifeTimeHookWithParseHooks)hook).beforeParse(qhc);
            }
        }
    }

    void runAfterParseHook(String command, boolean parseError) {
        this.initialize();
        if (!this.queryHooks.isEmpty()) {
            QueryLifeTimeHookContextImpl qhc = new QueryLifeTimeHookContextImpl.Builder().withHiveConf(this.conf).withCommand(command).build();
            for (QueryLifeTimeHook hook : this.queryHooks) {
                if (!(hook instanceof QueryLifeTimeHookWithParseHooks)) continue;
                ((QueryLifeTimeHookWithParseHooks)hook).afterParse(qhc, parseError);
            }
        }
    }

    void runBeforeCompileHook(String command) {
        this.initialize();
        if (!this.queryHooks.isEmpty()) {
            QueryLifeTimeHookContextImpl qhc = new QueryLifeTimeHookContextImpl.Builder().withHiveConf(this.conf).withCommand(command).build();
            for (QueryLifeTimeHook hook : this.queryHooks) {
                hook.beforeCompile(qhc);
            }
        }
    }

    void runAfterCompilationHook(String command, boolean compileError) {
        this.initialize();
        if (!this.queryHooks.isEmpty()) {
            QueryLifeTimeHookContextImpl qhc = new QueryLifeTimeHookContextImpl.Builder().withHiveConf(this.conf).withCommand(command).build();
            for (QueryLifeTimeHook hook : this.queryHooks) {
                hook.afterCompile(qhc, compileError);
            }
        }
    }

    void runBeforeExecutionHook(String command, HookContext hookContext) {
        this.initialize();
        if (!this.queryHooks.isEmpty()) {
            QueryLifeTimeHookContextImpl qhc = new QueryLifeTimeHookContextImpl.Builder().withHiveConf(this.conf).withCommand(command).withHookContext(hookContext).build();
            for (QueryLifeTimeHook hook : this.queryHooks) {
                hook.beforeExecution(qhc);
            }
        }
    }

    void runAfterExecutionHook(String command, HookContext hookContext, boolean executionError) {
        this.initialize();
        if (!this.queryHooks.isEmpty()) {
            QueryLifeTimeHookContextImpl qhc = new QueryLifeTimeHookContextImpl.Builder().withHiveConf(this.conf).withCommand(command).withHookContext(hookContext).build();
            for (QueryLifeTimeHook hook : this.queryHooks) {
                hook.afterExecution(qhc, executionError);
            }
        }
    }

    public ASTNode runPreAnalyzeHooks(HiveSemanticAnalyzerHookContext hookCtx, ASTNode tree) throws HiveException {
        this.initialize();
        try {
            for (HiveSemanticAnalyzerHook hook : this.saHooks) {
                tree = hook.preAnalyze(hookCtx, tree);
            }
            return tree;
        }
        catch (HiveException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HiveException("Error while invoking PreAnalyzeHooks:" + HiveStringUtils.stringifyException(e), e);
        }
    }

    public boolean hasPreAnalyzeHooks() {
        return !this.saHooks.isEmpty();
    }

    public void runPostAnalyzeHooks(HiveSemanticAnalyzerHookContext hookCtx, List<Task<? extends Serializable>> allRootTasks) throws HiveException {
        this.initialize();
        try {
            for (HiveSemanticAnalyzerHook hook : this.saHooks) {
                hook.postAnalyze(hookCtx, allRootTasks);
            }
        }
        catch (HiveException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HiveException("Error while invoking PostAnalyzeHooks:" + HiveStringUtils.stringifyException(e), e);
        }
    }

    public void runPreDriverHooks(HiveDriverRunHookContext hookContext) throws HiveException {
        this.initialize();
        try {
            for (HiveDriverRunHook driverRunHook : this.driverRunHooks) {
                driverRunHook.preDriverRun(hookContext);
            }
        }
        catch (HiveException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HiveException("Error while invoking PreDriverHooks:" + HiveStringUtils.stringifyException(e), e);
        }
    }

    public void runPostDriverHooks(HiveDriverRunHookContext hookContext) throws HiveException {
        this.initialize();
        try {
            for (HiveDriverRunHook driverRunHook : this.driverRunHooks) {
                driverRunHook.postDriverRun(hookContext);
            }
        }
        catch (HiveException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HiveException("Error while invoking PostDriverHooks:" + HiveStringUtils.stringifyException(e), e);
        }
    }

    public void runPreHooks(HookContext hookContext) throws HiveException {
        this.initialize();
        HookRunner.invokeGeneralHook(this.preExecHooks, "PreHook.", hookContext);
    }

    public void runPostExecHooks(HookContext hookContext) throws HiveException {
        this.initialize();
        HookRunner.invokeGeneralHook(this.postExecHooks, "PostHook.", hookContext);
    }

    public void runFailureHooks(HookContext hookContext) throws HiveException {
        this.initialize();
        HookRunner.invokeGeneralHook(this.onFailureHooks, "FailureHook.", hookContext);
    }

    private static void invokeGeneralHook(List<ExecuteWithHookContext> hooks, String prefix, HookContext hookContext) throws HiveException {
        if (hooks.isEmpty()) {
            return;
        }
        try {
            PerfLogger perfLogger = SessionState.getPerfLogger();
            for (ExecuteWithHookContext hook : hooks) {
                perfLogger.PerfLogBegin(CLASS_NAME, prefix + hook.getClass().getName());
                hook.run(hookContext);
                perfLogger.PerfLogEnd(CLASS_NAME, prefix + hook.getClass().getName());
            }
        }
        catch (HiveException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HiveException("Error while invoking " + prefix + " hooks: " + HiveStringUtils.stringifyException(e), e);
        }
    }

    public void addLifeTimeHook(QueryLifeTimeHook hook) {
        this.queryHooks.add(hook);
    }

    public void addPreHook(ExecuteWithHookContext hook) {
        this.preExecHooks.add(hook);
    }

    public void addPostHook(ExecuteWithHookContext hook) {
        this.postExecHooks.add(hook);
    }

    public void addOnFailureHook(ExecuteWithHookContext hook) {
        this.onFailureHooks.add(hook);
    }

    public void addSemanticAnalyzerHook(HiveSemanticAnalyzerHook hook) {
        this.saHooks.add(hook);
    }
}

