/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.antlr.runtime.TokenRewriteStream;
import org.antlr.runtime.tree.Tree;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.DriverContext;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.exec.DDLTask;
import org.apache.hadoop.hive.ql.exec.StatsTask;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.hooks.Entity;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveUtils;
import org.apache.hadoop.hive.ql.metadata.InvalidTableException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.metadata.VirtualColumn;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ColumnAccessInfo;
import org.apache.hadoop.hive.ql.parse.ExportSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ParseException;
import org.apache.hadoop.hive.ql.parse.ParseUtils;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.StorageFormat;
import org.apache.hadoop.hive.ql.plan.AlterTableDesc;
import org.apache.hadoop.hive.ql.plan.CreateTableLikeDesc;
import org.apache.hadoop.hive.ql.plan.DDLWork;
import org.apache.hadoop.hive.ql.plan.DropTableDesc;
import org.apache.hadoop.hive.ql.plan.ExportWork;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateDeleteSemanticAnalyzer
extends SemanticAnalyzer {
    private static final Logger LOG = LoggerFactory.getLogger(UpdateDeleteSemanticAnalyzer.class);
    private boolean useSuper = false;
    private Context.Operation currentOperation = Context.Operation.OTHER;
    private static final String Indent = "  ";
    private IdentifierQuoter quotedIdenfierHelper;

    UpdateDeleteSemanticAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    public void analyzeInternal(ASTNode tree) throws SemanticException {
        if (this.useSuper) {
            super.analyzeInternal(tree);
        } else {
            if (!this.getTxnMgr().supportsAcid()) {
                throw new SemanticException(ErrorMsg.ACID_OP_ON_NONACID_TXNMGR.getMsg());
            }
            switch (tree.getToken().getType()) {
                case 808: {
                    this.analyzeDelete(tree);
                    break;
                }
                case 1093: {
                    this.analyzeUpdate(tree);
                    break;
                }
                case 895: {
                    this.analyzeMerge(tree);
                    break;
                }
                case 835: {
                    this.analyzeAcidExport(tree);
                    break;
                }
                default: {
                    throw new RuntimeException("Asked to parse token " + tree.getName() + " in UpdateDeleteSemanticAnalyzer");
                }
            }
            this.cleanUpMetaColumnAccessControl();
        }
    }

    private boolean updating() {
        return this.currentOperation == Context.Operation.UPDATE;
    }

    private boolean deleting() {
        return this.currentOperation == Context.Operation.DELETE;
    }

    public static boolean isAcidExport(ASTNode tree) throws SemanticException {
        assert (tree != null && tree.getToken() != null && tree.getToken().getType() == 835);
        Tree tokTab = tree.getChild(0);
        assert (tokTab != null && tokTab.getType() == 1035);
        Table tableHandle = null;
        try {
            tableHandle = UpdateDeleteSemanticAnalyzer.getTable((ASTNode)tokTab.getChild(0), Hive.get(), false);
        }
        catch (HiveException ex) {
            throw new SemanticException(ex);
        }
        return tableHandle != null && AcidUtils.isFullAcidTable(tableHandle);
    }

    private static String getTmptTableNameForExport(Table exportTable) {
        String tmpTableDb = exportTable.getDbName();
        String tmpTableName = exportTable.getTableName() + "_" + UUID.randomUUID().toString().replace('-', '_');
        return Warehouse.getQualifiedName((String)tmpTableDb, (String)tmpTableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void analyzeAcidExport(ASTNode ast) throws SemanticException {
        Table newTable;
        assert (ast != null && ast.getToken() != null && ast.getToken().getType() == 835);
        ASTNode tableTree = (ASTNode)ast.getChild(0);
        assert (tableTree != null && tableTree.getType() == 1035);
        ASTNode tokRefOrNameExportTable = (ASTNode)tableTree.getChild(0);
        Table exportTable = this.getTargetTable(tokRefOrNameExportTable);
        assert (AcidUtils.isFullAcidTable(exportTable));
        String newTableName = UpdateDeleteSemanticAnalyzer.getTmptTableNameForExport(exportTable);
        HashMap<String, String> tblProps = new HashMap<String, String>();
        tblProps.put("transactional", Boolean.FALSE.toString());
        CreateTableLikeDesc ctlt = new CreateTableLikeDesc(newTableName, false, true, null, null, null, null, null, tblProps, true, Warehouse.getQualifiedName((org.apache.hadoop.hive.metastore.api.Table)exportTable.getTTable()), false);
        try {
            ReadEntity dbForTmpTable = new ReadEntity(this.db.getDatabase(exportTable.getDbName()));
            this.inputs.add(dbForTmpTable);
            DDLTask createTableTask = (DDLTask)TaskFactory.get(new DDLWork(new HashSet<ReadEntity>(), new HashSet<WriteEntity>(), ctlt), this.conf);
            createTableTask.setConf(this.conf);
            createTableTask.execute(new DriverContext(new Context((Configuration)this.conf)));
            newTable = this.db.getTable(newTableName);
        }
        catch (IOException | HiveException ex) {
            throw new SemanticException(ex);
        }
        StringBuilder rewrittenQueryStr = this.generateExportQuery(newTable.getPartCols(), tokRefOrNameExportTable, tableTree, newTableName);
        ReparseResult rr = this.parseRewrittenQuery(rewrittenQueryStr, this.ctx.getCmd());
        Context rewrittenCtx = rr.rewrittenCtx;
        rewrittenCtx.setIsUpdateDeleteMerge(false);
        ASTNode rewrittenTree = rr.rewrittenTree;
        try {
            this.useSuper = true;
            super.analyze(rewrittenTree, rewrittenCtx);
        }
        finally {
            this.useSuper = false;
        }
        this.removeStatsTasks(this.rootTasks);
        Task<ExportWork> exportTask = ExportSemanticAnalyzer.analyzeExport(ast, newTableName, this.db, this.conf, this.inputs, this.outputs);
        AlterTableDesc alterTblDesc = null;
        alterTblDesc = new AlterTableDesc(AlterTableDesc.AlterTableTypes.ADDPROPS);
        HashMap<String, String> mapProps = new HashMap<String, String>();
        mapProps.put("transactional", Boolean.TRUE.toString());
        alterTblDesc.setProps(mapProps);
        alterTblDesc.setOldName(newTableName);
        this.addExportTask(this.rootTasks, exportTask, TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), alterTblDesc)));
        ReplicationSpec replicationSpec = new ReplicationSpec();
        DropTableDesc dropTblDesc = new DropTableDesc(newTableName, TableType.MANAGED_TABLE, false, true, replicationSpec);
        Task<DDLWork> dropTask = TaskFactory.get(new DDLWork(new HashSet<ReadEntity>(), new HashSet<WriteEntity>(), dropTblDesc), this.conf);
        exportTask.addDependentTask(dropTask);
        this.markReadEntityForUpdate();
        if (this.ctx.isExplainPlan()) {
            try {
                this.db.dropTable(newTable.getDbName(), newTable.getTableName(), true, true, true);
            }
            catch (HiveException ex) {
                LOG.warn("Unable to drop " + newTableName + " due to: " + ex.getMessage(), (Throwable)ex);
            }
        }
    }

    private StringBuilder generateExportQuery(List<FieldSchema> partCols, ASTNode tokRefOrNameExportTable, ASTNode tableTree, String newTableName) throws SemanticException {
        StringBuilder rewrittenQueryStr = new StringBuilder("insert into ").append(newTableName);
        this.addPartitionColsToInsert(partCols, rewrittenQueryStr);
        rewrittenQueryStr.append(" select * from ").append(this.getFullTableNameForSQL(tokRefOrNameExportTable));
        BaseSemanticAnalyzer.TableSpec exportTableSpec = new BaseSemanticAnalyzer.TableSpec(this.db, this.conf, tableTree, false, true);
        if (exportTableSpec.getPartSpec() != null) {
            StringBuilder whereClause = null;
            int partColsIdx = -1;
            for (Map.Entry<String, String> ent : exportTableSpec.getPartSpec().entrySet()) {
                ++partColsIdx;
                if (ent.getValue() == null) continue;
                if (whereClause == null) {
                    whereClause = new StringBuilder(" WHERE ");
                }
                if (whereClause.length() > " WHERE ".length()) {
                    whereClause.append(" AND ");
                }
                whereClause.append(HiveUtils.unparseIdentifier(ent.getKey(), (Configuration)this.conf)).append(" = ").append(this.genPartValueString(partCols.get(partColsIdx).getType(), ent.getValue()));
            }
            if (whereClause != null) {
                rewrittenQueryStr.append((CharSequence)whereClause);
            }
        }
        return rewrittenQueryStr;
    }

    private void addExportTask(List<Task<? extends Serializable>> rootTasks, Task<ExportWork> exportTask, Task<DDLWork> alterTable) {
        for (Task<? extends Serializable> t : rootTasks) {
            if (t.getNumChild() <= 0) {
                t.addDependentTask(alterTable);
                alterTable.addDependentTask(exportTask);
                continue;
            }
            this.addExportTask(t.getDependentTasks(), exportTask, alterTable);
        }
    }

    private List<Task<? extends Serializable>> findStatsTasks(List<Task<? extends Serializable>> rootTasks, List<Task<? extends Serializable>> statsTasks) {
        for (Task<? extends Serializable> t : rootTasks) {
            if (t instanceof StatsTask) {
                if (statsTasks == null) {
                    statsTasks = new ArrayList<Task<? extends Serializable>>();
                }
                statsTasks.add(t);
            }
            if (t.getDependentTasks() == null) continue;
            statsTasks = this.findStatsTasks(t.getDependentTasks(), statsTasks);
        }
        return statsTasks;
    }

    private void removeStatsTasks(List<Task<? extends Serializable>> rootTasks) {
        List<Task<? extends Serializable>> statsTasks = this.findStatsTasks(rootTasks, null);
        if (statsTasks == null) {
            return;
        }
        for (Task<? extends Serializable> statsTask : statsTasks) {
            if (statsTask.getParentTasks() == null) continue;
            for (Task<Serializable> t : new ArrayList<Task<Serializable>>(statsTask.getParentTasks())) {
                t.removeDependentTask(statsTask);
            }
        }
    }

    private void analyzeUpdate(ASTNode tree) throws SemanticException {
        this.currentOperation = Context.Operation.UPDATE;
        this.reparseAndSuperAnalyze(tree);
    }

    private void analyzeDelete(ASTNode tree) throws SemanticException {
        this.currentOperation = Context.Operation.DELETE;
        this.reparseAndSuperAnalyze(tree);
    }

    private void addPartitionColsToSelect(List<FieldSchema> partCols, StringBuilder rewrittenQueryStr, ASTNode target) throws SemanticException {
        String targetName;
        String string = targetName = target != null ? this.getSimpleTableName(target) : null;
        if (partCols != null) {
            for (FieldSchema fschema : partCols) {
                rewrittenQueryStr.append(", ");
                if (targetName != null) {
                    rewrittenQueryStr.append(targetName).append('.');
                }
                rewrittenQueryStr.append(HiveUtils.unparseIdentifier(fschema.getName(), (Configuration)this.conf));
            }
        }
    }

    private void checkValidSetClauseTarget(ASTNode colName, Table targetTable) throws SemanticException {
        String columnName = UpdateDeleteSemanticAnalyzer.normalizeColName(colName.getText());
        for (FieldSchema fschema : targetTable.getPartCols()) {
            if (!fschema.getName().equalsIgnoreCase(columnName)) continue;
            throw new SemanticException(ErrorMsg.UPDATE_CANNOT_UPDATE_PART_VALUE.getMsg());
        }
        if (targetTable.getBucketCols() != null && targetTable.getBucketCols().contains(columnName)) {
            throw new SemanticException(ErrorMsg.UPDATE_CANNOT_UPDATE_BUCKET_VALUE, columnName);
        }
        boolean foundColumnInTargetTable = false;
        for (FieldSchema col : targetTable.getCols()) {
            if (!columnName.equalsIgnoreCase(col.getName())) continue;
            foundColumnInTargetTable = true;
            break;
        }
        if (!foundColumnInTargetTable) {
            throw new SemanticException(ErrorMsg.INVALID_TARGET_COLUMN_IN_SET_CLAUSE, colName.getText(), targetTable.getFullyQualifiedName());
        }
    }

    private ASTNode findLHSofAssignment(ASTNode assignment) {
        assert (assignment.getToken().getType() == 18) : "Expected set assignments to use equals operator but found " + assignment.getName();
        ASTNode tableOrColTok = (ASTNode)((ArrayList)assignment.getChildren()).get(0);
        assert (tableOrColTok.getToken().getType() == 1060) : "Expected left side of assignment to be table or column";
        ASTNode colName = (ASTNode)((ArrayList)tableOrColTok.getChildren()).get(0);
        assert (colName.getToken().getType() == 24) : "Expected column name";
        return colName;
    }

    private Map<String, ASTNode> collectSetColumnsAndExpressions(ASTNode setClause, Set<String> setRCols, Table targetTable) throws SemanticException {
        assert (setClause.getToken().getType() == 994) : "Expected second child of update token to be set token";
        List assignments = setClause.getChildren();
        LinkedHashMap<String, ASTNode> setCols = new LinkedHashMap<String, ASTNode>(assignments.size());
        for (Node a : assignments) {
            ASTNode assignment = (ASTNode)a;
            ASTNode colName = this.findLHSofAssignment(assignment);
            if (setRCols != null) {
                this.addSetRCols((ASTNode)((ArrayList)assignment.getChildren()).get(1), setRCols);
            }
            this.checkValidSetClauseTarget(colName, targetTable);
            String columnName = UpdateDeleteSemanticAnalyzer.normalizeColName(colName.getText());
            setCols.put(columnName, (ASTNode)((ArrayList)assignment.getChildren()).get(1));
        }
        return setCols;
    }

    private Table getTargetTable(ASTNode tabRef) throws SemanticException {
        return UpdateDeleteSemanticAnalyzer.getTable(tabRef, this.db, true);
    }

    private static Table getTable(ASTNode tabRef, Hive db, boolean throwException) throws SemanticException {
        Table mTable;
        String[] tableName;
        switch (tabRef.getType()) {
            case 1064: {
                tableName = UpdateDeleteSemanticAnalyzer.getQualifiedTableName((ASTNode)tabRef.getChild(0));
                break;
            }
            case 1063: {
                tableName = UpdateDeleteSemanticAnalyzer.getQualifiedTableName(tabRef);
                break;
            }
            default: {
                throw UpdateDeleteSemanticAnalyzer.raiseWrongType("TOK_TABREF|TOK_TABNAME", tabRef);
            }
        }
        try {
            mTable = db.getTable(tableName[0], tableName[1], throwException);
        }
        catch (InvalidTableException e) {
            LOG.error("Failed to find table " + UpdateDeleteSemanticAnalyzer.getDotName(tableName) + " got exception " + e.getMessage());
            throw new SemanticException(ErrorMsg.INVALID_TABLE.getMsg(UpdateDeleteSemanticAnalyzer.getDotName(tableName)), e);
        }
        catch (HiveException e) {
            LOG.error("Failed to find table " + UpdateDeleteSemanticAnalyzer.getDotName(tableName) + " got exception " + e.getMessage());
            throw new SemanticException(e.getMessage(), e);
        }
        return mTable;
    }

    private void markReadEntityForUpdate() {
        for (ReadEntity input : this.inputs) {
            if (!this.isWritten(input)) continue;
            input.setUpdateOrDelete(true);
        }
    }

    private void setUpAccessControlInfoForUpdate(Table mTable, Map<String, ASTNode> setCols) {
        ColumnAccessInfo cai = new ColumnAccessInfo();
        for (String colName : setCols.keySet()) {
            cai.add(Table.getCompleteName(mTable.getDbName(), mTable.getTableName()), colName);
        }
        this.setUpdateColumnAccessInfo(cai);
    }

    private void cleanUpMetaColumnAccessControl() {
        if (this.columnAccessInfo != null) {
            this.columnAccessInfo.stripVirtualColumn(VirtualColumn.ROWID);
        }
    }

    private ReparseResult parseRewrittenQuery(StringBuilder rewrittenQueryStr, String originalQuery) throws SemanticException {
        ASTNode rewrittenTree;
        Context rewrittenCtx;
        HiveConf.setVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.DYNAMICPARTITIONINGMODE, (String)"nonstrict");
        HiveConf.setBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_IO_ROW_WRAPPER_ENABLED, (boolean)false);
        try {
            rewrittenCtx = new Context((Configuration)this.conf);
            rewrittenCtx.setHDFSCleanup(true);
            this.ctx.addRewrittenStatementContext(rewrittenCtx);
        }
        catch (IOException e) {
            throw new SemanticException(ErrorMsg.UPDATEDELETE_IO_ERROR.getMsg());
        }
        rewrittenCtx.setExplainConfig(this.ctx.getExplainConfig());
        rewrittenCtx.setExplainPlan(this.ctx.isExplainPlan());
        rewrittenCtx.setIsUpdateDeleteMerge(true);
        rewrittenCtx.setCmd(rewrittenQueryStr.toString());
        try {
            LOG.info("Going to reparse <" + originalQuery + "> as \n<" + rewrittenQueryStr.toString() + ">");
            rewrittenTree = ParseUtils.parse(rewrittenQueryStr.toString(), rewrittenCtx, this.conf);
        }
        catch (ParseException e) {
            throw new SemanticException(ErrorMsg.UPDATEDELETE_PARSE_ERROR.getMsg(), e);
        }
        return new ReparseResult(rewrittenTree, rewrittenCtx);
    }

    private void validateTargetTable(Table mTable) throws SemanticException {
        if (mTable.getTableType() == TableType.VIRTUAL_VIEW || mTable.getTableType() == TableType.MATERIALIZED_VIEW) {
            LOG.error("Table " + mTable.getFullyQualifiedName() + " is a view or materialized view");
            throw new SemanticException(ErrorMsg.UPDATE_DELETE_VIEW.getMsg());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reparseAndSuperAnalyze(ASTNode tree) throws SemanticException {
        int whereIndex;
        List children = tree.getChildren();
        ASTNode tabName = (ASTNode)children.get(0);
        assert (tabName.getToken().getType() == 1063) : "Expected tablename as first child of " + this.operation() + " but found " + tabName.getName();
        StringBuilder rewrittenQueryStr = new StringBuilder();
        Table mTable = this.getTargetTable(tabName);
        this.validateTargetTable(mTable);
        rewrittenQueryStr.append("insert into table ");
        rewrittenQueryStr.append(this.getFullTableNameForSQL(tabName));
        this.addPartitionColsToInsert(mTable.getPartCols(), rewrittenQueryStr);
        rewrittenQueryStr.append(" select ROW__ID");
        HashMap<Integer, ASTNode> setColExprs = null;
        Map<String, ASTNode> setCols = null;
        LinkedHashSet<String> setRCols = new LinkedHashSet<String>();
        if (this.updating()) {
            assert (children.size() >= 2) : "Expected update token to have at least two children";
            ASTNode setClause = (ASTNode)children.get(1);
            setCols = this.collectSetColumnsAndExpressions(setClause, setRCols, mTable);
            setColExprs = new HashMap<Integer, ASTNode>(setClause.getChildCount());
            List<FieldSchema> nonPartCols = mTable.getCols();
            for (int i = 0; i < nonPartCols.size(); ++i) {
                rewrittenQueryStr.append(',');
                String name = nonPartCols.get(i).getName();
                ASTNode setCol = setCols.get(name);
                rewrittenQueryStr.append(HiveUtils.unparseIdentifier(name, (Configuration)this.conf));
                if (setCol == null) continue;
                setColExprs.put(i + 1, setCol);
            }
        }
        this.addPartitionColsToSelect(mTable.getPartCols(), rewrittenQueryStr, null);
        rewrittenQueryStr.append(" from ");
        rewrittenQueryStr.append(this.getFullTableNameForSQL(tabName));
        ASTNode where = null;
        int n = whereIndex = this.deleting() ? 1 : 2;
        if (children.size() > whereIndex) {
            where = (ASTNode)children.get(whereIndex);
            assert (where.getToken().getType() == 1101) : "Expected where clause, but found " + where.getName();
        }
        rewrittenQueryStr.append(" sort by ROW__ID ");
        ReparseResult rr = this.parseRewrittenQuery(rewrittenQueryStr, this.ctx.getCmd());
        Context rewrittenCtx = rr.rewrittenCtx;
        ASTNode rewrittenTree = rr.rewrittenTree;
        ASTNode rewrittenInsert = (ASTNode)((ArrayList)rewrittenTree.getChildren()).get(1);
        assert (rewrittenInsert.getToken().getType() == 861) : "Expected TOK_INSERT as second child of TOK_QUERY but found " + rewrittenInsert.getName();
        if (this.updating()) {
            rewrittenCtx.setOperation(Context.Operation.UPDATE);
            rewrittenCtx.addDestNamePrefix(1, Context.DestClausePrefix.UPDATE);
        } else if (this.deleting()) {
            rewrittenCtx.setOperation(Context.Operation.DELETE);
            rewrittenCtx.addDestNamePrefix(1, Context.DestClausePrefix.DELETE);
        }
        if (where != null) {
            ASTNode sortBy = (ASTNode)((ArrayList)rewrittenInsert.getChildren()).get(2);
            assert (sortBy.getToken().getType() == 1021) : "Expected TOK_SORTBY to be first child of TOK_SELECT, but found " + sortBy.getName();
            rewrittenInsert.addChild((Tree)sortBy);
            rewrittenInsert.setChild(2, (Tree)where);
        }
        if (this.updating() && setColExprs != null) {
            ASTNode rewrittenSelect = (ASTNode)((ArrayList)rewrittenInsert.getChildren()).get(1);
            assert (rewrittenSelect.getToken().getType() == 985) : "Expected TOK_SELECT as second child of TOK_INSERT but found " + rewrittenSelect.getName();
            for (Map.Entry entry : setColExprs.entrySet()) {
                ASTNode selExpr = (ASTNode)((ArrayList)rewrittenSelect.getChildren()).get((Integer)entry.getKey());
                assert (selExpr.getToken().getType() == 987) : "Expected child of TOK_SELECT to be TOK_SELEXPR but was " + selExpr.getName();
                selExpr.setChild(0, (Tree)entry.getValue());
            }
        }
        try {
            this.useSuper = true;
            super.analyze(rewrittenTree, rewrittenCtx);
        }
        finally {
            this.useSuper = false;
        }
        this.updateOutputs(mTable);
        if (this.updating()) {
            this.setUpAccessControlInfoForUpdate(mTable, setCols);
            for (String colName : setRCols) {
                if (this.columnAccessInfo == null) continue;
                this.columnAccessInfo.add(Table.getCompleteName(mTable.getDbName(), mTable.getTableName()), colName);
            }
        }
    }

    private boolean isWritten(Entity readEntity) {
        for (Entity writeEntity : this.outputs) {
            if (!writeEntity.toString().equalsIgnoreCase(readEntity.toString())) continue;
            return true;
        }
        return false;
    }

    private String operation() {
        if (this.currentOperation == Context.Operation.OTHER) {
            throw new IllegalStateException("UpdateDeleteSemanticAnalyzer neither updating nor deleting, operation not known.");
        }
        return this.currentOperation.toString();
    }

    private void addSetRCols(ASTNode node, Set<String> setRCols) {
        if (node.getToken().getType() == 1060) {
            ASTNode colName = (ASTNode)((ArrayList)node.getChildren()).get(0);
            assert (colName.getToken().getType() == 24) : "Expected column name";
            setRCols.add(UpdateDeleteSemanticAnalyzer.normalizeColName(colName.getText()));
        } else if (node.getChildren() != null) {
            for (Node n : node.getChildren()) {
                this.addSetRCols((ASTNode)n, setRCols);
            }
        }
    }

    private static String normalizeColName(String colName) {
        return colName.toLowerCase();
    }

    private String getMatchedText(ASTNode n) {
        this.quotedIdenfierHelper.visit(n);
        return this.ctx.getTokenRewriteStream().toString(n.getTokenStartIndex(), n.getTokenStopIndex() + 1).trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void analyzeMerge(ASTNode tree) throws SemanticException {
        this.currentOperation = Context.Operation.MERGE;
        this.quotedIdenfierHelper = new IdentifierQuoter(this.ctx.getTokenRewriteStream());
        ASTNode target = (ASTNode)tree.getChild(0);
        ASTNode source = (ASTNode)tree.getChild(1);
        String targetName = this.getSimpleTableName(target);
        String sourceName = this.getSimpleTableName(source);
        ASTNode onClause = (ASTNode)tree.getChild(2);
        String onClauseAsText = this.getMatchedText(onClause);
        Table targetTable = this.getTargetTable(target);
        this.validateTargetTable(targetTable);
        List<ASTNode> whenClauses = this.findWhenClauses(tree);
        StringBuilder rewrittenQueryStr = new StringBuilder("FROM\n");
        rewrittenQueryStr.append(Indent).append(this.getFullTableNameForSQL(target));
        if (this.isAliased(target)) {
            rewrittenQueryStr.append(" ").append(targetName);
        }
        rewrittenQueryStr.append('\n');
        rewrittenQueryStr.append(Indent).append(this.chooseJoinType(whenClauses)).append("\n");
        if (source.getType() == 1028) {
            rewrittenQueryStr.append(Indent).append(this.getMatchedText(source));
        } else {
            rewrittenQueryStr.append(Indent).append(this.getFullTableNameForSQL(source));
            if (this.isAliased(source)) {
                rewrittenQueryStr.append(" ").append(sourceName);
            }
        }
        rewrittenQueryStr.append('\n');
        rewrittenQueryStr.append(Indent).append("ON ").append(onClauseAsText).append('\n');
        String extraPredicate = null;
        int numWhenMatchedUpdateClauses = 0;
        int numWhenMatchedDeleteClauses = 0;
        int numInsertClauses = 0;
        for (ASTNode whenClause : whenClauses) {
            switch (this.getWhenClauseOperation(whenClause).getType()) {
                case 861: {
                    ++numInsertClauses;
                    this.handleInsert(whenClause, rewrittenQueryStr, target, onClause, targetTable, targetName, onClauseAsText);
                    break;
                }
                case 1092: {
                    String s = this.handleUpdate(whenClause, rewrittenQueryStr, target, onClauseAsText, targetTable, extraPredicate);
                    if (++numWhenMatchedUpdateClauses + numWhenMatchedDeleteClauses != 1) break;
                    extraPredicate = s;
                    break;
                }
                case 807: {
                    String s1 = this.handleDelete(whenClause, rewrittenQueryStr, target, onClauseAsText, targetTable, extraPredicate);
                    if (numWhenMatchedUpdateClauses + ++numWhenMatchedDeleteClauses != 1) break;
                    extraPredicate = s1;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected WHEN clause type: " + whenClause.getType() + UpdateDeleteSemanticAnalyzer.addParseInfo(whenClause));
                }
            }
            if (numWhenMatchedDeleteClauses > 1) {
                throw new SemanticException(ErrorMsg.MERGE_TOO_MANY_DELETE, this.ctx.getCmd());
            }
            if (numWhenMatchedUpdateClauses > 1) {
                throw new SemanticException(ErrorMsg.MERGE_TOO_MANY_UPDATE, this.ctx.getCmd());
            }
            assert (numInsertClauses < 2) : "too many Insert clauses";
        }
        if (numWhenMatchedDeleteClauses + numWhenMatchedUpdateClauses == 2 && extraPredicate == null) {
            throw new SemanticException(ErrorMsg.MERGE_PREDIACTE_REQUIRED, this.ctx.getCmd());
        }
        boolean validating = this.handleCardinalityViolation(rewrittenQueryStr, target, onClauseAsText, targetTable, numWhenMatchedDeleteClauses == 0 && numWhenMatchedUpdateClauses == 0);
        ReparseResult rr = this.parseRewrittenQuery(rewrittenQueryStr, this.ctx.getCmd());
        Context rewrittenCtx = rr.rewrittenCtx;
        ASTNode rewrittenTree = rr.rewrittenTree;
        rewrittenCtx.setOperation(Context.Operation.MERGE);
        int insClauseIdx = 1;
        int whenClauseIdx = 0;
        while (insClauseIdx < rewrittenTree.getChildCount() - (validating ? 1 : 0)) {
            ASTNode insertClause = (ASTNode)rewrittenTree.getChild(insClauseIdx);
            switch (this.getWhenClauseOperation(whenClauses.get(whenClauseIdx)).getType()) {
                case 861: {
                    rewrittenCtx.addDestNamePrefix(insClauseIdx, Context.DestClausePrefix.INSERT);
                    break;
                }
                case 1092: {
                    rewrittenCtx.addDestNamePrefix(insClauseIdx, Context.DestClausePrefix.UPDATE);
                    break;
                }
                case 807: {
                    rewrittenCtx.addDestNamePrefix(insClauseIdx, Context.DestClausePrefix.DELETE);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            ++insClauseIdx;
            ++whenClauseIdx;
        }
        if (validating) {
            rewrittenCtx.addDestNamePrefix(rewrittenTree.getChildCount() - 1, Context.DestClausePrefix.INSERT);
        }
        try {
            this.useSuper = true;
            super.analyze(rewrittenTree, rewrittenCtx);
        }
        finally {
            this.useSuper = false;
        }
        this.updateOutputs(targetTable);
    }

    private void updateOutputs(Table targetTable) {
        List<ReadEntity> partitionsRead;
        this.markReadEntityForUpdate();
        if (targetTable.isPartitioned() && !(partitionsRead = this.getRestrictedPartitionSet(targetTable)).isEmpty()) {
            ArrayList<WriteEntity> toRemove = new ArrayList<WriteEntity>();
            for (WriteEntity we : this.outputs) {
                WriteEntity.WriteType wt = we.getWriteType();
                if (!this.isTargetTable(we, targetTable) || wt != WriteEntity.WriteType.UPDATE && wt != WriteEntity.WriteType.DELETE) continue;
                toRemove.add(we);
            }
            this.outputs.removeAll(toRemove);
            for (ReadEntity re : partitionsRead) {
                for (WriteEntity original : toRemove) {
                    WriteEntity we = new WriteEntity(re.getPartition(), original.getWriteType());
                    we.setDynamicPartitionWrite(original.isDynamicPartitionWrite());
                    this.outputs.add(we);
                }
            }
        }
    }

    private List<ReadEntity> getRestrictedPartitionSet(Table targetTable) {
        ArrayList<ReadEntity> partitionsRead = new ArrayList<ReadEntity>();
        for (ReadEntity re : this.inputs) {
            if (!re.isFromTopLevelQuery || re.getType() != Entity.Type.PARTITION || !this.isTargetTable(re, targetTable)) continue;
            partitionsRead.add(re);
        }
        return partitionsRead;
    }

    private String chooseJoinType(List<ASTNode> whenClauses) {
        for (ASTNode whenClause : whenClauses) {
            if (this.getWhenClauseOperation(whenClause).getType() != 861) continue;
            return "RIGHT OUTER JOIN";
        }
        return "INNER JOIN";
    }

    private boolean isTargetTable(Entity entity, Table targetTable) {
        return targetTable.equals(entity.getTable());
    }

    private boolean handleCardinalityViolation(StringBuilder rewrittenQueryStr, ASTNode target, String onClauseAsString, Table targetTable, boolean onlyHaveWhenNotMatchedClause) throws SemanticException {
        if (!this.conf.getBoolVar(HiveConf.ConfVars.MERGE_CARDINALITY_VIOLATION_CHECK)) {
            LOG.info("Merge statement cardinality violation check is disabled: " + HiveConf.ConfVars.MERGE_CARDINALITY_VIOLATION_CHECK.varname);
            return false;
        }
        if (onlyHaveWhenNotMatchedClause) {
            return false;
        }
        String tableName = "merge_tmp_table";
        rewrittenQueryStr.append("\nINSERT INTO ").append(tableName).append("\n  SELECT cardinality_violation(").append(this.getSimpleTableName(target)).append(".ROW__ID");
        this.addPartitionColsToSelect(targetTable.getPartCols(), rewrittenQueryStr, target);
        rewrittenQueryStr.append(")\n WHERE ").append(onClauseAsString).append(" GROUP BY ").append(this.getSimpleTableName(target)).append(".ROW__ID");
        this.addPartitionColsToSelect(targetTable.getPartCols(), rewrittenQueryStr, target);
        rewrittenQueryStr.append(" HAVING count(*) > 1");
        try {
            if (null == this.db.getTable(tableName, false)) {
                StorageFormat format = new StorageFormat((Configuration)this.conf);
                format.processStorageFormat("TextFile");
                Table table = this.db.newTable(tableName);
                table.setSerializationLib(format.getSerde());
                ArrayList<FieldSchema> fields = new ArrayList<FieldSchema>();
                fields.add(new FieldSchema("val", "int", null));
                table.setFields(fields);
                table.setDataLocation(Warehouse.getDnsPath((Path)new Path(SessionState.get().getTempTableSpace(), tableName), (Configuration)this.conf));
                table.getTTable().setTemporary(true);
                table.setStoredAsSubDirectories(false);
                table.setInputFormatClass(format.getInputFormat());
                table.setOutputFormatClass(format.getOutputFormat());
                this.db.createTable(table, true);
            }
        }
        catch (MetaException | HiveException e) {
            throw new SemanticException(e.getMessage(), e);
        }
        return true;
    }

    private String handleUpdate(ASTNode whenMatchedUpdateClause, StringBuilder rewrittenQueryStr, ASTNode target, String onClauseAsString, Table targetTable, String deleteExtraPredicate) throws SemanticException {
        assert (whenMatchedUpdateClause.getType() == 894);
        assert (this.getWhenClauseOperation(whenMatchedUpdateClause).getType() == 1092);
        String targetName = this.getSimpleTableName(target);
        rewrittenQueryStr.append("INSERT INTO ").append(this.getFullTableNameForSQL(target));
        this.addPartitionColsToInsert(targetTable.getPartCols(), rewrittenQueryStr);
        rewrittenQueryStr.append("    -- update clause\n select ").append(targetName).append(".ROW__ID");
        ASTNode setClause = (ASTNode)this.getWhenClauseOperation(whenMatchedUpdateClause).getChild(0);
        Map<String, ASTNode> setColsExprs = this.collectSetColumnsAndExpressions(setClause, null, targetTable);
        List<FieldSchema> nonPartCols = targetTable.getCols();
        for (FieldSchema fs : nonPartCols) {
            rewrittenQueryStr.append(", ");
            String name = fs.getName();
            if (setColsExprs.containsKey(name)) {
                String rhsExp = this.getMatchedText(setColsExprs.get(name));
                switch (rhsExp.charAt(rhsExp.length() - 1)) {
                    case '\n': 
                    case ',': {
                        rhsExp = rhsExp.substring(0, rhsExp.length() - 1);
                    }
                }
                rewrittenQueryStr.append(rhsExp);
                continue;
            }
            rewrittenQueryStr.append(this.getSimpleTableName(target)).append(".").append(HiveUtils.unparseIdentifier(name, (Configuration)this.conf));
        }
        this.addPartitionColsToSelect(targetTable.getPartCols(), rewrittenQueryStr, target);
        rewrittenQueryStr.append("\n   WHERE ").append(onClauseAsString);
        String extraPredicate = this.getWhenClausePredicate(whenMatchedUpdateClause);
        if (extraPredicate != null) {
            rewrittenQueryStr.append(" AND ").append(extraPredicate);
        }
        if (deleteExtraPredicate != null) {
            rewrittenQueryStr.append(" AND NOT(").append(deleteExtraPredicate).append(")");
        }
        rewrittenQueryStr.append("\n sort by ");
        rewrittenQueryStr.append(targetName).append(".ROW__ID \n");
        this.setUpAccessControlInfoForUpdate(targetTable, setColsExprs);
        return extraPredicate;
    }

    private String handleDelete(ASTNode whenMatchedDeleteClause, StringBuilder rewrittenQueryStr, ASTNode target, String onClauseAsString, Table targetTable, String updateExtraPredicate) throws SemanticException {
        assert (whenMatchedDeleteClause.getType() == 894);
        assert (this.getWhenClauseOperation(whenMatchedDeleteClause).getType() == 807);
        List<FieldSchema> partCols = targetTable.getPartCols();
        String targetName = this.getSimpleTableName(target);
        rewrittenQueryStr.append("INSERT INTO ").append(this.getFullTableNameForSQL(target));
        this.addPartitionColsToInsert(partCols, rewrittenQueryStr);
        rewrittenQueryStr.append("    -- delete clause\n select ").append(targetName).append(".ROW__ID ");
        this.addPartitionColsToSelect(partCols, rewrittenQueryStr, target);
        rewrittenQueryStr.append("\n   WHERE ").append(onClauseAsString);
        String extraPredicate = this.getWhenClausePredicate(whenMatchedDeleteClause);
        if (extraPredicate != null) {
            rewrittenQueryStr.append(" AND ").append(extraPredicate);
        }
        if (updateExtraPredicate != null) {
            rewrittenQueryStr.append(" AND NOT(").append(updateExtraPredicate).append(")");
        }
        rewrittenQueryStr.append("\n sort by ");
        rewrittenQueryStr.append(targetName).append(".ROW__ID \n");
        return extraPredicate;
    }

    private static String addParseInfo(ASTNode n) {
        return " at " + ErrorMsg.renderPosition(n);
    }

    private String getSimpleTableName(ASTNode n) throws SemanticException {
        return HiveUtils.unparseIdentifier(this.getSimpleTableNameBase(n), (Configuration)this.conf);
    }

    private String getSimpleTableNameBase(ASTNode n) throws SemanticException {
        switch (n.getType()) {
            case 1064: {
                int aliasIndex = this.findTabRefIdxs(n)[0];
                if (aliasIndex != 0) {
                    return n.getChild(aliasIndex).getText();
                }
                return this.getSimpleTableNameBase((ASTNode)n.getChild(0));
            }
            case 1063: {
                if (n.getChildCount() == 2) {
                    return n.getChild(1).getText();
                }
                return n.getChild(0).getText();
            }
            case 1028: {
                return n.getChild(1).getText();
            }
        }
        throw UpdateDeleteSemanticAnalyzer.raiseWrongType("TOK_TABREF|TOK_TABNAME|TOK_SUBQUERY", n);
    }

    private boolean isAliased(ASTNode n) {
        switch (n.getType()) {
            case 1064: {
                return this.findTabRefIdxs(n)[0] != 0;
            }
            case 1063: {
                return false;
            }
            case 1028: {
                assert (n.getChildCount() > 1) : "Expected Derived Table to be aliased";
                return true;
            }
        }
        throw UpdateDeleteSemanticAnalyzer.raiseWrongType("TOK_TABREF|TOK_TABNAME", n);
    }

    private List<ASTNode> findWhenClauses(ASTNode tree) throws SemanticException {
        assert (tree.getType() == 895);
        ArrayList<ASTNode> whenClauses = new ArrayList<ASTNode>();
        for (int idx = 3; idx < tree.getChildCount(); ++idx) {
            ASTNode whenClause = (ASTNode)tree.getChild(idx);
            assert (whenClause.getType() == 894 || whenClause.getType() == 900) : "Unexpected node type found: " + whenClause.getType() + UpdateDeleteSemanticAnalyzer.addParseInfo(whenClause);
            whenClauses.add(whenClause);
        }
        if (whenClauses.size() <= 0) {
            throw new SemanticException("Must have at least 1 WHEN clause in MERGE statement");
        }
        return whenClauses;
    }

    private ASTNode getWhenClauseOperation(ASTNode whenClause) {
        if (whenClause.getType() != 894 && whenClause.getType() != 900) {
            throw UpdateDeleteSemanticAnalyzer.raiseWrongType("Expected TOK_MATCHED|TOK_NOT_MATCHED", whenClause);
        }
        return (ASTNode)whenClause.getChild(0);
    }

    private String getWhenClausePredicate(ASTNode whenClause) {
        if (whenClause.getType() != 894 && whenClause.getType() != 900) {
            throw UpdateDeleteSemanticAnalyzer.raiseWrongType("Expected TOK_MATCHED|TOK_NOT_MATCHED", whenClause);
        }
        if (whenClause.getChildCount() == 2) {
            return this.getMatchedText((ASTNode)whenClause.getChild(1));
        }
        return null;
    }

    private void handleInsert(ASTNode whenNotMatchedClause, StringBuilder rewrittenQueryStr, ASTNode target, ASTNode onClause, Table targetTable, String targetTableNameInSourceQuery, String onClauseAsString) throws SemanticException {
        assert (whenNotMatchedClause.getType() == 900);
        assert (this.getWhenClauseOperation(whenNotMatchedClause).getType() == 861);
        List<FieldSchema> partCols = targetTable.getPartCols();
        String valuesClause = this.getMatchedText((ASTNode)this.getWhenClauseOperation(whenNotMatchedClause).getChild(0));
        valuesClause = valuesClause.substring(1, valuesClause.length() - 1);
        valuesClause = SemanticAnalyzer.replaceDefaultKeywordForMerge(valuesClause, targetTable);
        rewrittenQueryStr.append("INSERT INTO ").append(this.getFullTableNameForSQL(target));
        this.addPartitionColsToInsert(partCols, rewrittenQueryStr);
        OnClauseAnalyzer oca = new OnClauseAnalyzer(onClause, targetTable, targetTableNameInSourceQuery, this.conf, onClauseAsString);
        oca.analyze();
        rewrittenQueryStr.append("    -- insert clause\n  select ").append(valuesClause).append("\n   WHERE ").append(oca.getPredicate());
        String extraPredicate = this.getWhenClausePredicate(whenNotMatchedClause);
        if (extraPredicate != null) {
            rewrittenQueryStr.append(" AND ").append(this.getMatchedText((ASTNode)whenNotMatchedClause.getChild(1))).append('\n');
        }
    }

    private static final class OnClauseAnalyzer {
        private final ASTNode onClause;
        private final Map<String, List<String>> table2column = new HashMap<String, List<String>>();
        private final List<String> unresolvedColumns = new ArrayList<String>();
        private final List<FieldSchema> allTargetTableColumns = new ArrayList<FieldSchema>();
        private final Set<String> tableNamesFound = new HashSet<String>();
        private final String targetTableNameInSourceQuery;
        private final HiveConf conf;
        private final String onClauseAsString;

        OnClauseAnalyzer(ASTNode onClause, Table targetTable, String targetTableNameInSourceQuery, HiveConf conf, String onClauseAsString) {
            this.onClause = onClause;
            this.allTargetTableColumns.addAll(targetTable.getCols());
            this.allTargetTableColumns.addAll(targetTable.getPartCols());
            this.targetTableNameInSourceQuery = BaseSemanticAnalyzer.unescapeIdentifier(targetTableNameInSourceQuery);
            this.conf = conf;
            this.onClauseAsString = onClauseAsString;
        }

        private void visit(ASTNode n) {
            if (n.getType() == 1060) {
                ASTNode parent = (ASTNode)n.getParent();
                if (parent != null && parent.getType() == 16) {
                    if (parent.getParent() != null && parent.getParent().getType() == 16) {
                        throw new IllegalArgumentException("Found unexpected db.table.col reference in " + this.onClauseAsString);
                    }
                    this.addColumn2Table(n.getChild(0).getText(), parent.getChild(1).getText());
                } else {
                    this.unresolvedColumns.add(n.getChild(0).getText());
                }
            }
            if (n.getChildCount() == 0) {
                return;
            }
            for (Node child : n.getChildren()) {
                this.visit((ASTNode)child);
            }
        }

        private void analyze() {
            this.visit(this.onClause);
            if (this.tableNamesFound.size() > 2) {
                throw new IllegalArgumentException("Found > 2 table refs in ON clause.  Found " + this.tableNamesFound + " in " + this.onClauseAsString);
            }
            this.handleUnresolvedColumns();
            if (this.tableNamesFound.size() > 2) {
                throw new IllegalArgumentException("Found > 2 table refs in ON clause (incl unresolved).  Found " + this.tableNamesFound + " in " + this.onClauseAsString);
            }
        }

        private void handleUnresolvedColumns() {
            if (this.unresolvedColumns.isEmpty()) {
                return;
            }
            block0: for (String c : this.unresolvedColumns) {
                for (FieldSchema fs : this.allTargetTableColumns) {
                    if (!c.equalsIgnoreCase(fs.getName())) continue;
                    this.addColumn2Table(this.targetTableNameInSourceQuery.toLowerCase(), c);
                    continue block0;
                }
            }
        }

        private void addColumn2Table(String tableName, String columnName) {
            tableName = tableName.toLowerCase();
            this.tableNamesFound.add(tableName);
            List<String> cols = this.table2column.get(tableName);
            if (cols == null) {
                cols = new ArrayList<String>();
                this.table2column.put(tableName, cols);
            }
            cols.add(columnName);
        }

        private String getPredicate() {
            List<String> targetCols = this.table2column.get(this.targetTableNameInSourceQuery.toLowerCase());
            if (targetCols == null) {
                throw new IllegalArgumentException(ErrorMsg.INVALID_TABLE_IN_ON_CLAUSE_OF_MERGE.format(this.targetTableNameInSourceQuery, this.onClauseAsString));
            }
            StringBuilder sb = new StringBuilder();
            for (String col : targetCols) {
                if (sb.length() > 0) {
                    sb.append(" AND ");
                }
                sb.append(HiveUtils.unparseIdentifier(this.targetTableNameInSourceQuery, (Configuration)this.conf)).append(".").append(HiveUtils.unparseIdentifier(col, (Configuration)this.conf)).append(" IS NULL");
            }
            return sb.toString();
        }
    }

    private static final class ReparseResult {
        private final ASTNode rewrittenTree;
        private final Context rewrittenCtx;

        ReparseResult(ASTNode n, Context c) {
            this.rewrittenTree = n;
            this.rewrittenCtx = c;
        }
    }

    private static class IdentifierQuoter {
        private final TokenRewriteStream trs;
        private final IdentityHashMap<ASTNode, ASTNode> visitedNodes = new IdentityHashMap();

        IdentifierQuoter(TokenRewriteStream trs) {
            this.trs = trs;
            if (trs == null) {
                throw new IllegalArgumentException("Must have a TokenRewriteStream");
            }
        }

        private void visit(ASTNode n) {
            if (n.getType() == 24) {
                if (this.visitedNodes.containsKey(n)) {
                    return;
                }
                this.visitedNodes.put(n, n);
                this.trs.insertBefore(n.getToken(), (Object)"`");
                this.trs.insertAfter(n.getToken(), (Object)"`");
            }
            if (n.getChildCount() <= 0) {
                return;
            }
            for (Node c : n.getChildren()) {
                this.visit((ASTNode)c);
            }
        }
    }
}

