/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import com.google.common.annotations.VisibleForTesting;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.SettableListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.SettableMapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.SettableStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.UnionObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableConstantIntObjectInspector;

@Description(name="extract_union", value="_FUNC_(union[, tag]) - Recursively explodes unions into structs or simply extracts the given tag.", extended="  > SELECT _FUNC_({0:\"foo\"}).tag_0 FROM src;\n  foo\n  > SELECT _FUNC_({0:\"foo\"}).tag_1 FROM src;\n  null\n  > SELECT _FUNC_({0:\"foo\"}, 0) FROM src;\n  foo\n  > SELECT _FUNC_({0:\"foo\"}, 1) FROM src;\n  null")
public class GenericUDFExtractUnion
extends GenericUDF {
    private static final int ALL_TAGS = -1;
    private final ObjectInspectorConverter objectInspectorConverter;
    private final ValueConverter valueConverter;
    private int tag = -1;
    private UnionObjectInspector unionOI;
    private ObjectInspector sourceOI;

    public GenericUDFExtractUnion() {
        this(new ObjectInspectorConverter(), new ValueConverter());
    }

    @VisibleForTesting
    GenericUDFExtractUnion(ObjectInspectorConverter objectInspectorConverter, ValueConverter valueConverter) {
        this.objectInspectorConverter = objectInspectorConverter;
        this.valueConverter = valueConverter;
    }

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length == 1) {
            this.sourceOI = arguments[0];
            return this.objectInspectorConverter.convert(this.sourceOI);
        }
        if (arguments.length == 2 && arguments[0] instanceof UnionObjectInspector && arguments[1] instanceof WritableConstantIntObjectInspector) {
            this.tag = ((WritableConstantIntObjectInspector)arguments[1]).getWritableConstantValue().get();
            this.unionOI = (UnionObjectInspector)arguments[0];
            List fieldOIs = ((UnionObjectInspector)arguments[0]).getObjectInspectors();
            if (this.tag < 0 || this.tag >= fieldOIs.size()) {
                throw new UDFArgumentException("int constant must be a valid union tag for " + this.unionOI.getTypeName() + ". Expected 0-" + (fieldOIs.size() - 1) + " got: " + this.tag);
            }
            return (ObjectInspector)fieldOIs.get(this.tag);
        }
        String argumentTypes = "nothing";
        if (arguments.length > 0) {
            ArrayList<String> typeNames = new ArrayList<String>();
            for (ObjectInspector oi : arguments) {
                typeNames.add(oi.getTypeName());
            }
            argumentTypes = ((Object)typeNames).toString();
        }
        throw new UDFArgumentException("Unsupported arguments. Expected a type containing a union or a union and an int constant, got: " + argumentTypes);
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        Object value = arguments[0].get();
        if (this.tag == -1) {
            return this.valueConverter.convert(value, this.sourceOI);
        }
        if (this.tag == this.unionOI.getTag(value)) {
            return this.unionOI.getField(value);
        }
        return null;
    }

    @Override
    public String getDisplayString(String[] children) {
        StringBuilder sb = new StringBuilder();
        sb.append("extract_union(");
        for (int i = 0; i < children.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(children[i]);
        }
        sb.append(')');
        return sb.toString();
    }

    static class ValueConverter {
        ValueConverter() {
        }

        Object convert(Object value, ObjectInspector inspector) {
            ObjectInspector.Category category = inspector.getCategory();
            switch (category) {
                case PRIMITIVE: {
                    return value;
                }
                case LIST: {
                    return this.convertList(value, inspector);
                }
                case MAP: {
                    return this.convertMap(value, inspector);
                }
                case STRUCT: {
                    return this.convertStruct(value, inspector);
                }
                case UNION: {
                    return this.convertUnion(value, inspector);
                }
            }
            throw new IllegalStateException("Unknown category: " + category);
        }

        private Object convertList(Object list, ObjectInspector inspector) {
            SettableListObjectInspector listOI = (SettableListObjectInspector)inspector;
            int size = listOI.getListLength(list);
            Object result = listOI.create(size);
            for (int i = 0; i < size; ++i) {
                listOI.set(result, i, this.convert(listOI.getListElement(list, i), listOI.getListElementObjectInspector()));
            }
            return result;
        }

        private Object convertMap(Object map, ObjectInspector inspector) {
            SettableMapObjectInspector mapOI = (SettableMapObjectInspector)inspector;
            Object result = mapOI.create();
            for (Object key : mapOI.getMap(map).keySet()) {
                Object value = mapOI.getMapValueElement(map, key);
                mapOI.put(result, this.convert(key, mapOI.getMapKeyObjectInspector()), this.convert(value, mapOI.getMapValueObjectInspector()));
            }
            return result;
        }

        private Object convertStruct(Object struct, ObjectInspector inspector) {
            SettableStructObjectInspector structOI = (SettableStructObjectInspector)inspector;
            Object result = structOI.create();
            for (StructField field : structOI.getAllStructFieldRefs()) {
                Object value = structOI.getStructFieldData(struct, field);
                structOI.setStructFieldData(result, field, this.convert(value, field.getFieldObjectInspector()));
            }
            return result;
        }

        private Object convertUnion(Object union, ObjectInspector inspector) {
            UnionObjectInspector unionOI = (UnionObjectInspector)inspector;
            List childOIs = unionOI.getObjectInspectors();
            byte tag = unionOI.getTag(union);
            Object value = unionOI.getField(union);
            ArrayList<Object> result = new ArrayList<Object>(childOIs.size());
            for (int i = 0; i < childOIs.size(); ++i) {
                if (i == tag) {
                    result.add(this.convert(value, (ObjectInspector)childOIs.get(i)));
                    continue;
                }
                result.add(null);
            }
            return result;
        }
    }

    static class ObjectInspectorConverter {
        private static final String TAG_FIELD_PREFIX = "tag_";

        ObjectInspectorConverter() {
        }

        ObjectInspector convert(ObjectInspector inspector) {
            AtomicBoolean foundUnion = new AtomicBoolean(false);
            ObjectInspector result = this.convert(inspector, foundUnion);
            if (!foundUnion.get()) {
                throw new IllegalArgumentException("No unions found in " + inspector.getTypeName());
            }
            return result;
        }

        private ObjectInspector convert(ObjectInspector inspector, AtomicBoolean foundUnion) {
            ObjectInspector.Category category = inspector.getCategory();
            switch (category) {
                case PRIMITIVE: {
                    return inspector;
                }
                case LIST: {
                    return this.convertList(inspector, foundUnion);
                }
                case MAP: {
                    return this.convertMap(inspector, foundUnion);
                }
                case STRUCT: {
                    return this.convertStruct(inspector, foundUnion);
                }
                case UNION: {
                    foundUnion.set(true);
                    return this.convertUnion(inspector, foundUnion);
                }
            }
            throw new IllegalStateException("Unknown category: " + category);
        }

        private ObjectInspector convertList(ObjectInspector inspector, AtomicBoolean foundUnion) {
            ListObjectInspector listOI = (ListObjectInspector)inspector;
            ObjectInspector elementOI = this.convert(listOI.getListElementObjectInspector(), foundUnion);
            return ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)elementOI);
        }

        private ObjectInspector convertMap(ObjectInspector inspector, AtomicBoolean foundUnion) {
            MapObjectInspector mapOI = (MapObjectInspector)inspector;
            ObjectInspector keyOI = this.convert(mapOI.getMapKeyObjectInspector(), foundUnion);
            ObjectInspector valueOI = this.convert(mapOI.getMapValueObjectInspector(), foundUnion);
            return ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)keyOI, (ObjectInspector)valueOI);
        }

        private ObjectInspector convertStruct(ObjectInspector inspector, AtomicBoolean foundUnion) {
            StructObjectInspector structOI = (StructObjectInspector)inspector;
            List fields = structOI.getAllStructFieldRefs();
            ArrayList<String> names = new ArrayList<String>(fields.size());
            ArrayList<ObjectInspector> inspectors = new ArrayList<ObjectInspector>(fields.size());
            for (StructField field : fields) {
                names.add(field.getFieldName());
                inspectors.add(this.convert(field.getFieldObjectInspector(), foundUnion));
            }
            return ObjectInspectorFactory.getStandardStructObjectInspector(names, inspectors);
        }

        private ObjectInspector convertUnion(ObjectInspector inspector, AtomicBoolean foundUnion) {
            UnionObjectInspector unionOI = (UnionObjectInspector)inspector;
            List fieldOIs = unionOI.getObjectInspectors();
            int tags = fieldOIs.size();
            ArrayList<CallSite> names = new ArrayList<CallSite>(tags);
            ArrayList<ObjectInspector> inspectors = new ArrayList<ObjectInspector>(tags);
            for (int i = 0; i < tags; ++i) {
                names.add((CallSite)((Object)(TAG_FIELD_PREFIX + i)));
                inspectors.add(this.convert((ObjectInspector)fieldOIs.get(i), foundUnion));
            }
            return ObjectInspectorFactory.getStandardStructObjectInspector(names, inspectors);
        }
    }
}

