/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableMap;
import com.mapr.fs.MapRFileSystem;
import java.io.IOException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.hive.common.SymLinkUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.io.AcidOutputFormat;
import org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat;
import org.apache.hadoop.hive.ql.io.HiveOutputFormat;
import org.apache.hadoop.hive.ql.io.HiveOutputFormatImpl;
import org.apache.hadoop.hive.ql.io.HivePassThroughOutputFormat;
import org.apache.hadoop.hive.ql.io.HiveSequenceFileOutputFormat;
import org.apache.hadoop.hive.ql.io.IgnoreKeyTextOutputFormat;
import org.apache.hadoop.hive.ql.io.InputFormatChecker;
import org.apache.hadoop.hive.ql.io.RCFileInputFormat;
import org.apache.hadoop.hive.ql.io.RecordUpdater;
import org.apache.hadoop.hive.ql.io.SequenceFileInputFormatChecker;
import org.apache.hadoop.hive.ql.io.orc.OrcInputFormat;
import org.apache.hadoop.hive.ql.io.parquet.MapredParquetInputFormat;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.FileSinkDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobContext;
import org.apache.hadoop.mapred.OutputCommitter;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;
import org.apache.hadoop.mapred.TaskAttemptContext;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.util.Progressable;
import org.apache.hive.common.util.ReflectionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HiveFileFormatUtils {
    private static final Logger LOG = LoggerFactory.getLogger(HiveFileFormatUtils.class);
    private static final int S_IFIFO = 4096;

    public static Class<? extends OutputFormat> getOutputFormatSubstitute(Class<?> origin) {
        if (origin == null || HiveOutputFormat.class.isAssignableFrom(origin)) {
            return origin;
        }
        Class<? extends OutputFormat> substitute = FileChecker.getInstance().getOutputFormatSubstiture(origin);
        if (substitute != null) {
            return substitute;
        }
        return origin;
    }

    public static boolean checkInputFormat(FileSystem fs, HiveConf conf, Class<? extends InputFormat> inputFormatCls, List<FileStatus> files) throws HiveException {
        if (files.isEmpty()) {
            return false;
        }
        Class<? extends InputFormatChecker> checkerCls = FileChecker.getInstance().getInputFormatCheckerClass(inputFormatCls);
        if (checkerCls == null && inputFormatCls.isAssignableFrom(TextInputFormat.class)) {
            return HiveFileFormatUtils.checkTextInputFormat(fs, conf, files);
        }
        if (checkerCls != null) {
            InputFormatChecker checkerInstance = FileChecker.getInstance().getInputFormatCheckerInstance(checkerCls);
            try {
                if (checkerInstance == null) {
                    checkerInstance = checkerCls.newInstance();
                    FileChecker.getInstance().putInputFormatCheckerInstance(checkerCls, checkerInstance);
                }
                return checkerInstance.validateInput(fs, conf, files);
            }
            catch (Exception e) {
                throw new HiveException(e);
            }
        }
        return true;
    }

    private static boolean checkTextInputFormat(FileSystem fs, HiveConf conf, List<FileStatus> files) throws HiveException {
        LinkedList<FileStatus> files2 = new LinkedList<FileStatus>(files);
        Iterator iter = files2.iterator();
        while (iter.hasNext()) {
            FileStatus file = (FileStatus)iter.next();
            if (file == null || !HiveFileFormatUtils.isPipe(fs, file)) continue;
            LOG.info("Skipping format check for " + file.getPath() + " as it is a pipe");
            iter.remove();
        }
        if (files2.isEmpty()) {
            return true;
        }
        Set<Class<? extends InputFormat>> inputFormatter = FileChecker.getInstance().registeredTextClasses();
        for (Class<? extends InputFormat> reg : inputFormatter) {
            boolean result = HiveFileFormatUtils.checkInputFormat(fs, conf, reg, files2);
            if (!result) continue;
            return false;
        }
        return true;
    }

    private static boolean isPipe(FileSystem fs, FileStatus file) {
        if (fs instanceof DistributedFileSystem) {
            return false;
        }
        int mode = 0;
        Object pathToLog = file.getPath();
        try {
            java.nio.file.Path realPath = Paths.get(file.getPath().toUri());
            pathToLog = realPath;
            mode = (Integer)Files.getAttribute(realPath, "unix:mode", new LinkOption[0]);
        }
        catch (FileSystemNotFoundException t) {
            return false;
        }
        catch (IOException | IllegalArgumentException | SecurityException | UnsupportedOperationException t) {
            LOG.info("Failed to check mode for " + pathToLog + ": " + t.getMessage() + " (" + t.getClass() + ")");
            return false;
        }
        return (mode & 0x1000) != 0;
    }

    public static FileSinkOperator.RecordWriter getHiveRecordWriter(JobConf jc, TableDesc tableInfo, Class<? extends Writable> outputClass, FileSinkDesc conf, Path outPath, Reporter reporter) throws HiveException {
        HiveOutputFormat<?, ?> hiveOutputFormat = HiveFileFormatUtils.getHiveOutputFormat((Configuration)jc, tableInfo);
        try {
            boolean isCompressed = conf.getCompressed();
            JobConf jc_output = jc;
            if (isCompressed) {
                String type;
                jc_output = new JobConf((Configuration)jc);
                String codecStr = conf.getCompressCodec();
                if (codecStr != null && !codecStr.trim().equals("")) {
                    Class codec = JavaUtils.loadClass((String)codecStr);
                    FileOutputFormat.setOutputCompressorClass((JobConf)jc_output, (Class)codec);
                }
                if ((type = conf.getCompressType()) != null && !type.trim().equals("")) {
                    SequenceFile.CompressionType style = SequenceFile.CompressionType.valueOf((String)type);
                    SequenceFileOutputFormat.setOutputCompressionType((JobConf)jc, (SequenceFile.CompressionType)style);
                }
            }
            return HiveFileFormatUtils.getRecordWriter(jc_output, hiveOutputFormat, outputClass, isCompressed, tableInfo.getProperties(), outPath, reporter);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public static FileSinkOperator.RecordWriter getRecordWriter(JobConf jc, OutputFormat<?, ?> outputFormat, Class<? extends Writable> valueClass, boolean isCompressed, Properties tableProp, Path outPath, Reporter reporter) throws IOException, HiveException {
        if (!(outputFormat instanceof HiveOutputFormat)) {
            outputFormat = new HivePassThroughOutputFormat(outputFormat);
        }
        return ((HiveOutputFormat)outputFormat).getHiveRecordWriter(jc, outPath, valueClass, isCompressed, tableProp, (Progressable)reporter);
    }

    public static HiveOutputFormat<?, ?> getHiveOutputFormat(Configuration conf, TableDesc tableDesc) throws HiveException {
        return HiveFileFormatUtils.getHiveOutputFormat(conf, tableDesc.getOutputFileFormatClass(), tableDesc.getProperties());
    }

    public static HiveOutputFormat<?, ?> getHiveOutputFormat(Configuration conf, PartitionDesc partDesc) throws HiveException {
        return HiveFileFormatUtils.getHiveOutputFormat(conf, partDesc.getOutputFileFormatClass(), partDesc.getProperties());
    }

    private static HiveOutputFormat<?, ?> getHiveOutputFormat(Configuration conf, Class<? extends OutputFormat> outputClass, Properties properties) throws HiveException {
        try {
            if (outputClass == HivePassThroughOutputFormat.class) {
                outputClass = properties != null && properties.getProperty("storage_handler", "").equals("org.apache.hadoop.hive.hbase.HBaseStorageHandler") ? Class.forName("org.apache.hadoop.hive.hbase.HiveHBaseTableOutputFormat") : HiveOutputFormatImpl.class;
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        HivePassThroughOutputFormat outputFormat = (HivePassThroughOutputFormat)ReflectionUtil.newInstance(outputClass, (Configuration)conf);
        if (!(outputFormat instanceof HiveOutputFormat)) {
            outputFormat = new HivePassThroughOutputFormat(outputFormat);
        }
        return outputFormat;
    }

    public static RecordUpdater getAcidRecordUpdater(JobConf jc, TableDesc tableInfo, int bucket, FileSinkDesc conf, Path outPath, ObjectInspector inspector, Reporter reporter, int rowIdColNum) throws HiveException, IOException {
        HiveOutputFormat<?, ?> hiveOutputFormat = HiveFileFormatUtils.getHiveOutputFormat((Configuration)jc, tableInfo);
        AcidOutputFormat acidOutputFormat = null;
        if (!(hiveOutputFormat instanceof AcidOutputFormat)) {
            throw new HiveException("Unable to create RecordUpdater for HiveOutputFormat that does not implement AcidOutputFormat");
        }
        acidOutputFormat = (AcidOutputFormat)hiveOutputFormat;
        return HiveFileFormatUtils.getRecordUpdater(jc, acidOutputFormat, bucket, inspector, tableInfo.getProperties(), outPath, reporter, rowIdColNum, conf);
    }

    private static RecordUpdater getRecordUpdater(JobConf jc, AcidOutputFormat<?, ?> acidOutputFormat, int bucket, ObjectInspector inspector, Properties tableProp, Path outPath, Reporter reporter, int rowIdColNum, FileSinkDesc conf) throws IOException {
        return acidOutputFormat.getRecordUpdater(outPath, new AcidOutputFormat.Options((Configuration)jc).isCompressed(conf.getCompressed()).tableProperties(tableProp).reporter(reporter).writingBase(conf.getInsertOverwrite()).minimumWriteId(conf.getTableWriteId()).maximumWriteId(conf.getTableWriteId()).bucket(bucket).inspector(inspector).recordIdColumn(rowIdColNum).statementId(conf.getStatementId()).finalDestination(conf.getDestPath()));
    }

    public static <T extends PartitionDesc> T getFromPathRecursively(Map<Path, T> pathToPartitionInfo, Path dir, Map<Map<Path, T>, Map<Path, T>> cacheMap, Configuration conf) throws IOException {
        return HiveFileFormatUtils.getFromPathRecursively(pathToPartitionInfo, dir, cacheMap, false, conf);
    }

    public static <T extends PartitionDesc> T getFromPathRecursively(Map<Path, T> pathToPartitionInfo, Path dir, Map<Map<Path, T>, Map<Path, T>> cacheMap, boolean ignoreSchema, Configuration conf) throws IOException {
        return HiveFileFormatUtils.getFromPathRecursively(pathToPartitionInfo, dir, cacheMap, ignoreSchema, false, conf);
    }

    public static <T extends PartitionDesc> T getFromPathRecursively(Map<Path, T> pathToPartitionInfo, Path dir, Map<Map<Path, T>, Map<Path, T>> cacheMap, boolean ignoreSchema, boolean ifPresent, Configuration conf) throws IOException {
        PartitionDesc part = (PartitionDesc)HiveFileFormatUtils.getFromPathRecursivelyInternal(pathToPartitionInfo, dir, cacheMap, ignoreSchema);
        part = HiveFileFormatUtils.processSymLinks(part, pathToPartitionInfo, dir, conf);
        return (T)HiveFileFormatUtils.processOutput(part, pathToPartitionInfo, dir, ifPresent);
    }

    private static <T extends PartitionDesc> T processSymLinks(T part, Map<Path, T> pathToPartitionInfo, Path dir, Configuration conf) throws IOException {
        if (part == null && FileSystem.get((Configuration)conf) instanceof MapRFileSystem && SymLinkUtils.isSymLinkSupportEnabled((Configuration)conf)) {
            FileSystem maprFs = MapRFileSystem.get((Configuration)conf);
            HashMap<Path, PartitionDesc> symlinkPathToPartitionInfo = new HashMap<Path, PartitionDesc>();
            for (Map.Entry<Path, T> entry : pathToPartitionInfo.entrySet()) {
                Path p;
                boolean isFound = false;
                FileStatus fileStatus = maprFs.getFileStatus(entry.getKey());
                if (fileStatus.isSymlink()) {
                    p = FileUtil.fixSymlinkFileStatus((FileStatus)fileStatus);
                    ((PartitionDesc)entry.getValue()).setBaseFileName(p.getName());
                    symlinkPathToPartitionInfo.put(p, (PartitionDesc)entry.getValue());
                    isFound = true;
                } else {
                    FileStatus[] candidates;
                    for (FileStatus file : candidates = maprFs.listStatus(entry.getKey())) {
                        Path p2;
                        if (!file.isSymlink() || maprFs.getFileStatus(p2 = FileUtil.fixSymlinkFileStatus((FileStatus)file)).compareTo(maprFs.getFileStatus(dir)) != 0) continue;
                        p2 = p2.getParent();
                        ((PartitionDesc)entry.getValue()).setBaseFileName(p2.getName());
                        symlinkPathToPartitionInfo.put(p2, (PartitionDesc)entry.getValue());
                        isFound = true;
                        break;
                    }
                }
                if (!isFound) {
                    p = entry.getKey();
                    Stack<String> nodes = new Stack<String>();
                    nodes.push(p.getName());
                    for (p = p.getParent(); p != null; p = p.getParent()) {
                        fileStatus = maprFs.getFileStatus(p);
                        if (fileStatus.isSymlink()) {
                            isFound = true;
                            p = FileUtil.fixSymlinkFileStatus((FileStatus)fileStatus);
                            break;
                        }
                        nodes.push(p.getName());
                    }
                    if (isFound) {
                        Object processedPath = p.toString();
                        while (!nodes.isEmpty()) {
                            processedPath = (String)processedPath + "/" + (String)nodes.pop();
                        }
                        p = new Path((String)processedPath);
                        symlinkPathToPartitionInfo.put(p, (PartitionDesc)entry.getValue());
                    }
                }
                if (isFound) continue;
                symlinkPathToPartitionInfo.put(entry.getKey(), (PartitionDesc)entry.getValue());
            }
            part = (PartitionDesc)HiveFileFormatUtils.getFromPath(symlinkPathToPartitionInfo, dir);
        }
        return part;
    }

    public static <T> T getFromPathRecursivelyCommon(Map<Path, T> pathToPartitionInfo, Path dir, Map<Map<Path, T>, Map<Path, T>> cacheMap, boolean ignoreSchema, boolean ifPresent) throws IOException {
        T part = HiveFileFormatUtils.getFromPathRecursivelyInternal(pathToPartitionInfo, dir, cacheMap, ignoreSchema);
        return HiveFileFormatUtils.processOutput(part, pathToPartitionInfo, dir, ifPresent);
    }

    private static <T> T processOutput(T part, Map<Path, T> pathToPartitionInfo, Path dir, boolean ifPresent) throws IOException {
        if (part != null || ifPresent) {
            return part;
        }
        throw new IOException("cannot find dir = " + dir.toString() + " in pathToPartitionInfo: " + pathToPartitionInfo.keySet());
    }

    private static <T> T getFromPathRecursivelyInternal(Map<Path, T> pathToPartitionInfo, Path dir, Map<Map<Path, T>, Map<Path, T>> cacheMap, boolean ignoreSchema) {
        T part = HiveFileFormatUtils.getFromPath(pathToPartitionInfo, dir);
        if (part == null && (ignoreSchema || dir.toUri().getScheme() == null || dir.toUri().getScheme().trim().equals("") || FileUtils.pathsContainNoScheme(pathToPartitionInfo.keySet()))) {
            Map<Path, T> newPathToPartitionInfo = null;
            if (cacheMap != null) {
                newPathToPartitionInfo = cacheMap.get(pathToPartitionInfo);
            }
            if (newPathToPartitionInfo == null) {
                newPathToPartitionInfo = HiveFileFormatUtils.populateNewT(pathToPartitionInfo);
                if (cacheMap != null) {
                    cacheMap.put(pathToPartitionInfo, newPathToPartitionInfo);
                }
            }
            part = HiveFileFormatUtils.getFromPath(newPathToPartitionInfo, dir);
        }
        return part;
    }

    private static <T> Map<Path, T> populateNewT(Map<Path, T> pathToPartitionInfo) {
        HashMap<Path, T> newPathToPartitionInfo = new HashMap<Path, T>();
        for (Map.Entry<Path, T> entry : pathToPartitionInfo.entrySet()) {
            T partDesc = entry.getValue();
            Path pathOnly = Path.getPathWithoutSchemeAndAuthority((Path)entry.getKey());
            newPathToPartitionInfo.put(pathOnly, partDesc);
        }
        return newPathToPartitionInfo;
    }

    private static <T> T getFromPath(Map<Path, T> pathToPartitionInfo, Path dir) {
        Path path = FileUtils.getParentRegardlessOfScheme((Path)dir, pathToPartitionInfo.keySet());
        if (path == null) {
            return null;
        }
        return pathToPartitionInfo.get(path);
    }

    private static boolean foundAlias(Map<Path, ArrayList<String>> pathToAliases, Path path) {
        List aliases = pathToAliases.get(path);
        return aliases != null && !aliases.isEmpty();
    }

    private static Path getMatchingPath(Map<Path, ArrayList<String>> pathToAliases, Path dir) {
        Path path = dir;
        if (HiveFileFormatUtils.foundAlias(pathToAliases, path)) {
            return path;
        }
        Path dirPath = Path.getPathWithoutSchemeAndAuthority((Path)dir);
        if (HiveFileFormatUtils.foundAlias(pathToAliases, dirPath)) {
            return dirPath;
        }
        while (path != null && dirPath != null) {
            path = path.getParent();
            dirPath = dirPath.getParent();
            if (HiveFileFormatUtils.foundAlias(pathToAliases, path)) {
                return path;
            }
            if (!HiveFileFormatUtils.foundAlias(pathToAliases, dirPath)) continue;
            return dirPath;
        }
        return null;
    }

    public static List<Operator<? extends OperatorDesc>> doGetWorksFromPath(Map<Path, ArrayList<String>> pathToAliases, Map<String, Operator<? extends OperatorDesc>> aliasToWork, Path dir) {
        ArrayList<Operator<? extends OperatorDesc>> opList = new ArrayList<Operator<? extends OperatorDesc>>();
        List<String> aliases = HiveFileFormatUtils.doGetAliasesFromPath(pathToAliases, dir);
        for (String alias : aliases) {
            opList.add(aliasToWork.get(alias));
        }
        return opList;
    }

    public static List<String> doGetAliasesFromPath(Map<Path, ArrayList<String>> pathToAliases, Path dir) {
        if (pathToAliases == null) {
            return new ArrayList<String>();
        }
        Path path = HiveFileFormatUtils.getMatchingPath(pathToAliases, dir);
        return pathToAliases.get(path);
    }

    private HiveFileFormatUtils() {
    }

    public static void prepareJobOutput(JobConf conf) {
        conf.setOutputCommitter(NullOutputCommitter.class);
        conf.setBoolean("mapreduce.job.committer.setup.cleanup.needed", false);
        conf.setBoolean("mapreduce.job.committer.task.cleanup.needed", false);
    }

    public static class NullOutputCommitter
    extends OutputCommitter {
        public void setupJob(JobContext jobContext) {
        }

        public void cleanupJob(JobContext jobContext) {
        }

        public void setupTask(TaskAttemptContext taskContext) {
        }

        public boolean needsTaskCommit(TaskAttemptContext taskContext) {
            return false;
        }

        public void commitTask(TaskAttemptContext taskContext) {
        }

        public void abortTask(TaskAttemptContext taskContext) {
        }
    }

    public static class FileChecker {
        private static final int MAX_CACHE_SIZE = 16;
        Map<Class<? extends InputFormat>, Class<? extends InputFormatChecker>> inputFormatCheckerMap = ImmutableMap.builder().put(SequenceFileInputFormat.class, SequenceFileInputFormatChecker.class).put(RCFileInputFormat.class, RCFileInputFormat.class).put(OrcInputFormat.class, OrcInputFormat.class).put(MapredParquetInputFormat.class, MapredParquetInputFormat.class).build();
        Map<Class<? extends InputFormat>, Class<? extends InputFormatChecker>> textInputFormatCheckerMap = ImmutableMap.builder().put(SequenceFileInputFormat.class, SequenceFileInputFormatChecker.class).build();
        Map<Class<?>, Class<? extends OutputFormat>> outputFormatSubstituteMap = ImmutableMap.builder().put(IgnoreKeyTextOutputFormat.class, HiveIgnoreKeyTextOutputFormat.class).put(SequenceFileOutputFormat.class, HiveSequenceFileOutputFormat.class).build();
        Cache<Class<? extends InputFormatChecker>, InputFormatChecker> inputFormatCheckerInstanceCache = CacheBuilder.newBuilder().maximumSize(16L).build();

        public static FileChecker getInstance() {
            return Factory.INSTANCE;
        }

        private FileChecker() {
        }

        public Set<Class<? extends InputFormat>> registeredClasses() {
            return this.inputFormatCheckerMap.keySet();
        }

        public Set<Class<? extends InputFormat>> registeredTextClasses() {
            return this.textInputFormatCheckerMap.keySet();
        }

        public Class<? extends OutputFormat> getOutputFormatSubstiture(Class<?> origin) {
            return this.outputFormatSubstituteMap.get(origin);
        }

        public Class<? extends InputFormatChecker> getInputFormatCheckerClass(Class<?> inputFormat) {
            return this.inputFormatCheckerMap.get(inputFormat);
        }

        public void putInputFormatCheckerInstance(Class<? extends InputFormatChecker> checkerCls, InputFormatChecker instanceCls) {
            this.inputFormatCheckerInstanceCache.put(checkerCls, (Object)instanceCls);
        }

        public InputFormatChecker getInputFormatCheckerInstance(Class<? extends InputFormatChecker> checkerCls) {
            return (InputFormatChecker)this.inputFormatCheckerInstanceCache.getIfPresent(checkerCls);
        }

        private static class Factory {
            static final FileChecker INSTANCE = new FileChecker();

            private Factory() {
            }
        }
    }
}

