/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.metadata.formatting;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.WMFullResourcePlan;
import org.apache.hadoop.hive.metastore.api.WMResourcePlan;
import org.apache.hadoop.hive.metastore.api.WMValidateResourcePlanResponse;
import org.apache.hadoop.hive.ql.metadata.CheckConstraint;
import org.apache.hadoop.hive.ql.metadata.DefaultConstraint;
import org.apache.hadoop.hive.ql.metadata.ForeignKeyInfo;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.NotNullConstraint;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.PrimaryKeyInfo;
import org.apache.hadoop.hive.ql.metadata.StorageHandlerInfo;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.metadata.UniqueConstraint;
import org.apache.hadoop.hive.ql.metadata.formatting.MapBuilder;
import org.apache.hadoop.hive.ql.metadata.formatting.MetaDataFormatUtils;
import org.apache.hadoop.hive.ql.metadata.formatting.MetaDataFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonMetaDataFormatter
implements MetaDataFormatter {
    private static final Logger LOG = LoggerFactory.getLogger(JsonMetaDataFormatter.class);

    private void asJson(OutputStream out, Map<String, Object> data) throws HiveException {
        try {
            new ObjectMapper().writeValue(out, data);
        }
        catch (IOException e) {
            throw new HiveException("Unable to convert to json", e);
        }
    }

    @Override
    public void error(OutputStream out, String msg, int errorCode, String sqlState) throws HiveException {
        this.error(out, msg, errorCode, sqlState, null);
    }

    @Override
    public void error(OutputStream out, String errorMessage, int errorCode, String sqlState, String errorDetail) throws HiveException {
        MapBuilder mb = MapBuilder.create().put("error", errorMessage);
        if (errorDetail != null) {
            mb.put("errorDetail", errorDetail);
        }
        mb.put("errorCode", errorCode);
        if (sqlState != null) {
            mb.put("sqlState", sqlState);
        }
        this.asJson(out, mb.build());
    }

    @Override
    public void showTables(DataOutputStream out, Set<String> tables) throws HiveException {
        this.asJson(out, MapBuilder.create().put("tables", tables).build());
    }

    @Override
    public void describeTable(DataOutputStream out, String colPath, String tableName, Table tbl, Partition part, List<FieldSchema> cols, boolean isFormatted, boolean isExt, boolean isOutputPadded, List<ColumnStatisticsObj> colStats, PrimaryKeyInfo pkInfo, ForeignKeyInfo fkInfo, UniqueConstraint ukInfo, NotNullConstraint nnInfo, DefaultConstraint dInfo, CheckConstraint cInfo, StorageHandlerInfo storageHandlerInfo) throws HiveException {
        MapBuilder builder = MapBuilder.create();
        builder.put("columns", this.makeColsUnformatted(cols));
        if (isExt) {
            if (part != null) {
                builder.put("partitionInfo", part.getTPartition());
            } else {
                builder.put("tableInfo", tbl.getTTable());
            }
            if (pkInfo != null && !pkInfo.getColNames().isEmpty()) {
                builder.put("primaryKeyInfo", pkInfo);
            }
            if (fkInfo != null && !fkInfo.getForeignKeys().isEmpty()) {
                builder.put("foreignKeyInfo", fkInfo);
            }
            if (ukInfo != null && !ukInfo.getUniqueConstraints().isEmpty()) {
                builder.put("uniqueConstraintInfo", ukInfo);
            }
            if (nnInfo != null && !nnInfo.getNotNullConstraints().isEmpty()) {
                builder.put("notNullConstraintInfo", nnInfo);
            }
            if (dInfo != null && !dInfo.getDefaultConstraints().isEmpty()) {
                builder.put("defaultConstraintInfo", dInfo);
            }
            if (cInfo != null && !cInfo.getCheckConstraints().isEmpty()) {
                builder.put("checkConstraintInfo", cInfo);
            }
            if (storageHandlerInfo != null) {
                builder.put("storageHandlerInfo", storageHandlerInfo.toString());
            }
        }
        this.asJson(out, builder.build());
    }

    private List<Map<String, Object>> makeColsUnformatted(List<FieldSchema> cols) {
        ArrayList<Map<String, Object>> res = new ArrayList<Map<String, Object>>();
        for (FieldSchema col : cols) {
            res.add(this.makeOneColUnformatted(col));
        }
        return res;
    }

    private Map<String, Object> makeOneColUnformatted(FieldSchema col) {
        return MapBuilder.create().put("name", col.getName()).put("type", col.getType()).put("comment", col.getComment()).build();
    }

    @Override
    public void showTableStatus(DataOutputStream out, Hive db, HiveConf conf, List<Table> tbls, Map<String, String> part, Partition par) throws HiveException {
        this.asJson(out, MapBuilder.create().put("tables", this.makeAllTableStatus(db, conf, tbls, part, par)).build());
    }

    private List<Map<String, Object>> makeAllTableStatus(Hive db, HiveConf conf, List<Table> tbls, Map<String, String> part, Partition par) throws HiveException {
        try {
            ArrayList<Map<String, Object>> res = new ArrayList<Map<String, Object>>();
            for (Table tbl : tbls) {
                res.add(this.makeOneTableStatus(tbl, db, conf, part, par));
            }
            return res;
        }
        catch (IOException e) {
            throw new HiveException(e);
        }
    }

    private Map<String, Object> makeOneTableStatus(Table tbl, Hive db, HiveConf conf, Map<String, String> part, Partition par) throws HiveException, IOException {
        String tblLoc = null;
        String inputFormattCls = null;
        String outputFormattCls = null;
        if (part != null) {
            if (par != null) {
                if (par.getLocation() != null) {
                    tblLoc = par.getDataLocation().toString();
                }
                inputFormattCls = par.getInputFormatClass().getName();
                outputFormattCls = par.getOutputFormatClass().getName();
            }
        } else {
            if (tbl.getPath() != null) {
                tblLoc = tbl.getDataLocation().toString();
            }
            inputFormattCls = tbl.getInputFormatClass().getName();
            outputFormattCls = tbl.getOutputFormatClass().getName();
        }
        MapBuilder builder = MapBuilder.create();
        builder.put("tableName", tbl.getTableName());
        builder.put("ownerType", tbl.getOwnerType() != null ? tbl.getOwnerType().name() : "null");
        builder.put("owner", tbl.getOwner());
        builder.put("location", tblLoc);
        builder.put("inputFormat", inputFormattCls);
        builder.put("outputFormat", outputFormattCls);
        builder.put("columns", this.makeColsUnformatted(tbl.getCols()));
        builder.put("partitioned", tbl.isPartitioned());
        if (tbl.isPartitioned()) {
            builder.put("partitionColumns", this.makeColsUnformatted(tbl.getPartCols()));
        }
        if (tbl.getTableType() != TableType.VIRTUAL_VIEW) {
            this.putFileSystemsStats(builder, this.makeTableStatusLocations(tbl, db, par), conf, tbl.getPath());
        }
        return builder.build();
    }

    private List<Path> makeTableStatusLocations(Table tbl, Hive db, Partition par) throws HiveException {
        Path tblPath = tbl.getPath();
        ArrayList<Path> locations = new ArrayList<Path>();
        if (tbl.isPartitioned()) {
            if (par == null) {
                for (Partition curPart : db.getPartitions(tbl)) {
                    if (curPart.getLocation() == null) continue;
                    locations.add(new Path(curPart.getLocation()));
                }
            } else if (par.getLocation() != null) {
                locations.add(new Path(par.getLocation()));
            }
        } else if (tblPath != null) {
            locations.add(tblPath);
        }
        return locations;
    }

    private void putFileSystemsStats(MapBuilder builder, List<Path> locations, HiveConf conf, Path tblPath) throws IOException {
        long totalFileSize = 0L;
        long maxFileSize = 0L;
        long minFileSize = Long.MAX_VALUE;
        long lastAccessTime = 0L;
        long lastUpdateTime = 0L;
        int numOfFiles = 0;
        boolean unknown = false;
        FileSystem fs = tblPath.getFileSystem((Configuration)conf);
        try {
            FileStatus tmpStatus = fs.getFileStatus(tblPath);
            lastAccessTime = tmpStatus.getAccessTime();
            lastUpdateTime = tmpStatus.getModificationTime();
        }
        catch (IOException e) {
            LOG.warn("Cannot access File System. File System status will be unknown: ", (Throwable)e);
            unknown = true;
        }
        if (!unknown) {
            for (Path loc : locations) {
                try {
                    FileStatus status = fs.getFileStatus(tblPath);
                    FileStatus[] files = fs.listStatus(loc);
                    long accessTime = status.getAccessTime();
                    long updateTime = status.getModificationTime();
                    if (!status.isDir()) continue;
                    if (accessTime > lastAccessTime) {
                        lastAccessTime = accessTime;
                    }
                    if (updateTime > lastUpdateTime) {
                        lastUpdateTime = updateTime;
                    }
                    for (FileStatus currentStatus : files) {
                        if (currentStatus.isDir()) continue;
                        ++numOfFiles;
                        long fileLen = currentStatus.getLen();
                        totalFileSize += fileLen;
                        if (fileLen > maxFileSize) {
                            maxFileSize = fileLen;
                        }
                        if (fileLen < minFileSize) {
                            minFileSize = fileLen;
                        }
                        accessTime = currentStatus.getAccessTime();
                        updateTime = currentStatus.getModificationTime();
                        if (accessTime > lastAccessTime) {
                            lastAccessTime = accessTime;
                        }
                        if (updateTime <= lastUpdateTime) continue;
                        lastUpdateTime = updateTime;
                    }
                }
                catch (IOException iOException) {
                }
            }
        }
        builder.put("totalNumberFiles", numOfFiles, !unknown).put("totalFileSize", totalFileSize, !unknown).put("maxFileSize", maxFileSize, !unknown).put("minFileSize", numOfFiles > 0 ? minFileSize : 0L, !unknown).put("lastAccessTime", lastAccessTime, !unknown && lastAccessTime >= 0L).put("lastUpdateTime", lastUpdateTime, !unknown);
    }

    @Override
    public void showTablePartitions(DataOutputStream out, List<String> parts) throws HiveException {
        this.asJson(out, MapBuilder.create().put("partitions", this.makeTablePartions(parts)).build());
    }

    private List<Map<String, Object>> makeTablePartions(List<String> parts) throws HiveException {
        try {
            ArrayList<Map<String, Object>> res = new ArrayList<Map<String, Object>>();
            for (String part : parts) {
                res.add(this.makeOneTablePartition(part));
            }
            return res;
        }
        catch (UnsupportedEncodingException e) {
            throw new HiveException(e);
        }
    }

    private Map<String, Object> makeOneTablePartition(String partIdent) throws UnsupportedEncodingException {
        ArrayList<Map<String, Object>> res = new ArrayList<Map<String, Object>>();
        ArrayList<Object> names = new ArrayList<Object>();
        String[] stringArray = StringUtils.split((String)partIdent, (String)"/");
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String part;
            String name = part = stringArray[i];
            String val = null;
            String[] kv = StringUtils.split((String)part, (String)"=", (int)2);
            if (kv != null) {
                name = kv[0];
                if (kv.length > 1) {
                    val = URLDecoder.decode(kv[1], "UTF-8");
                }
            }
            if (val != null) {
                names.add(name + "='" + val + "'");
            } else {
                names.add(name);
            }
            res.add(MapBuilder.create().put("columnName", name).put("columnValue", val).build());
        }
        return MapBuilder.create().put("name", StringUtils.join(names, (String)",")).put("values", res).build();
    }

    @Override
    public void showDatabases(DataOutputStream out, List<String> databases) throws HiveException {
        this.asJson(out, MapBuilder.create().put("databases", databases).build());
    }

    @Override
    public void showDatabaseDescription(DataOutputStream out, String database, String comment, String location, String ownerName, String ownerType, Map<String, String> params) throws HiveException {
        MapBuilder builder = MapBuilder.create().put("database", database).put("comment", comment).put("location", location);
        if (null != ownerName) {
            builder.put("owner", ownerName);
        }
        if (null != ownerType) {
            builder.put("ownerType", ownerType);
        }
        if (null != params && !params.isEmpty()) {
            builder.put("params", params);
        }
        this.asJson(out, builder.build());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void showResourcePlans(DataOutputStream out, List<WMResourcePlan> resourcePlans) throws HiveException {
        JsonGenerator generator = null;
        try {
            generator = new ObjectMapper().getJsonFactory().createJsonGenerator((OutputStream)out);
            generator.writeStartArray();
            for (WMResourcePlan plan : resourcePlans) {
                generator.writeStartObject();
                generator.writeStringField("name", plan.getName());
                generator.writeStringField("status", plan.getStatus().name());
                if (plan.isSetQueryParallelism()) {
                    generator.writeNumberField("queryParallelism", plan.getQueryParallelism());
                }
                if (plan.isSetDefaultPoolPath()) {
                    generator.writeStringField("defaultPoolPath", plan.getDefaultPoolPath());
                }
                generator.writeEndObject();
            }
            generator.writeEndArray();
            generator.close();
            if (generator == null) return;
        }
        catch (IOException e) {
            try {
                throw new HiveException(e);
            }
            catch (Throwable throwable) {
                if (generator == null) throw throwable;
                IOUtils.closeQuietly(generator);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)generator);
        return;
    }

    @Override
    public void showFullResourcePlan(DataOutputStream out, WMFullResourcePlan resourcePlan) throws HiveException {
        try (JsonRPFormatter formatter = new JsonRPFormatter(out);){
            MetaDataFormatUtils.formatFullRP(formatter, resourcePlan);
        }
        catch (IOException e) {
            throw new HiveException(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void showErrors(DataOutputStream out, WMValidateResourcePlanResponse response) throws HiveException {
        JsonGenerator generator = null;
        try {
            generator = new ObjectMapper().getJsonFactory().createJsonGenerator((OutputStream)out);
            generator.writeStartObject();
            generator.writeArrayFieldStart("errors");
            for (String error : response.getErrors()) {
                generator.writeString(error);
            }
            generator.writeEndArray();
            generator.writeArrayFieldStart("warnings");
            for (String error : response.getWarnings()) {
                generator.writeString(error);
            }
            generator.writeEndArray();
            generator.writeEndObject();
            if (generator == null) return;
        }
        catch (IOException e) {
            try {
                throw new HiveException(e);
            }
            catch (Throwable throwable) {
                if (generator == null) throw throwable;
                IOUtils.closeQuietly(generator);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)generator);
        return;
    }

    private static class JsonRPFormatter
    implements MetaDataFormatUtils.RPFormatter,
    Closeable {
        private final JsonGenerator generator;

        JsonRPFormatter(DataOutputStream out) throws IOException {
            this.generator = new ObjectMapper().getJsonFactory().createJsonGenerator((OutputStream)out);
        }

        private void writeNameAndFields(String name, Object ... kvPairs) throws IOException {
            if (kvPairs.length % 2 != 0) {
                throw new IllegalArgumentException("Expected pairs");
            }
            this.generator.writeStringField("name", name);
            for (int i = 0; i < kvPairs.length; i += 2) {
                this.generator.writeObjectField(kvPairs[i].toString(), kvPairs[i + 1]);
            }
        }

        @Override
        public void startRP(String rpName, Object ... kvPairs) throws IOException {
            this.generator.writeStartObject();
            this.writeNameAndFields(rpName, kvPairs);
        }

        @Override
        public void endRP() throws IOException {
            this.generator.writeEndObject();
        }

        @Override
        public void startPools() throws IOException {
            this.generator.writeArrayFieldStart("pools");
        }

        @Override
        public void endPools() throws IOException {
            this.generator.writeEndArray();
        }

        @Override
        public void startPool(String poolName, Object ... kvPairs) throws IOException {
            this.generator.writeStartObject();
            this.writeNameAndFields(poolName, kvPairs);
        }

        @Override
        public void startTriggers() throws IOException {
            this.generator.writeArrayFieldStart("triggers");
        }

        @Override
        public void endTriggers() throws IOException {
            this.generator.writeEndArray();
        }

        @Override
        public void startMappings() throws IOException {
            this.generator.writeArrayFieldStart("mappings");
        }

        @Override
        public void endMappings() throws IOException {
            this.generator.writeEndArray();
        }

        @Override
        public void endPool() throws IOException {
            this.generator.writeEndObject();
        }

        @Override
        public void formatTrigger(String triggerName, String actionExpression, String triggerExpression) throws IOException {
            this.generator.writeStartObject();
            this.writeNameAndFields(triggerName, "action", actionExpression, "trigger", triggerExpression);
            this.generator.writeEndObject();
        }

        @Override
        public void formatMappingType(String type, List<String> names) throws IOException {
            this.generator.writeStartObject();
            this.generator.writeStringField("type", type);
            this.generator.writeArrayFieldStart("values");
            for (String name : names) {
                this.generator.writeString(name);
            }
            this.generator.writeEndArray();
            this.generator.writeEndObject();
        }

        @Override
        public void close() throws IOException {
            this.generator.close();
        }
    }
}

