/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io;

import java.io.DataInput;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.hadoop.hive.ql.io.AcidInputFormat;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class TestAcidInputFormat {
    @Mock
    private DataInput mockDataInput;

    @Test
    public void testDeltaMetaDataReadFieldsNoStatementIds() throws Exception {
        Mockito.when((Object)this.mockDataInput.readLong()).thenReturn((Object)1L, (Object[])new Long[]{2L});
        Mockito.when((Object)this.mockDataInput.readInt()).thenReturn((Object)0);
        AcidInputFormat.DeltaMetaData deltaMetaData = new AcidInputFormat.DeltaMetaData();
        deltaMetaData.readFields(this.mockDataInput);
        ((DataInput)Mockito.verify((Object)this.mockDataInput, (VerificationMode)Mockito.times((int)1))).readInt();
        Assert.assertThat((Object)deltaMetaData.getMinWriteId(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)deltaMetaData.getMaxWriteId(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)deltaMetaData.getStmtIds().isEmpty(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testDeltaMetaDataReadFieldsWithStatementIds() throws Exception {
        Mockito.when((Object)this.mockDataInput.readLong()).thenReturn((Object)1L, (Object[])new Long[]{2L});
        Mockito.when((Object)this.mockDataInput.readInt()).thenReturn((Object)2, (Object[])new Integer[]{100, 101});
        AcidInputFormat.DeltaMetaData deltaMetaData = new AcidInputFormat.DeltaMetaData();
        deltaMetaData.readFields(this.mockDataInput);
        ((DataInput)Mockito.verify((Object)this.mockDataInput, (VerificationMode)Mockito.times((int)3))).readInt();
        Assert.assertThat((Object)deltaMetaData.getMinWriteId(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)deltaMetaData.getMaxWriteId(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)deltaMetaData.getStmtIds().size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((Integer)deltaMetaData.getStmtIds().get(0)), (Matcher)CoreMatchers.is((Object)100));
        Assert.assertThat((Object)((Integer)deltaMetaData.getStmtIds().get(1)), (Matcher)CoreMatchers.is((Object)101));
    }

    @Test
    public void testDeltaMetaConstructWithState() throws Exception {
        AcidInputFormat.DeltaMetaData deltaMetaData = new AcidInputFormat.DeltaMetaData(2000L, 2001L, Arrays.asList(97, 98, 99));
        Assert.assertThat((Object)deltaMetaData.getMinWriteId(), (Matcher)CoreMatchers.is((Object)2000L));
        Assert.assertThat((Object)deltaMetaData.getMaxWriteId(), (Matcher)CoreMatchers.is((Object)2001L));
        Assert.assertThat((Object)deltaMetaData.getStmtIds().size(), (Matcher)CoreMatchers.is((Object)3));
        Assert.assertThat((Object)((Integer)deltaMetaData.getStmtIds().get(0)), (Matcher)CoreMatchers.is((Object)97));
        Assert.assertThat((Object)((Integer)deltaMetaData.getStmtIds().get(1)), (Matcher)CoreMatchers.is((Object)98));
        Assert.assertThat((Object)((Integer)deltaMetaData.getStmtIds().get(2)), (Matcher)CoreMatchers.is((Object)99));
    }

    @Test
    public void testDeltaMetaDataReadFieldsWithStatementIdsResetsState() throws Exception {
        Mockito.when((Object)this.mockDataInput.readLong()).thenReturn((Object)1L, (Object[])new Long[]{2L});
        Mockito.when((Object)this.mockDataInput.readInt()).thenReturn((Object)2, (Object[])new Integer[]{100, 101});
        ArrayList<Integer> statementIds = new ArrayList<Integer>();
        statementIds.add(97);
        statementIds.add(98);
        statementIds.add(99);
        AcidInputFormat.DeltaMetaData deltaMetaData = new AcidInputFormat.DeltaMetaData(2000L, 2001L, statementIds);
        deltaMetaData.readFields(this.mockDataInput);
        ((DataInput)Mockito.verify((Object)this.mockDataInput, (VerificationMode)Mockito.times((int)3))).readInt();
        Assert.assertThat((Object)deltaMetaData.getMinWriteId(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)deltaMetaData.getMaxWriteId(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)deltaMetaData.getStmtIds().size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((Integer)deltaMetaData.getStmtIds().get(0)), (Matcher)CoreMatchers.is((Object)100));
        Assert.assertThat((Object)((Integer)deltaMetaData.getStmtIds().get(1)), (Matcher)CoreMatchers.is((Object)101));
    }
}

