/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import org.apache.hadoop.hive.ql.exec.vector.VectorAggregationDesc;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.plan.AbstractVectorDesc;
import org.apache.hadoop.hive.ql.plan.GroupByDesc;

public class VectorGroupByDesc
extends AbstractVectorDesc {
    private static final long serialVersionUID = 1L;
    private ProcessingMode processingMode = ProcessingMode.NONE;
    private VectorExpression[] keyExpressions;
    private VectorAggregationDesc[] vecAggrDescs;
    private int[] projectedOutputColumns;
    private boolean isVectorizationComplexTypesEnabled;
    private boolean isVectorizationGroupByComplexTypesEnabled;

    public void setProcessingMode(ProcessingMode processingMode) {
        this.processingMode = processingMode;
    }

    public ProcessingMode getProcessingMode() {
        return this.processingMode;
    }

    public void setKeyExpressions(VectorExpression[] keyExpressions) {
        this.keyExpressions = keyExpressions;
    }

    public VectorExpression[] getKeyExpressions() {
        return this.keyExpressions;
    }

    public void setVecAggrDescs(VectorAggregationDesc[] vecAggrDescs) {
        this.vecAggrDescs = vecAggrDescs;
    }

    public VectorAggregationDesc[] getVecAggrDescs() {
        return this.vecAggrDescs;
    }

    public void setProjectedOutputColumns(int[] projectedOutputColumns) {
        this.projectedOutputColumns = projectedOutputColumns;
    }

    public int[] getProjectedOutputColumns() {
        return this.projectedOutputColumns;
    }

    public void setIsVectorizationComplexTypesEnabled(boolean isVectorizationComplexTypesEnabled) {
        this.isVectorizationComplexTypesEnabled = isVectorizationComplexTypesEnabled;
    }

    public boolean getIsVectorizationComplexTypesEnabled() {
        return this.isVectorizationComplexTypesEnabled;
    }

    public void setIsVectorizationGroupByComplexTypesEnabled(boolean isVectorizationGroupByComplexTypesEnabled) {
        this.isVectorizationGroupByComplexTypesEnabled = isVectorizationGroupByComplexTypesEnabled;
    }

    public boolean getIsVectorizationGroupByComplexTypesEnabled() {
        return this.isVectorizationGroupByComplexTypesEnabled;
    }

    public static ProcessingMode groupByDescModeToVectorProcessingMode(GroupByDesc.Mode mode, boolean hasKeys) {
        switch (mode) {
            case COMPLETE: {
                return hasKeys ? ProcessingMode.STREAMING : ProcessingMode.GLOBAL;
            }
            case HASH: {
                return ProcessingMode.HASH;
            }
            case MERGEPARTIAL: {
                return hasKeys ? ProcessingMode.MERGE_PARTIAL : ProcessingMode.GLOBAL;
            }
            case PARTIAL1: 
            case PARTIAL2: 
            case PARTIALS: 
            case FINAL: {
                return ProcessingMode.STREAMING;
            }
        }
        throw new RuntimeException("Unexpected GROUP BY mode " + mode.name());
    }

    public static enum ProcessingMode {
        NONE,
        GLOBAL,
        HASH,
        MERGE_PARTIAL,
        STREAMING;

    }
}

