/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.lineage;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Stack;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.FilterOperator;
import org.apache.hadoop.hive.ql.exec.ForwardOperator;
import org.apache.hadoop.hive.ql.exec.GroupByOperator;
import org.apache.hadoop.hive.ql.exec.JoinOperator;
import org.apache.hadoop.hive.ql.exec.LateralViewJoinOperator;
import org.apache.hadoop.hive.ql.exec.LimitOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.exec.ScriptOperator;
import org.apache.hadoop.hive.ql.exec.SelectOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.hooks.LineageInfo;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.Utils;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.metadata.VirtualColumn;
import org.apache.hadoop.hive.ql.optimizer.lineage.ExprProcFactory;
import org.apache.hadoop.hive.ql.optimizer.lineage.LineageCtx;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.AggregationDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.FilterDesc;
import org.apache.hadoop.hive.ql.plan.GroupByDesc;
import org.apache.hadoop.hive.ql.plan.JoinCondDesc;
import org.apache.hadoop.hive.ql.plan.JoinDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.SelectDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;

public class OpProcFactory {
    protected static Operator<? extends OperatorDesc> getParent(Stack<Node> stack) {
        return (Operator)Utils.getNthAncestor(stack, 1);
    }

    public static NodeProcessor getJoinProc() {
        return new JoinLineage();
    }

    public static NodeProcessor getLateralViewJoinProc() {
        return new LateralViewJoinLineage();
    }

    public static NodeProcessor getTSProc() {
        return new TableScanLineage();
    }

    public static NodeProcessor getTransformProc() {
        return new TransformLineage();
    }

    public static NodeProcessor getSelProc() {
        return new SelectLineage();
    }

    public static NodeProcessor getGroupByProc() {
        return new GroupByLineage();
    }

    public static NodeProcessor getUnionProc() {
        return new UnionLineage();
    }

    public static NodeProcessor getReduceSinkProc() {
        return new ReduceSinkLineage();
    }

    public static NodeProcessor getDefaultProc() {
        return new DefaultLineage();
    }

    public static NodeProcessor getFilterProc() {
        return new FilterLineage();
    }

    public static class DefaultLineage
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            assert (!stack.isEmpty());
            LineageCtx lCtx = (LineageCtx)procCtx;
            Operator op = (Operator)nd;
            Operator<? extends OperatorDesc> inpOp = OpProcFactory.getParent(stack);
            lCtx.getIndex().copyPredicates(inpOp, op);
            RowSchema rs = op.getSchema();
            ArrayList<ColumnInfo> inp_cols = inpOp.getSchema().getSignature();
            int cnt = 0;
            for (ColumnInfo ci : rs.getSignature()) {
                lCtx.getIndex().putDependency(op, ci, lCtx.getIndex().getDependency(inpOp, inp_cols.get(cnt++)));
            }
            return null;
        }
    }

    public static class FilterLineage
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            assert (!stack.isEmpty());
            LineageCtx lCtx = (LineageCtx)procCtx;
            FilterOperator fop = (FilterOperator)nd;
            Operator<? extends OperatorDesc> inpOp = OpProcFactory.getParent(stack);
            lCtx.getIndex().copyPredicates(inpOp, fop);
            FilterDesc filterDesc = (FilterDesc)fop.getConf();
            RowSchema rs = fop.getSchema();
            if (!filterDesc.isGenerated()) {
                LineageInfo.Predicate cond = new LineageInfo.Predicate();
                cond.setExpr(ExprProcFactory.getExprString(rs, filterDesc.getPredicate(), lCtx, inpOp, cond));
                lCtx.getIndex().addPredicate(fop, cond);
            }
            ArrayList<ColumnInfo> inp_cols = inpOp.getSchema().getSignature();
            int cnt = 0;
            for (ColumnInfo ci : rs.getSignature()) {
                lCtx.getIndex().putDependency(fop, ci, lCtx.getIndex().getDependency(inpOp, inp_cols.get(cnt++)));
            }
            return null;
        }
    }

    public static class ReduceSinkLineage
    implements NodeProcessor {
        private final HashMap<Node, Object> outputMap = new HashMap();

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            assert (!stack.isEmpty());
            LineageCtx lCtx = (LineageCtx)procCtx;
            ReduceSinkOperator rop = (ReduceSinkOperator)nd;
            Operator<? extends OperatorDesc> inpOp = OpProcFactory.getParent(stack);
            lCtx.getIndex().copyPredicates(inpOp, rop);
            int cnt = 0;
            Operator<OperatorDesc> op = rop.getChildOperators().get(0);
            while (op instanceof ForwardOperator) {
                op = op.getChildOperators().get(0);
            }
            if (op instanceof GroupByOperator) {
                ArrayList<ColumnInfo> col_infos = rop.getSchema().getSignature();
                for (ExprNodeDesc expr : ((ReduceSinkDesc)rop.getConf()).getKeyCols()) {
                    lCtx.getIndex().putDependency(rop, col_infos.get(cnt++), ExprProcFactory.getExprDependency(lCtx, inpOp, expr, this.outputMap));
                }
                for (ExprNodeDesc expr : ((ReduceSinkDesc)rop.getConf()).getValueCols()) {
                    lCtx.getIndex().putDependency(rop, col_infos.get(cnt++), ExprProcFactory.getExprDependency(lCtx, inpOp, expr, this.outputMap));
                }
            } else {
                RowSchema schema = rop.getSchema();
                ReduceSinkDesc desc = (ReduceSinkDesc)rop.getConf();
                ArrayList<ExprNodeDesc> keyCols = desc.getKeyCols();
                ArrayList<String> keyColNames = desc.getOutputKeyColumnNames();
                for (int i = 0; i < keyCols.size(); ++i) {
                    ColumnInfo column = schema.getColumnInfo(Utilities.ReduceField.KEY + "." + keyColNames.get(i));
                    if (column == null) continue;
                    lCtx.getIndex().putDependency(rop, column, ExprProcFactory.getExprDependency(lCtx, inpOp, (ExprNodeDesc)keyCols.get(i), this.outputMap));
                }
                ArrayList<ExprNodeDesc> valCols = desc.getValueCols();
                ArrayList<String> valColNames = desc.getOutputValueColumnNames();
                for (int i = 0; i < valCols.size(); ++i) {
                    ColumnInfo column = schema.getColumnInfo(valColNames.get(i));
                    if (column == null) {
                        column = schema.getColumnInfo(Utilities.ReduceField.VALUE + "." + valColNames.get(i));
                    }
                    lCtx.getIndex().putDependency(rop, column, ExprProcFactory.getExprDependency(lCtx, inpOp, (ExprNodeDesc)valCols.get(i), this.outputMap));
                }
            }
            return null;
        }
    }

    public static class UnionLineage
    extends DefaultLineage
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            assert (!stack.isEmpty());
            LineageCtx lCtx = (LineageCtx)procCtx;
            Operator op = (Operator)nd;
            Operator<? extends OperatorDesc> inpOp = OpProcFactory.getParent(stack);
            lCtx.getIndex().copyPredicates(inpOp, op);
            RowSchema rs = op.getSchema();
            ArrayList<ColumnInfo> inp_cols = inpOp.getSchema().getSignature();
            for (ColumnInfo input : inp_cols) {
                LineageInfo.Dependency inp_dep = lCtx.getIndex().getDependency(inpOp, input);
                if (inp_dep == null) continue;
                ColumnInfo ci = rs.getColumnInfo(input.getInternalName());
                lCtx.getIndex().mergeDependency(op, ci, inp_dep);
            }
            return null;
        }
    }

    public static class GroupByLineage
    extends DefaultLineage
    implements NodeProcessor {
        private final HashMap<Node, Object> outputMap = new HashMap();

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            LineageCtx lctx = (LineageCtx)procCtx;
            GroupByOperator gop = (GroupByOperator)nd;
            ArrayList<ColumnInfo> col_infos = gop.getSchema().getSignature();
            Operator<? extends OperatorDesc> inpOp = OpProcFactory.getParent(stack);
            lctx.getIndex().copyPredicates(inpOp, gop);
            int cnt = 0;
            for (ExprNodeDesc expr : ((GroupByDesc)gop.getConf()).getKeys()) {
                lctx.getIndex().putDependency(gop, col_infos.get(cnt++), ExprProcFactory.getExprDependency(lctx, inpOp, expr, this.outputMap));
            }
            boolean reduceSideGop = inpOp instanceof ReduceSinkOperator && Utils.getNthAncestor(stack, 2) instanceof GroupByOperator;
            RowSchema rs = gop.getSchema();
            for (AggregationDesc agg : ((GroupByDesc)gop.getConf()).getAggregators()) {
                LineageInfo.Dependency dep = new LineageInfo.Dependency();
                LineageInfo.DependencyType new_type = LineageInfo.DependencyType.EXPRESSION;
                StringBuilder sb = new StringBuilder();
                boolean first = true;
                LinkedHashSet<LineageInfo.BaseColumnInfo> bci_set = new LinkedHashSet<LineageInfo.BaseColumnInfo>();
                for (ExprNodeDesc expr : agg.getParameters()) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(", ");
                    }
                    LineageInfo.Dependency expr_dep = ExprProcFactory.getExprDependency(lctx, inpOp, expr, this.outputMap);
                    if (expr_dep != null && !expr_dep.getBaseCols().isEmpty()) {
                        new_type = LineageCtx.getNewDependencyType(expr_dep.getType(), new_type);
                        bci_set.addAll(expr_dep.getBaseCols());
                        if (expr_dep.getType() == LineageInfo.DependencyType.SIMPLE) {
                            LineageInfo.BaseColumnInfo col = expr_dep.getBaseCols().iterator().next();
                            org.apache.hadoop.hive.metastore.api.Table t = col.getTabAlias().getTable();
                            if (t != null) {
                                sb.append(Warehouse.getQualifiedName((org.apache.hadoop.hive.metastore.api.Table)t)).append(".");
                            }
                            sb.append(col.getColumn().getName());
                        }
                    }
                    if (expr_dep != null && !expr_dep.getBaseCols().isEmpty() && expr_dep.getType() == LineageInfo.DependencyType.SIMPLE) continue;
                    sb.append(expr_dep != null && expr_dep.getExpr() != null ? expr_dep.getExpr() : ExprProcFactory.getExprString(rs, expr, lctx, inpOp, null));
                }
                String expr = sb.toString();
                String udafName = agg.getGenericUDAFName();
                if (!reduceSideGop || !expr.startsWith(udafName)) {
                    sb.setLength(0);
                    sb.append(udafName);
                    sb.append("(");
                    if (agg.getDistinct()) {
                        sb.append("DISTINCT ");
                    }
                    sb.append(expr);
                    if (first) {
                        sb.append("*");
                    }
                    sb.append(")");
                    expr = sb.toString();
                }
                dep.setExpr(expr);
                if (bci_set.isEmpty()) {
                    LinkedHashSet<LineageInfo.TableAliasInfo> tai_set = new LinkedHashSet<LineageInfo.TableAliasInfo>();
                    if (inpOp.getSchema() != null && inpOp.getSchema().getSignature() != null) {
                        for (ColumnInfo ci : inpOp.getSchema().getSignature()) {
                            LineageInfo.Dependency inp_dep = lctx.getIndex().getDependency(inpOp, ci);
                            if (inp_dep == null) continue;
                            for (LineageInfo.BaseColumnInfo bci : inp_dep.getBaseCols()) {
                                new_type = LineageCtx.getNewDependencyType(inp_dep.getType(), new_type);
                                tai_set.add(bci.getTabAlias());
                            }
                        }
                    }
                    for (LineageInfo.TableAliasInfo tai : tai_set) {
                        LineageInfo.BaseColumnInfo bci = new LineageInfo.BaseColumnInfo();
                        bci.setTabAlias(tai);
                        bci.setColumn(null);
                        bci_set.add(bci);
                    }
                }
                dep.setBaseCols(bci_set);
                dep.setType(new_type);
                lctx.getIndex().putDependency(gop, col_infos.get(cnt++), dep);
            }
            return null;
        }
    }

    public static class SelectLineage
    extends DefaultLineage
    implements NodeProcessor {
        private final HashMap<Node, Object> outputMap = new HashMap();

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            LineageCtx lctx = (LineageCtx)procCtx;
            SelectOperator sop = (SelectOperator)nd;
            if (((SelectDesc)sop.getConf()).isSelStarNoCompute()) {
                return super.process(nd, stack, procCtx, nodeOutputs);
            }
            Operator<? extends OperatorDesc> inpOp = OpProcFactory.getParent(stack);
            lctx.getIndex().copyPredicates(inpOp, sop);
            RowSchema rs = sop.getSchema();
            ArrayList<ColumnInfo> col_infos = rs.getSignature();
            int cnt = 0;
            for (ExprNodeDesc expr : ((SelectDesc)sop.getConf()).getColList()) {
                LineageInfo.Dependency dep = ExprProcFactory.getExprDependency(lctx, inpOp, expr, this.outputMap);
                if (dep != null && dep.getExpr() == null && (dep.getBaseCols().isEmpty() || dep.getType() != LineageInfo.DependencyType.SIMPLE)) {
                    dep.setExpr(ExprProcFactory.getExprString(rs, expr, lctx, inpOp, null));
                }
                lctx.getIndex().putDependency(sop, col_infos.get(cnt++), dep);
            }
            Operator<OperatorDesc> op = null;
            if (!sop.getChildOperators().isEmpty() && !(op = sop.getChildOperators().get(0)).getChildOperators().isEmpty() && op instanceof LimitOperator) {
                op = op.getChildOperators().get(0);
            }
            if (op == null || op.getChildOperators().isEmpty() && op instanceof FileSinkOperator) {
                lctx.getIndex().addFinalSelectOp(sop, op);
            }
            return null;
        }
    }

    public static class LateralViewJoinLineage
    extends DefaultLineage
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            assert (!stack.isEmpty());
            LineageCtx lCtx = (LineageCtx)procCtx;
            LateralViewJoinOperator op = (LateralViewJoinOperator)nd;
            boolean isUdtfPath = true;
            Operator<? extends OperatorDesc> inpOp = OpProcFactory.getParent(stack);
            ArrayList<ColumnInfo> cols = inpOp.getSchema().getSignature();
            lCtx.getIndex().copyPredicates(inpOp, op);
            if (inpOp instanceof SelectOperator) {
                isUdtfPath = false;
            }
            ArrayList<ColumnInfo> out_cols = op.getSchema().getSignature();
            int out_cols_size = out_cols.size();
            int cols_size = cols.size();
            int outColOffset = isUdtfPath ? out_cols_size - cols_size : 0;
            for (int cnt = 0; cnt < cols_size; ++cnt) {
                ColumnInfo outCol = out_cols.get(outColOffset + cnt);
                if (outCol.isHiddenVirtualCol()) continue;
                ColumnInfo col = cols.get(cnt);
                lCtx.getIndex().mergeDependency(op, outCol, lCtx.getIndex().getDependency(inpOp, col));
            }
            return null;
        }
    }

    public static class JoinLineage
    extends DefaultLineage
    implements NodeProcessor {
        private final HashMap<Node, Object> outputMap = new HashMap();

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            assert (!stack.isEmpty());
            LineageCtx lCtx = (LineageCtx)procCtx;
            JoinOperator op = (JoinOperator)nd;
            JoinDesc jd = (JoinDesc)op.getConf();
            ReduceSinkOperator inpOp = (ReduceSinkOperator)OpProcFactory.getParent(stack);
            lCtx.getIndex().copyPredicates(inpOp, op);
            LineageInfo.Predicate cond = this.getPredicate(op, lCtx);
            if (cond != null) {
                lCtx.getIndex().addPredicate(op, cond);
            }
            ReduceSinkDesc rd = (ReduceSinkDesc)inpOp.getConf();
            int tag = rd.getTag();
            int cnt = 0;
            List<ExprNodeDesc> exprs = jd.getExprs().get((byte)tag);
            for (ColumnInfo ci : op.getSchema().getSignature()) {
                if (jd.getReversedExprs().get(ci.getInternalName()) != tag) continue;
                ExprNodeDesc expr = exprs.get(cnt++);
                LineageInfo.Dependency dependency = ExprProcFactory.getExprDependency(lCtx, inpOp, expr, this.outputMap);
                lCtx.getIndex().mergeDependency(op, ci, dependency);
            }
            return null;
        }

        private LineageInfo.Predicate getPredicate(JoinOperator jop, LineageCtx lctx) {
            List<Operator<OperatorDesc>> parentOperators = jop.getParentOperators();
            JoinDesc jd = (JoinDesc)jop.getConf();
            ExprNodeDesc[][] joinKeys = jd.getJoinKeys();
            if (joinKeys == null || parentOperators == null || parentOperators.size() < 2) {
                return null;
            }
            LineageCtx.Index index = lctx.getIndex();
            for (Operator<OperatorDesc> op : parentOperators) {
                if (index.getDependencies(op) != null) continue;
                return null;
            }
            LineageInfo.Predicate cond = new LineageInfo.Predicate();
            JoinCondDesc[] conds = jd.getConds();
            int parents = parentOperators.size();
            StringBuilder sb = new StringBuilder("(");
            for (int i = 0; i < conds.length; ++i) {
                if (i != 0) {
                    sb.append(" AND ");
                }
                int left = conds[i].getLeft();
                int right = conds[i].getRight();
                if (joinKeys.length < left || joinKeys[left].length == 0 || joinKeys.length < right || joinKeys[right].length == 0 || parents < left || parents < right) {
                    return null;
                }
                ExprNodeDesc expr = joinKeys[left][0];
                Operator<OperatorDesc> op = parentOperators.get(left);
                List<Operator<OperatorDesc>> p = op.getParentOperators();
                if (p == null || p.isEmpty()) {
                    return null;
                }
                sb.append(ExprProcFactory.getExprString(op.getSchema(), expr, lctx, p.get(0), cond));
                sb.append(" = ");
                expr = joinKeys[right][0];
                op = parentOperators.get(right);
                p = op.getParentOperators();
                if (p == null || p.isEmpty()) {
                    return null;
                }
                sb.append(ExprProcFactory.getExprString(op.getSchema(), expr, lctx, p.get(0), cond));
            }
            sb.append(")");
            cond.setExpr(sb.toString());
            return cond;
        }
    }

    public static class TableScanLineage
    extends DefaultLineage
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            LineageCtx lCtx = (LineageCtx)procCtx;
            ParseContext pctx = lCtx.getParseCtx();
            TableScanOperator top = (TableScanOperator)nd;
            Table t = ((TableScanDesc)top.getConf()).getTableMetadata();
            org.apache.hadoop.hive.metastore.api.Table tab = t.getTTable();
            RowSchema rs = top.getSchema();
            List<FieldSchema> cols = t.getAllCols();
            HashMap<String, FieldSchema> fieldSchemaMap = new HashMap<String, FieldSchema>();
            for (FieldSchema col : cols) {
                fieldSchemaMap.put(col.getName(), col);
            }
            for (VirtualColumn vc : VirtualColumn.getRegistry((Configuration)pctx.getConf())) {
                fieldSchemaMap.put(vc.getName(), new FieldSchema(vc.getName(), vc.getTypeInfo().getTypeName(), ""));
            }
            LineageInfo.TableAliasInfo tai = new LineageInfo.TableAliasInfo();
            tai.setAlias(((TableScanDesc)top.getConf()).getAlias());
            tai.setTable(tab);
            for (ColumnInfo ci : rs.getSignature()) {
                LineageInfo.Dependency dep = new LineageInfo.Dependency();
                LineageInfo.BaseColumnInfo bci = new LineageInfo.BaseColumnInfo();
                bci.setTabAlias(tai);
                bci.setColumn((FieldSchema)fieldSchemaMap.get(ci.getInternalName()));
                dep.setType(LineageInfo.DependencyType.SIMPLE);
                dep.setBaseCols(new LinkedHashSet<LineageInfo.BaseColumnInfo>());
                dep.getBaseCols().add(bci);
                lCtx.getIndex().putDependency(top, ci, dep);
            }
            return null;
        }
    }

    public static class TransformLineage
    extends DefaultLineage
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            LineageCtx lCtx = (LineageCtx)procCtx;
            Operator op = (Operator)nd;
            Operator<? extends OperatorDesc> inpOp = OpProcFactory.getParent(stack);
            lCtx.getIndex().copyPredicates(inpOp, op);
            LineageInfo.Dependency dep = new LineageInfo.Dependency();
            LineageInfo.DependencyType new_type = LineageInfo.DependencyType.SCRIPT;
            dep.setType(LineageInfo.DependencyType.SCRIPT);
            dep.setExpr(null);
            LinkedHashSet<LineageInfo.BaseColumnInfo> col_set = new LinkedHashSet<LineageInfo.BaseColumnInfo>();
            for (ColumnInfo ci : inpOp.getSchema().getSignature()) {
                LineageInfo.Dependency d = lCtx.getIndex().getDependency(inpOp, ci);
                if (d == null) continue;
                new_type = LineageCtx.getNewDependencyType(d.getType(), new_type);
                if (ci.isHiddenVirtualCol()) continue;
                col_set.addAll(d.getBaseCols());
            }
            dep.setType(new_type);
            dep.setBaseCols(col_set);
            boolean isScript = op instanceof ScriptOperator;
            for (ColumnInfo ci : op.getSchema().getSignature()) {
                LineageInfo.Dependency dep_ci;
                LineageInfo.Dependency d = dep;
                if (!isScript && (dep_ci = lCtx.getIndex().getDependency(inpOp, ci)) != null) {
                    d = dep_ci;
                }
                lCtx.getIndex().putDependency(op, ci, d);
            }
            return null;
        }
    }
}

