/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import com.mapr.db.Admin;
import com.mapr.db.JsonTable;
import com.mapr.db.MapRDB;
import com.mapr.db.impl.MapRDBImpl;
import java.io.Serializable;
import org.apache.hadoop.hive.maprdb.json.util.MapRDbJsonParseUtil;
import org.apache.hadoop.hive.ql.DriverContext;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.plan.DeleteWork;
import org.apache.hadoop.hive.ql.plan.api.StageType;
import org.ojai.Document;
import org.ojai.DocumentStream;

public class DeleteTask
extends Task<DeleteWork>
implements Serializable {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected int execute(DriverContext driverContext) {
        String targetMapRDbTableName = ((DeleteWork)this.work).getTargetMapRDbTableName();
        String sourceMapRDbTableName = ((DeleteWork)this.work).getSourceMapRDbTableName();
        switch (((DeleteWork)this.work).getDeleteOperation()) {
            case DELETE_ALL: {
                try (Admin admin = MapRDB.newAdmin();){
                    if (!admin.tableExists(targetMapRDbTableName)) return 0;
                    admin.deleteTable(targetMapRDbTableName);
                    admin.createTable(targetMapRDbTableName);
                    return 0;
                }
            }
            case DELETE_ALL_IN_SET: {
                try (JsonTable table = MapRDBImpl.getTable((String)targetMapRDbTableName);){
                    for (String id : ((DeleteWork)this.work).getValues()) {
                        table.delete(id);
                    }
                    return 0;
                }
            }
            case DELETE_ALL_EXCEPT_IN_SET: {
                try (JsonTable table = MapRDBImpl.getTable((String)targetMapRDbTableName);){
                    try (DocumentStream documents = table.find(MapRDbJsonParseUtil.buildQueryCondition(((DeleteWork)this.work).getValues()));){
                        for (Document document : documents) {
                            table.delete(document);
                        }
                        int id = 0;
                        if (documents == null) return id;
                    }
                    return id;
                }
            }
            case DELETE_SINGLE: {
                try (JsonTable table = MapRDBImpl.getTable((String)targetMapRDbTableName);){
                    table.delete(((DeleteWork)this.work).getValue());
                    return 0;
                }
            }
            case DELETE_WHEN_MATCHED: {
                try (JsonTable targetTable = MapRDBImpl.getTable((String)targetMapRDbTableName);
                     JsonTable sourceTable = MapRDBImpl.getTable((String)sourceMapRDbTableName);
                     DocumentStream targetDocs = targetTable.find();){
                    for (Document targetDoc : targetDocs) {
                        Document sourceDoc = sourceTable.findById(targetDoc.getId());
                        boolean sourceDocExists = sourceDoc != null;
                        if (!sourceDocExists || !sourceDoc.equals(targetDoc)) continue;
                        targetTable.delete(targetDoc);
                    }
                    return 0;
                }
            }
        }
        return 0;
    }

    @Override
    public StageType getType() {
        return StageType.MOVE;
    }

    @Override
    public String getName() {
        return "DELETE";
    }
}

