/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.http;

import com.google.common.base.Preconditions;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.math3.util.Pair;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.ConfServlet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.http.AdminAuthorizedServlet;
import org.apache.hadoop.http.HttpServer2;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.security.http.CrossOriginFilter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.AbstractOutputStreamAppender;
import org.apache.logging.log4j.core.appender.FileManager;
import org.apache.logging.log4j.core.appender.OutputStreamManager;
import org.eclipse.jetty.rewrite.handler.RewriteHandler;
import org.eclipse.jetty.rewrite.handler.RewriteRegexRule;
import org.eclipse.jetty.rewrite.handler.Rule;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.LowResourceMonitor;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.webapp.WebAppContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleHttpStatusServer {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleHttpStatusServer.class);
    public static final String CONF_CONTEXT_ATTRIBUTE = "hive.conf";
    public static final String ADMINS_ACL = "admins.acl";
    private final String name;
    private String appDir;
    private WebAppContext webAppContext;
    private Server webServer;

    private SimpleHttpStatusServer(Builder b) throws IOException {
        this.name = b.name;
        this.createWebServer(b);
    }

    public void start() throws Exception {
        this.webServer.start();
        LOG.info("Started HttpServer[{}] on port {}", (Object)this.name, (Object)this.getPort());
    }

    public void stop() throws Exception {
        this.webServer.stop();
    }

    public boolean isRunning() {
        return this.webServer.isRunning();
    }

    public int getPort() {
        return ((ServerConnector)this.webServer.getConnectors()[0]).getLocalPort();
    }

    @InterfaceAudience.LimitedPrivate(value={"hive"})
    public static boolean isInstrumentationAccessAllowed(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response) throws IOException {
        Configuration conf = (Configuration)servletContext.getAttribute(CONF_CONTEXT_ATTRIBUTE);
        boolean access = true;
        boolean adminAccess = conf.getBoolean("hadoop.security.instrumentation.requires.admin", false);
        if (adminAccess) {
            access = SimpleHttpStatusServer.hasAdministratorAccess(servletContext, request, response);
        }
        return access;
    }

    @InterfaceAudience.LimitedPrivate(value={"hive"})
    public static boolean isInstrumentationAccessAllowedStrict(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response) throws IOException {
        Configuration conf = (Configuration)servletContext.getAttribute(CONF_CONTEXT_ATTRIBUTE);
        boolean adminAccess = conf.getBoolean("hadoop.security.instrumentation.requires.admin", false);
        if (!adminAccess) {
            return false;
        }
        boolean access = SimpleHttpStatusServer.hasAdministratorAccess(servletContext, request, response);
        return access;
    }

    public static boolean hasAccess(String remoteUser, String user, ServletContext ctx, HttpServletRequest request) throws IOException {
        return StringUtils.equalsIgnoreCase(remoteUser, user) || SimpleHttpStatusServer.hasAdministratorAccess(ctx, request, null);
    }

    static boolean hasAdministratorAccess(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response) throws IOException {
        Configuration conf = (Configuration)servletContext.getAttribute(CONF_CONTEXT_ATTRIBUTE);
        if (!conf.getBoolean("hadoop.security.authorization", false)) {
            return true;
        }
        String remoteUser = request.getRemoteUser();
        if (remoteUser == null) {
            if (response != null) {
                response.sendError(401, "Unauthenticated users are not authorized to access this page.");
            }
            return false;
        }
        if (servletContext.getAttribute(ADMINS_ACL) != null && !SimpleHttpStatusServer.userHasAdministratorAccess(servletContext, remoteUser)) {
            if (response != null) {
                response.sendError(401, "User " + remoteUser + " is unauthorized to access this page.");
            }
            return false;
        }
        return true;
    }

    static boolean userHasAdministratorAccess(ServletContext servletContext, String remoteUser) {
        AccessControlList adminsAcl = (AccessControlList)servletContext.getAttribute(ADMINS_ACL);
        UserGroupInformation remoteUserUGI = UserGroupInformation.createRemoteUser((String)remoteUser);
        return adminsAcl != null && adminsAcl.isUserAllowed(remoteUserUGI);
    }

    WebAppContext createWebAppContext(Builder b) {
        WebAppContext ctx = new WebAppContext();
        this.setContextAttributes(ctx.getServletContext(), b.contextAttrs);
        if (b.useSSL) {
            ctx.getServletContext().getSessionCookieConfig().setSecure(true);
        }
        ctx.setDisplayName(b.name);
        ctx.setContextPath("/");
        ctx.setWar(this.appDir + "/" + b.name);
        return ctx;
    }

    private void setupCORSFilter(Builder b) {
        FilterHolder holder = new FilterHolder();
        holder.setClassName(CrossOriginFilter.class.getName());
        HashMap params = new HashMap();
        holder.setInitParameters(params);
        ServletHandler handler = this.webAppContext.getServletHandler();
        handler.addFilterWithMapping(holder, "/*", 31);
    }

    Connector createChannelConnector(int queueSize, Builder b) {
        HttpConfiguration conf = new HttpConfiguration();
        conf.setRequestHeaderSize(65536);
        conf.setSendServerVersion(false);
        HttpConnectionFactory http = new HttpConnectionFactory(conf);
        ServerConnector connector = new ServerConnector(this.webServer, new ConnectionFactory[]{http});
        connector.setAcceptQueueSize(queueSize);
        connector.setReuseAddress(true);
        connector.setHost(b.host);
        connector.setPort(b.port);
        return connector;
    }

    void setContextAttributes(ContextHandler.Context ctx, Map<String, Object> contextAttrs) {
        for (Map.Entry<String, Object> e : contextAttrs.entrySet()) {
            ctx.setAttribute(e.getKey(), e.getValue());
        }
    }

    private void createWebServer(Builder b) throws IOException {
        QueuedThreadPool threadPool = new QueuedThreadPool();
        if (b.maxThreads > 0) {
            threadPool.setMaxThreads(b.maxThreads);
        }
        threadPool.setDaemon(true);
        threadPool.setName(b.name + "-web");
        this.webServer = new Server((ThreadPool)threadPool);
        this.appDir = this.getWebAppsPath(b.name);
        this.webAppContext = this.createWebAppContext(b);
        if (b.enableCORS) {
            this.setupCORSFilter(b);
        }
        this.initializeWebServer(b, threadPool.getMaxThreads());
    }

    private void initializeWebServer(Builder b, int queueSize) throws IOException {
        LowResourceMonitor low = new LowResourceMonitor(this.webServer);
        low.setLowResourcesIdleTimeout(10000);
        this.webServer.addBean((Object)low);
        Connector connector = this.createChannelConnector(queueSize, b);
        this.webServer.addConnector(connector);
        RewriteHandler rwHandler = new RewriteHandler();
        rwHandler.setRewriteRequestURI(true);
        rwHandler.setRewritePathInfo(false);
        RewriteRegexRule rootRule = new RewriteRegexRule();
        rootRule.setRegex("^/$");
        rootRule.setReplacement(b.contextRootRewriteTarget);
        rootRule.setTerminating(true);
        rwHandler.addRule((Rule)rootRule);
        rwHandler.setHandler((Handler)this.webAppContext);
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        contexts.addHandler((Handler)rwHandler);
        this.webServer.setHandler((Handler)contexts);
        this.addServlet("conf", "/conf", ConfServlet.class);
        this.addServlet("stacks", "/stacks", HttpServer2.StackServlet.class);
        for (Pair<String, Class<? extends HttpServlet>> p : b.servlets) {
            this.addServlet((String)p.getFirst(), "/" + (String)p.getFirst(), (Class)p.getSecond());
        }
        ServletContextHandler staticCtx = new ServletContextHandler((HandlerContainer)contexts, "/static");
        staticCtx.setResourceBase(this.appDir + "/static");
        staticCtx.addServlet(DefaultServlet.class, "/*");
        staticCtx.setDisplayName("static");
        String logDir = this.getLogDir(b.conf);
        if (logDir != null) {
            ServletContextHandler logCtx = new ServletContextHandler((HandlerContainer)contexts, "/logs");
            this.setContextAttributes(logCtx.getServletContext(), b.contextAttrs);
            logCtx.addServlet(AdminAuthorizedServlet.class, "/*");
            logCtx.setResourceBase(logDir);
            logCtx.setDisplayName("logs");
        }
    }

    String getLogDir(Configuration conf) {
        String logDir = conf.get("hive.log.dir");
        if (logDir == null) {
            logDir = System.getProperty("hive.log.dir");
        }
        if (logDir != null) {
            return logDir;
        }
        LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
        for (org.apache.logging.log4j.core.Logger logger : context.getLoggers()) {
            for (Appender appender : logger.getAppenders().values()) {
                String fileName;
                OutputStreamManager manager;
                if (!(appender instanceof AbstractOutputStreamAppender) || !((manager = ((AbstractOutputStreamAppender)appender).getManager()) instanceof FileManager) || (fileName = ((FileManager)manager).getFileName()) == null) continue;
                return fileName.substring(0, fileName.lastIndexOf(47));
            }
        }
        return null;
    }

    String getWebAppsPath(String appName) throws FileNotFoundException {
        String relativePath = "hive-webapps/" + appName;
        URL url = this.getClass().getClassLoader().getResource(relativePath);
        if (url == null) {
            throw new FileNotFoundException(relativePath + " not found in CLASSPATH");
        }
        String urlString = url.toString();
        return urlString.substring(0, urlString.lastIndexOf(47));
    }

    public void addServlet(String name, String pathSpec, Class<? extends HttpServlet> clazz) {
        ServletHolder holder = new ServletHolder(clazz);
        if (name != null) {
            holder.setName(name);
        }
        this.webAppContext.addServlet(holder, pathSpec);
    }

    public static class Builder {
        private final String name;
        private String host;
        private int port;
        private int maxThreads;
        private Configuration conf;
        private final Map<String, Object> contextAttrs = new HashMap<String, Object>();
        private boolean useSPNEGO;
        private boolean useSSL;
        private boolean enableCORS;
        private String contextRootRewriteTarget = "/index.html";
        private final List<Pair<String, Class<? extends HttpServlet>>> servlets = new LinkedList<Pair<String, Class<? extends HttpServlet>>>();

        public Builder(String name) {
            Preconditions.checkArgument(name != null && !name.isEmpty(), "Name must be specified");
            this.name = name;
        }

        public SimpleHttpStatusServer build() throws IOException {
            return new SimpleHttpStatusServer(this);
        }

        public Builder setHost(String host) {
            this.host = host;
            return this;
        }

        public Builder setPort(int port) {
            this.port = port;
            return this;
        }

        public Builder setMaxThreads(int maxThreads) {
            this.maxThreads = maxThreads;
            return this;
        }

        public Builder setAdmins(String admins) {
            if (admins != null) {
                this.setContextAttribute(SimpleHttpStatusServer.ADMINS_ACL, new AccessControlList(admins));
            }
            return this;
        }

        public Builder setConf(Configuration origConf) {
            this.conf = new Configuration(origConf);
            this.setContextAttribute(SimpleHttpStatusServer.CONF_CONTEXT_ATTRIBUTE, this.conf);
            return this;
        }

        public Builder setUseSSL(boolean useSSL) {
            this.useSSL = useSSL;
            return this;
        }

        public Builder setUseSPNEGO(boolean useSPNEGO) {
            this.useSPNEGO = useSPNEGO;
            return this;
        }

        public Builder setEnableCORS(boolean enableCORS) {
            this.enableCORS = enableCORS;
            return this;
        }

        public Builder setContextAttribute(String name, Object value) {
            this.contextAttrs.put(name, value);
            return this;
        }

        public Builder setContextRootRewriteTarget(String contextRootRewriteTarget) {
            this.contextRootRewriteTarget = contextRootRewriteTarget;
            return this;
        }

        public Builder addServlet(String endpoint, Class<? extends HttpServlet> servlet) {
            this.servlets.add((Pair<String, Class<? extends HttpServlet>>)new Pair((Object)endpoint, servlet));
            return this;
        }
    }
}

