/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf;

import org.apache.hadoop.hive.common.type.Date;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedExpressions;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFDayOfWeekDate;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFDayOfWeekString;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFDayOfWeekTimestamp;
import org.apache.hadoop.hive.ql.udf.generic.NDV;
import org.apache.hadoop.hive.serde2.io.DateWritableV2;
import org.apache.hadoop.hive.serde2.io.TimestampWritableV2;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;

@Description(name="dayofweek", value="_FUNC_(param) - Returns the day of the week of date/timestamp (1 = Sunday, 2 = Monday, ..., 7 = Saturday)", extended="param can be one of:\n1. A string in the format of 'yyyy-MM-dd HH:mm:ss' or 'yyyy-MM-dd'.\n2. A date value\n3. A timestamp valueExample:\n   > SELECT _FUNC_('2009-07-30') FROM src LIMIT 1;\n  5")
@VectorizedExpressions(value={VectorUDFDayOfWeekDate.class, VectorUDFDayOfWeekString.class, VectorUDFDayOfWeekTimestamp.class})
@NDV(maxNdv=7L)
public class UDFDayOfWeek
extends UDF {
    private final IntWritable result = new IntWritable();

    public IntWritable evaluate(Text dateString) {
        if (dateString == null) {
            return null;
        }
        try {
            Date date = Date.valueOf(dateString.toString());
            this.result.set(date.getDayOfWeek());
            return this.result;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public IntWritable evaluate(DateWritableV2 d) {
        if (d == null) {
            return null;
        }
        this.result.set(d.get().getDayOfWeek());
        return this.result;
    }

    public IntWritable evaluate(TimestampWritableV2 t) {
        if (t == null) {
            return null;
        }
        this.result.set(t.getTimestamp().getDayOfWeek());
        return this.result;
    }
}

