/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.repl.bootstrap;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.AddDependencyToLeaves;
import org.apache.hadoop.hive.ql.exec.util.DAGTraversal;
import org.apache.hadoop.hive.ql.plan.DependencyCollectionWork;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class AddDependencyToLeavesTest {
    @Mock
    private HiveConf hiveConf;

    @Test
    public void shouldNotSkipIntermediateDependencyCollectionTasks() {
        Task collectionWorkTaskOne = TaskFactory.get((Serializable)new DependencyCollectionWork());
        Task collectionWorkTaskTwo = TaskFactory.get((Serializable)new DependencyCollectionWork());
        Task collectionWorkTaskThree = TaskFactory.get((Serializable)new DependencyCollectionWork());
        Task rootTask = (Task)Mockito.mock(Task.class);
        Mockito.when((Object)rootTask.getDependentTasks()).thenReturn(Arrays.asList(collectionWorkTaskOne, collectionWorkTaskTwo, collectionWorkTaskThree));
        List<Task> tasksPostCurrentGraph = Arrays.asList((Task)Mockito.mock(Task.class), (Task)Mockito.mock(Task.class));
        DAGTraversal.traverse(Collections.singletonList(rootTask), (DAGTraversal.Function)new AddDependencyToLeaves(tasksPostCurrentGraph));
        List dependentTasksForOne = collectionWorkTaskOne.getDependentTasks();
        List dependentTasksForTwo = collectionWorkTaskTwo.getDependentTasks();
        List dependentTasksForThree = collectionWorkTaskThree.getDependentTasks();
        Assert.assertEquals((long)dependentTasksForOne.size(), (long)2L);
        Assert.assertEquals((long)dependentTasksForTwo.size(), (long)2L);
        Assert.assertEquals((long)dependentTasksForThree.size(), (long)2L);
        Assert.assertTrue((boolean)tasksPostCurrentGraph.containsAll(dependentTasksForOne));
        Assert.assertTrue((boolean)tasksPostCurrentGraph.containsAll(dependentTasksForTwo));
        Assert.assertTrue((boolean)tasksPostCurrentGraph.containsAll(dependentTasksForThree));
    }
}

