/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.repl.load;

import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.ql.parse.EximUtil;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.repl.load.MetaData;
import org.apache.thrift.TBase;
import org.apache.thrift.TDeserializer;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TJSONProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.transport.TTransportException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MetadataJson {
    private final JSONObject json;
    private final TDeserializer deserializer = new TDeserializer((TProtocolFactory)new TJSONProtocol.Factory());
    private final String tableDesc;

    public MetadataJson(String message) throws JSONException, SemanticException, TTransportException {
        this.json = new JSONObject(message);
        this.checkCompatibility();
        this.tableDesc = this.jsonEntry("table");
    }

    public MetaData getMetaData() throws TException, JSONException {
        return new MetaData(this.database(), this.table(), this.partitions(), this.readReplicationSpec(), this.function());
    }

    private org.apache.hadoop.hive.metastore.api.Function function() throws TException {
        return this.deserialize(new org.apache.hadoop.hive.metastore.api.Function(), this.jsonEntry("function"));
    }

    private Database database() throws TException {
        return this.deserialize(new Database(), this.jsonEntry("db"));
    }

    private Table table() throws TException {
        return this.deserialize(new Table(), this.tableDesc);
    }

    private <T extends TBase> T deserialize(T intoObject, String json) throws TException {
        if (json == null) {
            return null;
        }
        this.deserializer.deserialize(intoObject, json, "UTF-8");
        return intoObject;
    }

    private List<Partition> partitions() throws JSONException, TException {
        if (this.tableDesc == null) {
            return null;
        }
        JSONArray jsonPartitions = new JSONArray(this.json.getString("partitions"));
        ArrayList<Partition> partitionsList = new ArrayList<Partition>(jsonPartitions.length());
        for (int i = 0; i < jsonPartitions.length(); ++i) {
            String partDesc = jsonPartitions.getString(i);
            partitionsList.add(this.deserialize(new Partition(), partDesc));
        }
        return partitionsList;
    }

    private ReplicationSpec readReplicationSpec() {
        Function<String, String> keyFetcher = new Function<String, String>(){

            public String apply(@Nullable String s) {
                return MetadataJson.this.jsonEntry(s);
            }
        };
        return new ReplicationSpec(keyFetcher);
    }

    private void checkCompatibility() throws SemanticException, JSONException {
        String version = this.json.getString("version");
        String fcVersion = this.jsonEntry("fcversion");
        EximUtil.doCheckCompatibility("0.2", version, fcVersion);
    }

    private String jsonEntry(String forName) {
        try {
            return this.json.getString(forName);
        }
        catch (JSONException ignored) {
            return null;
        }
    }
}

