/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.wm;

import org.apache.hadoop.hive.ql.wm.Action;
import org.apache.hadoop.hive.ql.wm.CounterLimit;
import org.apache.hadoop.hive.ql.wm.CustomCounterLimit;
import org.apache.hadoop.hive.ql.wm.ExecutionTrigger;
import org.apache.hadoop.hive.ql.wm.Expression;
import org.apache.hadoop.hive.ql.wm.ExpressionFactory;
import org.apache.hadoop.hive.ql.wm.FileSystemCounterLimit;
import org.apache.hadoop.hive.ql.wm.TimeCounterLimit;
import org.apache.hadoop.hive.ql.wm.Trigger;
import org.apache.hadoop.hive.ql.wm.VertexCounterLimit;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class TestTrigger {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testSimpleQueryTrigger() {
        Expression expression = ExpressionFactory.createExpression((CounterLimit)new FileSystemCounterLimit("hdfs", FileSystemCounterLimit.FSCounter.BYTES_READ, 1024L));
        ExecutionTrigger trigger = new ExecutionTrigger("hdfs_read_heavy", expression, new Action(Action.Type.KILL_QUERY));
        Assert.assertEquals((Object)"counter: HDFS_BYTES_READ limit: 1024", (Object)expression.getCounterLimit().toString());
        Assert.assertFalse((boolean)trigger.apply(1000L));
        Assert.assertTrue((boolean)trigger.apply(1025L));
        expression = ExpressionFactory.createExpression((CounterLimit)new FileSystemCounterLimit("hdfs", FileSystemCounterLimit.FSCounter.BYTES_WRITTEN, 1024L));
        trigger = new ExecutionTrigger("hdfs_write_heavy", expression, new Action(Action.Type.KILL_QUERY));
        Assert.assertEquals((Object)"counter: HDFS_BYTES_WRITTEN limit: 1024", (Object)expression.getCounterLimit().toString());
        Assert.assertFalse((boolean)trigger.apply(1000L));
        Assert.assertTrue((boolean)trigger.apply(1025L));
        expression = ExpressionFactory.createExpression((CounterLimit)new FileSystemCounterLimit("", FileSystemCounterLimit.FSCounter.BYTES_READ, 1024L));
        trigger = new ExecutionTrigger("local_read_heavy", expression, new Action(Action.Type.KILL_QUERY));
        Assert.assertEquals((Object)"counter: BYTES_READ limit: 1024", (Object)expression.getCounterLimit().toString());
        Assert.assertFalse((boolean)trigger.apply(1000L));
        Assert.assertTrue((boolean)trigger.apply(1025L));
        expression = ExpressionFactory.createExpression((CounterLimit)new FileSystemCounterLimit("", FileSystemCounterLimit.FSCounter.BYTES_WRITTEN, 1024L));
        trigger = new ExecutionTrigger("local_write_heavy", expression, new Action(Action.Type.KILL_QUERY));
        Assert.assertEquals((Object)"counter: BYTES_WRITTEN limit: 1024", (Object)expression.getCounterLimit().toString());
        Assert.assertFalse((boolean)trigger.apply(1000L));
        Assert.assertTrue((boolean)trigger.apply(1025L));
        expression = ExpressionFactory.createExpression((CounterLimit)new FileSystemCounterLimit("", FileSystemCounterLimit.FSCounter.SHUFFLE_BYTES, 1024L));
        trigger = new ExecutionTrigger("shuffle_heavy", expression, new Action(Action.Type.KILL_QUERY));
        Assert.assertEquals((Object)"counter: SHUFFLE_BYTES limit: 1024", (Object)expression.getCounterLimit().toString());
        Assert.assertFalse((boolean)trigger.apply(1000L));
        Assert.assertTrue((boolean)trigger.apply(1025L));
        expression = ExpressionFactory.createExpression((CounterLimit)new TimeCounterLimit(TimeCounterLimit.TimeCounter.EXECUTION_TIME, 10000L));
        trigger = new ExecutionTrigger("slow_query", expression, new Action(Action.Type.MOVE_TO_POOL, "fake_pool"));
        Assert.assertEquals((Object)"counter: EXECUTION_TIME limit: 10000", (Object)expression.getCounterLimit().toString());
        Assert.assertFalse((boolean)trigger.apply(1000L));
        Assert.assertTrue((boolean)trigger.apply(100000L));
        expression = ExpressionFactory.createExpression((CounterLimit)new VertexCounterLimit(VertexCounterLimit.VertexCounter.VERTEX_TOTAL_TASKS, 10000L));
        trigger = new ExecutionTrigger("highly_parallel", expression, new Action(Action.Type.KILL_QUERY));
        Assert.assertEquals((Object)"counter: VERTEX_TOTAL_TASKS limit: 10000", (Object)expression.getCounterLimit().toString());
        Assert.assertFalse((boolean)trigger.apply(1000L));
        Assert.assertTrue((boolean)trigger.apply(100000L));
        expression = ExpressionFactory.createExpression((CounterLimit)new VertexCounterLimit(VertexCounterLimit.VertexCounter.DAG_TOTAL_TASKS, 10000L));
        trigger = new ExecutionTrigger("highly_parallel", expression, new Action(Action.Type.KILL_QUERY));
        Assert.assertEquals((Object)"counter: DAG_TOTAL_TASKS limit: 10000", (Object)expression.getCounterLimit().toString());
        Assert.assertFalse((boolean)trigger.apply(1000L));
        Assert.assertTrue((boolean)trigger.apply(100000L));
        expression = ExpressionFactory.createExpression((CounterLimit)new CustomCounterLimit("HDFS_WRITE_OPS", 10000L));
        trigger = new ExecutionTrigger("write_heavy", expression, new Action(Action.Type.KILL_QUERY));
        Assert.assertEquals((Object)"counter: HDFS_WRITE_OPS limit: 10000", (Object)expression.getCounterLimit().toString());
        Assert.assertFalse((boolean)trigger.apply(1000L));
        Assert.assertTrue((boolean)trigger.apply(100000L));
    }

    @Test
    public void testExpressionFromString() {
        Expression expression = ExpressionFactory.fromString((String)"BYTES_READ>1024");
        Expression expected = ExpressionFactory.createExpression((CounterLimit)new FileSystemCounterLimit("", FileSystemCounterLimit.FSCounter.BYTES_READ, 1024L));
        Assert.assertEquals((Object)expected, (Object)expression);
        Assert.assertEquals((long)expected.hashCode(), (long)expression.hashCode());
        expression = ExpressionFactory.fromString((String)"BYTES_READ > 1024");
        Assert.assertEquals((Object)expected, (Object)expression);
        expression = ExpressionFactory.fromString((String)expected.toString());
        Assert.assertEquals((Object)expected.toString(), (Object)expression.toString());
        Assert.assertEquals((long)expected.hashCode(), (long)expression.hashCode());
        expression = ExpressionFactory.fromString((String)"  BYTES_READ   >   1024  ");
        Assert.assertEquals((Object)expected, (Object)expression);
        Assert.assertEquals((long)expected.hashCode(), (long)expression.hashCode());
        expression = ExpressionFactory.fromString((String)"BYTES_WRITTEN > 1024");
        expected = ExpressionFactory.createExpression((CounterLimit)new FileSystemCounterLimit("", FileSystemCounterLimit.FSCounter.BYTES_WRITTEN, 1024L));
        Assert.assertEquals((Object)expected, (Object)expression);
        Assert.assertEquals((long)expected.hashCode(), (long)expression.hashCode());
        expression = ExpressionFactory.fromString((String)" HDFS_BYTES_READ > 1024 ");
        expected = ExpressionFactory.createExpression((CounterLimit)new FileSystemCounterLimit("hdfs", FileSystemCounterLimit.FSCounter.BYTES_READ, 1024L));
        Assert.assertEquals((Object)expected, (Object)expression);
        Assert.assertEquals((long)expected.hashCode(), (long)expression.hashCode());
        expression = ExpressionFactory.fromString((String)" HDFS_BYTES_WRITTEN > 1024");
        expected = ExpressionFactory.createExpression((CounterLimit)new FileSystemCounterLimit("hdfs", FileSystemCounterLimit.FSCounter.BYTES_WRITTEN, 1024L));
        Assert.assertEquals((Object)expected, (Object)expression);
        Assert.assertEquals((long)expected.hashCode(), (long)expression.hashCode());
        expression = ExpressionFactory.fromString((String)" S3A_BYTES_READ > 1024");
        expected = ExpressionFactory.createExpression((CounterLimit)new FileSystemCounterLimit("s3a", FileSystemCounterLimit.FSCounter.BYTES_READ, 1024L));
        Assert.assertEquals((Object)expected, (Object)expression);
        Assert.assertEquals((long)expected.hashCode(), (long)expression.hashCode());
        expression = ExpressionFactory.fromString((String)" S3A_BYTES_WRITTEN > 1024");
        expected = ExpressionFactory.createExpression((CounterLimit)new FileSystemCounterLimit("s3a", FileSystemCounterLimit.FSCounter.BYTES_WRITTEN, 1024L));
        Assert.assertEquals((Object)expected, (Object)expression);
        Assert.assertEquals((long)expected.hashCode(), (long)expression.hashCode());
        expression = ExpressionFactory.fromString((String)" s3a_ByTeS_WRiTTeN > 1024");
        expected = ExpressionFactory.createExpression((CounterLimit)new FileSystemCounterLimit("s3a", FileSystemCounterLimit.FSCounter.BYTES_WRITTEN, 1024L));
        Assert.assertEquals((Object)expected, (Object)expression);
        Assert.assertEquals((long)expected.hashCode(), (long)expression.hashCode());
        expression = ExpressionFactory.fromString((String)" SHUFFLE_BYTES > 1024");
        expected = ExpressionFactory.createExpression((CounterLimit)new FileSystemCounterLimit("", FileSystemCounterLimit.FSCounter.SHUFFLE_BYTES, 1024L));
        Assert.assertEquals((Object)expected, (Object)expression);
        Assert.assertEquals((long)expected.hashCode(), (long)expression.hashCode());
        expression = ExpressionFactory.fromString((String)" EXECUTION_TIME > 300");
        expected = ExpressionFactory.createExpression((CounterLimit)new TimeCounterLimit(TimeCounterLimit.TimeCounter.EXECUTION_TIME, 300L));
        Assert.assertEquals((Object)expected, (Object)expression);
        Assert.assertEquals((long)expected.hashCode(), (long)expression.hashCode());
        expression = ExpressionFactory.fromString((String)" ELAPSED_TIME > 300");
        expected = ExpressionFactory.createExpression((CounterLimit)new TimeCounterLimit(TimeCounterLimit.TimeCounter.ELAPSED_TIME, 300L));
        Assert.assertEquals((Object)expected, (Object)expression);
        Assert.assertEquals((long)expected.hashCode(), (long)expression.hashCode());
        expression = ExpressionFactory.fromString((String)" elapsed_TIME > 300");
        expected = ExpressionFactory.createExpression((CounterLimit)new TimeCounterLimit(TimeCounterLimit.TimeCounter.ELAPSED_TIME, 300L));
        Assert.assertEquals((Object)expected, (Object)expression);
        Assert.assertEquals((long)expected.hashCode(), (long)expression.hashCode());
        expression = ExpressionFactory.fromString((String)" VERTEX_TOTAL_TASKS > 10000");
        expected = ExpressionFactory.createExpression((CounterLimit)new VertexCounterLimit(VertexCounterLimit.VertexCounter.VERTEX_TOTAL_TASKS, 10000L));
        Assert.assertEquals((Object)"counter: VERTEX_TOTAL_TASKS limit: 10000", (Object)expression.getCounterLimit().toString());
        Assert.assertEquals((Object)expected, (Object)expression);
        Assert.assertEquals((long)expected.hashCode(), (long)expression.hashCode());
        expression = ExpressionFactory.fromString((String)" DAG_TOTAL_TASKS > 10000");
        expected = ExpressionFactory.createExpression((CounterLimit)new VertexCounterLimit(VertexCounterLimit.VertexCounter.DAG_TOTAL_TASKS, 10000L));
        Assert.assertEquals((Object)"counter: DAG_TOTAL_TASKS limit: 10000", (Object)expression.getCounterLimit().toString());
        Assert.assertEquals((Object)expected, (Object)expression);
        Assert.assertEquals((long)expected.hashCode(), (long)expression.hashCode());
        expression = ExpressionFactory.fromString((String)" HDFS_WRITE_OPS > 10000");
        expected = ExpressionFactory.createExpression((CounterLimit)new CustomCounterLimit("HDFS_WRITE_OPS", 10000L));
        Assert.assertEquals((Object)"counter: HDFS_WRITE_OPS limit: 10000", (Object)expression.getCounterLimit().toString());
        Assert.assertEquals((Object)expected, (Object)expression);
        Assert.assertEquals((long)expected.hashCode(), (long)expression.hashCode());
    }

    @Test
    public void testSizeValidationInTrigger() {
        Expression expression = ExpressionFactory.fromString((String)" SHUFFLE_BYTES > '100MB'");
        Expression expected = ExpressionFactory.createExpression((CounterLimit)new FileSystemCounterLimit("", FileSystemCounterLimit.FSCounter.SHUFFLE_BYTES, 0x6400000L));
        Assert.assertEquals((Object)expected, (Object)expression);
        Assert.assertEquals((long)expected.hashCode(), (long)expression.hashCode());
        expression = ExpressionFactory.fromString((String)" SHUFFLE_BYTES > '1gB'");
        expected = ExpressionFactory.createExpression((CounterLimit)new FileSystemCounterLimit("", FileSystemCounterLimit.FSCounter.SHUFFLE_BYTES, 0x40000000L));
        Assert.assertEquals((Object)expected, (Object)expression);
        Assert.assertEquals((long)expected.hashCode(), (long)expression.hashCode());
        expression = ExpressionFactory.fromString((String)" SHUFFLE_BYTES > '1TB'");
        expected = ExpressionFactory.createExpression((CounterLimit)new FileSystemCounterLimit("", FileSystemCounterLimit.FSCounter.SHUFFLE_BYTES, 0x10000000000L));
        Assert.assertEquals((Object)expected, (Object)expression);
        Assert.assertEquals((long)expected.hashCode(), (long)expression.hashCode());
        expression = ExpressionFactory.fromString((String)" SHUFFLE_BYTES > 100");
        expected = ExpressionFactory.createExpression((CounterLimit)new FileSystemCounterLimit("", FileSystemCounterLimit.FSCounter.SHUFFLE_BYTES, 100L));
        Assert.assertEquals((Object)expected, (Object)expression);
        Assert.assertEquals((long)expected.hashCode(), (long)expression.hashCode());
        expression = ExpressionFactory.fromString((String)" SHUFFLE_BYTES > 100");
        expected = ExpressionFactory.createExpression((CounterLimit)new FileSystemCounterLimit("", FileSystemCounterLimit.FSCounter.SHUFFLE_BYTES, 100L));
        Assert.assertEquals((Object)expected, (Object)expression);
        Assert.assertEquals((long)expected.hashCode(), (long)expression.hashCode());
    }

    @Test
    public void testIllegalSizeCounterValue1() {
        this.thrown.expect(IllegalArgumentException.class);
        ExpressionFactory.fromString((String)" SHUFFLE_BYTES > '300GiB'");
    }

    @Test
    public void testIllegalSizeCounterValue2() {
        this.thrown.expect(IllegalArgumentException.class);
        ExpressionFactory.fromString((String)" SHUFFLE_BYTES > '300 foo'");
    }

    @Test
    public void testTimeValidationInTrigger() {
        Expression expression = ExpressionFactory.fromString((String)" elapsed_TIME > '300sec'");
        Expression expected = ExpressionFactory.createExpression((CounterLimit)new TimeCounterLimit(TimeCounterLimit.TimeCounter.ELAPSED_TIME, 300000L));
        Assert.assertEquals((Object)expected, (Object)expression);
        Assert.assertEquals((long)expected.hashCode(), (long)expression.hashCode());
        expression = ExpressionFactory.fromString((String)" elapsed_TIME > '300seconds'");
        expected = ExpressionFactory.createExpression((CounterLimit)new TimeCounterLimit(TimeCounterLimit.TimeCounter.ELAPSED_TIME, 300000L));
        Assert.assertEquals((Object)expected, (Object)expression);
        Assert.assertEquals((long)expected.hashCode(), (long)expression.hashCode());
        expression = ExpressionFactory.fromString((String)" elapsed_TIME > '300sec'");
        expected = ExpressionFactory.createExpression((CounterLimit)new TimeCounterLimit(TimeCounterLimit.TimeCounter.ELAPSED_TIME, 300000L));
        Assert.assertEquals((Object)expected, (Object)expression);
        Assert.assertEquals((long)expected.hashCode(), (long)expression.hashCode());
        expression = ExpressionFactory.fromString((String)" elapsed_TIME > '300second'");
        expected = ExpressionFactory.createExpression((CounterLimit)new TimeCounterLimit(TimeCounterLimit.TimeCounter.ELAPSED_TIME, 300000L));
        Assert.assertEquals((Object)expected, (Object)expression);
        Assert.assertEquals((long)expected.hashCode(), (long)expression.hashCode());
        expression = ExpressionFactory.fromString((String)" elapsed_TIME > '300seconds'");
        expected = ExpressionFactory.createExpression((CounterLimit)new TimeCounterLimit(TimeCounterLimit.TimeCounter.ELAPSED_TIME, 300000L));
        Assert.assertEquals((Object)expected, (Object)expression);
        Assert.assertEquals((long)expected.hashCode(), (long)expression.hashCode());
        expression = ExpressionFactory.fromString((String)" elapsed_TIME > '300sec'");
        expected = ExpressionFactory.createExpression((CounterLimit)new TimeCounterLimit(TimeCounterLimit.TimeCounter.ELAPSED_TIME, 300000L));
        Assert.assertEquals((Object)expected, (Object)expression);
        Assert.assertEquals((long)expected.hashCode(), (long)expression.hashCode());
        expression = ExpressionFactory.fromString((String)" elapsed_TIME > '300000ms'");
        expected = ExpressionFactory.createExpression((CounterLimit)new TimeCounterLimit(TimeCounterLimit.TimeCounter.ELAPSED_TIME, 300000L));
        Assert.assertEquals((Object)expected, (Object)expression);
        Assert.assertEquals((long)expected.hashCode(), (long)expression.hashCode());
        expression = ExpressionFactory.fromString((String)" elapsed_TIME > '300000000microseconds'");
        expected = ExpressionFactory.createExpression((CounterLimit)new TimeCounterLimit(TimeCounterLimit.TimeCounter.ELAPSED_TIME, 300000L));
        Assert.assertEquals((Object)expected, (Object)expression);
        Assert.assertEquals((long)expected.hashCode(), (long)expression.hashCode());
        expression = ExpressionFactory.fromString((String)" elapsed_TIME > '1DAY'");
        expected = ExpressionFactory.createExpression((CounterLimit)new TimeCounterLimit(TimeCounterLimit.TimeCounter.ELAPSED_TIME, 86400000L));
        Assert.assertEquals((Object)expected, (Object)expression);
        Assert.assertEquals((long)expected.hashCode(), (long)expression.hashCode());
    }

    @Test
    public void testIllegalTimeCounterValue1() {
        this.thrown.expect(IllegalArgumentException.class);
        ExpressionFactory.fromString((String)" elapsed_TIME > '300lightyears'");
    }

    @Test
    public void testIllegalTimeCounterValue2() {
        this.thrown.expect(IllegalArgumentException.class);
        ExpressionFactory.fromString((String)" elapsed_TIME > '300secTOR'");
    }

    @Test
    public void testActionFromMetastoreStr() {
        Assert.assertEquals((Object)Action.Type.KILL_QUERY, (Object)Action.fromMetastoreExpression((String)"KILL").getType());
        Assert.assertEquals((Object)Action.Type.MOVE_TO_POOL, (Object)Action.fromMetastoreExpression((String)"MOVE TO bi").getType());
        Assert.assertEquals((Object)"bi", (Object)Action.fromMetastoreExpression((String)"MOVE TO bi").getPoolName());
        Assert.assertEquals((Object)"bi.c1.c2", (Object)Action.fromMetastoreExpression((String)"MOVE TO bi.c1.c2").getPoolName());
        Assert.assertEquals((Object)"MOVE TO etl", (Object)Action.fromMetastoreExpression((String)"MOVE TO etl").toString());
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Invalid action expression: MOVE TO  ");
        Assert.assertEquals((Object)Action.Type.MOVE_TO_POOL, (Object)Action.fromMetastoreExpression((String)"MOVE TO    ").getType());
    }

    @Test
    public void testTriggerClone() {
        Expression expression = ExpressionFactory.createExpression((CounterLimit)new FileSystemCounterLimit("hdfs", FileSystemCounterLimit.FSCounter.BYTES_READ, 1024L));
        ExecutionTrigger trigger = new ExecutionTrigger("hdfs_read_heavy", expression, new Action(Action.Type.KILL_QUERY));
        Trigger clonedTrigger = trigger.clone();
        Assert.assertNotEquals((long)System.identityHashCode(trigger), (long)System.identityHashCode(clonedTrigger));
        Assert.assertNotEquals((long)System.identityHashCode(trigger.getExpression()), (long)System.identityHashCode(clonedTrigger.getExpression()));
        Assert.assertNotEquals((long)System.identityHashCode(trigger.getExpression().getCounterLimit()), (long)System.identityHashCode(clonedTrigger.getExpression().getCounterLimit()));
        Assert.assertEquals((Object)trigger, (Object)clonedTrigger);
        Assert.assertEquals((long)trigger.hashCode(), (long)clonedTrigger.hashCode());
        expression = ExpressionFactory.fromString((String)" ELAPSED_TIME > 300");
        trigger = new ExecutionTrigger("slow_query", expression, new Action(Action.Type.KILL_QUERY));
        clonedTrigger = trigger.clone();
        Assert.assertNotEquals((long)System.identityHashCode(trigger), (long)System.identityHashCode(clonedTrigger));
        Assert.assertNotEquals((long)System.identityHashCode(trigger.getExpression()), (long)System.identityHashCode(clonedTrigger.getExpression()));
        Assert.assertNotEquals((long)System.identityHashCode(trigger.getExpression().getCounterLimit()), (long)System.identityHashCode(clonedTrigger.getExpression().getCounterLimit()));
        Assert.assertEquals((Object)trigger, (Object)clonedTrigger);
        Assert.assertEquals((long)trigger.hashCode(), (long)clonedTrigger.hashCode());
    }

    @Test
    public void testIllegalExpressionsUnsupportedPredicate() {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Invalid expression: BYTES_READ < 1024");
        ExpressionFactory.fromString((String)"BYTES_READ < 1024");
    }

    @Test
    public void testIllegalExpressionsMissingLimit() {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Invalid expression: BYTES_READ >");
        ExpressionFactory.fromString((String)"BYTES_READ >");
    }

    @Test
    public void testIllegalExpressionsMissingCounter() {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Invalid expression: > 1024");
        ExpressionFactory.fromString((String)"> 1024");
    }

    @Test
    public void testIllegalExpressionsMultipleLimit() {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Invalid expression: BYTES_READ > 1024 > 1025");
        ExpressionFactory.fromString((String)"BYTES_READ > 1024 > 1025");
    }

    @Test
    public void testIllegalExpressionsMultipleCounters() {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Invalid expression: BYTES_READ > BYTES_READ > 1025");
        ExpressionFactory.fromString((String)"BYTES_READ > BYTES_READ > 1025");
    }

    @Test
    public void testIllegalExpressionsNoQuoutes() {
        this.thrown.expect(IllegalArgumentException.class);
        ExpressionFactory.fromString((String)"BYTES_READ > 1mb");
    }

    @Test
    public void testIllegalExpressionsInvalidLimitPost() {
        this.thrown.expect(IllegalArgumentException.class);
        ExpressionFactory.fromString((String)"BYTES_READ > '1024aaaa'");
    }

    @Test
    public void testIllegalExpressionsInvalidLimitPre() {
        this.thrown.expect(IllegalArgumentException.class);
        ExpressionFactory.fromString((String)"BYTES_READ > foo1024");
    }

    @Test
    public void testIllegalExpressionsInvalidNegativeLimit() {
        this.thrown.expect(IllegalArgumentException.class);
        ExpressionFactory.fromString((String)"BYTES_READ > -1024");
    }
}

